/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.upgrade.step.rebootpiuupgrade;

import org.xml.sax.SAXException;
import se.ericsson.cello.su.extsuif.upgradepackage.util.constants.UpgradePackageConst;
import se.ericsson.cello.support.thread.ActionListener;
import se.ericsson.cello.swmanagement.suaccess.ReliableProgramUniterMoSU_Access;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.TransactionServiceImpl;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.upgrade.step.ExecutableOp;
import se.ericsson.cello.upgradepackage.util.mohandler.jvm.JvmMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.rpu.RPU_MO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;
import se.ericsson.cello.upgradepackage.util.time.TimeHandler;
import se.ericsson.cello.upgradepackage.util.transaction.Transaction;

public final class WaitOp
implements ExecutableOp,
UpgradePackageConst {
    int myTimeout;
    boolean myNoRpMove;
    boolean myIsJVM_RPU_SwitchRequired = true;
    private static final long ONE_MINUTE = 60000L;

    public WaitOp(int n, boolean bl) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "WaitOp ( int timeout, boolean noRpMove )", "timeout: " + n + "\n\tnoRpMove: " + bl + "\n\tmyIsJVM_RPU_SwitchRequired: " + this.myIsJVM_RPU_SwitchRequired);
        }
        this.myTimeout = n * 1000;
        this.myNoRpMove = bl;
    }

    public WaitOp(int n, boolean bl, boolean bl2) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "WaitOp ( int timeout, boolean noRpMove )", "timeout: " + n + "\n\tnoRpMove: " + bl + "\n\tanIsJVM_RPU_SwitchRequired: " + bl2);
        }
        this.myTimeout = n * 1000;
        this.myNoRpMove = bl;
        this.myIsJVM_RPU_SwitchRequired = bl2;
    }

    public synchronized void executeOp(ActionListener actionListener) throws SAXException {
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "Execute private operation 'Wait'.", "executeOp()\n\ttimeout: " + this.myTimeout + "\n\tnoRpMove: " + this.myNoRpMove + "\n\tmyIsJVM_RPU_SwitchRequired: " + this.myIsJVM_RPU_SwitchRequired);
        }
        TimeHandler.sleep(this.myTimeout);
        Control control = null;
        try {
            if (!this.myNoRpMove && this.myIsJVM_RPU_SwitchRequired) {
                JvmMO_HandlerInterface jvmMO_HandlerInterface = ServiceFinder.getJvmMO_HandlerInterface();
                RPU_MO_HandlerInterface rPU_MO_HandlerInterface = ServiceFinder.getRPU_MO_HandlerInterface();
                ReliableProgramUniterMoSU_Access reliableProgramUniterMoSU_Access = jvmMO_HandlerInterface.getReliableProgramUniter(null);
                if (reliableProgramUniterMoSU_Access != null) {
                    int n = rPU_MO_HandlerInterface.getOperationalMode(reliableProgramUniterMoSU_Access, null);
                    if (n == 2) {
                        if (Trace.valid(this.getClass(), 22)) {
                            Trace.debug(this.getClass(), 22, "executeOp(ActionListener observer)", "The JVM RPU operational mode is 'SwitchedOver'. requests for switch...");
                        }
                        control = TransactionServiceImpl.instance().getTransactionFactory().create(3600);
                        Coordinator coordinator = control.getCoordinator();
                        rPU_MO_HandlerInterface.switchRPU(reliableProgramUniterMoSU_Access, coordinator);
                        control.getTerminator().commit();
                        this.waitForJVM_ToBeSwitched();
                    } else if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "executeOp(ActionListener observer)", "The JVM RPU operational mode is 'as configured'.");
                    }
                }
            }
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "executeOp( ActionListener observer )", "Exception caught, \n\ttimeout (in milliseconds): " + this.myTimeout + "\n\tnoRpMove: " + this.myNoRpMove, exception);
            Transaction.rollback(control);
            throw new SAXException(exception.toString());
        }
    }

    public void setRPU_SwitchForJVM(boolean bl) {
        this.myIsJVM_RPU_SwitchRequired = bl;
    }

    private void waitForJVM_ToBeSwitched() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "waitForJVM_ToBeSwitched ()");
        }
        for (int i = 0; i < 30; ++i) {
            Trace.log1(this.getClass(), "waitForJVM_ToBeSwitched()", "Waits for the JVM to be switched by its RPU");
            TimeHandler.sleep(60000L);
        }
    }

    public String toString() {
        return "\n\tmyTimeout: " + this.myTimeout + "\n\tmyNoRpMove: " + this.myNoRpMove + "\n\tmyIsJVM_RPU_SwitchRequired: " + this.myIsJVM_RPU_SwitchRequired;
    }
}

