/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.upgrade.step.softpiuupgrade;

import java.util.Iterator;
import java.util.Vector;
import org.xml.sax.SAXException;
import se.ericsson.cello.equipment.suaccess.ProgramMoSU_Access;
import se.ericsson.cello.su.extsuif.upgradepackage.util.constants.UpgradePackageConst;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.NotifyingSystemUpgradePropertyName;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.ProgressInformationHandler;
import se.ericsson.cello.support.thread.ActionListener;
import se.ericsson.cello.swmanagement.suaccess.LoadModuleMoSU_Access;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.upgrade.step.ExecutableOp;
import se.ericsson.cello.upgradepackage.util.datacontainer.NewStepLabelInformation;

public final class WaitForSoftOperationStateOP
implements ExecutableOp,
UpgradePackageConst {
    private Vector programList;
    private String myStepLabel = null;

    public WaitForSoftOperationStateOP(Vector vector, String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "WaitForSoftOperationStateOP(Vector programList)", "programList: " + vector);
        }
        this.programList = (Vector)vector.clone();
        this.myStepLabel = string;
        this.printInformation();
    }

    public synchronized void executeOp(ActionListener actionListener) throws SAXException {
        Trace.log1(this.getClass(), "executeOp( ActionListener observer )", "Execute operation 'WaitForSoftOperationState'.\n\tPrograms: " + this.programList);
        if (this.myStepLabel != null) {
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new NewStepLabelInformation((Object)this, this.myStepLabel));
        }
        this.printInformation();
        boolean bl = false;
        while (!bl) {
            for (int i = 0; i < this.programList.size(); ++i) {
                ProgramMoSU_Access programMoSU_Access = (ProgramMoSU_Access)this.programList.elementAt(i);
                try {
                    if (programMoSU_Access.getOperationalState(null) != 1) continue;
                    String string = this.getLoadModuleData((LoadModuleMoSU_Access)programMoSU_Access.getLoadModule(null));
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "executeOp( ActionListener observer )", "The OperationState for program " + programMoSU_Access + " has been changed to ENABLED." + "\n\ti: " + i + "\n\tPrograms LM Data: " + string);
                    }
                    this.programList.removeElementAt(i);
                    continue;
                }
                catch (Throwable throwable) {
                    Trace.error(this.getClass(), "executeOp( ActionListener observer )", "Throwable caught. Message: " + throwable.toString(), throwable);
                    throw new SAXException(throwable.toString());
                }
            }
            if (this.programList.size() != 0) continue;
            bl = true;
            if (!Trace.valid(this.getClass(), 20)) continue;
            Trace.debug(this.getClass(), 20, "executeOp( ActionListener observer )", "Operational State has been changed to ENABLED for all programs in the list.");
        }
    }

    private void printInformation() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "printInformation()");
        }
        try {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "printInformation()", "programList: " + this.programList + "programList size: " + this.programList.size());
            }
            Iterator iterator = this.programList.iterator();
            ProgramMoSU_Access programMoSU_Access = null;
            while (iterator.hasNext()) {
                programMoSU_Access = (ProgramMoSU_Access)iterator.next();
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "printInformation()", "theProgramMo: " + programMoSU_Access + "\n\tOperationalState: " + programMoSU_Access.getOperationalState(null) + "\n\tStartState: " + programMoSU_Access.getStartState(null) + "\n\tProgram FRO ID: " + programMoSU_Access.getProgramFroId(null) + "\n\tLoadModule MO: " + programMoSU_Access.getLoadModule(null));
                }
                String string = this.getLoadModuleData((LoadModuleMoSU_Access)programMoSU_Access.getLoadModule(null));
                if (!Trace.valid(this.getClass(), 20)) continue;
                Trace.debug(this.getClass(), 20, "printInformation()", "LoadModule data for the program: " + string);
            }
        }
        catch (Throwable throwable) {
            Trace.info(this.getClass(), "printInformation ()", "Throwable caught: " + throwable);
        }
    }

    private String getLoadModuleData(LoadModuleMoSU_Access loadModuleMoSU_Access) {
        String string = "";
        try {
            string = string + "\n\tLoadModule MO: " + loadModuleMoSU_Access;
            string = string + "\n\tProduct no: " + loadModuleMoSU_Access.getProductNumber(null);
            string = string + "\n\ttProduct rev: " + loadModuleMoSU_Access.getProductRevision(null);
            string = string + "\n\tRPU Label: " + loadModuleMoSU_Access.getReliableProgramLabel(null);
            return string;
        }
        catch (Throwable throwable) {
            return "\n\tClass name: " + this.getClass().getName() + "\n\tgetLoadModuleData ( LoadModuleMoSU_Access aLoadModuleMo )" + "\n\tThrowable caught: " + throwable.toString() + "\n\taLoadModuleMo: " + loadModuleMoSU_Access;
        }
    }
}

