/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.util.eventhandler;

import java.util.Iterator;
import java.util.Vector;
import se.ericsson.cello.faultmanagement.AdditionalInfo;
import se.ericsson.cello.faultmanagement.AlarmManager;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.property.PropertyChangeEvent;
import se.ericsson.cello.property.PropertyChangeListener;
import se.ericsson.cello.su.extsuif.upgradepackage.util.enumer.NotifyingUpgradePackagePropertyName;
import se.ericsson.cello.su.extsuif.upgradepackage.util.time.Timer;
import se.ericsson.cello.su.extsuif.upgradepackage.util.time.TimerEvent;
import se.ericsson.cello.su.extsuif.upgradepackage.util.time.TimerListener;
import se.ericsson.cello.upgradepackage.main.UpgradePackageMoImpl;
import se.ericsson.cello.upgradepackage.main.event.UpgradePackageProperty;
import se.ericsson.cello.upgradepackage.main.event.progresstotal.ProgressTotalEvent;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.trace.datacontainer.TraceData;
import se.ericsson.cello.upgradepackage.trace.datacontainer.TraceError;
import se.ericsson.cello.upgradepackage.trace.datacontainer.TraceWarning;
import se.ericsson.cello.upgradepackage.util.datacontainer.AueInfo;
import se.ericsson.cello.upgradepackage.util.datacontainer.CreatingA_FinalConfigurationVersion;
import se.ericsson.cello.upgradepackage.util.datacontainer.CreatingA_RollbackConfigurationVersion;
import se.ericsson.cello.upgradepackage.util.datacontainer.CreatingA_SystemUpgradeConfigurationVersion;
import se.ericsson.cello.upgradepackage.util.datacontainer.CreationOfFinalConfigurationVersionFailed;
import se.ericsson.cello.upgradepackage.util.datacontainer.EnteringNormalModeInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.EnteringUpgradeModeInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.JVM_RestartRequestInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.NodeRestartReqInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.NodeUpgradeRequestInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.PIU_UpgradeRequestInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.PreUpgradeSU_Information;
import se.ericsson.cello.upgradepackage.util.datacontainer.ProgramAdditionRemovalInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.ProgressCount;
import se.ericsson.cello.upgradepackage.util.datacontainer.ProgressHeaderInformationInterface;
import se.ericsson.cello.upgradepackage.util.datacontainer.ReconfiguringMOsInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.SoftJvmUpgradeInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.SoftPIU_UpgradeRequestInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.StepLabel;
import se.ericsson.cello.upgradepackage.util.datacontainer.SuAueConfirmedWithWarningInfo;
import se.ericsson.cello.upgradepackage.util.datacontainer.SuAueFailureInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.TriggerInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.UpgradeExecutedInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.UpgradeExecutionFailedInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.UpgradeRequestedInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.VerificationInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.VerifyUP_Started;
import se.ericsson.cello.upgradepackage.util.datacontainer.WaitingForConfirmUpgrade;
import se.ericsson.cello.upgradepackage.util.datacontainer.WaitingForResumeUpgrade;
import se.ericsson.cello.upgradepackage.util.enumer.NotifyingTracePropertyName;
import se.ericsson.cello.upgradepackage.util.event.EventInformationInterface;
import se.ericsson.cello.upgradepackage.util.eventhandler.EventClientInterface;
import se.ericsson.cello.upgradepackage.util.library.SuLib;

public class UpgradeEventHandler
implements PropertyChangeListener,
TimerListener {
    private UpgradePackageMoImpl myUpgradePackage = null;
    private EventClientInterface myAdditionalEventClientInterface = null;
    private String myCurrentStepLabel = "";
    private int myCurrentStepCounter = 0;
    private int myCurrentTaskCounter = 0;
    private int myPreImplicitNumberOfTasks = 2;
    private int myPostImplicitNumberOfTasks = 2;
    private String myStepLabelWhenSendingLastEvent = "";
    private int myTotalTasks = 0;
    private Vector myTraceErrors = new Vector();
    private Timer myTimer = null;
    private ProgressHeaderInformationInterface myLatestUpgradeProgressInformation = null;
    private int myPreUpgradeState = -1;

    public UpgradeEventHandler(UpgradePackageMoImpl upgradePackageMoImpl, int n, String string, int n2, int n3, int n4) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "UpgradeEventHandler(UpgradePackageMoImpl anUpgradePackage, EventClientInterface anActionUpdateHandler, int aCurrentUpgradePackageState, String aCurrentStepLabel, int aTotalSteps, int aCurrentStepCounter, int aPreUpgradeState)", "anUpgradePackage: " + upgradePackageMoImpl + "\n\taCurrentUpgradePackageState: " + n + "\n\taCurrentStepLabel: " + string + "\n\taTotalSteps: " + n2 + "\n\taCurrentStepCounter: " + n3 + "\n\taPreUpgradeState: " + n4);
        }
        this.myUpgradePackage = upgradePackageMoImpl;
        this.myCurrentStepLabel = string;
        this.myCurrentStepCounter = n3;
        this.myPreUpgradeState = n4;
        if (this.myCurrentStepCounter > 0) {
            this.myTotalTasks = n2 + this.myPreImplicitNumberOfTasks + this.myPostImplicitNumberOfTasks;
            this.myCurrentTaskCounter = this.myCurrentStepCounter;
            if (n != 9) {
                this.myCurrentTaskCounter = this.myCurrentStepCounter + this.myPreImplicitNumberOfTasks;
            } else if (this.myPreUpgradeState == 1) {
                ++this.myCurrentTaskCounter;
            }
        }
        this.addAsListenerDefault();
    }

    public UpgradeEventHandler(UpgradePackageMoImpl upgradePackageMoImpl, EventClientInterface eventClientInterface, int n, String string, int n2, int n3) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "UpgradeEventHandler(UpgradePackageMoImpl anUpgradePackage, EventClientInterface anAdditionalEventClientInterface, int aCurrentUpgradePackageState, String aCurrentStepLabel, int aTotalSteps, int aCurrentStepCounter)", "anUpgradePackage: " + upgradePackageMoImpl + "\n\tanAdditionalEventClientInterface: " + eventClientInterface + "\n\taCurrentUpgradePackageState: " + n + "\n\taCurrentStepLabel: " + string + "\n\taTotalSteps: " + n2 + "\n\taCurrentStepCounter: " + n3);
        }
        this.myUpgradePackage = upgradePackageMoImpl;
        this.myAdditionalEventClientInterface = eventClientInterface;
        this.myCurrentStepLabel = string;
        this.myCurrentStepCounter = n3;
        this.myPreImplicitNumberOfTasks = 1;
        this.myPostImplicitNumberOfTasks = 1;
        this.addAsListenerDefault();
        this.addAsListenerAdditional();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "propertyChange(PropertyChangeEvent aPropertyChangeEvent)", "aPropertyChangeEvent: " + propertyChangeEvent);
        }
        try {
            if (propertyChangeEvent.getNewValue() instanceof ProgressHeaderInformationInterface) {
                ProgressHeaderInformationInterface progressHeaderInformationInterface = (ProgressHeaderInformationInterface)propertyChangeEvent.getNewValue();
                if (this.myLatestUpgradeProgressInformation == null) {
                    this.invokeHandleUpgradeProgressPropertyChange(progressHeaderInformationInterface, false);
                    this.myStepLabelWhenSendingLastEvent = this.myCurrentStepLabel;
                    this.myLatestUpgradeProgressInformation = progressHeaderInformationInterface;
                } else if (!this.myStepLabelWhenSendingLastEvent.equals(this.myCurrentStepLabel) || !this.myLatestUpgradeProgressInformation.getClass().getName().equals(progressHeaderInformationInterface.getClass().getName())) {
                    this.invokeHandleUpgradeProgressPropertyChange(progressHeaderInformationInterface, false);
                    this.myStepLabelWhenSendingLastEvent = this.myCurrentStepLabel;
                    this.myLatestUpgradeProgressInformation = progressHeaderInformationInterface;
                } else if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "propertyChange(PropertyChangeEvent aPropertyChangeEvent)", "Same type of progress information received twice within same step (IGNORED)\n\taPropertyChangeEvent: " + propertyChangeEvent + "\n\tNewValue: " + propertyChangeEvent.getNewValue());
                }
            } else if (propertyChangeEvent.getNewValue() instanceof UpgradePackageProperty) {
                this.invokeHandleUpgradePackagePropertyChange((UpgradePackageProperty)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getNewValue() instanceof TraceData) {
                this.invokeHandleTraceDataPropertyChange((TraceData)propertyChangeEvent.getNewValue());
            } else {
                Trace.info(this.getClass(), "propertyChange(PropertyChangeEvent aPropertyChangeEvent)", "Unexpected property type received (ignored)\n\taPropertyChangeEvent: " + propertyChangeEvent + "\n\tNewValue: " + propertyChangeEvent.getNewValue());
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "propertyChange(PropertyChangeEvent aPropertyChangeEvent)", "Throwable caught.\n\tThrowable data: " + throwable.toString(), throwable, false);
        }
    }

    public void setAdditionalEventClientInterface(EventClientInterface eventClientInterface) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setAdditionalEventClientInterface(EventClientInterface anAdditionalEventClientInterface)", "anAdditionalEventClientInterface: " + eventClientInterface);
        }
        if (this.myAdditionalEventClientInterface == null) {
            this.myAdditionalEventClientInterface = eventClientInterface;
            this.addAsListenerAdditional();
        }
    }

    public void stop() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "stop()");
        }
        this.removeAsListener();
        this.myUpgradePackage = null;
        this.myAdditionalEventClientInterface = null;
        this.myCurrentStepLabel = "";
        this.myCurrentStepCounter = 0;
        this.myCurrentTaskCounter = 0;
        this.myTotalTasks = 0;
        if (Trace.valid(this.getClass(), 40)) {
            Trace.debug(this.getClass(), 40, "stop( )", "The UpgradeEventHandler has been deactivated.");
        }
    }

    public void timerAction(TimerEvent timerEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "timerAction(TimerEvent aTimerEvent)", "aTimerEvent: " + timerEvent);
        }
        try {
            if (this.myLatestUpgradeProgressInformation != null) {
                this.invokeHandleUpgradeProgressPropertyChange(this.myLatestUpgradeProgressInformation, true);
            } else {
                Trace.info(this.getClass(), "timerAction ( TimerEvent aTimerEvent)", "Time out between events and latest sent event is null. Should never happen (ignored).\n\taTimerEvent: " + timerEvent);
            }
        }
        catch (Throwable throwable) {
            Trace.info(this.getClass(), "timerAction(TimerEvent aTimerEvent)", "Throwable caught when receiving a time out indication at event handling (IGNORED).\n\tThrowable data: " + throwable.toString());
        }
    }

    private void addAsListenerAdditional() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addAsListenerAdditional( )");
        }
        this.myAdditionalEventClientInterface.addPropertyChangeListener(NotifyingUpgradePackagePropertyName.VerifyUP_Started, this);
    }

    private void addAsListenerDefault() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addAsListenerDefault( )");
        }
        this.myUpgradePackage.addPropertyChangeListener(NotifyingUpgradePackagePropertyName.ProgressCount, this);
        this.myUpgradePackage.addPropertyChangeListener(NotifyingUpgradePackagePropertyName.ProgressInformation, this);
        this.myUpgradePackage.addPropertyChangeListener(NotifyingUpgradePackagePropertyName.ProgressTotal, this);
        this.myUpgradePackage.addPropertyChangeListener(NotifyingUpgradePackagePropertyName.StepLabel, this);
        Trace.addPropertyChangeListener(NotifyingTracePropertyName.Warning, this);
        Trace.addPropertyChangeListener(NotifyingTracePropertyName.Error, this);
    }

    private String getExecutingTaskNumber() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getExecutingTaskNumber()");
        }
        if (this.myTotalTasks != 0) {
            return "Executing task number " + this.myCurrentTaskCounter + " of " + this.myTotalTasks;
        }
        return "Executing task number " + this.myCurrentTaskCounter + " of x";
    }

    private void handleTraceDataPropertyChange(TraceError traceError) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleTraceDataPropertyChange(TraceError aTraceError)", "aTraceError: " + traceError);
        }
        this.myTraceErrors.add(traceError);
    }

    private void handleTraceDataPropertyChange(TraceWarning traceWarning) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleTraceDataPropertyChange(TraceWarning aTraceWarning)", "aTraceWarning: " + traceWarning);
        }
        AdditionalInfo[] additionalInfoArray = new AdditionalInfo[]{new AdditionalInfo("currentStepLabel", this.myCurrentStepLabel), new AdditionalInfo("TimeStamp", traceWarning.getTimeStamp()), new AdditionalInfo("Version", traceWarning.getVersion()), new AdditionalInfo("Slogan", traceWarning.getSlogan()), new AdditionalInfo("Class name", traceWarning.getClassName()), new AdditionalInfo("Method", traceWarning.getMethod())};
        int n = 72;
        if (AlarmManager.getReporter() != null) {
            AlarmManager.getReporter().reportEvent(n, (ManagedObject)this.myUpgradePackage, null, "", additionalInfoArray);
        }
    }

    private void handleTraceDataPropertyChange(TraceData traceData) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleTraceDataPropertyChange(TraceData aTraceData)", "aTraceData: " + traceData);
        }
    }

    private void handleUpgradePackagePropertyChange(ProgressCount progressCount) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleUpgradePackagePropertyChange(ProgressCount aProgressCount)", "aProgressCount: " + progressCount);
        }
        if (progressCount.getValue() != 0) {
            this.myCurrentTaskCounter += progressCount.getValue() - this.myCurrentStepCounter;
            this.myCurrentStepCounter = progressCount.getValue();
        }
    }

    private void handleUpgradePackagePropertyChange(ProgressTotalEvent progressTotalEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleUpgradePackagePropertyChange(ProgressTotalEvent aProgressTotalEvent)", "aProgressTotalEvent: " + progressTotalEvent);
        }
        if (progressTotalEvent.totalSteps != 0) {
            this.myTotalTasks = this.myPreImplicitNumberOfTasks + progressTotalEvent.totalSteps + this.myPostImplicitNumberOfTasks;
        }
    }

    private void handleUpgradePackagePropertyChange(StepLabel stepLabel) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleUpgradePackagePropertyChange(StepLabel aStepLabel)", "aStepLabel: " + stepLabel);
        }
        this.myCurrentStepLabel = stepLabel.getValue();
    }

    private void handleUpgradePackagePropertyChange(UpgradePackageProperty upgradePackageProperty) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleUpgradePackagePropertyChange(UpgradePackageProperty anUpgradePackageProperty)", "anUpgradePackageProperty: " + upgradePackageProperty);
        }
    }

    private void handleUpgradeProgressPropertyChange(VerifyUP_Started verifyUP_Started) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleUpgradeProgressPropertyChange(VerifyUP_Started aVerifyUP_Started)", "aVerifyUP_Started: " + verifyUP_Started);
        }
        this.sendEvent(verifyUP_Started);
    }

    private void handleUpgradeProgressPropertyChange(PreUpgradeSU_Information preUpgradeSU_Information) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleUpgradeProgressPropertyChange(PreUpgradeSU_Information aPreUpgradeSU_Information)", "aPreUpgradeSU_Information: " + preUpgradeSU_Information);
        }
        this.sendEvent(preUpgradeSU_Information);
    }

    private void handleUpgradeProgressPropertyChange(SoftJvmUpgradeInformation softJvmUpgradeInformation) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleUpgradeProgressPropertyChange(SoftJvmUpgradeInformation aSoftJvmUpgradeInformation)", "aSoftJvmUpgradeInformation: " + softJvmUpgradeInformation);
        }
        this.sendEvent(softJvmUpgradeInformation);
    }

    private void handleUpgradeProgressPropertyChange(VerificationInformation verificationInformation) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleUpgradeProgressPropertyChange(VerificationInformation anVerificationInformation)", "anVerificationInformation: " + verificationInformation);
        }
    }

    private void handleUpgradeProgressPropertyChange(CreatingA_RollbackConfigurationVersion creatingA_RollbackConfigurationVersion, boolean bl) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleUpgradeProgressPropertyChange(CreatingA_RollbackConfigurationVersion aCreatingA_RollbackConfigurationVersion, boolean anIsResendingAtTimeout)", "aCreatingA_RollbackConfigurationVersion: " + creatingA_RollbackConfigurationVersion + "\n\tanIsResendingAtTimeout: " + bl);
        }
        if (creatingA_RollbackConfigurationVersion.getCV_Name().startsWith("Rb")) {
            if (!bl) {
                ++this.myCurrentTaskCounter;
            }
            AdditionalInfo[] additionalInfoArray = new AdditionalInfo[]{new AdditionalInfo("CV_Name", creatingA_RollbackConfigurationVersion.getCV_Name()), new AdditionalInfo("CV_Type", creatingA_RollbackConfigurationVersion.getCV_Type())};
            this.sendEvent(creatingA_RollbackConfigurationVersion, additionalInfoArray);
        }
    }

    private void handleUpgradeProgressPropertyChange(EnteringUpgradeModeInformation enteringUpgradeModeInformation, boolean bl) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleUpgradeProgressPropertyChange(EnteringUpgradeModeInformation anEnteringUpgradeModeInformation, boolean anIsResendingAtTimeout)", "anEnteringUpgradeModeInformation: " + enteringUpgradeModeInformation + "anIsResendingAtTimeout: " + bl);
        }
        if (bl) {
            this.sendEvent(enteringUpgradeModeInformation);
        } else if (this.myLatestUpgradeProgressInformation instanceof CreatingA_RollbackConfigurationVersion || this.myPreUpgradeState == 1) {
            ++this.myCurrentTaskCounter;
            this.sendEvent(enteringUpgradeModeInformation);
        }
    }

    private void handleUpgradeProgressPropertyChange(ReconfiguringMOsInformation reconfiguringMOsInformation) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleUpgradeProgressPropertyChange(ReconfiguringMOsInformation aReconfiguringMOsInformation)", "aReconfiguringMOsInformation: " + reconfiguringMOsInformation);
        }
        AdditionalInfo[] additionalInfoArray = new AdditionalInfo[]{new AdditionalInfo("currentStepLabel", this.myCurrentStepLabel)};
        this.sendEvent(reconfiguringMOsInformation, additionalInfoArray);
    }

    private void handleUpgradeProgressPropertyChange(JVM_RestartRequestInformation jVM_RestartRequestInformation) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleUpgradeProgressPropertyChange( JVM_RestartRequestInformation aJVM_RestartRequestInformation )", "aJVM_RestartRequestInformation: " + jVM_RestartRequestInformation);
        }
        AdditionalInfo[] additionalInfoArray = new AdditionalInfo[]{new AdditionalInfo("currentStepLabel", this.myCurrentStepLabel)};
        this.sendEvent(jVM_RestartRequestInformation, additionalInfoArray);
    }

    private void handleUpgradeProgressPropertyChange(TriggerInformation triggerInformation) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleUpgradeProgressPropertyChange( TriggerInformation aTriggerInformation )", "aTriggerInformation: " + triggerInformation);
        }
        AdditionalInfo[] additionalInfoArray = new AdditionalInfo[]{new AdditionalInfo("currentStepLabel", this.myCurrentStepLabel)};
        this.sendEvent(triggerInformation, additionalInfoArray);
    }

    private void handleUpgradeProgressPropertyChange(NodeRestartReqInformation nodeRestartReqInformation) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleUpgradeProgressPropertyChange(NodeRestartReqInformation aNodeRestartReqInformation, boolean anIsResendingAtTimeout)", "aNodeRestartReqInformation: " + nodeRestartReqInformation);
        }
        AdditionalInfo[] additionalInfoArray = new AdditionalInfo[]{new AdditionalInfo("currentStepLabel", this.myCurrentStepLabel), new AdditionalInfo("reason", nodeRestartReqInformation.getReason())};
        this.sendEvent(nodeRestartReqInformation, additionalInfoArray);
    }

    private void handleUpgradeProgressPropertyChange(NodeUpgradeRequestInformation nodeUpgradeRequestInformation) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleUpgradeProgressPropertyChange( NodeUpgradeRequestInformation aNodeUpgradeRequestInformation )", "aNodeUpgradeRequestInformation: " + nodeUpgradeRequestInformation);
        }
        AdditionalInfo[] additionalInfoArray = new AdditionalInfo[]{new AdditionalInfo("currentStepLabel", this.myCurrentStepLabel)};
        this.sendEvent(nodeUpgradeRequestInformation, additionalInfoArray);
    }

    private void handleUpgradeProgressPropertyChange(PIU_UpgradeRequestInformation pIU_UpgradeRequestInformation) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleUpgradeProgressPropertyChange( PIU_UpgradeRequestInformation aPIU_UpgradeRequestInformation )", "aPIU_UpgradeRequestInformation: " + pIU_UpgradeRequestInformation);
        }
        AdditionalInfo[] additionalInfoArray = new AdditionalInfo[]{new AdditionalInfo("currentStepLabel", this.myCurrentStepLabel)};
        this.sendEvent(pIU_UpgradeRequestInformation, additionalInfoArray);
    }

    private void handleUpgradeProgressPropertyChange(SoftPIU_UpgradeRequestInformation softPIU_UpgradeRequestInformation) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleUpgradeProgressPropertyChange( SoftPIU_UpgradeRequestInformation aSoftPIU_UpgradeRequestInformation )", "aSoftPIU_UpgradeRequestInformation: " + softPIU_UpgradeRequestInformation);
        }
        AdditionalInfo[] additionalInfoArray = new AdditionalInfo[]{new AdditionalInfo("currentStepLabel", this.myCurrentStepLabel)};
        this.sendEvent(softPIU_UpgradeRequestInformation, additionalInfoArray);
    }

    private void handleUpgradeProgressPropertyChange(ProgramAdditionRemovalInformation programAdditionRemovalInformation) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleUpgradeProgressPropertyChange( ProgramAdditionRemovalInformation aProgramAdditionRemovalInformation )", "aProgramAdditionRemovalInformation: " + programAdditionRemovalInformation);
        }
        AdditionalInfo[] additionalInfoArray = new AdditionalInfo[]{new AdditionalInfo("currentStepLabel", this.myCurrentStepLabel)};
        this.sendEvent(programAdditionRemovalInformation, additionalInfoArray);
    }

    private void handleUpgradeProgressPropertyChange(EnteringNormalModeInformation enteringNormalModeInformation, boolean bl) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleUpgradeProgressPropertyChange(EnteringNormalModeInformation aEnteringNormalModeInformation, boolean anIsResendingAtTimeout)", "aEnteringNormalModeInformation: " + enteringNormalModeInformation + "\n\tanIsResendingAtTimeout: " + bl);
        }
        if (!bl) {
            ++this.myCurrentTaskCounter;
        }
        this.sendEvent(enteringNormalModeInformation);
    }

    private void handleUpgradeProgressPropertyChange(CreatingA_SystemUpgradeConfigurationVersion creatingA_SystemUpgradeConfigurationVersion) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleUpgradeProgressPropertyChange(CreatingA_SystemUpgradeConfigurationVersion aCreatingA_SystemUpgradeConfigurationVersion)", "aCreatingA_SystemUpgradeConfigurationVersion: " + creatingA_SystemUpgradeConfigurationVersion);
        }
        AdditionalInfo[] additionalInfoArray = new AdditionalInfo[]{new AdditionalInfo("currentStepLabel", this.myCurrentStepLabel), new AdditionalInfo("CV_Name", creatingA_SystemUpgradeConfigurationVersion.getCV_Name()), new AdditionalInfo("CV_Type", creatingA_SystemUpgradeConfigurationVersion.getCV_Type())};
        this.sendEvent(creatingA_SystemUpgradeConfigurationVersion, additionalInfoArray);
    }

    private void handleUpgradeProgressPropertyChange(CreatingA_FinalConfigurationVersion creatingA_FinalConfigurationVersion, boolean bl) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleUpgradeProgressPropertyChange(CreatingA_FinalConfigurationVersion aCreatingA_FinalConfigurationVersion, boolean anIsResendingAtTimeout)", "aCreatingA_FinalConfigurationVersion: " + creatingA_FinalConfigurationVersion + "\n\tanIsResendingAtTimeout: " + bl);
        }
        if (creatingA_FinalConfigurationVersion.getCV_Name().startsWith("Fi")) {
            if (!bl) {
                ++this.myCurrentTaskCounter;
            }
            AdditionalInfo[] additionalInfoArray = new AdditionalInfo[]{new AdditionalInfo("CV_Name", creatingA_FinalConfigurationVersion.getCV_Name()), new AdditionalInfo("CV_Type", creatingA_FinalConfigurationVersion.getCV_Type())};
            this.sendEvent(creatingA_FinalConfigurationVersion, additionalInfoArray);
        }
    }

    private void handleUpgradeProgressPropertyChange(WaitingForConfirmUpgrade waitingForConfirmUpgrade) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleUpgradeProgressPropertyChange( WaitingForConfirmUpgrade aWaitingForConfirmUpgrade )", "aWaitingForConfirmUpgrade: " + waitingForConfirmUpgrade);
        }
        AdditionalInfo[] additionalInfoArray = new AdditionalInfo[]{new AdditionalInfo("currentStepLabel", this.myCurrentStepLabel)};
        this.sendEvent(waitingForConfirmUpgrade, additionalInfoArray);
    }

    private void handleUpgradeProgressPropertyChange(WaitingForResumeUpgrade waitingForResumeUpgrade) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleUpgradeProgressPropertyChange( WaitingForResumeUpgrade aWaitingForResumeUpgrade )", "aWaitingForResumeUpgrade: " + waitingForResumeUpgrade);
        }
        AdditionalInfo[] additionalInfoArray = new AdditionalInfo[]{new AdditionalInfo("currentStepLabel", this.myCurrentStepLabel)};
        this.sendEvent(waitingForResumeUpgrade, additionalInfoArray);
    }

    private void handleUpgradeProgressPropertyChange(UpgradeExecutedInformation upgradeExecutedInformation) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleUpgradeProgressPropertyChange( UpgradeExecutedInformation anUpgradeExecutedInformation )", "anUpgradeExecutedInformation: " + upgradeExecutedInformation);
        }
        this.sendEvent(upgradeExecutedInformation);
    }

    private void handleUpgradeProgressPropertyChange(UpgradeExecutionFailedInformation upgradeExecutionFailedInformation) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleUpgradeProgressPropertyChange( UpgradeExecutionFailedInformation anUpgradeExecutionFailedInformation )", "anUpgradeExecutionFailedInformation: " + upgradeExecutionFailedInformation);
        }
        Throwable throwable = upgradeExecutionFailedInformation.getException();
        String string = "";
        if (throwable != null) {
            string = throwable.toString();
        }
        AdditionalInfo[] additionalInfoArray = new AdditionalInfo[3 + this.myTraceErrors.size() * 6];
        int n = 0;
        additionalInfoArray[n++] = new AdditionalInfo("currentStepLabel", this.myCurrentStepLabel);
        additionalInfoArray[n++] = new AdditionalInfo("reason", upgradeExecutionFailedInformation.getReason());
        additionalInfoArray[n++] = new AdditionalInfo("last exception", string);
        Iterator iterator = this.myTraceErrors.iterator();
        TraceError traceError = null;
        while (iterator.hasNext()) {
            traceError = (TraceError)iterator.next();
            additionalInfoArray[n++] = new AdditionalInfo("TimeStamp", traceError.getTimeStamp());
            additionalInfoArray[n++] = new AdditionalInfo("Version", traceError.getVersion());
            additionalInfoArray[n++] = new AdditionalInfo("Slogan", traceError.getSlogan());
            additionalInfoArray[n++] = new AdditionalInfo("Class name", traceError.getClassName());
            additionalInfoArray[n++] = new AdditionalInfo("Method", traceError.getMethod());
            if (traceError.getException() != null) {
                additionalInfoArray[n++] = new AdditionalInfo("Exception", traceError.getException().toString());
                continue;
            }
            additionalInfoArray[n++] = new AdditionalInfo("Exception", "-");
        }
        this.sendEvent(upgradeExecutionFailedInformation, additionalInfoArray);
    }

    private void handleUpgradeProgressPropertyChange(CreationOfFinalConfigurationVersionFailed creationOfFinalConfigurationVersionFailed) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleUpgradeProgressPropertyChange( CreationOfFinalConfigurationVersionFailed aCreationOfFinalConfigurationVersionFailed )", "aCreationOfFinalConfigurationVersionFailed: " + creationOfFinalConfigurationVersionFailed);
        }
        AdditionalInfo[] additionalInfoArray = new AdditionalInfo[]{new AdditionalInfo("reason", creationOfFinalConfigurationVersionFailed.getReason())};
        this.sendEvent(creationOfFinalConfigurationVersionFailed, additionalInfoArray);
    }

    private void handleUpgradeProgressPropertyChange(UpgradeRequestedInformation upgradeRequestedInformation) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleUpgradeProgressPropertyChange(UpgradeRequestedInformation anUpgradeRequestedInformation)", "anUpgradeRequestedInformation: " + upgradeRequestedInformation);
        }
        this.sendEvent(upgradeRequestedInformation);
    }

    private void handleUpgradeProgressPropertyChange(SuAueConfirmedWithWarningInfo suAueConfirmedWithWarningInfo) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleUpgradeProgressPropertyChange(SuAueConfirmedWithWarningInfo aSuAueConfirmedWithWarningInfo)", "aSuAueConfirmedWithWarningInfo: " + suAueConfirmedWithWarningInfo);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("AUE participator name=");
        stringBuffer.append(suAueConfirmedWithWarningInfo.getParticipatorName());
        stringBuffer.append(suAueConfirmedWithWarningInfo.getActionResultDatasToString());
        AdditionalInfo[] additionalInfoArray = new AdditionalInfo[]{new AdditionalInfo("reason", stringBuffer.toString())};
        this.sendEvent(suAueConfirmedWithWarningInfo, additionalInfoArray);
    }

    private void handleUpgradeProgressPropertyChange(SuAueFailureInformation suAueFailureInformation) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleUpgradeProgressPropertyChange(SuAueFailureInformation aSuAueFailureInformation)", "aSuAueFailureInformation: " + suAueFailureInformation);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("AUE participator name=");
        stringBuffer.append(suAueFailureInformation.getParticipatorName());
        stringBuffer.append(suAueFailureInformation.getActionResultDatasToString());
        AdditionalInfo[] additionalInfoArray = new AdditionalInfo[]{new AdditionalInfo("reason", stringBuffer.toString())};
        this.sendEvent(suAueFailureInformation, additionalInfoArray);
    }

    private void handleUpgradeProgressPropertyChange(AueInfo aueInfo) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleUpgradeProgressPropertyChange(AueInfo anAueInfo)", "anAueInfo: " + aueInfo);
        }
        String[] stringArray = aueInfo.getAdditionalInfo();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i] + " ");
        }
        stringBuffer.append("AUE participator name=");
        stringBuffer.append(aueInfo.getParticipatorName());
        AdditionalInfo[] additionalInfoArray = new AdditionalInfo[]{new AdditionalInfo("reason", stringBuffer.toString())};
        this.sendEvent(aueInfo, additionalInfoArray);
    }

    private void handleUpgradeProgressPropertyChange(ProgressHeaderInformationInterface progressHeaderInformationInterface) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleUpgradeProgressPropertyChange(ProgressHeaderInformationInterface aProgressHeaderInformationInterface)", "aProgressHeaderInformationInterface: " + progressHeaderInformationInterface);
        }
    }

    private void invokeHandleTraceDataPropertyChange(TraceData traceData) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "invokeHandleTraceDataPropertyChange(TraceData aTraceData)", "aTraceData: " + traceData);
        }
        if (traceData instanceof TraceError) {
            this.handleTraceDataPropertyChange((TraceError)traceData);
        } else if (traceData instanceof TraceWarning) {
            this.handleTraceDataPropertyChange((TraceWarning)traceData);
        } else {
            this.handleTraceDataPropertyChange(traceData);
        }
    }

    private void invokeHandleUpgradePackagePropertyChange(UpgradePackageProperty upgradePackageProperty) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "invokeHandleUpgradePackagePropertyChange(UpgradePackageProperty anUpgradePackageProperty)", "anUpgradePackageProperty: " + upgradePackageProperty);
        }
        if (upgradePackageProperty instanceof ProgressCount) {
            this.handleUpgradePackagePropertyChange((ProgressCount)upgradePackageProperty);
        } else if (upgradePackageProperty instanceof ProgressTotalEvent) {
            this.handleUpgradePackagePropertyChange((ProgressTotalEvent)upgradePackageProperty);
        } else if (upgradePackageProperty instanceof StepLabel) {
            this.handleUpgradePackagePropertyChange((StepLabel)upgradePackageProperty);
        } else {
            this.handleUpgradePackagePropertyChange(upgradePackageProperty);
        }
    }

    private void invokeHandleUpgradeProgressPropertyChange(ProgressHeaderInformationInterface progressHeaderInformationInterface, boolean bl) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "invokeHandleUpgradeProgressPropertyChange(ProgressHeaderInformationInterface aProgressHeaderInformationInterface)", "aProgressHeaderInformationInterface: " + progressHeaderInformationInterface + "\n\tanIsResendingAtTimeout: " + bl);
        }
        if (progressHeaderInformationInterface instanceof VerifyUP_Started) {
            this.handleUpgradeProgressPropertyChange((VerifyUP_Started)progressHeaderInformationInterface);
        } else if (progressHeaderInformationInterface instanceof VerificationInformation) {
            this.handleUpgradeProgressPropertyChange((VerificationInformation)progressHeaderInformationInterface);
        } else if (progressHeaderInformationInterface instanceof PreUpgradeSU_Information) {
            this.handleUpgradeProgressPropertyChange((PreUpgradeSU_Information)progressHeaderInformationInterface);
        } else if (progressHeaderInformationInterface instanceof SoftJvmUpgradeInformation) {
            this.handleUpgradeProgressPropertyChange((SoftJvmUpgradeInformation)progressHeaderInformationInterface);
        } else if (progressHeaderInformationInterface instanceof CreatingA_RollbackConfigurationVersion) {
            this.handleUpgradeProgressPropertyChange((CreatingA_RollbackConfigurationVersion)progressHeaderInformationInterface, bl);
        } else if (progressHeaderInformationInterface instanceof EnteringUpgradeModeInformation) {
            this.handleUpgradeProgressPropertyChange((EnteringUpgradeModeInformation)progressHeaderInformationInterface, bl);
        } else if (progressHeaderInformationInterface instanceof ReconfiguringMOsInformation) {
            this.handleUpgradeProgressPropertyChange((ReconfiguringMOsInformation)progressHeaderInformationInterface);
        } else if (progressHeaderInformationInterface instanceof JVM_RestartRequestInformation) {
            this.handleUpgradeProgressPropertyChange((JVM_RestartRequestInformation)progressHeaderInformationInterface);
        } else if (progressHeaderInformationInterface instanceof TriggerInformation) {
            this.handleUpgradeProgressPropertyChange((TriggerInformation)progressHeaderInformationInterface);
        } else if (progressHeaderInformationInterface instanceof NodeRestartReqInformation) {
            this.handleUpgradeProgressPropertyChange((NodeRestartReqInformation)progressHeaderInformationInterface);
        } else if (progressHeaderInformationInterface instanceof NodeUpgradeRequestInformation) {
            this.handleUpgradeProgressPropertyChange((NodeUpgradeRequestInformation)progressHeaderInformationInterface);
        } else if (progressHeaderInformationInterface instanceof PIU_UpgradeRequestInformation) {
            this.handleUpgradeProgressPropertyChange((PIU_UpgradeRequestInformation)progressHeaderInformationInterface);
        } else if (progressHeaderInformationInterface instanceof SoftPIU_UpgradeRequestInformation) {
            this.handleUpgradeProgressPropertyChange((SoftPIU_UpgradeRequestInformation)progressHeaderInformationInterface);
        } else if (progressHeaderInformationInterface instanceof ProgramAdditionRemovalInformation) {
            this.handleUpgradeProgressPropertyChange((ProgramAdditionRemovalInformation)progressHeaderInformationInterface);
        } else if (progressHeaderInformationInterface instanceof EnteringNormalModeInformation) {
            this.handleUpgradeProgressPropertyChange((EnteringNormalModeInformation)progressHeaderInformationInterface, bl);
        } else if (progressHeaderInformationInterface instanceof CreatingA_SystemUpgradeConfigurationVersion) {
            this.handleUpgradeProgressPropertyChange((CreatingA_SystemUpgradeConfigurationVersion)progressHeaderInformationInterface);
        } else if (progressHeaderInformationInterface instanceof CreatingA_FinalConfigurationVersion) {
            this.handleUpgradeProgressPropertyChange((CreatingA_FinalConfigurationVersion)progressHeaderInformationInterface, bl);
        } else if (progressHeaderInformationInterface instanceof WaitingForConfirmUpgrade) {
            this.handleUpgradeProgressPropertyChange((WaitingForConfirmUpgrade)progressHeaderInformationInterface);
        } else if (progressHeaderInformationInterface instanceof WaitingForResumeUpgrade) {
            this.handleUpgradeProgressPropertyChange((WaitingForResumeUpgrade)progressHeaderInformationInterface);
        } else if (progressHeaderInformationInterface instanceof UpgradeExecutedInformation) {
            this.handleUpgradeProgressPropertyChange((UpgradeExecutedInformation)progressHeaderInformationInterface);
        } else if (progressHeaderInformationInterface instanceof UpgradeExecutionFailedInformation) {
            this.handleUpgradeProgressPropertyChange((UpgradeExecutionFailedInformation)progressHeaderInformationInterface);
        } else if (progressHeaderInformationInterface instanceof CreationOfFinalConfigurationVersionFailed) {
            this.handleUpgradeProgressPropertyChange((CreationOfFinalConfigurationVersionFailed)progressHeaderInformationInterface);
        } else if (progressHeaderInformationInterface instanceof UpgradeRequestedInformation) {
            this.handleUpgradeProgressPropertyChange((UpgradeRequestedInformation)progressHeaderInformationInterface);
        } else if (progressHeaderInformationInterface instanceof SuAueConfirmedWithWarningInfo) {
            this.handleUpgradeProgressPropertyChange((SuAueConfirmedWithWarningInfo)progressHeaderInformationInterface);
        } else if (progressHeaderInformationInterface instanceof SuAueFailureInformation) {
            this.handleUpgradeProgressPropertyChange((SuAueFailureInformation)progressHeaderInformationInterface);
        } else if (progressHeaderInformationInterface instanceof AueInfo) {
            this.handleUpgradeProgressPropertyChange((AueInfo)progressHeaderInformationInterface);
        } else {
            this.handleUpgradeProgressPropertyChange(progressHeaderInformationInterface);
        }
    }

    private void removeAsListener() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "removeAsListener()");
        }
        this.myUpgradePackage.removePropertyChangeListener(NotifyingUpgradePackagePropertyName.ProgressCount, this);
        this.myUpgradePackage.removePropertyChangeListener(NotifyingUpgradePackagePropertyName.ProgressInformation, this);
        this.myUpgradePackage.removePropertyChangeListener(NotifyingUpgradePackagePropertyName.ProgressTotal, this);
        this.myUpgradePackage.removePropertyChangeListener(NotifyingUpgradePackagePropertyName.StepLabel, this);
        if (this.myAdditionalEventClientInterface != null) {
            this.myAdditionalEventClientInterface.removePropertyChangeListener(NotifyingUpgradePackagePropertyName.VerifyUP_Started, this);
        }
        Trace.removePropertyChangeListener(NotifyingTracePropertyName.Warning, this);
        Trace.removePropertyChangeListener(NotifyingTracePropertyName.Error, this);
        if (this.myTimer != null) {
            this.myTimer.removeListener(this);
            this.myTimer.stopTimer();
        }
    }

    private void sendEvent(UpgradeExecutedInformation upgradeExecutedInformation) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "sendEvent(UpgradeProgressInformation anUpgradeProgressInformation)", "anUpgradeExecutedInformation: " + upgradeExecutedInformation);
        }
        this.sendEvent(upgradeExecutedInformation.getEventId(), "", null);
    }

    private void sendEvent(UpgradeRequestedInformation upgradeRequestedInformation) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "sendEvent(UpgradeRequestedInformation anUpgradeRequestedInformation)", "anUpgradeRequestedInformation: " + upgradeRequestedInformation);
        }
        this.sendEvent(upgradeRequestedInformation.getEventId(), "", null);
    }

    private void sendEvent(EventInformationInterface eventInformationInterface) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "sendEvent(UpgradePackageEventInformation anUpgradePackageEventInformation)", "anUpgradePackageEventInformation: " + eventInformationInterface);
        }
        this.sendEvent(eventInformationInterface.getEventId(), this.getExecutingTaskNumber(), null);
    }

    private void sendEvent(EventInformationInterface eventInformationInterface, AdditionalInfo[] additionalInfoArray) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "sendEvent(UpgradePackageEventInformation anUpgradePackageEventInformation, AdditionalInfo[] anAdditionalInformations)", "anUpgradePackageEventInformation: " + eventInformationInterface + "\n\tanAdditionalInformations: " + SuLib.toString(additionalInfoArray));
        }
        this.sendEvent(eventInformationInterface.getEventId(), this.getExecutingTaskNumber(), additionalInfoArray);
    }

    private void sendEvent(int n, String string, AdditionalInfo[] additionalInfoArray) {
        block18: {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "sendEvent(int anEventId, String anAdditionalText, AdditionalInfo[] anAdditionalInformations)", "anEventId: " + n + "\n\tanAdditionalText: " + string + "\n\tanAdditionalInformations: " + SuLib.toString(additionalInfoArray));
            }
            try {
                String string2 = string;
                if (additionalInfoArray != null && additionalInfoArray.length > 0) {
                    string2 = string2 + "\n" + SuLib.toString(additionalInfoArray);
                }
                AdditionalInfo[] additionalInfoArray2 = new AdditionalInfo[]{};
                if (this.myUpgradePackage.getSendEvents(null)) {
                    try {
                        if (AlarmManager.getReporter() != null) {
                            AlarmManager.getReporter().reportEvent(n, (ManagedObject)this.myUpgradePackage, null, string2, additionalInfoArray2);
                        }
                        if (Trace.valid(this.getClass(), 40)) {
                            Trace.debug(this.getClass(), 40, "sendEvent(int anEventId, String anAdditionalText)", "Event has been sent, id=" + n + ", additional text=" + string);
                        }
                        if (Trace.valid(this.getClass(), 22)) {
                            Trace.debug(this.getClass(), 22, "sendEvent(int anEventId, String anAdditionalText)", "Event has been sent, anEventId: " + n + "\n\tanAdditionalText: " + string);
                        }
                    }
                    catch (Throwable throwable) {
                        String string3 = "null";
                        if (additionalInfoArray != null) {
                            AdditionalInfo additionalInfo = null;
                            string3 = "anAdditionalInformations length: " + additionalInfoArray.length;
                            for (int i = 0; i < additionalInfoArray.length; ++i) {
                                additionalInfo = additionalInfoArray[i];
                                if (Trace.valid(this.getClass(), 22)) {
                                    Trace.debug(this.getClass(), 22, "sendEvent(int anEventId, String anAdditionalText)", "AdditionalInfo[" + i + "]: " + "\n\t\ttheAdditionalInfo: " + additionalInfo + "\n\tanAdditionalInformations.length: " + additionalInfoArray.length);
                                }
                                string3 = string3 + "\n\tAdditionalInfo[" + i + "]: ";
                                string3 = string3 + "\n\t\tname: " + additionalInfo.getName() + "\n\t\tvalue: " + additionalInfo.getValue();
                            }
                        }
                        Trace.error(this.getClass(), "sendEvent(int anEventId, String anAdditionalText)", "Throwable caught when sending event with following data: \n\t\tType: " + this.myUpgradePackage.getType() + "\n\t\tFullDistinguishedName: " + this.myUpgradePackage.getFullDistinguishedName() + "\n\tTime: " + null + "\n\tType eventId: " + this.myUpgradePackage.getType() + " " + n + "\n\tanAdditionalText: " + string + "\n\tanAdditionalInformations: " + string3);
                    }
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "sendEvent(int anEventId, String anAdditionalText)", "Start time supervision between events.");
                    }
                    if (this.myTimer == null) {
                        this.myTimer = new Timer(this.myUpgradePackage.getMaxTimeBetweenUpgradeEvents(null) * 60 * 1000);
                        this.myTimer.addListener(this);
                        this.myTimer.startTimer();
                    } else {
                        this.myTimer.removeListener(this);
                        this.myTimer.stopTimer();
                        this.myTimer = new Timer(this.myUpgradePackage.getMaxTimeBetweenUpgradeEvents(null) * 60 * 1000);
                        this.myTimer.addListener(this);
                        this.myTimer.startTimer();
                    }
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "sendEvent(int anEventId, String anAdditionalText)", "Stop time supervision between events.");
                    }
                    break block18;
                }
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "sendEvent(int anEventId, String anAdditionalText)", "Event has not been sent since it is configured to NOT be sent.anEventId: " + n + "\n\tanAdditionalText: " + string);
                }
            }
            catch (MoAccessException moAccessException) {
                Trace.info(this.getClass(), "sendEvent(int anEventId, String anAdditionalText)", "Failed to send event due to MoAccessException was caught (IGNORED).\n\tException data: " + moAccessException.toString() + "\n\tanEventId: " + n + "\n\tanAdditionalText: " + string + "\n\tanAdditionalInformations: " + SuLib.toString(additionalInfoArray));
            }
        }
    }
}

