/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.util.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.file.FileCopyException;
import se.ericsson.cello.upgradepackage.util.file.FileNotExistException;
import se.ericsson.cello.upgradepackage.util.library.SuLib;
import se.ericsson.cello.upgradepackage.util.mohandler.managedelementdata.ManagedElementDataMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;

public class FileHandler {
    public static boolean enoughWithDiskSpaceForCopy(File file) throws FileCopyException {
        if (Trace.valid(FileHandler.class, 20)) {
            Trace.debug(FileHandler.class, 20, "enoughWithDiskSpaceForCopy (File aSourceFile)", "aSourceFile: " + file);
        }
        try {
            ManagedElementDataMO_HandlerInterface managedElementDataMO_HandlerInterface = ServiceFinder.getManagedElementDataMO_HandlerInterface();
            long l = managedElementDataMO_HandlerInterface.getHdVolumeCFreespace(null);
            long l2 = 0L;
            long l3 = 0L;
            l2 = file.length();
            if (l2 != 0L) {
                l2 = l2 / 1024L / 1024L;
            }
            long l4 = l2 + l3;
            if (Trace.valid(FileHandler.class, 20)) {
                Trace.debug(FileHandler.class, 20, "enoughWithDiskSpaceForCopy (File aSourceFile)", "theRequiredFileSize: " + l4 + "\n\ttheAvailableDiskspace: " + l);
            }
            boolean bl = false;
            if (l == -1L) {
                bl = true;
            } else if (l > l4) {
                bl = true;
            }
            if (Trace.valid(FileHandler.class, 21)) {
                Trace.debug(FileHandler.class, 21, "enoughWithDiskSpaceForCopy (File aSourceFile)", "RETURNS: " + bl);
            }
            return bl;
        }
        catch (Throwable throwable) {
            Trace.error(FileHandler.class, "enoughWithDiskSpaceForCopy (File aSourceFile)", "aSourceFile: " + file + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable);
            throw new FileCopyException("Class name: FileHandler\n\tenoughWithDiskSpaceForCopy (File aSourceFile)\n\taSourceFile: " + file + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable);
        }
    }

    public static void copyFile(File file, File file2) throws FileNotExistException, FileCopyException {
        if (Trace.valid(FileHandler.class, 20)) {
            Trace.debug(FileHandler.class, 20, "copyFile(File aSourceFile, File aDestinationFile)", "aSourceFile: " + file + "\n\taDestinationFile: " + file2);
        }
        if (file == null || !file.exists()) {
            Trace.info(FileHandler.class, "copyUCF(File anFromUCF, File anToUCF)", "The source (from) file do not exist. Not possible to copy...\n\ttheFromUCF: " + SuLib.toString(file) + "\n\ttheToUCF: " + SuLib.toString(file2));
            throw new FileNotExistException("The source (from) file do not exist. Not possible to copy...\n\ttheFromUCF: " + SuLib.toString(file) + "\n\ttheToUCF: " + SuLib.toString(file2));
        }
        if (Trace.valid(FileHandler.class, 20)) {
            Trace.debug(FileHandler.class, 20, "copyUCF(File anFromUCF, File anToUCF)", "aSourceFile: " + SuLib.toString(file) + "\n\taDestinationFile: " + SuLib.toString(file2));
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[1024];
            int n = 0;
            while ((n = fileInputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileInputStream.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            Trace.error(FileHandler.class, "copyUCF(File anFromUCF, File anToUCF)", "Failed to copy the source file " + SuLib.toString(file) + " to the destination file " + SuLib.toString(file2) + ".", exception);
            throw new FileCopyException("Failed to copy the source file " + SuLib.toString(file) + " to the destination file " + SuLib.toString(file2) + ".");
        }
    }

    public static void removeFile(File file) {
        if (Trace.valid(FileHandler.class, 20)) {
            Trace.debug(FileHandler.class, 20, "removeFile ( File aFile )");
        }
        try {
            if (file != null && file.exists()) {
                if (Trace.valid(FileHandler.class, 6)) {
                    Trace.debug("removeFile ( File aFile )", "Deleting file: " + file.getAbsoluteFile());
                }
                file.delete();
            }
        }
        catch (Exception exception) {
            Trace.info(FileHandler.class, "removeTempUCF ( String anUCF_ToBeRemoved )", "Failed to remove the file " + SuLib.toString(file));
        }
    }

    public static boolean doesFilesExist(Collection collection) {
        if (Trace.valid(FileHandler.class, 20)) {
            Trace.debug(FileHandler.class, 20, "doesFilesExist(Collection aFilePaths)", "aFilePaths: " + collection);
        }
        boolean bl = true;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (FileHandler.doesFileExist((String)iterator.next())) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public static boolean doesFileExist(String string) {
        if (Trace.valid(FileHandler.class, 20)) {
            Trace.debug(FileHandler.class, 20, "doesFileExist(String aFilePath)", "aFilePath: " + string);
        }
        File file = new File(string);
        return file.exists();
    }

    public static Collection toString(Collection collection) {
        Iterator iterator = collection.iterator();
        Object e = null;
        LinkedList<String> linkedList = new LinkedList<String>();
        while (iterator.hasNext()) {
            e = iterator.next();
            if (e instanceof File) {
                linkedList.add(((File)e).getAbsolutePath());
                continue;
            }
            linkedList.add((String)e);
        }
        return linkedList;
    }
}

