/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.verify.ssw;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import se.ericsson.cello.equipment.suaccess.PlugInUnitMoSU_Access;
import se.ericsson.cello.su.extsuif.upgradepackage.util.enumer.TypeOfUpgrade;
import se.ericsson.cello.su.froproxy.swinstall.interfaces.OsaSwInstallProxyAccess;
import se.ericsson.cello.su.signedsw.SignedSoftwareUtils;
import se.ericsson.cello.su.util.versionhandler.SU_AccessVersionHandler;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.sequence.SupportedSequenceInformation;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.sequence.ValidSequencesInformation;
import se.ericsson.cello.sudom.proxy.OptimizedDocumentObjectProxyInterface;
import se.ericsson.cello.sudom.proxy.UCF_ParserFacade;
import se.ericsson.cello.sudom.proxy.exceptions.UpgradeControlFileParserException;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMoExtended;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.mohandler.managedelement.ManagedElementMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.upgradeable.UpgradeablePIU_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;
import se.ericsson.cello.upgradepackage.verify.CalculateCAUEs;
import se.ericsson.cello.upgradepackage.verify.CalculateJAUEs;
import se.ericsson.cello.upgradepackage.verify.CalculateProgramsForToState;
import se.ericsson.cello.upgradepackage.verify.VerifyRequestException;
import se.ericsson.cello.upgradepackage.verify.ssw.CalculateJavaLMsForToState;
import se.ericsson.cello.upgradepackage.verify.ssw.CalculateOtherLMsForToState;
import se.ericsson.cello.upgradepackage.verify.ssw.SSW_ValidationInformation;
import se.ericsson.cello.upgradepackage.verify.ssw.SSW_Validator;
import se.ericsson.cello.upgradepackage.verify.ssw.SignedSoftwareInformationForPIU_Interface;

public class SignedSoftwareVerifier {
    public static final String SSW_FILE_NAME = "ssw.xml";
    public static final String SSW_FILE_NAME_FROM = "ssw_from.xml";

    private Collection getSignedUpgradeablePIUs() throws VerifyRequestException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getSignedUpgradeablePIUs()");
        }
        UpgradeablePIU_HandlerInterface upgradeablePIU_HandlerInterface = ServiceFinder.getUpgradeablePIU_HandlerInterface();
        try {
            Collection collection = upgradeablePIU_HandlerInterface.getSignedUpgradeablePlugInUnits();
            if (SignedSoftwareUtils.hasSSW_UpgradeablePlugInUnit(collection)) {
                ManagedElementMO_HandlerInterface managedElementMO_HandlerInterface = ServiceFinder.getManagedElementMO_HandlerInterface();
                PlugInUnitMoSU_Access[] plugInUnitMoSU_AccessArray = managedElementMO_HandlerInterface.getFtcMos();
                if ((plugInUnitMoSU_AccessArray = SignedSoftwareUtils.contains(collection, plugInUnitMoSU_AccessArray)).length == 0) {
                    collection = SignedSoftwareUtils.removeAllSSW_UpgradeablePlugInUnit(collection);
                }
            }
            return collection;
        }
        catch (Exception exception) {
            throw new VerifyRequestException(exception.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getSignedUpgradeablePIUs()", "getSignedUpgradeablePIUs()", throwable);
            throw new VerifyRequestException(throwable.toString());
        }
    }

    public SSW_ValidationInformation execute(String string, String string2, String string3, String string4, SupportedSequenceInformation supportedSequenceInformation) throws VerifyRequestException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "execute(String anUP_ProductNumber, String anUP_ProductRevision, String anUP_Date, String anUCF_Path, SupportedSequenceInformation aSupportedSequenceInformation)", "anUP_ProductNumber: " + string + "\n\tanUP_ProductRevision: " + string2 + "\n\tanUP_Date: " + string3 + "\n\tanUCF_Path: " + string4 + "\n\taSupportedSequenceInformation: " + supportedSequenceInformation);
        }
        try {
            SSW_ValidationInformation sSW_ValidationInformation = new SSW_ValidationInformation();
            OsaSwInstallProxyAccess osaSwInstallProxyAccess = (OsaSwInstallProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaSwInstallProxyAccess.class);
            Collection collection = this.getSignedUpgradeablePIUs();
            if (collection.isEmpty()) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "execute(String anUP_ProductNumber, String anUP_ProductRevision, String anUP_Date, String anUCF_Path, ValidSequencesInformation aValidSequencesInformation)", "anUP_ProductNumber: " + string + "\n\tanUP_ProductRevision: " + string2 + "\n\tanUP_Date: " + string3 + "\n\tanUCF_Path: " + string4 + "\n\taSupportedSequenceInformation: " + supportedSequenceInformation + "\n\tNo boards found that are trusted i.e. no SSW validation needed.");
                }
                return sSW_ValidationInformation;
            }
            UpgradePackageMoExtended upgradePackageMoExtended = ServiceFinder.getUpgradePackageMO_HandlerInterface().getUpgradePackageMo(string, string2);
            if (upgradePackageMoExtended == null) {
                Trace.warning(this.getClass(), "execute(String anUP_ProductNumber, String anUP_ProductRevision, String anUP_Date, String anUCF_Path, SupportedSequenceInformation aSupportedSequenceInformation)", "anUP_ProductNumber: " + string + "\n\tanUP_ProductRevision: " + string2 + "\n\tanUP_Date: " + string3 + "\n\tanUCF_Path: " + string4 + "\n\taSupportedSequenceInformation: " + supportedSequenceInformation + "\n\tThe instance of the UP was not found i.e. the ssw validation check is ignored");
                return sSW_ValidationInformation;
            }
            int n = upgradePackageMoExtended.getPreviousState(null);
            if (n == 4 || n == 6 || n == 0) {
                sSW_ValidationInformation.setIsNotInstalled();
                return sSW_ValidationInformation;
            }
            OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface = this.getDocumentObjectProxyInterface(string, string2, string4);
            if (!optimizedDocumentObjectProxyInterface.isSignedSW()) {
                sSW_ValidationInformation = new SSW_ValidationInformation();
                sSW_ValidationInformation.setResult(1);
                sSW_ValidationInformation.setIsNodeTrustedUpUnSigned(true);
                sSW_ValidationInformation.setErrorInfo("Node is trusted while the UP is unsigned\n\tThe trusted boards are: " + collection);
                return sSW_ValidationInformation;
            }
            CalculateProgramsForToState calculateProgramsForToState = new CalculateProgramsForToState();
            Collection collection2 = new LinkedList();
            Collection collection3 = calculateProgramsForToState.collect(optimizedDocumentObjectProxyInterface, supportedSequenceInformation.getFirstSequenceInformation().currentCase, collection);
            CalculateJavaLMsForToState calculateJavaLMsForToState = new CalculateJavaLMsForToState();
            Collection collection4 = calculateJavaLMsForToState.collect(optimizedDocumentObjectProxyInterface, supportedSequenceInformation.getFirstSequenceInformation().currentCase, collection);
            collection3 = SignedSoftwareUtils.add(collection3, collection4);
            CalculateOtherLMsForToState calculateOtherLMsForToState = new CalculateOtherLMsForToState();
            Collection collection5 = calculateOtherLMsForToState.collect(optimizedDocumentObjectProxyInterface, supportedSequenceInformation.getFirstSequenceInformation().currentCase, collection);
            collection3 = SignedSoftwareUtils.add(collection3, collection5);
            SSW_Validator sSW_Validator = new SSW_Validator();
            CalculateJAUEs calculateJAUEs = new CalculateJAUEs();
            collection3 = SignedSoftwareUtils.add(collection3, calculateJAUEs.collectToState(optimizedDocumentObjectProxyInterface, supportedSequenceInformation.getFirstSequenceInformation().currentCase, collection, string4));
            if (SU_AccessVersionHandler.getInstance().isCurrentlySupported("SU_3", (Object)osaSwInstallProxyAccess) && !SU_AccessVersionHandler.getInstance().isCurrentlySupported("SU_5", (Object)osaSwInstallProxyAccess)) {
                collection2 = calculateJAUEs.collectFromState(optimizedDocumentObjectProxyInterface, supportedSequenceInformation.getFirstSequenceInformation().currentCase, collection);
            }
            CalculateCAUEs calculateCAUEs = new CalculateCAUEs();
            collection3 = SignedSoftwareUtils.add(collection3, calculateCAUEs.collectToState(optimizedDocumentObjectProxyInterface, supportedSequenceInformation.getFirstSequenceInformation().currentCase, collection));
            if (SU_AccessVersionHandler.getInstance().isCurrentlySupported("SU_3", (Object)osaSwInstallProxyAccess) && !SU_AccessVersionHandler.getInstance().isCurrentlySupported("SU_5", (Object)osaSwInstallProxyAccess)) {
                collection2 = SignedSoftwareUtils.add(calculateCAUEs.collectFromState(optimizedDocumentObjectProxyInterface, supportedSequenceInformation.getFirstSequenceInformation().currentCase, collection), collection2);
            }
            sSW_ValidationInformation = sSW_Validator.validate(string, string2, string3, collection3);
            sSW_ValidationInformation.setIsInstalled();
            if (SU_AccessVersionHandler.getInstance().isCurrentlySupported("SU_3", (Object)osaSwInstallProxyAccess) && !(collection2 = this.extractSignedSoftwareInformationForPIU_InterfacesContainingLM_Information(collection2)).isEmpty()) {
                SSW_Validator sSW_Validator2 = new SSW_Validator(SSW_FILE_NAME_FROM);
                SSW_ValidationInformation sSW_ValidationInformation2 = sSW_Validator2.validate(string, string2, string3, collection2);
                if (!sSW_ValidationInformation2.isResultOK()) {
                    sSW_ValidationInformation.setResult(1);
                }
                sSW_ValidationInformation.getOsaVerifySswConfErrorIndInformations().addAll(sSW_ValidationInformation2.getOsaVerifySswConfErrorIndInformations());
                if (sSW_ValidationInformation2.getErrorInfo() != "") {
                    sSW_ValidationInformation.setErrorInfo(sSW_ValidationInformation.getErrorInfo() + "\n\t FOR FROM STATE  :" + sSW_ValidationInformation2.getErrorInfo());
                }
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "execute(String anUP_ProductNumber, String anUP_ProductRevision, String anUP_Date, String anUCF_Path, SupportedSequenceInformation aSupportedSequenceInformation)", "RETURNS - theSSW_ValidationInformation: " + sSW_ValidationInformation);
            }
            return sSW_ValidationInformation;
        }
        catch (VerifyRequestException verifyRequestException) {
            SSW_ValidationInformation sSW_ValidationInformation = new SSW_ValidationInformation(0);
            sSW_ValidationInformation.setIsInstalled();
            return sSW_ValidationInformation;
        }
        catch (Throwable throwable) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "execute(String anUP_ProductNumber, String anUP_ProductRevision, String anUP_Date, String anUCF_Path, SupportedSequenceInformation aSupportedSequenceInformation)", "Throwable caught - Signed Software check is omitted due to unexpected Throwable" + throwable);
            }
            SSW_ValidationInformation sSW_ValidationInformation = new SSW_ValidationInformation(0);
            sSW_ValidationInformation.setIsInstalled();
            return sSW_ValidationInformation;
        }
    }

    public SSW_ValidationInformation execute(String string, String string2, String string3, String string4, int n, ValidSequencesInformation validSequencesInformation) throws VerifyRequestException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "execute(String anUP_ProductNumber, String anUP_ProductRevision, String anUP_Date, String anUCF_Path, ValidSequencesInformation aValidSequencesInformation)", "anUP_ProductNumber: " + string + "\n\tanUP_ProductRevision: " + string2 + "\n\tanUP_Date: " + string3 + "\n\tanUCF_Path: " + string4 + "\n\taValidSequencesInformation: " + validSequencesInformation);
        }
        try {
            SSW_ValidationInformation sSW_ValidationInformation = new SSW_ValidationInformation();
            Collection collection = this.getSignedUpgradeablePIUs();
            if (collection.isEmpty()) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "execute(String anUP_ProductNumber, String anUP_ProductRevision, String anUP_Date, String anUCF_Path, ValidSequencesInformation aValidSequencesInformation)", "anUP_ProductNumber: " + string + "\n\tanUP_ProductRevision: " + string2 + "\n\tanUP_Date: " + string3 + "\n\tanUCF_Path: " + string4 + "\n\taValidSequencesInformation: " + validSequencesInformation + "\n\tNo boards found that are trusted i.e. no SSW validation needed.");
                }
                return sSW_ValidationInformation;
            }
            UpgradePackageMoExtended upgradePackageMoExtended = ServiceFinder.getUpgradePackageMO_HandlerInterface().getUpgradePackageMo(string, string2);
            if (upgradePackageMoExtended == null) {
                Trace.warning(this.getClass(), "execute(String anUP_ProductNumber, String anUP_ProductRevision, String anUP_Date, String anUCF_Path, ValidSequencesInformation aValidSequencesInformation)", "anUP_ProductNumber: " + string + "\n\tanUP_ProductRevision: " + string2 + "\n\tanUP_Date: " + string3 + "\n\tanUCF_Path: " + string4 + "\n\taValidSequencesInformation: " + validSequencesInformation + "\n\tThe instance of the UP was not found i.e. the ssw validation check is ignored");
                return sSW_ValidationInformation;
            }
            int n2 = upgradePackageMoExtended.getPreviousState(null);
            if (n2 == 4 || n2 == 6 || n2 == 0) {
                sSW_ValidationInformation.setIsNotInstalled();
                return sSW_ValidationInformation;
            }
            if (validSequencesInformation.isSupported(TypeOfUpgrade.RebootNodeUpgrade) || validSequencesInformation.isSupported(TypeOfUpgrade.Upgrade) || validSequencesInformation.isSupported(TypeOfUpgrade.Update)) {
                return this.verifySSW(string, string2, string3, string4, n, validSequencesInformation, collection);
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "execute(String anUP_ProductNumber, String anUP_ProductRevision, String anUP_Date, String anUCF_Path, ValidSequencesInformation aValidSequencesInformation)", "No variant of upgrade is supported and therefor not possible to check the signatures of the load modules.anUP_ProductNumber: " + string + "\n\tanUP_ProductRevision: " + string2 + "\n\tanUP_Date: " + string3 + "\n\tanUCF_Path: " + string4 + "\n\taValidSequencesInformation: " + validSequencesInformation);
            }
            return new SSW_ValidationInformation(0);
        }
        catch (VerifyRequestException verifyRequestException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "execute(String anUP_ProductNumber, String anUP_ProductRevision, String anUP_Date, String anUCF_Path, ValidSequencesInformation aValidSequencesInformation)", "Throwable caught - Signed Software check is omitted due to unexpected VerifyRequestException");
            }
            return new SSW_ValidationInformation(0);
        }
        catch (Throwable throwable) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "execute(String anUP_ProductNumber, String anUP_ProductRevision, String anUP_Date, String anUCF_Path, ValidSequencesInformation aValidSequencesInformation)", "Throwable caught - Signed Software check is omitted due to unexpected Throwable");
            }
            return new SSW_ValidationInformation(0);
        }
    }

    public SSW_ValidationInformation verifySSW(String string, String string2, String string3, String string4, int n, ValidSequencesInformation validSequencesInformation, Collection collection) throws VerifyRequestException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "verifySSW(VerifyRequestEvent aVerifyRequestEvent, ValidSequencesInformation aValidSequencesInformation, Collection aSSW_PIUs)", "anUP_ProductNumber: " + string + "\n\tanUP_ProductRevision: " + string2 + "\n\tanUP_Date: " + string3 + "\n\tanUCF_Path: " + string4 + "\n\taSU_LogicCompatibilityIndex: " + n + "\n\taValidSequencesInformation: " + validSequencesInformation + "\n\taSSW_PIUs: " + collection);
        }
        try {
            OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface = this.getDocumentObjectProxyInterface(string, string2, string4);
            if (!optimizedDocumentObjectProxyInterface.isSignedSW()) {
                SSW_ValidationInformation sSW_ValidationInformation = new SSW_ValidationInformation();
                sSW_ValidationInformation.setResult(1);
                sSW_ValidationInformation.setIsNodeTrustedUpUnSigned(true);
                sSW_ValidationInformation.setErrorInfo("Node is trusted while the UP is unsigned\n\tThe trusted boards are: " + collection);
                return sSW_ValidationInformation;
            }
            OsaSwInstallProxyAccess osaSwInstallProxyAccess = (OsaSwInstallProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaSwInstallProxyAccess.class);
            Collection collection2 = new LinkedList();
            CalculateProgramsForToState calculateProgramsForToState = new CalculateProgramsForToState();
            Collection collection3 = calculateProgramsForToState.collect(optimizedDocumentObjectProxyInterface, validSequencesInformation, collection);
            CalculateJavaLMsForToState calculateJavaLMsForToState = new CalculateJavaLMsForToState();
            Collection collection4 = calculateJavaLMsForToState.collect(optimizedDocumentObjectProxyInterface, validSequencesInformation, collection);
            collection3 = SignedSoftwareUtils.add(collection3, collection4);
            CalculateOtherLMsForToState calculateOtherLMsForToState = new CalculateOtherLMsForToState();
            Collection collection5 = calculateOtherLMsForToState.collect(optimizedDocumentObjectProxyInterface, validSequencesInformation, collection);
            collection3 = SignedSoftwareUtils.add(collection3, collection5);
            CalculateJAUEs calculateJAUEs = new CalculateJAUEs();
            if (SU_AccessVersionHandler.getInstance().isCurrentlySupported("SU_5", (Object)osaSwInstallProxyAccess)) {
                collection3 = SignedSoftwareUtils.add(collection3, calculateJAUEs.collectToState(optimizedDocumentObjectProxyInterface, n, validSequencesInformation, collection, string4));
            } else if (SU_AccessVersionHandler.getInstance().isCurrentlySupported("SU_3", (Object)osaSwInstallProxyAccess)) {
                collection3 = SignedSoftwareUtils.add(collection3, calculateJAUEs.collectToState(optimizedDocumentObjectProxyInterface, validSequencesInformation, collection));
            }
            if (SU_AccessVersionHandler.getInstance().isCurrentlySupported("SU_3", (Object)osaSwInstallProxyAccess) && !SU_AccessVersionHandler.getInstance().isCurrentlySupported("SU_5", (Object)osaSwInstallProxyAccess)) {
                collection2 = calculateJAUEs.collectFromState(optimizedDocumentObjectProxyInterface, n, validSequencesInformation, collection);
            }
            CalculateCAUEs calculateCAUEs = new CalculateCAUEs();
            collection3 = SignedSoftwareUtils.add(collection3, calculateCAUEs.collectToState(optimizedDocumentObjectProxyInterface, validSequencesInformation, collection));
            if (SU_AccessVersionHandler.getInstance().isCurrentlySupported("SU_3", (Object)osaSwInstallProxyAccess) && !SU_AccessVersionHandler.getInstance().isCurrentlySupported("SU_5", (Object)osaSwInstallProxyAccess)) {
                collection2 = SignedSoftwareUtils.add(collection2, calculateCAUEs.collectFromState(optimizedDocumentObjectProxyInterface, validSequencesInformation, collection));
            }
            SSW_Validator sSW_Validator = new SSW_Validator();
            SSW_ValidationInformation sSW_ValidationInformation = sSW_Validator.validate(string, string2, string3, collection3);
            if (!(collection2 = this.extractSignedSoftwareInformationForPIU_InterfacesContainingLM_Information(collection2)).isEmpty()) {
                SSW_Validator sSW_Validator2 = new SSW_Validator(SSW_FILE_NAME_FROM);
                SSW_ValidationInformation sSW_ValidationInformation2 = sSW_Validator2.validate(string, string2, string3, collection2);
                if (!sSW_ValidationInformation2.isResultOK()) {
                    sSW_ValidationInformation.setResult(1);
                }
                sSW_ValidationInformation.getOsaVerifySswConfErrorIndInformations().addAll(sSW_ValidationInformation2.getOsaVerifySswConfErrorIndInformations());
                if (sSW_ValidationInformation2.getErrorInfo() != "") {
                    sSW_ValidationInformation.setErrorInfo(sSW_ValidationInformation.getErrorInfo() + "\n\t FOR FROM STATE  :" + sSW_ValidationInformation2.getErrorInfo());
                }
            }
            return sSW_ValidationInformation;
        }
        catch (VerifyRequestException verifyRequestException) {
            throw verifyRequestException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "verifySSW(String anUP_ProductNumber, String anUP_ProductRevision, String anUP_Date, String anUCF_Path, String aCase)", "anUP_ProductNumber: " + string + "\n\tanUP_ProductRevision: " + string2 + "\n\tanUP_Date: " + string3 + "\n\tanUCF_Path: " + string4, throwable);
            throw new VerifyRequestException(throwable.toString());
        }
    }

    private OptimizedDocumentObjectProxyInterface getDocumentObjectProxyInterface(String string, String string2, String string3) throws VerifyRequestException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getDocumentObjectProxyInterface(VerifyRequestEvent aVerifyRequestEvent)", "anUP_ProductNumber: " + string + "\n\tanUP_ProductRevision: " + string2 + "\n\tanUCF_Path: " + string3);
        }
        try {
            String[] stringArray = new String[]{"Repertoire", "ExplicitReplacement", "InstallSequence", "VerifySequence", "VerifyUpgradeSequence", "VerifyUpdateSequence", "UpgradeSequence", "LoadModule", "PiuType"};
            OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface = UCF_ParserFacade.parseMainElementsOptimizedInterface(string, string2, string3, stringArray, false);
            return optimizedDocumentObjectProxyInterface;
        }
        catch (UpgradeControlFileParserException upgradeControlFileParserException) {
            throw new VerifyRequestException(upgradeControlFileParserException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getDocumentObjectProxyInterface(VerifyRequestEvent aVerifyRequestEvent)", "Throwable caught.anUP_ProductNumber: " + string + "\n\tanUP_ProductRevision: " + string2 + "\n\tanUCF_Path: " + string3, throwable);
            throw new VerifyRequestException(throwable.toString());
        }
    }

    private Collection extractSignedSoftwareInformationForPIU_InterfacesContainingLM_Information(Collection collection) throws VerifyRequestException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "extractSignedSoftwareInformationForPIU_InterfacesContainingLM_Information(Collection aSignedSoftwareInformationForPIU_Interfaces)", "aSignedSoftwareInformationForPIU_Interfaces: " + collection);
        }
        try {
            LinkedList<SignedSoftwareInformationForPIU_Interface> linkedList = new LinkedList<SignedSoftwareInformationForPIU_Interface>();
            Iterator iterator = collection.iterator();
            SignedSoftwareInformationForPIU_Interface signedSoftwareInformationForPIU_Interface = null;
            while (iterator.hasNext()) {
                signedSoftwareInformationForPIU_Interface = (SignedSoftwareInformationForPIU_Interface)iterator.next();
                if (signedSoftwareInformationForPIU_Interface.getSignedProgramInformationsForPIU().isEmpty()) continue;
                linkedList.add(signedSoftwareInformationForPIU_Interface);
            }
            return linkedList;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "extractSignedSoftwareInformationForPIU_InterfacesContainingLM_Information(Collection aSignedSoftwareInformationForPIU_Interfaces)", "Throwable caught.\n\taSignedSoftwareInformationForPIU_Interfaces: " + collection, throwable);
            throw new VerifyRequestException(throwable.toString());
        }
    }
}

