/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.common.db.sql;

import com.polyhedra.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class Sql {
    public static final String INT_TYPE = "integer";
    public static final String VARCHAR_TYPE = "varchar";
    public static final String BOOLEAN_TYPE = "boolean";
    public static final String NOT_NULL_CONSTRAINT = "NOT NULL";
    public static final String CONSTRAINT_UNIQUE = "UNIQUE";
    public static final int POLYHEDRA = 0;
    public static final int SMALL_SQL = 1;
    private static int mode = 0;

    public static void setMode(int mode) {
        Sql.mode = mode;
    }

    public static String varcharType(int maxLen) {
        return "varchar(" + maxLen + ")";
    }

    public static int defaultVarCharDisplaySize() {
        return 30;
    }

    public static String integer16Type() {
        return "SMALLINT";
    }

    public static String integer8Type() {
        return "TINYINT";
    }

    private static String object2SqlValue(Object o) {
        if (o == null) {
            return "NULL";
        }
        if (o instanceof String || o instanceof MomDataType || o instanceof SqlDataType) {
            return "'" + o + "'";
        }
        return o.toString();
    }

    public static class Select
    extends Statement {
        private final ArrayList columnList = new ArrayList();
        private ColumnValue matchColumnValue = null;

        public Select(String tableName) throws SQLException {
            super(tableName);
        }

        public Select(String tableName, String[] columns) throws SQLException {
            this(tableName);
            if (columns == null || columns.length == 0) {
                throw new SQLException("Invalid attribute columns: null or zero length");
            }
            for (int c = 0; c < columns.length; ++c) {
                this.addColumn(columns[c]);
            }
        }

        public Select(String tableName, ColumnValue matchColumnValue) throws SQLException {
            this(tableName);
            this.setMatchColumnValue(matchColumnValue);
        }

        public Select(String tableName, String[] columns, ColumnValue matchColumnValue) throws SQLException {
            this(tableName, columns);
            this.setMatchColumnValue(matchColumnValue);
        }

        public void addColumn(String column) {
            this.columnList.add(column.toLowerCase(Locale.getDefault()));
        }

        public List getColumnList() {
            return this.columnList;
        }

        private void setMatchColumnValue(ColumnValue matchColumnValue) throws SQLException {
            if (matchColumnValue == null) {
                throw new SQLException("Invalid attribute matchColumn: null");
            }
            this.matchColumnValue = matchColumnValue;
        }

        public ColumnValue getMatchColumnValue() {
            return this.matchColumnValue;
        }

        String toPolyhedraString() {
            StringBuffer sb = new StringBuffer("SELECT ");
            if (this.columnList.size() == 0) {
                sb.append("*");
            } else {
                Iterator columnIterator = this.columnList.iterator();
                boolean first = true;
                while (columnIterator.hasNext()) {
                    sb.append(first ? "" : ", ").append(columnIterator.next());
                    first = false;
                }
            }
            sb.append(" FROM ").append(this.getTableNameLowerCase());
            if (this.matchColumnValue != null) {
                sb.append(" WHERE ").append(this.matchColumnValue);
            }
            return sb.toString();
        }

        String toSmallSqlString() {
            return this.toPolyhedraString();
        }

        public static class ColumnValue
        extends ColumnValueBase {
            public ColumnValue(String name, Object value) throws SQLException {
                super(name, value);
            }

            public ColumnValue(String name, int value) throws SQLException {
                super(name, value);
            }
        }

        public static class Count
        extends Select {
            public Count(String tableName) throws SQLException {
                super(tableName);
            }

            public Count(String tableName, String column) throws SQLException {
                super(tableName, new String[]{column});
            }

            public Count(String tableName, ColumnValue matchColumnValue) throws SQLException {
                super(tableName, matchColumnValue);
            }

            public Count(String tableName, String column, ColumnValue matchColumnValue) throws SQLException {
                super(tableName, new String[]{column}, matchColumnValue);
            }

            String toPolyhedraString() {
                StringBuffer sb = new StringBuffer("SELECT COUNT(").append(this.getColumnList().size() > 0 ? this.getColumnList().get(0) : "*").append(") FROM ").append(this.getTableNameLowerCase());
                ColumnValue matchColumnValue = this.getMatchColumnValue();
                if (matchColumnValue != null) {
                    sb.append(" WHERE ").append(matchColumnValue);
                }
                return sb.toString();
            }
        }
    }

    public static class DeleteRow
    extends Modification {
        private final ColumnValue matchColumnValue;

        public DeleteRow(String tableName, ColumnValue matchColumnValue) throws SQLException {
            super(tableName);
            if (matchColumnValue == null) {
                throw new SQLException("Invalid attribute matchColumnValue: null");
            }
            this.matchColumnValue = matchColumnValue;
        }

        String toPolyhedraString() {
            return "DELETE FROM " + this.getTableNameLowerCase() + " WHERE " + this.matchColumnValue;
        }

        String toSmallSqlString() {
            return this.toPolyhedraString();
        }

        public static class ColumnValue
        extends ColumnValueBase {
            public ColumnValue(String name, Object value) throws SQLException {
                super(name, value);
            }

            public ColumnValue(String name, int value) throws SQLException {
                super(name, value);
            }
        }
    }

    public static class UpdateRow
    extends Modification {
        private final ColumnValue matchColumnValue;
        private final ArrayList updatedValueList = new ArrayList();

        public UpdateRow(String tableName, ColumnValue matchColumnValue) throws SQLException {
            this(tableName, new ColumnValue[0], matchColumnValue);
        }

        public UpdateRow(String tableName, ColumnValue[] columnValues, ColumnValue matchColumnValue) throws SQLException {
            super(tableName);
            if (columnValues == null) {
                throw new SQLException("Invalid attribute columnValues: null");
            }
            if (matchColumnValue == null || matchColumnValue == null) {
                throw new SQLException("Invalid attribute columnValues: null");
            }
            for (int c = 0; columnValues != null && c < columnValues.length; ++c) {
                if (columnValues[c] == null) {
                    throw new SQLException("Invalid attribute columnValues[" + c + "]: null");
                }
                this.addColumnValue(columnValues[c]);
            }
            this.matchColumnValue = matchColumnValue;
        }

        public void addColumnValue(ColumnValue columnValue) {
            this.updatedValueList.add(columnValue);
        }

        String toPolyhedraString() {
            StringBuffer set = new StringBuffer();
            Iterator columnValueIterator = this.updatedValueList.iterator();
            while (columnValueIterator.hasNext()) {
                ColumnValue columnValue = (ColumnValue)columnValueIterator.next();
                set.append(columnValue);
                if (!columnValueIterator.hasNext()) continue;
                set.append(", ");
            }
            return "UPDATE " + this.getTableNameLowerCase() + " SET " + set + " WHERE " + this.matchColumnValue;
        }

        String toSmallSqlString() {
            return this.toPolyhedraString();
        }

        public static class ColumnValue
        extends ColumnValueBase {
            public ColumnValue(String name, Object value) throws SQLException {
                super(name, value);
            }

            public ColumnValue(String name, int value) throws SQLException {
                super(name, value);
            }
        }
    }

    public static class InsertRow
    extends Modification {
        private final ArrayList insertValueList = new ArrayList();

        public InsertRow(String tableName) throws SQLException {
            super(tableName);
        }

        public InsertRow(String tableName, ColumnValue[] columnValues) throws SQLException {
            super(tableName);
            if (columnValues == null || columnValues.length == 0) {
                throw new SQLException("Invalid attribute: null or zero length columnValues");
            }
            for (int c = 0; columnValues != null && c < columnValues.length; ++c) {
                this.addColumnValue(columnValues[c]);
            }
        }

        public void addColumnValue(ColumnValue columnValue) throws SQLException {
            this.insertValueList.add(columnValue);
        }

        String toPolyhedraString() {
            StringBuffer names = new StringBuffer("");
            StringBuffer values = new StringBuffer("");
            Iterator columnValueIterator = this.insertValueList.iterator();
            while (columnValueIterator.hasNext()) {
                ColumnValue columnValue = (ColumnValue)columnValueIterator.next();
                names.append(columnValue.getName());
                values.append(Sql.object2SqlValue(columnValue.getValue()));
                if (!columnValueIterator.hasNext()) continue;
                names.append(", ");
                values.append(", ");
            }
            return "INSERT INTO " + this.getTableNameLowerCase() + (names.length() > 0 ? " (" + names + ")" : "") + " VALUES (" + values + ")";
        }

        String toSmallSqlString() {
            return this.toPolyhedraString();
        }

        public static class ColumnValue
        extends ColumnValueBase {
            public ColumnValue(String name, Object value) throws SQLException {
                super(name, value);
            }

            public ColumnValue(String name, int value) throws SQLException {
                super(name, value);
            }
        }
    }

    public static class RenameTable
    extends Modification {
        private final String newTableName;

        public RenameTable(String tableName, String newTableName) throws SQLException {
            super(tableName);
            this.newTableName = newTableName;
        }

        public String getNewTableName() {
            return this.newTableName;
        }

        String toPolyhedraString() {
            return "ALTER TABLE " + this.getTableNameLowerCase() + " RENAME TO " + this.newTableName.toLowerCase(Locale.getDefault());
        }

        String toSmallSqlString() {
            return this.toPolyhedraString();
        }
    }

    public static class DropTable
    extends Modification {
        public DropTable(String tableName) throws SQLException {
            super(tableName);
        }

        String toPolyhedraString() {
            return "DROP TABLE " + this.getTableNameLowerCase();
        }

        String toSmallSqlString() {
            return this.toPolyhedraString();
        }
    }

    public static class CreateTable
    extends Modification {
        private final ArrayList columnSpecList = new ArrayList();

        public CreateTable(String tableName) throws SQLException {
            super(tableName);
        }

        public CreateTable(String tableName, ColumnSpec[] columnSpecs) throws SQLException {
            super(tableName);
            if (columnSpecs == null || columnSpecs.length == 0) {
                throw new SQLException("Invalid attribute: columnSpecs");
            }
            for (int c = 0; c < columnSpecs.length; ++c) {
                this.columnSpecList.add(columnSpecs[c]);
            }
        }

        public void addColumn(ColumnSpec columnSpec) {
            this.columnSpecList.add(columnSpec);
        }

        public ColumnSpec[] getColumnsSpecs() {
            return this.columnSpecList.toArray(new ColumnSpec[this.columnSpecList.size()]);
        }

        String toPolyhedraString() {
            return this.internalToString();
        }

        String toSmallSqlString() {
            return this.internalToString();
        }

        private String internalToString() {
            boolean addedFirstAttr = false;
            StringBuffer buf = new StringBuffer().append("CREATE TABLE ").append(this.tableName.toLowerCase(Locale.getDefault())).append(" (");
            if (mode == 0) {
                buf.append("PERSISTENT");
                addedFirstAttr = true;
            }
            Iterator columnSpecIterator = this.columnSpecList.iterator();
            while (columnSpecIterator.hasNext()) {
                ColumnSpec columnSpec = (ColumnSpec)columnSpecIterator.next();
                if (addedFirstAttr) {
                    buf.append(", ");
                }
                buf.append(columnSpec.getName()).append(' ').append(columnSpec.getSqlDataType());
                if (columnSpec.getSqlDataType() == SqlDataType.SQL_VARCHAR) {
                    buf.append('(').append(columnSpec.getLength()).append(')');
                }
                if (columnSpec.constraint != null) {
                    buf.append(' ').append(columnSpec.constraint);
                }
                addedFirstAttr = true;
            }
            Iterator columnPrimaryIterator = this.columnSpecList.iterator();
            boolean foundFirstPrimaryKey = false;
            while (columnPrimaryIterator.hasNext()) {
                ColumnSpec columnSpec = (ColumnSpec)columnPrimaryIterator.next();
                if (!columnSpec.isPrimaryKey) continue;
                if (!foundFirstPrimaryKey) {
                    buf.append(", PRIMARY KEY(").append(columnSpec.name);
                    foundFirstPrimaryKey = true;
                    continue;
                }
                buf.append(", ").append(columnSpec.name);
            }
            if (foundFirstPrimaryKey) {
                buf.append(')');
            }
            buf.append(')');
            return buf.toString();
        }

        public static class ColumnSpec {
            private final String name;
            private final MomDataType momDataType;
            private final SqlDataType sqlDataType;
            private final int length;
            private final String constraint;
            private final boolean isPrimaryKey;

            public ColumnSpec(String name, MomDataType momDataType, int length, String constraint, boolean isPrimaryKey) throws SQLException {
                if (momDataType == null) {
                    throw new SQLException("Invalid attribute \"momDataType\": null");
                }
                this.momDataType = momDataType;
                this.sqlDataType = momDataType.toSqlDataType();
                this.verify(name, length, constraint, isPrimaryKey);
                this.name = name.toLowerCase(Locale.getDefault());
                this.length = length;
                this.constraint = constraint;
                this.isPrimaryKey = isPrimaryKey;
            }

            public ColumnSpec(String name, SqlDataType sqlDataType, int length, String constraint, boolean isPrimaryKey) throws SQLException {
                if (sqlDataType == null) {
                    throw new SQLException("Invalid attribute \"sqlDataType\": null");
                }
                this.momDataType = null;
                this.sqlDataType = sqlDataType;
                this.verify(name, length, constraint, isPrimaryKey);
                this.name = name.toLowerCase(Locale.getDefault());
                this.length = length;
                this.constraint = constraint;
                this.isPrimaryKey = isPrimaryKey;
            }

            private void verify(String name, int length, String constraint, boolean isPrimaryKey) throws SQLException {
                if (name == null || name.length() == 0) {
                    throw new SQLException("Invalid attribute \"name\": null or zero length");
                }
                if (length < 0) {
                    throw new SQLException("Invalid attribute \"length\": < 0");
                }
                if (length > 0 && (this.sqlDataType == SqlDataType.SQL_INT || this.sqlDataType == SqlDataType.SQL_BOOL)) {
                    throw new SQLException("Invalid attribute \"length\": for " + this.sqlDataType + " only 0 is supported");
                }
            }

            public String getName() {
                return this.name;
            }

            public int getLength() {
                return mode == 1 && this.length == 0 ? 255 : this.length;
            }

            public String getNameLowerCase() {
                return this.name.toLowerCase(Locale.getDefault());
            }

            public MomDataType getMomDataType() {
                return this.momDataType;
            }

            public SqlDataType getSqlDataType() {
                return this.sqlDataType;
            }

            public String getConstraint() {
                return this.constraint;
            }

            public boolean isPrimaryKey() {
                return this.isPrimaryKey;
            }
        }
    }

    public static class SqlUpdateString
    extends Modification {
        private final String sqlUpdateString;

        public SqlUpdateString(String sqlUpdateString) throws SQLException {
            super("NA");
            this.sqlUpdateString = sqlUpdateString;
        }

        String toPolyhedraString() {
            return this.sqlUpdateString;
        }

        String toSmallSqlString() {
            return this.sqlUpdateString;
        }
    }

    public static class SqlDataType {
        private static HashMap sqlDataTypeMap = new HashMap(3);
        public static final SqlDataType SQL_BOOL = new SqlDataType("boolean");
        public static final SqlDataType SQL_INT = new SqlDataType("integer");
        public static final SqlDataType SQL_VARCHAR = new SqlDataType("varchar");
        private final String sqlDataType;

        private SqlDataType(String sqlDataType) {
            this.sqlDataType = sqlDataType;
            sqlDataTypeMap.put(sqlDataType, this);
        }

        public static SqlDataType toSqlDataType(String dataType) throws SQLException {
            if (!sqlDataTypeMap.containsKey(dataType)) {
                throw new SQLException("Invalid data type: " + dataType);
            }
            return (SqlDataType)sqlDataTypeMap.get(dataType);
        }

        public String toString() {
            return this.sqlDataType;
        }
    }

    public static class MomDataType {
        private static HashMap momDataTypeMap = new HashMap(7);
        public static final MomDataType MOM_ARRAY = new MomDataType("array");
        public static final MomDataType MOM_MOREF = new MomDataType("moref");
        public static final MomDataType MOM_S32 = new MomDataType("S32");
        public static final MomDataType MOM_S64 = new MomDataType("S64");
        public static final MomDataType MOM_STRING = new MomDataType("STRING");
        public static final MomDataType MOM_STRUCT = new MomDataType("struct");
        public static final MomDataType MOM_U32 = new MomDataType("U32");
        private final String momDataType;

        private MomDataType(String momDataType) {
            this.momDataType = momDataType;
            momDataTypeMap.put(momDataType, this);
        }

        public static MomDataType toMomDataType(String dataType) throws SQLException {
            if (!momDataTypeMap.containsKey(dataType)) {
                throw new SQLException("Invalid data type: \"" + dataType + "\"");
            }
            return (MomDataType)momDataTypeMap.get(dataType);
        }

        public SqlDataType toSqlDataType() {
            if (this == MOM_S32 || this == MOM_U32) {
                return SqlDataType.SQL_INT;
            }
            if (this == MOM_ARRAY || this == MOM_MOREF || this == MOM_STRING || this == MOM_STRUCT || this == MOM_S64) {
                return SqlDataType.SQL_VARCHAR;
            }
            return null;
        }

        public String toString() {
            return this.momDataType;
        }
    }

    public static abstract class ColumnValueBase {
        private final String name;
        private final Object value;

        public ColumnValueBase(String name, Object value) throws SQLException {
            if (name == null || name.length() == 0) {
                throw new SQLException("Invalid attribute: name: \"" + name);
            }
            this.name = name.toLowerCase(Locale.getDefault());
            this.value = value;
        }

        public ColumnValueBase(String name, int value) throws SQLException {
            this(name, new Integer(value));
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public String toString() {
            return this.name + "=" + Sql.object2SqlValue(this.value);
        }
    }

    public static abstract class Modification
    extends Statement {
        Modification(String tableName) throws SQLException {
            super(tableName);
        }
    }

    public static abstract class Statement {
        final String tableName;

        Statement(String tableName) throws SQLException {
            if (tableName == null || tableName.length() == 0) {
                throw new SQLException("Invalid attribute: tableName: \"" + tableName + "\"");
            }
            this.tableName = tableName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public String getTableNameLowerCase() {
            return this.tableName.toLowerCase(Locale.getDefault());
        }

        public String toString() {
            return mode == 0 ? this.toPolyhedraString() : (mode == 1 ? this.toSmallSqlString() : null);
        }

        abstract String toPolyhedraString();

        abstract String toSmallSqlString();
    }
}

