/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step2;

import com.polyhedra.sql.ResultSet;
import com.polyhedra.sql.SQLException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.converter.ConversionGraph;
import se.ericsson.cello.aueframework.converter.ConversionStep;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.UpgradePathCalculator;
import se.ericsson.cello.aueframework.converter.WriteableConverterContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.DateTimeHelper;
import se.ericsson.crbs.omf.aue.common.LoggerImpl;
import se.ericsson.crbs.omf.aue.common.MainAueHelper;
import se.ericsson.crbs.omf.aue.common.RbsAueMetaData;
import se.ericsson.crbs.omf.aue.common.db.DbWrapper;
import se.ericsson.crbs.omf.aue.common.db.DbWrapperFactory;
import se.ericsson.crbs.omf.aue.common.jar.XmlHolder;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.common.xml.ModificationXmlVersionHandler;
import se.ericsson.crbs.omf.aue.common.xml.MomInfo;
import se.ericsson.crbs.omf.aue.step2.AbstractLastConversionStep;
import se.ericsson.crbs.omf.aue.step2.AbstractRbsAueStep2;
import se.ericsson.crbs.omf.aue.step2.AbstractRbsAueStep2Helper;
import se.ericsson.crbs.omf.aue.step2.ConversionStepImpl;
import se.ericsson.crbs.omf.aue.step2.LastConversionStep;
import se.ericsson.crbs.omf.aue.step2.RbsConversionStepUpgradeHandler;
import se.ericsson.crbs.omf.aue.step2.actions.util.Step2Handler;
import se.ericsson.crbs.omf.aue.step2.common.RbsDataConverter;
import se.ericsson.crbs.omf.aue.step2.common.SequenceHolderStep2;
import se.ericsson.crbs.omf.aue.step2.sequencer.RbsAueStep2SequencerImpl;

public class AbstractRbsAueStep2HelperImpl
implements AbstractRbsAueStep2Helper {
    private final RbsAueMetaData rbsAueMetaData;
    protected final MainAueHelper mainAueHelper;
    private static final Class THIS_CLASS = RbsAueStep2SequencerImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    private final Map upgradeHandlers = new HashMap();

    public AbstractRbsAueStep2HelperImpl(RbsAueMetaData rbsAueMetaData) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "AbstractRbsAueStep2(" + rbsAueMetaData.getAueName() + ")");
        this.rbsAueMetaData = rbsAueMetaData;
        ResourceBundle step2Bundle = ResourceBundle.getBundle(rbsAueMetaData.getPropertiesFileStep2());
        String cxcNumber = step2Bundle.getString("cxcNumber");
        String cxcRevision = step2Bundle.getString("cxcRevision");
        String modifiedCxcNumber = AueUtil.replaceInString(cxcNumber, "/", "%");
        this.mainAueHelper = new MainAueHelper(rbsAueMetaData.getPropertiesFileStep2());
        new LoggerImpl(false);
        logger.info(THIS_CLASS, "Step2MainAue is starting now " + new Date().toString());
        logger.traceDebug(THIS_CLASS, "Step2MainAue cxcNumber from bundle: " + cxcNumber);
        logger.traceDebug(THIS_CLASS, "Step2MainAue cxcNumber in file name: " + modifiedCxcNumber);
        logger.traceDebug(THIS_CLASS, "Step2MainAue cxcRevision: " + cxcRevision);
        logger.traceReturn(THIS_CLASS, "AbstractRbsAueStep2(" + rbsAueMetaData.getAueName() + ")");
    }

    public String getConverterName() {
        return this.rbsAueMetaData.getAueName();
    }

    public RbsDataConverter getRbsDataConverter(WriteableConverterContext context, AbstractRbsAueStep2 abstractRbsAueStep2) {
        logger.traceEnter(THIS_CLASS, "getRbsDataConverter()" + this.rbsAueMetaData.getAueName());
        AbstractRbsAueStep2 result = abstractRbsAueStep2;
        try {
            XmlHolder[] xmlHolders = this.mainAueHelper.getModificationXmlHolders();
            DbWrapper dbWrapper = DbWrapperFactory.getInstance().getDbWrapper();
            dbWrapper.openConnection();
            MomInfo fromMomInfo = this.getFromMomInfo(dbWrapper);
            AbstractLastConversionStep lastConversionStep = abstractRbsAueStep2.getLastConversionStep(this.mainAueHelper.getResetXmlHolder());
            this.createRbsUpgradeHandlers(xmlHolders, fromMomInfo, lastConversionStep);
        }
        catch (IOException ioe) {
            logger.traceError(THIS_CLASS, "Unable to parse MOM: " + AueUtil.getExceptionMessage(ioe), ioe);
            result = null;
        }
        catch (SQLException se) {
            logger.traceError(THIS_CLASS, "Database error: " + se.getMessage(), se);
            result = null;
        }
        catch (CrbsAueException cae) {
            logger.traceError(THIS_CLASS, "Database connection error: " + AueUtil.getExceptionMessage((Throwable)((Object)cae)), (Throwable)((Object)cae));
            result = null;
        }
        logger.traceReturn(THIS_CLASS, "getRbsDataConverter()" + this.rbsAueMetaData.getAueName());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MomInfo getFromMomInfo(DbWrapper dbWrapper) throws SQLException {
        logger.traceEnter(THIS_CLASS, "getFromMomInfo()");
        ResultSet resultSet = null;
        try {
            resultSet = dbWrapper.executeQuery("SELECT value FROM " + this.rbsAueMetaData.getAuePersistencyTableName() + " WHERE name = " + AueUtil.quote("FROM_MOM_VERSION"));
            MomInfo momInfo = null;
            if (resultSet.next()) {
                String momVersionStr = resultSet.getString(1);
                try {
                    momInfo = MomInfo.getMomInfo(momVersionStr);
                }
                catch (ParseException e) {
                    throw new SQLException("Found illegal MOM version " + momVersionStr + " in " + this.rbsAueMetaData.getAuePersistencyTableName());
                }
            } else {
                throw new SQLException("Cannot retrieve from MOM version from " + this.rbsAueMetaData.getAuePersistencyTableName());
            }
            logger.traceDebug(THIS_CLASS, "getFromMomInfo: fromMomInfo = " + momInfo + " for aue " + this.rbsAueMetaData.getAueName());
            logger.traceReturn(THIS_CLASS, "getFromMomInfo()");
            MomInfo momInfo2 = momInfo;
            return momInfo2;
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception ignore) {}
        }
    }

    private void createRbsUpgradeHandlers(XmlHolder[] xmlHolders, MomInfo fromMomInfo, LastConversionStep lastConversionStep) {
        logger.traceEnter(THIS_CLASS, "getRbsUpgradeHandlers()");
        try {
            SequenceHolderStep2[] sequenceHolders = this.parseXmlFiles(xmlHolders);
            if (sequenceHolders != null) {
                this.finalizeSequenceHolders(sequenceHolders, fromMomInfo, lastConversionStep);
            }
        }
        catch (SAXException se) {
            logger.traceError(THIS_CLASS, "Unable to instantiate SAXParser", se);
        }
        catch (ParseException pe) {
            logger.traceError(THIS_CLASS, "Unable to determine the very last conversion step!");
        }
        logger.traceReturn(THIS_CLASS, "getRbsUpgradeHandlers()");
    }

    private void finalizeSequenceHolders(SequenceHolderStep2[] sequenceHolders, MomInfo fromMomInfo, LastConversionStep lastConversionStep) throws ParseException {
        SequenceHolderStep2 lastSequence = null;
        for (int index = 0; index < sequenceHolders.length; ++index) {
            if (lastSequence != null && lastSequence.getSequenceToVersion().intValue() >= sequenceHolders[index].getSequenceToVersion().intValue()) continue;
            lastSequence = sequenceHolders[index];
        }
        logger.traceDebug(THIS_CLASS, "The MOM for AUE " + this.rbsAueMetaData.getAueName() + " will be upgraded to version " + lastSequence.getSequenceToVersion().toString());
        lastConversionStep.setFromRevision(lastSequence.getSequenceToVersion().toString());
        lastSequence.addConversionStep(lastSequence.getSequenceToVersion(), MomInfo.getMomInfo("Z.99.99"), lastConversionStep);
        int fromMomInfoIntValue = fromMomInfo.intValue();
        for (int index = 0; index < sequenceHolders.length; ++index) {
            if (fromMomInfoIntValue < sequenceHolders[index].getSequenceToVersion().intValue()) {
                ConversionGraph conversionGraph = new ConversionGraph(sequenceHolders[index].getConversionSteps());
                logger.traceDebug(THIS_CLASS, "Created conversion graph with " + sequenceHolders[index].getConversionSteps().length + " nodes");
                String fromMomInfoForThisSequence = fromMomInfoIntValue > sequenceHolders[index].getSequenceFromVersion().intValue() ? fromMomInfo.toString() : sequenceHolders[index].getSequenceFromVersion().toString();
                RbsConversionStepUpgradeHandler upgradeHandler = new RbsConversionStepUpgradeHandler((UpgradePathCalculator)conversionGraph, fromMomInfoForThisSequence, sequenceHolders[index].getSequenceToVersion().toString(), sequenceHolders[index].getSequenceToVersionExcludingLastStep().toString());
                this.upgradeHandlers.put(sequenceHolders[index].getSequenceNumber(), upgradeHandler);
                continue;
            }
            logger.traceDebug(THIS_CLASS, "Converter " + this.rbsAueMetaData.getAueName() + " will not perform sequence " + sequenceHolders[index].getSequenceNumber() + " from MOM version " + sequenceHolders[index].getSequenceFromVersion() + " to " + sequenceHolders[index].getSequenceToVersion() + ".");
        }
    }

    public Integer[] getWantedRbsSequenceNumbers() {
        return this.upgradeHandlers.keySet().toArray(new Integer[this.upgradeHandlers.size()]);
    }

    private SequenceHolderStep2[] parseXmlFiles(XmlHolder[] xmlHolders) throws SAXException {
        HashMap<Integer, SequenceHolderStep2> sequenceMap = new HashMap<Integer, SequenceHolderStep2>();
        boolean success = false;
        XMLReader parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
        ModificationXmlVersionHandler handler = new ModificationXmlVersionHandler();
        parser.setContentHandler(handler);
        String xmlResourceName = null;
        for (int i = 0; i < xmlHolders.length; ++i) {
            try {
                logger.traceGeneral(THIS_CLASS, "getConversionGraph xmlResourceName " + AueUtil.doubleQuote(xmlHolders[i].getPath()));
                ByteArrayInputStream inputStream = new ByteArrayInputStream(xmlHolders[i].getContents().getBytes());
                InputSource inputSource = new InputSource(inputStream);
                parser.parse(inputSource);
                ((InputStream)inputStream).close();
                MomInfo fromMomInfo = handler.getFromMomInfo();
                MomInfo toMomInfo = handler.getToMomInfo();
                Integer sequenceNumber = handler.getSequenceNumber();
                ConversionStep conversionStep = this.getConversionStep(fromMomInfo.toString(), toMomInfo.toString(), xmlHolders[i]);
                logger.traceDebug(THIS_CLASS, "Adding ConversionStep from " + fromMomInfo + " to " + toMomInfo + " for sequence " + sequenceNumber + " , xml=" + xmlResourceName);
                if (sequenceMap.containsKey(sequenceNumber)) {
                    ((SequenceHolderStep2)sequenceMap.get(sequenceNumber)).addConversionStep(fromMomInfo, toMomInfo, conversionStep);
                } else {
                    SequenceHolderStep2 sequenceHolder = new SequenceHolderStep2(sequenceNumber);
                    sequenceHolder.addConversionStep(fromMomInfo, toMomInfo, conversionStep);
                    sequenceMap.put(sequenceNumber, sequenceHolder);
                }
                success = true;
                continue;
            }
            catch (IOException ioe) {
                logger.traceError(THIS_CLASS, "IO exception when parsing file " + xmlResourceName, ioe);
                success = false;
                break;
            }
            catch (SAXException se) {
                logger.traceError(THIS_CLASS, "Parse error when parsing file " + xmlResourceName, se);
                success = false;
                break;
            }
        }
        SequenceHolderStep2[] sequenceHolders = success ? sequenceMap.values().toArray(new SequenceHolderStep2[sequenceMap.size()]) : null;
        return sequenceHolders;
    }

    private ConversionStep getConversionStep(String fromRevision, String toRevision, XmlHolder xmlHolder) {
        return new ConversionStepImpl(fromRevision, toRevision, xmlHolder);
    }

    public void upgrade(ConverterContext context, Integer currentSequenceNumber) throws CrbsAueException {
        long endTime;
        SimpleDateFormat dateFormat;
        if (this.upgradeHandlers.containsKey(currentSequenceNumber)) {
            String toUp;
            String fromUp;
            dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.getDefault());
            long startTime = System.currentTimeMillis();
            long memoryAtStart = AueUtil.getUsedMemory();
            logger.info(THIS_CLASS, this.rbsAueMetaData.getAueName() + " started " + DateTimeHelper.dateToString(startTime, dateFormat));
            Step2Handler step2Handler = new Step2Handler(this.rbsAueMetaData);
            context.setAttribute("CURRENT_STEP2_HANDLER", (Object)step2Handler);
            try {
                fromUp = step2Handler.retrieveFromAuePersistency("performedUpgrades", "fromUp");
            }
            catch (CrbsAueException e) {
                fromUp = "Can not read fromUp";
            }
            try {
                toUp = step2Handler.retrieveFromAuePersistency("performedUpgrades", "toUp");
            }
            catch (CrbsAueException e) {
                toUp = "Can not read toUp";
            }
            RbsConversionStepUpgradeHandler currentRbsConversionStepUpgradeHandler = (RbsConversionStepUpgradeHandler)((Object)this.upgradeHandlers.get(currentSequenceNumber));
            try {
                currentRbsConversionStepUpgradeHandler.upgrade(context);
            }
            catch (AueException ae) {
                CrbsAueException cae = new CrbsAueException(ae.getMessage());
                cae.setStackTrace(ae.getStackTrace());
                throw cae;
            }
            endTime = System.currentTimeMillis();
            long memoryAtEnd = AueUtil.getUsedMemory();
            try {
                AueUtil.storePerformedUpgradeSequence(false, this.rbsAueMetaData.getAueName(), currentRbsConversionStepUpgradeHandler.getFromVersion().toString(), fromUp, currentRbsConversionStepUpgradeHandler.getToVersionExcludingLastStep().toString(), toUp, DateTimeHelper.dateToString(startTime, dateFormat), (int)(endTime - startTime), (int)(memoryAtEnd - memoryAtStart));
            }
            catch (Exception exception) {
                logger.traceError(THIS_CLASS, "Unable to store information about performed upgrade! " + AueUtil.getExceptionMessage(exception));
            }
        } else {
            throw new CrbsAueException("Incorrect trigger, " + currentSequenceNumber + " recived from RbsSequencer to upgrade participant " + this.rbsAueMetaData.getAueName() + ".");
        }
        logger.info(THIS_CLASS, this.rbsAueMetaData.getAueName() + " finished " + DateTimeHelper.dateToString(endTime, dateFormat));
    }
}

