/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.MoDataAction;
import se.ericsson.cello.aueframework.converter.MoDataModifier;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.crbs.omf.aue.common.LayerException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.common.xml.AbstractModificationXmlHandler;
import se.ericsson.crbs.omf.aue.common.xml.MomInfo;
import se.ericsson.crbs.omf.aue.step2.MoDataModifierFactory;
import se.ericsson.crbs.omf.aue.step2.actions.MoDataActionFactory;
import se.ericsson.crbs.omf.aue.step2.actions.MoDataModifierWrapper;

public class ModificationXmlStep2Handler
extends AbstractModificationXmlHandler {
    private static final Class THIS_CLASS = ModificationXmlStep2Handler.class;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    private MoDataModifier moDataModifier;
    private static final String SET_REVISION = "SetRevision";
    private List nonLteMos = null;

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("ModificationFile".equals(localName)) {
            this.fromMomInfo = this.getMomInfo("fromVersion", attributes);
            this.toMomInfo = this.getMomInfo("toVersion", attributes);
        } else if ("Mo".equals(localName)) {
            this.moName = this.getMoName(attributes);
            this.moDataModifier = MoDataModifierFactory.getMoDataModifier();
            Collection coll = ((ConverterContext)this.aueContext).getMoDataAccessor().getByType(this.moName);
            int toRevision = this.toMomInfo.intValue();
            if (coll.isEmpty()) {
                logger.traceDebug(THIS_CLASS, "startElement: cannot find any instance of " + this.moName);
            } else if (this.isNonLteMo(this.moName)) {
                MoDataWrapper modatawrapper = (MoDataWrapper)coll.toArray()[0];
                toRevision = modatawrapper.getRevision();
            }
            logger.traceDebug(THIS_CLASS, "startElement: creating MoDataModifier for " + AueUtil.quote(this.moName) + ", toRev=" + toRevision);
            this.moDataModifier.setup(this.moName, -1, toRevision);
        } else if ("MoAction".equals(localName)) {
            try {
                this.moActionName = this.getMoActionName(attributes, "MAO");
            }
            catch (LayerException le) {
                this.moActionName = "";
            }
        } else if ("Arg".equals(localName) && this.moActionName.length() > 0) {
            AbstractModificationXmlHandler.NameValue nameValue = this.getNameAndValue(attributes);
            this.moActionArgsMap.put(nameValue.name, nameValue.value);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("Mo".equals(localName)) {
            HashMap<String, MomInfo> argMap = new HashMap<String, MomInfo>();
            argMap.put("toVersion", this.toMomInfo);
            MoDataAction moDataAction = MoDataActionFactory.getMoDataAction(SET_REVISION, argMap);
            logger.traceDebug(THIS_CLASS, "adding MoDataAction " + moDataAction.getClass().getName());
            this.moDataModifier.add(moDataAction);
            MoDataModifierWrapper wrapper = new MoDataModifierWrapper(this.moDataModifier);
            ArrayList<MoDataModifierWrapper> list = new ArrayList<MoDataModifierWrapper>();
            list.add(wrapper);
            this.notifyConversionActionListeners(this.moName, list);
        } else if ("MoAction".equals(localName) && this.moActionName.length() > 0) {
            MoDataAction moDataAction = MoDataActionFactory.getMoDataAction(this.moActionName, this.moActionArgsMap);
            if (moDataAction == null) {
                String msg = "Cannot map " + this.moActionName + " to a MoDataAction";
                logger.traceError(THIS_CLASS, msg);
                throw new SAXException(msg);
            }
            logger.traceDebug(THIS_CLASS, "adding MoDataAction " + moDataAction.getClass().getName());
            this.moDataModifier.add(moDataAction);
            this.moActionName = "";
            this.moActionArgsMap.clear();
        }
    }

    protected boolean isNonLteMo(String mo) {
        if (this.nonLteMos == null) {
            this.nonLteMos = new ArrayList();
            this.nonLteMos.add("PlugInUnit");
            this.nonLteMos.add("Equipment");
        }
        return this.nonLteMos.contains(mo);
    }
}

