/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step2;

import se.ericsson.cello.aueframework.collector.CollectorUpgradeParticipator;
import se.ericsson.cello.aueframework.collector.SystemUpgradeProxy;
import se.ericsson.cello.aueframework.common.TransactionWrapper;
import se.ericsson.cello.aueframework.common.TransactionWrapperFactory;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.equipment.ProgramMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.productinventory.ProductData;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.jar.XmlHolder;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.step2.AbstractLastConversionStep;
import se.ericsson.crbs.omf.aue.step2.mao.MoRepositoryWrapper;
import se.ericsson.crbs.omf.aue.step2.mao.MoRepositoryWrapperFactory;
import se.ericsson.crbs.omf.aue.step2.mao.SystemUpgradeProxyFactoryWrapper;
import se.ericsson.crbs.omf.aue.step2.mao.SystemUpgradeProxyFactoryWrapperFactory;

public class NoamLastConversionStepImpl
extends AbstractLastConversionStep
implements CollectorUpgradeParticipator {
    private static final Class THIS_CLASS = NoamLastConversionStepImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    public static final String[] LTE_MP_LOADMODULE_PRODUCT_NUMBERS = new String[]{"CXC1725190", "CXC1725191", "CXC1725192", "CXC1726088", "CXC1729152", "CXC1725398", "CXC1725422", "CXC1323891", "CXC1329000"};
    private SystemUpgradeProxy systemUpgradeProxy;
    private static final String name = "LTE reset of MP programs restart limit";
    private TransactionWrapperFactory transactionWrapperFactory;

    public NoamLastConversionStepImpl(XmlHolder resetXmlHolder) {
        super(resetXmlHolder);
        logger.traceEnter(THIS_CLASS, "NoamLastConversionStepImpl()");
        logger.traceReturn(THIS_CLASS, "NoamLastConversionStepImpl()");
    }

    public void aueSpecificConvert(ConverterContext context) throws CrbsAueException {
        this.transactionWrapperFactory = context.getTransactionWrapperFactory();
        SystemUpgradeProxyFactoryWrapper systemUpgradeProxyFactoryWrapper = SystemUpgradeProxyFactoryWrapperFactory.getInstance().getSystemUpgradeProxyFactoryWrapper();
        this.systemUpgradeProxy = systemUpgradeProxyFactoryWrapper.getProxy(this, context);
    }

    private void setLteMpProgramsRestartCounterLimit(int restartCounterLimit, Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "setLteMpProgramsRestartCounterLimit()");
        int resettedAttributes = 0;
        MoRepositoryWrapper repository = MoRepositoryWrapperFactory.getInstance().getMoRepositoryWrapper();
        MoIterator moIter = repository.lookupType("Program");
        String productNumber = null;
        if (moIter != null) {
            while (moIter.hasMoreElements()) {
                ProgramMo program = (ProgramMo)moIter.nextElement();
                try {
                    ProductData loadModule = (ProductData)program.getLoadModule(coordinator);
                    productNumber = loadModule.getProductNumber(coordinator);
                    if (!this.isIncludedInLteLoadmoduleList(productNumber)) continue;
                    try {
                        program.setRestartCounterLimit(restartCounterLimit, coordinator);
                        ++resettedAttributes;
                    }
                    catch (MoAccessException mae) {
                        String msg = "Could not set restartCounterLimit to " + restartCounterLimit + " for LTE Program MO connected to LoadModule " + productNumber + ": " + mae.getVariablesAsString();
                        logger.traceAbnormal(THIS_CLASS, msg);
                    }
                }
                catch (MoAccessException mae) {
                    String msg = "Could not retrieve necessary information from Program MO  " + program.getLocalDistinguishedName() + ". Origianl exception: " + mae.getVariablesAsString();
                    logger.traceAbnormal(THIS_CLASS, msg);
                }
            }
            if (resettedAttributes != LTE_MP_LOADMODULE_PRODUCT_NUMBERS.length) {
                String msg = "Attribute restartCounterLimit could not be reset for all LTE programs on the MP";
                logger.traceAbnormal(THIS_CLASS, "Attribute restartCounterLimit could not be reset for all LTE programs on the MP");
            }
        }
        logger.traceReturn(THIS_CLASS, "setLteMpProgramsRestartCounterLimit()");
    }

    public String participatorName() {
        return name;
    }

    public void triggerIndicated(String trigger) {
        logger.traceEnter(THIS_CLASS, "triggerIndicated(" + trigger + ")");
        try {
            if ("FINISH".equalsIgnoreCase(trigger)) {
                TransactionWrapper transactionWrapper = this.transactionWrapperFactory.create();
                this.setLteMpProgramsRestartCounterLimit(1, transactionWrapper.getCoordinator());
                transactionWrapper.commit();
            }
            this.systemUpgradeProxy.triggerConfirmed(trigger, true);
        }
        catch (Throwable throwable) {
            logger.traceError(THIS_CLASS, "Exception caught when resetting LTE MPs " + throwable.getMessage());
            this.systemUpgradeProxy.triggerConfirmed(trigger, false);
        }
        logger.traceReturn(THIS_CLASS, "triggerIndicated(" + trigger + ")");
    }

    private boolean isIncludedInLteLoadmoduleList(String productNumber) {
        boolean result = false;
        for (int i = 0; i < LTE_MP_LOADMODULE_PRODUCT_NUMBERS.length; ++i) {
            if (productNumber.indexOf(LTE_MP_LOADMODULE_PRODUCT_NUMBERS[i]) == -1) continue;
            result = true;
            break;
        }
        return result;
    }
}

