/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ipsec;

import se.ericsson.cello.equipment.PiuUtils;
import se.ericsson.cello.ipsec.PeerIpSecProfileMoGen;
import se.ericsson.cello.ipsec.StructHelper;
import se.ericsson.cello.ipsec.VpnInterfaceMo;
import se.ericsson.cello.iptransport.IpAccessHostEtMo;
import se.ericsson.cello.iptransport.IpInterfaceMo;
import se.ericsson.cello.iptransport.Ipv6InterfaceMo;
import se.ericsson.cello.mao.MaxNumberExceededException;
import se.ericsson.cello.mao.SetRequestContext;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.transaction.Coordinator;

public class PeerIpSecProfileMoImpl
extends PeerIpSecProfileMoGen {
    public PeerIpSecProfileMoImpl(ManagedObject managedObject, AttrList attrList, String string, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy) throws MoAccessException {
        super(coordinator, managedObject, string, froProxy, initialMaoContext, attrList);
    }

    public PeerIpSecProfileMoImpl(MoData moData, InitialMaoContext initialMaoContext, FroProxy froProxy) throws MoNameAlreadyTakenException {
        super(moData, initialMaoContext, froProxy);
    }

    protected void onCreate(SetRequestContext setRequestContext) throws MoAccessException {
        Coordinator coordinator = setRequestContext.getCoordinator();
        int n = 0;
        ManagedObject managedObject = this.getParent();
        IpAccessHostEtMo ipAccessHostEtMo = (IpAccessHostEtMo)((VpnInterfaceMo)managedObject).getIpAccessHostEtRef(coordinator);
        ManagedObject managedObject2 = ipAccessHostEtMo.getIpInterfaceMoRef(coordinator);
        if (managedObject2 instanceof IpInterfaceMo) {
            n = PiuUtils.findPiuParentFroId((ManagedObject)managedObject2);
        } else if (managedObject2 instanceof Ipv6InterfaceMo) {
            n = PiuUtils.findPiuParentFroId((ManagedObject)((Ipv6InterfaceMo)managedObject2).getEthernetRef(coordinator));
        } else {
            throw new MoCanNotBeCreatedException("PeerIpSecProfile", "The referenced instance of IpAccessHostEt MO must refer to IpInterface MO or Ipv6Interface Mo but not to VpnInterface Mo");
        }
        setRequestContext.addParameter(this.froProxy, (Parameter)new SignedIntParameter("piuId", n));
        MoIterator moIterator = MoRepository.instance().lookupType("PeerIpSecProfile");
        if (moIterator != null && moIterator.size() > 1) {
            throw new MaxNumberExceededException("Max Number of MOs exceeded", "PeerIpSecProfile");
        }
        if (setRequestContext.isIncludedInRequest("allowedChildSaTransform")) {
            StructHelper.checkIntegrityAlgorithm("allowedChildSaTransform", "PeerIpSecProfile", setRequestContext);
        }
        if (setRequestContext.isIncludedInRequest("allowedIkeSaTransform")) {
            StructHelper.checkIntegrityAlgorithm("allowedIkeSaTransform", "PeerIpSecProfile", setRequestContext);
        }
    }

    protected void onSetAttributes(SetRequestContext setRequestContext) throws MoAccessException {
        if (setRequestContext.isIncludedInRequest("allowedChildSaTransform")) {
            StructHelper.checkIntegrityAlgorithm("allowedChildSaTransform", "PeerIpSecProfile", setRequestContext);
        }
        if (setRequestContext.isIncludedInRequest("allowedIkeSaTransform")) {
            StructHelper.checkIntegrityAlgorithm("allowedIkeSaTransform", "PeerIpSecProfile", setRequestContext);
        }
    }
}

