/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.mosearch.view.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import se.ericsson.cello.emt.mosearch.MoSearchLog;
import se.ericsson.cello.emt.mosearch.model.MoSearchModel;
import se.ericsson.cello.emt.mosearch.view.View;
import se.ericsson.cello.emt.mosearch.view.gui.ColumnHeaderListener;
import se.ericsson.cello.emt.mosearch.view.gui.MoSearchController;
import se.ericsson.cello.emt.mosearch.view.gui.SearchResultTableModel;
import se.ericsson.cello.emt.moti.LdnSelectionListener;
import se.ericsson.cello.emt.motools.common.toolservices.StartFailureException;
import se.ericsson.cello.emt.utils.guihelper.MessageDialog;
import se.ericsson.cello.emt.utils.guihelper.MessageDialogFactory;
import se.ericsson.cello.emt.utils.guitestsupport.GuiTestEventTypes;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoSearchGUI
extends JFrame
implements View,
ActionListener,
DocumentListener {
    private static final long serialVersionUID = -1252780566301195490L;
    private MoSearchModel searchModel;
    private JSplitPane splitPane;
    private JPanel myResultPanel;
    private JScrollPane searchOptionScrollPane;
    private JPanel searchOptionsPanel;
    private JTextField ldnRootTextField;
    private JComboBox typeBox;
    private Component instance;
    static final int MAXROWLENGTH = 600;
    private final Dimension bigBoxSize = new Dimension(600, 20);
    private final Dimension mainSize = new Dimension(760, 550);
    private AttributesGuiManager myAttributesGuiManager = null;
    private JPanel buttonPane;
    private JButton setB;
    private JButton searchB;
    private JButton cancelB;
    private JButton gotoB;
    private JButton clearB;
    private JButton openB;
    private JButton moHelpB;
    private JPopupMenu hyperToolPopupMeny;
    private JButton helpB;
    private MoSearchController controller = null;
    private static final String EMPTYVALUE = "";
    private static final String SELECT_TYPE_STRING = "            ";
    private static final String NO_AVAILABLE_TYPES_STRING = "No MO classes available";
    private static final String PARENT_FIELD_TOOLTIP = "Search root. Mandatory.";
    private static final String STAR_TOOLTIP = "Mandatory value";
    private static final String CLASS_COMBO_TOOLTIP = "Select the MO class. Mandatory.";
    private static final String ACTION_TYPEBOX = "ACTION_TYPEBOX";
    private static final String ACTION_SET = "ACTION_SET";
    private static final String ACTION_SEARCH = "ACTION_SEARCH";
    private static final String ACTION_CANCEL = "ACTION_CANCEL";
    private static final String ACTION_GOTO = "ACTION_GOTO";
    private static final String ACTION_CLEAR = "ACTION_CLEAR";
    private static final String ACTION_MO_HELP = "ACTION_MO_HELP";
    private static final String ACTION_HELP = "ACTION_HELP";
    private static final String ACTION_ATTRIBUTE_TO_SHOW = "ACTION_ATTRIBUTE_TO_SHOW";
    private final Dimension sBoxSize = new Dimension(220, 20);
    private final Dimension tBoxSize = new Dimension(220, 20);
    private JButton myFilterButton;
    private JTextField filterTextField;
    private JLabel resultLabel;
    private JLabel resultMsg;
    private JComboBox atsBox;
    private SearchResultTableModel mySearchResultTableModel;
    private JTable mySearchResultTable;
    private SearchComponentListener mySearchComponentListener = null;
    private JScrollPane resScrollPane;
    private TableColumn secondCol = null;
    private Hashtable<String, Mo> subNodes = null;
    private LdnSelectionListener ldnSelectionListener = null;
    private Hashtable<String, Mo> emptyTable = new Hashtable();
    private ResultTableHeaderRenderer myHeaderRender;
    private TableSelectionListener myTableSelectionListener;
    private FilteringSearchResultActionListener filterListener;
    private MenuItemListener menuItemlistener;

    public MoSearchGUI(MoSearchModel searchModel) {
        MoSearchLog.logger().fine("Entering Gui constructor..");
        this.searchModel = searchModel;
        this.initialize(false);
    }

    private void initialize(boolean reinit) {
        this.makeGui(reinit);
    }

    private void makeGui(final boolean reinit) {
        if (!SwingUtilities.isEventDispatchThread()) {
            this.ldnSelectionListener = null;
            Runnable guiMakeRunner = new Runnable(){

                public void run() {
                    MoSearchGUI.this.makeGui(reinit);
                }
            };
            SwingUtilities.invokeLater(guiMakeRunner);
            return;
        }
        MoSearchLog.logger().fine("Excuting in EventDispatchThread is: " + SwingUtilities.isEventDispatchThread());
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        this.instance = this;
        try {
            Image icon = this.searchModel.getConfiguration().getIconImage();
            if (icon != null) {
                this.setIconImage(icon);
            }
        }
        catch (Exception ee) {
            MoSearchLog.logger().info("MoSearchGUI was not able to set an icon. ");
        }
        this.setTitle(this.searchModel.getConfiguration().getTitle());
        this.controller = new MoSearchController(this.searchModel);
        if (!reinit) {
            this.setSize(this.mainSize);
        }
        this.mySearchComponentListener = new SearchComponentListener();
        this.addComponentListener(this.mySearchComponentListener);
        JPanel moSelectionPane = new JPanel(false);
        moSelectionPane.setBorder(BorderFactory.createTitledBorder("Search criteria"));
        GridBagLayout gridbag = new GridBagLayout();
        moSelectionPane.setLayout(gridbag);
        this.searchOptionsPanel = new JPanel();
        this.searchOptionsPanel.setLayout(new BoxLayout(this.searchOptionsPanel, 1));
        this.searchOptionsPanel.add(moSelectionPane);
        this.searchOptionScrollPane = new JScrollPane(20, 30);
        this.searchOptionScrollPane.setOpaque(false);
        this.searchOptionScrollPane.setBorder(BorderFactory.createTitledBorder(EMPTYVALUE));
        this.searchOptionScrollPane.getViewport().add(this.searchOptionsPanel);
        this.myResultPanel = new JPanel();
        this.myResultPanel.setLayout(new BoxLayout(this.myResultPanel, 1));
        Component myResultSpacer = Box.createRigidArea(new Dimension(20, 20));
        this.myResultPanel.add(myResultSpacer);
        this.myResultPanel.setAlignmentX(0.0f);
        this.myResultPanel.setMaximumSize(new Dimension(600, 600));
        this.myFilterButton = new JButton("Filter");
        JLabel filterLabel = new JLabel("Filter on: ");
        this.filterTextField = new JTextField();
        this.filterTextField.setPreferredSize(this.bigBoxSize);
        this.filterTextField.setMaximumSize(this.bigBoxSize);
        this.filterTextField.setEditable(true);
        this.filterTextField.setToolTipText("Filter");
        this.filterListener = new FilteringSearchResultActionListener();
        this.myFilterButton.addActionListener(this.filterListener);
        JPanel searchResultPanel = this.createResultTable();
        searchResultPanel.setAlignmentX(0.0f);
        JPanel filterOnPanel = new JPanel();
        filterOnPanel.setLayout(new BoxLayout(filterOnPanel, 0));
        filterOnPanel.setBorder(BorderFactory.createTitledBorder(EMPTYVALUE));
        filterOnPanel.setAlignmentX(0.0f);
        filterLabel.setAlignmentX(0.0f);
        this.filterTextField.setAlignmentX(0.0f);
        this.myFilterButton.setMnemonic('r');
        Component myFilterButtonSpacer = Box.createRigidArea(new Dimension(10, 20));
        filterOnPanel.add(filterLabel);
        filterOnPanel.add(this.filterTextField);
        filterOnPanel.add(myFilterButtonSpacer);
        filterOnPanel.add(this.myFilterButton);
        Component myFilterSpacer = Box.createRigidArea(new Dimension(20, 20));
        filterOnPanel.add(myFilterSpacer);
        this.myResultPanel.add(filterOnPanel);
        this.myResultPanel.add(searchResultPanel);
        this.splitPane = new JSplitPane(0, this.searchOptionScrollPane, this.myResultPanel);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerLocation(180);
        JLabel sourceLabel = new JLabel("Search from: ");
        sourceLabel.setHorizontalAlignment(2);
        this.ldnRootTextField = new JTextField();
        this.ldnRootTextField.setName("ldnRootTextField");
        this.ldnRootTextField.setText(this.searchModel.getConfiguration().getLdn());
        this.ldnRootTextField.setPreferredSize(this.bigBoxSize);
        this.ldnRootTextField.setEditable(true);
        this.ldnRootTextField.setToolTipText(PARENT_FIELD_TOOLTIP);
        JPanel srcPanel = new JPanel();
        srcPanel.setLayout(new FlowLayout(0, 0, 5));
        JLabel starLabel = new JLabel("* ");
        starLabel.setFont(new Font("sansserif", 0, 16));
        starLabel.setToolTipText(STAR_TOOLTIP);
        srcPanel.add(starLabel);
        this.ldnRootTextField.getDocument().addDocumentListener(this);
        srcPanel.setAlignmentX(0.0f);
        this.ldnRootTextField.setAlignmentX(0.0f);
        srcPanel.add(this.ldnRootTextField);
        JPanel typePanel = new JPanel();
        typePanel.setLayout(new FlowLayout(0, 0, 5));
        JLabel starLabel2 = new JLabel("* ");
        starLabel2.setFont(new Font("sansserif", 0, 16));
        starLabel2.setToolTipText(STAR_TOOLTIP);
        typePanel.add(starLabel2);
        JLabel typeLabel = new JLabel("MO class: ");
        typeLabel.setHorizontalAlignment(2);
        Object[] motypes = this.controller.getAvailableObjectTypes();
        this.typeBox = new JComboBox<Object>(motypes);
        this.typeBox.setName("typeBox");
        this.typeBox.setToolTipText(CLASS_COMBO_TOOLTIP);
        if (motypes.length == 0) {
            this.typeBox.addItem(NO_AVAILABLE_TYPES_STRING);
            this.typeBox.setSelectedItem(NO_AVAILABLE_TYPES_STRING);
        } else if (this.searchModel.getConfiguration().moClassSpecified()) {
            if (motypes.length > 1) {
                this.typeBox.insertItemAt(SELECT_TYPE_STRING, 0);
            }
            this.typeBox.setSelectedIndex(0);
        } else {
            this.typeBox.insertItemAt(SELECT_TYPE_STRING, 0);
            this.typeBox.addItem(SELECT_TYPE_STRING);
            this.typeBox.setSelectedItem(SELECT_TYPE_STRING);
        }
        this.typeBox.addActionListener(this);
        this.typeBox.setActionCommand(ACTION_TYPEBOX);
        typePanel.setAlignmentX(0.0f);
        this.typeBox.setAlignmentX(0.0f);
        typePanel.add(this.typeBox);
        this.addParameterRow(moSelectionPane, sourceLabel, srcPanel, false);
        this.addParameterRow(moSelectionPane, typeLabel, typePanel, false);
        this.myAttributesGuiManager = new AttributesGuiManager();
        JLabel attrPanelLabel = new JLabel("Attributes:");
        this.addParameterRow(moSelectionPane, attrPanelLabel, this.myAttributesGuiManager.getAttributsPanel(), true);
        this.getContentPane().add((Component)this.splitPane, "Center");
        this.setB = new JButton("Set");
        this.setB.setName("setB");
        this.setB.setMnemonic('t');
        this.setB.setToolTipText("Set the selected LDN in the reference field");
        this.setB.setVisible(this.ldnSelectionListener != null);
        this.setB.setEnabled(false);
        this.setB.addActionListener(this);
        this.setB.setActionCommand(ACTION_SET);
        this.searchB = new JButton("Search");
        this.searchB.setName("searchB");
        this.searchB.setMnemonic('s');
        this.searchB.setToolTipText("Search with selected MO as search base");
        this.searchB.setActionCommand(ACTION_SEARCH);
        this.searchB.addActionListener(this);
        this.searchB.setEnabled(false);
        this.getRootPane().setDefaultButton(this.searchB);
        this.cancelB = new JButton("Close");
        this.cancelB.setName("closeB");
        this.cancelB.setMnemonic('c');
        this.cancelB.setToolTipText("Close Search dialog");
        this.cancelB.setActionCommand(ACTION_CANCEL);
        this.cancelB.addActionListener(this);
        this.hyperToolPopupMeny = new JPopupMenu("   ");
        this.menuItemlistener = new MenuItemListener();
        Object[] hyperTools = this.controller.getHyperTools();
        for (int i = 0; i < hyperTools.length; ++i) {
            JMenuItem menuItem = new JMenuItem((String)hyperTools[i]);
            menuItem.addActionListener(this.menuItemlistener);
            this.hyperToolPopupMeny.add(menuItem);
        }
        GotoButtonListener popupListener = new GotoButtonListener();
        this.gotoB = new JButton("Open In...");
        this.gotoB.setMnemonic('p');
        this.gotoB.setEnabled(false);
        this.gotoB.setToolTipText("Select a tool to open the MO(s)");
        this.gotoB.addMouseListener(popupListener);
        this.gotoB.setActionCommand(ACTION_GOTO);
        this.gotoB.addActionListener(this);
        this.clearB = new JButton("Clear");
        this.clearB.setName("clearB");
        this.clearB.setMnemonic('l');
        this.clearB.setEnabled(true);
        this.clearB.setToolTipText("Clear attributes, filters and the result list.");
        this.clearB.setActionCommand(ACTION_CLEAR);
        this.clearB.addActionListener(this);
        this.moHelpB = new JButton("MO Help");
        this.moHelpB.setMnemonic('M');
        this.moHelpB.setActionCommand(ACTION_MO_HELP);
        this.moHelpB.addActionListener(this);
        this.helpB = new JButton(" Help ");
        this.helpB.setActionCommand(ACTION_HELP);
        this.helpB.addActionListener(this);
        this.helpB.getInputMap(2).put(KeyStroke.getKeyStroke(112, 0), EMPTYVALUE);
        this.helpB.getActionMap().put(EMPTYVALUE, new AbstractAction(){
            private static final long serialVersionUID = -297313304928575747L;

            public void actionPerformed(ActionEvent ae) {
                MoSearchGUI.this.startHelp();
            }
        });
        this.buttonPane = new JPanel(new FlowLayout(2));
        this.buttonPane.add(this.setB);
        this.buttonPane.add(this.searchB);
        this.buttonPane.add(this.gotoB);
        this.buttonPane.add(this.clearB);
        this.buttonPane.add(this.cancelB);
        this.buttonPane.add(this.moHelpB);
        this.buttonPane.add(this.helpB);
        if (this.searchModel.getConfiguration().moClassSpecified()) {
            String str = (String)this.typeBox.getSelectedItem();
            this.searchB.setEnabled(false);
            this.atsBox.setEnabled(true);
            this.controller.setMoTemplate(str);
            if (null == this.controller.getMoTemplate()) {
                MessageDialog message = MessageDialogFactory.createMessageDialog((String)("The MO " + this.searchModel.getConfiguration().getMoClass() + " is not specified in the MOM. Please select an MO to search for."), (String)"Click Close to continue.", (boolean)false, null);
                message.setVisible(true);
                MoSearchLog.logger().warning("The MO " + this.searchModel.getConfiguration().getMoClass() + " is not specified");
                this.searchModel.getConfiguration().setMoClassSpecified(false);
                this.updateUI(this.isVisible());
                return;
            }
            this.atsBox.removeAllItems();
            Object[] attributes = this.controller.getAttributes(str);
            for (int i = 0; i < attributes.length; ++i) {
                this.atsBox.addItem(attributes[i]);
            }
            this.atsBox.insertItemAt(EMPTYVALUE, 0);
            this.atsBox.setSelectedItem(EMPTYVALUE);
            this.myAttributesGuiManager.reset();
            this.myAttributesGuiManager.setCurrentMoType(str);
            this.myAttributesGuiManager.performTypeChangedAction(str);
            this.clearResultTable();
            boolean canDoSearchNow = this.myAttributesGuiManager.validateUserInput(false);
            this.searchB.setEnabled(canDoSearchNow);
            this.getRootPane().setDefaultButton(this.searchB);
        }
        this.getContentPane().add((Component)this.buttonPane, "South");
        if (!reinit) {
            this.pack();
            this.setLocationRelativeTo(null);
        }
        this.clearResultTable();
    }

    private void helpOnMO() {
        if (this.typeBox.getSelectedItem().toString().equals(SELECT_TYPE_STRING) || this.typeBox.getSelectedItem().toString().equals(NO_AVAILABLE_TYPES_STRING)) {
            String ldn = this.ldnRootTextField.getText();
            int start = ldn.lastIndexOf(44) + 1;
            int end = ldn.lastIndexOf(61);
            String moType = ldn.substring(start, end);
            this.searchModel.getToolServices().runHelp("class " + moType, EMPTYVALUE);
        } else {
            this.searchModel.getToolServices().runHelp("class " + this.typeBox.getSelectedItem().toString(), EMPTYVALUE);
        }
    }

    private void sourceChanged() {
        this.clearResultList();
        String LDN = this.ldnRootTextField.getText();
        this.searchModel.getStartMo().updateLdn(LDN);
        this.setB.setEnabled(false);
        this.setObjTypeList();
    }

    private void clearResultList() {
        this.clearResultTable();
    }

    private void setObjTypeList() {
        Object[] typeList = this.controller.getAvailableObjectTypes();
        this.typeBox.removeAllItems();
        if (typeList.length == 0) {
            this.typeBox.addItem(NO_AVAILABLE_TYPES_STRING);
            this.typeBox.setSelectedItem(NO_AVAILABLE_TYPES_STRING);
        } else {
            this.typeBox.addItem(SELECT_TYPE_STRING);
            this.typeBox.setSelectedItem(SELECT_TYPE_STRING);
        }
        for (int i = 0; i < typeList.length; ++i) {
            this.typeBox.addItem(typeList[i]);
        }
    }

    private void userClosing() {
        this.searchModel.getToolServices().exit();
    }

    @Override
    public void exit() {
        if (null != this.myAttributesGuiManager) {
            this.myAttributesGuiManager.destroy();
        }
        this.setVisible(false);
    }

    private void clearResultTable() {
        this.subNodes = null;
        this.updateResultTable(this.emptyTable, true);
    }

    public void searchForMos() {
        MoSearchLog.logger().finer("Entering method searchForMos");
        if (!this.myAttributesGuiManager.validateUserInput(false)) {
            MoSearchLog.logger().finer("User input not valid. Don't process the search");
            return;
        }
        this.myAttributesGuiManager.lock();
        Hashtable<String, Mo> resultTable = new Hashtable<String, Mo>();
        String query = !this.myAttributesGuiManager.isRefsSearch() ? this.myAttributesGuiManager.createQuery() : this.myAttributesGuiManager.getQueryForRefSearch();
        MoSearchLog.logger().info("Search for mo's with query = " + query);
        String[] items = query.split("#");
        Mo[] mos = items.length == 1 ? this.searchModel.search(items[0], EMPTYVALUE) : this.searchModel.search(items[0], items[1]);
        MoSearchLog.logger().info("Found " + mos.length + " hits matching the query.");
        if (this.myAttributesGuiManager.isRefsSearch()) {
            String[] attrNames = this.myAttributesGuiManager.getAttributeNames();
            for (int i = 0; i < mos.length; ++i) {
                Mo mo = mos[i];
                NameValue[] attributes = mo.getAttributes(attrNames, null);
                if (!this.myAttributesGuiManager.accept(attributes)) continue;
                resultTable.put(mo.getLdn(), mo);
            }
        } else {
            for (int i = 0; i < mos.length; ++i) {
                resultTable.put(mos[i].getLdn(), mos[i]);
            }
        }
        this.subNodes = null;
        this.subNodes = resultTable;
        this.updateResultTable(resultTable, true);
        this.myAttributesGuiManager.unlock();
    }

    private void updateResultTable(final Hashtable<String, Mo> t, final boolean success) {
        if (!SwingUtilities.isEventDispatchThread()) {
            Runnable runner = new Runnable(){

                public void run() {
                    MoSearchGUI.this.updateResultTable(t, success);
                }
            };
            SwingUtilities.invokeLater(runner);
            return;
        }
        String searchMsg = EMPTYVALUE;
        if (!success) {
            searchMsg = "Error user input.";
        } else if (t == null || t.isEmpty()) {
            searchMsg = " 0 matches.";
        } else {
            searchMsg = new Integer(t.size()).toString();
            searchMsg = searchMsg + " matches";
        }
        this.resultMsg.setText(searchMsg);
        this.mySearchResultTableModel.setData(t);
        String myAtaName = this.myAttributesGuiManager.getAtsName();
        int n = this.mySearchResultTable.getColumnCount();
        if (myAtaName == null || myAtaName.equals(EMPTYVALUE)) {
            this.removeColumn(this.mySearchResultTable, this.secondCol);
        } else if (n < 2) {
            this.myHeaderRender.setHeader(1, myAtaName);
            this.addColumn(this.mySearchResultTable, this.secondCol, myAtaName);
            this.mySearchResultTableModel.setAttrName(myAtaName);
        }
        if (n > 1) {
            this.myHeaderRender.setHeader(1, myAtaName);
            this.mySearchResultTableModel.setAttrName(myAtaName);
        }
        this.mySearchResultTableModel.getClass();
        this.myHeaderRender.setHeader(0, "LDN");
        this.mySearchComponentListener.componentResized(null);
        this.searchModel.getToolServices().sendEmNotification(GuiTestEventTypes.SEARCH_RESULTS_UPDATED, "The search results in MO Search have been updated.", null, GuiTestEventTypes.claimSeqNum(), System.currentTimeMillis(), this);
    }

    private void addParameterRow(Container container, JLabel label, Component component, boolean lastRow) {
        GridBagLayout gridbag = null;
        try {
            gridbag = (GridBagLayout)container.getLayout();
        }
        catch (Exception e) {
            MoSearchLog.logger().warning("Must use GridBagLayout. ");
            return;
        }
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(2, 5, 2, 5);
        c.anchor = 18;
        c.weightx = 0.0;
        if (lastRow) {
            c.weighty = 1.0;
            c.insets = new Insets(5, 5, 0, 5);
        }
        gridbag.setConstraints(label, c);
        container.add(label);
        c.weightx = 1.0;
        c.gridwidth = 0;
        gridbag.setConstraints(component, c);
        container.add(component);
    }

    private JPanel createResultTable() {
        JPanel resultPanel = new JPanel();
        resultPanel.setLayout(new BorderLayout());
        JPanel firstRowPanel = new JPanel();
        firstRowPanel.setLayout(new BorderLayout());
        JPanel firstRowWestPanel = new JPanel();
        firstRowWestPanel.setLayout(new FlowLayout(0));
        JPanel firstRowEastPanel = new JPanel();
        firstRowEastPanel.setLayout(new FlowLayout(2));
        firstRowPanel.add((Component)firstRowWestPanel, "West");
        firstRowPanel.add((Component)firstRowEastPanel, "East");
        this.resultLabel = new JLabel("Result:");
        this.resultLabel.setHorizontalAlignment(4);
        this.resultMsg = new JLabel("0  ");
        this.resultMsg.setHorizontalAlignment(2);
        firstRowWestPanel.add(this.resultLabel);
        firstRowWestPanel.add(this.resultMsg);
        JLabel attrToShowLabel = new JLabel("Show attribute column:");
        attrToShowLabel.setPreferredSize(this.tBoxSize);
        attrToShowLabel.setHorizontalAlignment(4);
        this.atsBox = new JComboBox();
        this.atsBox.setToolTipText("Attribute to show");
        this.atsBox.setPreferredSize(this.sBoxSize);
        this.atsBox.setEnabled(false);
        this.atsBox.setActionCommand(ACTION_ATTRIBUTE_TO_SHOW);
        this.atsBox.addActionListener(this);
        firstRowEastPanel.add(attrToShowLabel);
        firstRowEastPanel.add(this.atsBox);
        firstRowPanel.add((Component)firstRowWestPanel, "West");
        firstRowPanel.add((Component)firstRowEastPanel, "East");
        this.mySearchResultTableModel = new SearchResultTableModel(this.searchModel);
        this.mySearchResultTableModel.init();
        this.emptyTable.clear();
        this.mySearchResultTableModel.setData(this.emptyTable);
        this.mySearchResultTableModel.getClass();
        this.mySearchResultTableModel.setAttrName("Not Selected");
        this.mySearchResultTable = new JTable(this.mySearchResultTableModel);
        this.mySearchResultTable.setName("resultTable");
        this.mySearchResultTable.getTableHeader().addMouseListener(new ColumnHeaderListener());
        this.myTableSelectionListener = new TableSelectionListener(this.mySearchResultTable);
        this.mySearchResultTable.getSelectionModel().addListSelectionListener(this.myTableSelectionListener);
        this.mySearchResultTable.getColumnModel().getSelectionModel().addListSelectionListener(this.myTableSelectionListener);
        this.mySearchResultTable.setAutoResizeMode(0);
        this.mySearchResultTable.getTableHeader().setReorderingAllowed(false);
        this.mySearchResultTable.setAutoCreateColumnsFromModel(false);
        this.mySearchResultTable.setToolTipText("Ctrl+Tab to goto next button");
        int vColIndex = 1;
        this.myHeaderRender = new ResultTableHeaderRenderer();
        TableColumn col = this.mySearchResultTable.getColumnModel().getColumn(vColIndex);
        col.setHeaderRenderer(this.myHeaderRender);
        col = this.mySearchResultTable.getColumnModel().getColumn(0);
        col.setHeaderRenderer(this.myHeaderRender);
        this.mySearchResultTableModel.getClass();
        this.myHeaderRender.setHeader(0, "LDN");
        this.myHeaderRender.setBorder(BorderFactory.createTitledBorder(EMPTYVALUE));
        this.myHeaderRender.setBorder(BorderFactory.createBevelBorder(0, Color.gray, Color.darkGray));
        this.mySearchResultTableModel.initColumns(this.mySearchResultTable);
        this.secondCol = this.mySearchResultTable.getColumnModel().getColumn(1);
        int cellHeight = 20;
        int nRow = this.mySearchResultTableModel.getRowCount();
        if (nRow < 1) {
            nRow = 9;
        }
        this.mySearchResultTable.setPreferredScrollableViewportSize(new Dimension(600, (nRow + 1) * cellHeight));
        this.mySearchResultTable.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                }
            }
        });
        this.resScrollPane = new JScrollPane(20, 30);
        this.resScrollPane.setOpaque(false);
        this.resScrollPane.setBorder(BorderFactory.createTitledBorder(EMPTYVALUE));
        resultPanel.add((Component)firstRowPanel, "North");
        this.resScrollPane.getViewport().add(this.mySearchResultTable);
        resultPanel.add((Component)this.resScrollPane, "Center");
        resultPanel.setBorder(BorderFactory.createBevelBorder(1, Color.gray, Color.darkGray));
        return resultPanel;
    }

    private void postUpdateDialog() {
        this.searchB.setEnabled(this.myAttributesGuiManager.validateUserInput(false));
        if (this.subNodes == null || this.subNodes.size() == 0) {
            this.gotoB.setEnabled(false);
            this.setB.setEnabled(false);
        } else if (this.mySearchResultTable.getSelectedRowCount() > 0) {
            this.gotoB.setEnabled(true);
            this.setB.setEnabled(true);
            if (this.setB.isVisible()) {
                this.getRootPane().setDefaultButton(this.setB);
            } else {
                this.getRootPane().setDefaultButton(this.openB);
            }
        } else {
            this.gotoB.setEnabled(false);
            this.setB.setEnabled(false);
            this.getRootPane().setDefaultButton(this.searchB);
        }
        this.resScrollPane.updateUI();
    }

    protected void addColumn(JTable table, TableColumn col, Object headerLabel) {
        if (table.getAutoCreateColumnsFromModel()) {
            throw new IllegalStateException();
        }
        col.setHeaderValue(headerLabel);
        table.addColumn(col);
        ((SearchResultTableModel)table.getModel()).addColumn(col);
    }

    protected void removeColumn(JTable table, TableColumn col) {
        if (table.getAutoCreateColumnsFromModel()) {
            throw new IllegalStateException();
        }
        table.removeColumn(col);
        TableColumnModel columnModel = table.getColumnModel();
        columnModel.removeColumn(col);
    }

    private void showMessage(final Component parentComponent, final String message) {
        if (!SwingUtilities.isEventDispatchThread()) {
            Runnable runner = new Runnable(){

                public void run() {
                    MoSearchGUI.this.showMessage(parentComponent, message);
                }
            };
            SwingUtilities.invokeLater(runner);
            return;
        }
        Object[] options = new Object[]{"Close"};
        JOptionPane pane = new JOptionPane(message, 1, -1, null, options);
        JDialog dialog = pane.createDialog(parentComponent, "Message");
        dialog.pack();
        dialog.setVisible(true);
    }

    private Hashtable<String, Mo> filterTable(JTable aTable, String[] keys) {
        this.mySearchResultTableModel.setData(this.subNodes);
        Hashtable<String, Mo> result = new Hashtable<String, Mo>();
        String aLdn = null;
        String aAttrValue = null;
        Mo aMo = null;
        int nc = aTable.getColumnCount();
        int nr = aTable.getRowCount();
        String[] sArray = null;
        for (int i = 0; i < nr; ++i) {
            aLdn = (String)aTable.getValueAt(i, 0);
            if (nc == 2) {
                aAttrValue = (String)aTable.getValueAt(i, 1);
                sArray = new String[]{aLdn, aAttrValue};
            } else {
                sArray = new String[]{aLdn};
            }
            if (!this.mathStringsIgnoreCase(sArray, keys)) continue;
            aMo = this.subNodes.get(aLdn);
            result.put(aLdn, aMo);
        }
        return result;
    }

    private boolean mathStringsIgnoreCase(String[] sArray, String[] keyArray) {
        int i;
        boolean result = true;
        int slen = sArray.length;
        int klen = keyArray.length;
        String aText = null;
        String aKey = null;
        String targetSting = null;
        for (i = 0; i < slen; ++i) {
            targetSting = targetSting + sArray[i];
        }
        aText = targetSting.toLowerCase();
        for (i = 0; i < klen; ++i) {
            aKey = keyArray[i];
            if (aText.indexOf(aKey = aKey.toLowerCase()) != -1) continue;
            result = false;
            break;
        }
        return result;
    }

    @Override
    public void updateUI(boolean visible) {
        MoSearchLog.logger().fine("Updating gui: removing all components an reinitilize with new data.");
        this.typeBox.removeActionListener(this);
        this.getContentPane().removeAll();
        this.searchModel.setLdn(this.searchModel.getConfiguration().getLdn());
        this.initialize(true);
        this.showUI(visible);
    }

    @Override
    public synchronized void setLdnSelectionListener(LdnSelectionListener listener) {
        MoSearchLog.logger().fine("setLdnSelectionListener");
        this.ldnSelectionListener = listener;
        if (this.setB != null) {
            this.setB.setVisible(true);
        }
    }

    @Override
    public void showUI(final boolean visible) {
        if (!SwingUtilities.isEventDispatchThread()) {
            Runnable ShowRunner = new Runnable(){

                public void run() {
                    MoSearchGUI.this.showUI(visible);
                }
            };
            SwingUtilities.invokeLater(ShowRunner);
            return;
        }
        if (visible) {
            this.bringToFront();
        } else {
            this.setVisible(false);
        }
    }

    public void bringToFront() {
        if (this.getState() == 1) {
            this.setState(0);
        }
        this.setVisible(true);
        this.toFront();
        this.typeBox.requestFocus();
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.userClosing();
        } else {
            super.processWindowEvent(e);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCmd = e.getActionCommand();
        if (actionCmd.equals(ACTION_TYPEBOX)) {
            this.typeboxAction(e);
        } else if (actionCmd.equals(ACTION_SET)) {
            this.setAction();
        } else if (actionCmd.equals(ACTION_SEARCH)) {
            this.searchAction();
        } else if (actionCmd.equals(ACTION_CANCEL)) {
            this.userClosing();
        } else if (actionCmd.equals(ACTION_GOTO)) {
            this.hyperToolPopupMeny.show(this.gotoB, 0, this.gotoB.getHeight());
        } else if (actionCmd.equals(ACTION_CLEAR)) {
            this.clearAction();
        } else if (actionCmd.equals(ACTION_MO_HELP)) {
            this.helpOnMO();
        } else if (actionCmd.equals(ACTION_HELP)) {
            this.startHelp();
        } else if (actionCmd.equals(ACTION_ATTRIBUTE_TO_SHOW)) {
            this.getRootPane().setDefaultButton(this.searchB);
        }
    }

    private void clearAction() {
        this.filterTextField.setText(EMPTYVALUE);
        this.atsBox.setSelectedItem(EMPTYVALUE);
        this.myAttributesGuiManager.reset();
        String cwMo = (String)this.typeBox.getSelectedItem();
        this.myAttributesGuiManager.setCurrentMoType(cwMo);
        this.myAttributesGuiManager.performTypeChangedAction(cwMo);
        this.clearResultTable();
        boolean canDoSearchNow = this.myAttributesGuiManager.validateUserInput(false);
        this.searchB.setEnabled(canDoSearchNow);
        this.typeBox.requestFocus();
        this.getRootPane().setDefaultButton(this.searchB);
    }

    private void searchAction() {
        this.setCursor(new Cursor(3));
        Runnable runnable = new Runnable(){

            public void run() {
                MoSearchGUI.this.searchB.setEnabled(false);
                try {
                    MoSearchGUI.this.searchForMos();
                    MoSearchGUI.this.setCursor(new Cursor(0));
                }
                catch (Exception e) {
                    MoSearchGUI.this.setCursor(new Cursor(0));
                    MessageDialog dia = MessageDialogFactory.createMessageDialog((String)"Search failed", (Exception)e, (boolean)true, (JFrame)((JFrame)MoSearchGUI.this.instance));
                    dia.setVisible(true);
                }
                MoSearchGUI.this.searchB.setEnabled(true);
            }
        };
        Thread t = new Thread(runnable);
        t.start();
    }

    private void setAction() {
        if (this.ldnSelectionListener != null) {
            MoSearchLog.logger().info("Set LDN in the tool that listen.");
            List<String> list = this.controller.getSelectedLdns(this.mySearchResultTable);
            if (!list.isEmpty()) {
                this.ldnSelectionListener.ldnSelected(list);
                this.userClosing();
            }
        }
    }

    private void typeboxAction(ActionEvent e) {
        JComboBox cb = (JComboBox)e.getSource();
        String str = (String)cb.getSelectedItem();
        if (str != null) {
            if (str.equals(SELECT_TYPE_STRING) || str.equals(EMPTYVALUE) || str.equals(NO_AVAILABLE_TYPES_STRING)) {
                this.searchB.setEnabled(false);
                this.atsBox.setEnabled(false);
                this.myAttributesGuiManager.reset();
                String cwMo = (String)this.typeBox.getSelectedItem();
                this.myAttributesGuiManager.setCurrentMoType(cwMo);
                this.myAttributesGuiManager.performTypeChangedAction(cwMo);
                this.clearResultTable();
            } else {
                this.searchB.setEnabled(false);
                this.atsBox.setEnabled(true);
                this.controller.setMoTemplate(str);
                this.atsBox.removeAllItems();
                Object[] attributes = this.controller.getAttributes(str);
                for (int i = 0; i < attributes.length; ++i) {
                    this.atsBox.addItem(attributes[i]);
                }
                this.atsBox.insertItemAt(EMPTYVALUE, 0);
                this.atsBox.setSelectedItem(EMPTYVALUE);
                this.myAttributesGuiManager.reset();
                this.myAttributesGuiManager.setCurrentMoType(str);
                this.myAttributesGuiManager.performTypeChangedAction(str);
                this.clearResultTable();
                boolean canDoSearchNow = this.myAttributesGuiManager.validateUserInput(false);
                this.searchB.setEnabled(canDoSearchNow);
                this.getRootPane().setDefaultButton(this.searchB);
            }
        }
    }

    private void startHelp() {
        this.searchModel.getToolServices().runHelp("Element Manager", "moSearchHelp");
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.sourceChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.sourceChanged();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.sourceChanged();
    }

    private class GotoButtonListener
    implements MouseListener {
        private GotoButtonListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.showPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.showPopup(e);
        }

        private void showPopup(MouseEvent e) {
            if (MoSearchGUI.this.gotoB.isEnabled()) {
                MoSearchGUI.this.hyperToolPopupMeny.show(e.getComponent(), 0, e.getComponent().getHeight());
            }
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    }

    private class MenuItemListener
    implements ActionListener {
        private MenuItemListener() {
        }

        public void actionPerformed(ActionEvent e) {
            JMenuItem menuItem = (JMenuItem)e.getSource();
            int[] sRows = MoSearchGUI.this.mySearchResultTable.getSelectedRows();
            if (sRows == null || sRows.length == 0) {
                MoSearchLog.logger().fine("No Selection when wanting open MO.");
                return;
            }
            int n = sRows.length;
            String ldns = MoSearchGUI.EMPTYVALUE;
            for (int i = 0; i < n; ++i) {
                ldns = ldns + (String)MoSearchGUI.this.mySearchResultTable.getValueAt(sRows[i], 0) + ";";
            }
            ldns = ldns.substring(0, ldns.length() - 1);
            try {
                MoSearchGUI.this.searchModel.getToolServices().startHyperTool(menuItem.getText(), ldns);
            }
            catch (StartFailureException e1) {
                MessageDialog dialog = MessageDialogFactory.createMessageDialog((String)"No such tool", (Exception)e1, (boolean)false, (JFrame)((JFrame)MoSearchGUI.this.instance));
                dialog.setVisible(true);
            }
            catch (Exception e2) {
                MessageDialog dialog = MessageDialogFactory.createMessageDialog((String)("It was not possible to start " + menuItem.getText()), (Exception)e2, (boolean)false, (JFrame)((JFrame)MoSearchGUI.this.instance));
                dialog.setVisible(true);
            }
        }
    }

    private class ResultTableHeaderRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = 3227382068932743472L;
        private String[] headerText;

        private ResultTableHeaderRenderer() {
            String[] stringArray = new String[2];
            MoSearchGUI.this.mySearchResultTableModel.getClass();
            stringArray[0] = "LDN";
            MoSearchGUI.this.mySearchResultTableModel.getClass();
            stringArray[1] = "Not Selected";
            this.headerText = stringArray;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
            try {
                this.setText(this.headerText[vColIndex]);
            }
            catch (Exception e) {
                MoSearchLog.logger().fine("Error to set search table header: " + e.getMessage());
            }
            this.setToolTipText("Attribute Value");
            return this;
        }

        public void setHeader(int col, String t) {
            this.headerText[col] = t;
            this.setText(this.headerText[col]);
            this.invalidate();
            MoSearchGUI.this.myResultPanel.invalidate();
            MoSearchGUI.this.myResultPanel.repaint();
        }
    }

    private class SearchComponentListener
    extends ComponentAdapter {
        private SearchComponentListener() {
        }

        public void componentResized(final ComponentEvent e) {
            String theExtraAttr;
            if (!SwingUtilities.isEventDispatchThread()) {
                Runnable aRunner = new Runnable(){

                    public void run() {
                        SearchComponentListener.this.componentResized(e);
                    }
                };
                SwingUtilities.invokeLater(aRunner);
                return;
            }
            Dimension newSize = MoSearchGUI.this.getSize();
            int numberColumns = MoSearchGUI.this.mySearchResultTable.getModel().getColumnCount();
            if (numberColumns <= 0) {
                numberColumns = 1;
            }
            if ((theExtraAttr = MoSearchGUI.this.myAttributesGuiManager.getAtsName()) == null || theExtraAttr.equals(MoSearchGUI.EMPTYVALUE)) {
                numberColumns = 1;
            }
            int colWidth = newSize.width / numberColumns;
            if (numberColumns == 1) {
                MoSearchGUI.this.mySearchResultTable.getColumnModel().getColumn(0).setPreferredWidth(colWidth);
                return;
            }
            int firstColPercent = 60;
            int fcWith = newSize.width * firstColPercent / 100;
            MoSearchGUI.this.mySearchResultTable.getColumnModel().getColumn(0).setPreferredWidth(fcWith);
            int otherColWidth = (newSize.width - fcWith) / (numberColumns - 1);
            MoSearchGUI.this.mySearchResultTableModel.getClass();
            int minColWidth = 20;
            otherColWidth = otherColWidth > minColWidth ? otherColWidth : minColWidth;
            for (int i = 1; i < numberColumns; ++i) {
                MoSearchGUI.this.mySearchResultTable.getColumnModel().getColumn(i).setPreferredWidth(otherColWidth);
            }
        }
    }

    private class TableSelectionListener
    implements ListSelectionListener {
        JTable table;

        TableSelectionListener(JTable table) {
            this.table = table;
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getSource() == this.table.getSelectionModel() && this.table.getRowSelectionAllowed()) {
                MoSearchGUI.this.postUpdateDialog();
            } else if (e.getSource() == this.table.getColumnModel().getSelectionModel() && this.table.getColumnSelectionAllowed()) {
                MoSearchGUI.this.postUpdateDialog();
            }
        }
    }

    private class FilteringSearchResultActionListener
    implements ActionListener {
        private FilteringSearchResultActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String keyText = MoSearchGUI.this.filterTextField.getText();
            LinkedList<String> keyList = new LinkedList<String>();
            StringTokenizer tokens = new StringTokenizer(keyText);
            while (tokens.hasMoreTokens()) {
                keyList.add(tokens.nextToken());
            }
            String[] myKeys = keyList.toArray(new String[0]);
            if (MoSearchGUI.this.subNodes == null || MoSearchGUI.this.subNodes.isEmpty()) {
                return;
            }
            Hashtable filteredData = null;
            filteredData = myKeys.length == 0 ? MoSearchGUI.this.subNodes : MoSearchGUI.this.filterTable(MoSearchGUI.this.mySearchResultTable, myKeys);
            MoSearchGUI.this.updateResultTable(filteredData, true);
            MoSearchGUI.this.postUpdateDialog();
            MoSearchGUI.this.getRootPane().setDefaultButton(MoSearchGUI.this.myFilterButton);
        }
    }

    private class AttributesGuiManager {
        private JPanel attrPanel = new JPanel();
        private Hashtable<String, AttrRow> rows = null;
        private LinkedList<String> rowIdList = null;
        private String currentType = null;

        public AttributesGuiManager() {
            this.attrPanel.setName("attrPanel");
            this.attrPanel.setLayout(new BoxLayout(this.attrPanel, 1));
            this.attrPanel.setBorder(BorderFactory.createTitledBorder(MoSearchGUI.EMPTYVALUE));
            this.rows = new Hashtable();
            this.rowIdList = new LinkedList();
            this.createNewRow();
        }

        public void lock() {
            AttrRow aRow = null;
            Iterator<String> iter = this.rows.keySet().iterator();
            String key = null;
            while (iter.hasNext()) {
                key = iter.next();
                aRow = this.rows.get(key);
                aRow.lock();
            }
        }

        public void unlock() {
            AttrRow aRow = null;
            Iterator<String> iter = this.rows.keySet().iterator();
            String key = null;
            while (iter.hasNext()) {
                key = iter.next();
                aRow = this.rows.get(key);
                aRow.unlock();
            }
        }

        private AttrRow createNewRow() {
            AttrRow aRow = null;
            String aId = null;
            aId = Long.toString(System.currentTimeMillis());
            this.rowIdList.add(aId);
            aRow = new AttrRow();
            this.rows.put(aId, aRow);
            aRow.setId(aId);
            aRow.setRowManager(this);
            this.attrPanel.add(aRow.getAttrRowPanel());
            this.attrPanel.revalidate();
            return aRow;
        }

        public void reset() {
            this.attrPanel.removeAll();
            AttrRow aRow = null;
            Iterator<String> iter = this.rows.keySet().iterator();
            String key = null;
            while (iter.hasNext()) {
                key = iter.next();
                aRow = this.rows.get(key);
                aRow.destroy();
            }
            this.rows.clear();
            this.rowIdList.clear();
            this.createNewRow();
        }

        public JPanel getAttributsPanel() {
            return this.attrPanel;
        }

        public void refreshRowGui(AttrRow aRow) {
            JComboBox box = aRow.getLogicBox();
            String selItem = (String)box.getSelectedItem();
            String aId = aRow.getId();
            int pos = -1;
            pos = this.rowIdList.indexOf(aId);
            int nRows = this.rowIdList.size();
            if (selItem.equals(MoSearchGUI.EMPTYVALUE)) {
                if (pos != nRows - 1) {
                    String nextRowId = null;
                    AttrRow nextRow = null;
                    while (this.rowIdList.size() > pos + 1) {
                        nextRowId = this.rowIdList.removeLast();
                        nextRow = this.rows.get(nextRowId);
                        this.attrPanel.remove(nextRow.getAttrRowPanel());
                        this.rows.remove(nextRowId);
                        nextRow.destroy();
                        nextRow = null;
                    }
                }
            } else if (pos == this.rowIdList.size() - 1) {
                aRow = this.createNewRow();
                aRow.performTypeChangedAction(this.getCurrentMoType());
                Rectangle attrPanelRect = this.attrPanel.getBounds();
                attrPanelRect.setLocation(attrPanelRect.x + attrPanelRect.width, attrPanelRect.height + attrPanelRect.y);
                this.attrPanel.scrollRectToVisible(attrPanelRect);
            }
            this.attrPanel.revalidate();
            boolean canDoSearchNow = MoSearchGUI.this.myAttributesGuiManager.validateUserInput(false);
            MoSearchGUI.this.searchB.setEnabled(canDoSearchNow);
        }

        public void destroy() {
            if (this.attrPanel != null) {
                this.attrPanel.removeAll();
                this.attrPanel = null;
            }
            if (MoSearchGUI.this.buttonPane != null) {
                MoSearchGUI.this.buttonPane.removeAll();
                MoSearchGUI.this.buttonPane = null;
            }
            if (MoSearchGUI.this.ldnSelectionListener != null) {
                MoSearchGUI.this.ldnSelectionListener = null;
            }
            if (MoSearchGUI.this.resScrollPane != null) {
                MoSearchGUI.this.resScrollPane = null;
            }
            if (MoSearchGUI.this.atsBox != null) {
                MoSearchGUI.this.atsBox = null;
            }
            if (MoSearchGUI.this.subNodes != null) {
                MoSearchGUI.this.subNodes = null;
            }
            AttrRow aRow = null;
            if (this.rows != null) {
                Iterator<String> iter = this.rows.keySet().iterator();
                String key = null;
                while (iter.hasNext()) {
                    key = iter.next();
                    aRow = this.rows.get(key);
                    aRow.destroy();
                }
                this.rows.clear();
            }
        }

        public void setCurrentMoType(String t) {
            this.currentType = t;
        }

        public String getCurrentMoType() {
            return this.currentType;
        }

        public void performTypeChangedAction(String moType) {
            AttrRow aRow = null;
            Iterator<String> iter = this.rows.keySet().iterator();
            while (iter.hasNext()) {
                aRow = this.rows.get(iter.next());
                aRow.performTypeChangedAction(moType);
            }
        }

        public int getRowPosition(AttrRow aRow) {
            String aId = aRow.getId();
            int pos = -1;
            pos = this.rowIdList.indexOf(aId);
            return pos;
        }

        public String[] getAttributeNames() {
            LinkedList<String> attrNameList = new LinkedList<String>();
            AttrRow aRow = null;
            Iterator<String> iter = this.rows.keySet().iterator();
            while (iter.hasNext()) {
                aRow = this.rows.get(iter.next());
                attrNameList.add(aRow.getAttrName());
            }
            if (!aRow.getAtsName().equalsIgnoreCase(MoSearchGUI.EMPTYVALUE)) {
                attrNameList.add(aRow.getAtsName());
            }
            String[] attrNames = attrNameList.toArray(new String[0]);
            return attrNames;
        }

        public boolean validateUserInput(boolean showInFoDialog) {
            boolean result = false;
            AttrRow aRow = null;
            Iterator<String> iter = this.rows.keySet().iterator();
            while (iter.hasNext() && (result = (aRow = this.rows.get(iter.next())).validateUserInput(showInFoDialog))) {
                JComboBox box = aRow.getLogicBox();
                String selItem = (String)box.getSelectedItem();
                int pos = this.getRowPosition(aRow);
                if (pos < this.rowIdList.size() - 1 && selItem.equals(MoSearchGUI.EMPTYVALUE)) {
                    if (showInFoDialog) {
                        MoSearchGUI.this.showMessage(aRow.getAttrRowPanel(), "Please select an AND/OR.");
                    }
                    result = false;
                    break;
                }
                String attrName = aRow.getAttrName();
                if (attrName != null && !attrName.equals(MoSearchGUI.EMPTYVALUE) || this.rowIdList.size() == 1) continue;
                if (showInFoDialog) {
                    JOptionPane.showMessageDialog(aRow.getAttrRowPanel(), "Please select an attribute.");
                }
                result = false;
                break;
            }
            return result;
        }

        public String createQuery() {
            this.validateUserInput(true);
            String id = null;
            AttrRow aRow = null;
            String moType = null;
            id = this.rowIdList.getFirst();
            aRow = this.rows.get(id);
            moType = aRow.getMoType();
            String result = moType + "#";
            String tmpId = MoSearchGUI.EMPTYVALUE;
            Iterator iter = this.rowIdList.iterator();
            String attrQuery = MoSearchGUI.EMPTYVALUE;
            String aRowQuery = MoSearchGUI.EMPTYVALUE;
            while (iter.hasNext()) {
                id = (String)iter.next();
                aRow = this.rows.get(id);
                aRowQuery = aRow.createQuery();
                if (!aRowQuery.equals(MoSearchGUI.EMPTYVALUE)) {
                    aRowQuery = aRowQuery + (String)aRow.getLogicBox().getSelectedItem();
                }
                attrQuery = attrQuery + aRowQuery;
            }
            if (!tmpId.equals(MoSearchGUI.EMPTYVALUE) && !attrQuery.equals(MoSearchGUI.EMPTYVALUE)) {
                result = result + tmpId + " AND " + attrQuery;
            } else if (!tmpId.equals(MoSearchGUI.EMPTYVALUE) && attrQuery.equals(MoSearchGUI.EMPTYVALUE)) {
                result = result + tmpId;
            } else if (tmpId.equals(MoSearchGUI.EMPTYVALUE) && !attrQuery.equals(MoSearchGUI.EMPTYVALUE)) {
                result = result + attrQuery;
            }
            return result;
        }

        public String getAtsName() {
            String atsName = (String)MoSearchGUI.this.atsBox.getSelectedItem();
            return atsName;
        }

        public boolean isRefsSearch() {
            boolean result = false;
            Iterator iter = this.rowIdList.iterator();
            AttrRow aRow = null;
            String id = null;
            while (iter.hasNext()) {
                id = (String)iter.next();
                aRow = this.rows.get(id);
                if (!aRow.isRefsSearch()) continue;
                result = true;
                break;
            }
            return result;
        }

        public String getQueryForRefSearch() {
            this.validateUserInput(true);
            String id = null;
            AttrRow aRow = null;
            String moType = null;
            id = this.rowIdList.getFirst();
            aRow = this.rows.get(id);
            moType = aRow.getMoType();
            String tmpId = MoSearchGUI.EMPTYVALUE;
            String result = moType + "#" + tmpId;
            return result;
        }

        public boolean accept(NameValue[] attributes) {
            boolean finalResult = false;
            Iterator iter = this.rowIdList.iterator();
            AttrRow aRow = null;
            String id = null;
            String value = null;
            boolean oneRowResult = false;
            boolean andResult = false;
            boolean startedANewAndEvaluation = false;
            LinkedList<Boolean> orList = new LinkedList<Boolean>();
            String myLogicOperator = MoSearchGUI.EMPTYVALUE;
            while (iter.hasNext()) {
                id = (String)iter.next();
                aRow = this.rows.get(id);
                String rowName = aRow.getAttrName();
                for (int i = 0; i < attributes.length; ++i) {
                    String attrName = attributes[i].getName();
                    if (!rowName.equals(attrName)) continue;
                    value = attributes[i].valueToString();
                    break;
                }
                if ((myLogicOperator = (String)aRow.getLogicBox().getSelectedItem()).equals(" AND ")) {
                    if (!startedANewAndEvaluation) {
                        startedANewAndEvaluation = true;
                        andResult = aRow.accept(value);
                        continue;
                    }
                    if (!andResult) continue;
                    andResult = aRow.accept(value);
                    continue;
                }
                if (startedANewAndEvaluation) {
                    if (andResult) {
                        andResult = aRow.accept(value);
                    }
                    orList.add(new Boolean(andResult));
                    andResult = false;
                    startedANewAndEvaluation = false;
                    continue;
                }
                oneRowResult = aRow.accept(value);
                orList.add(new Boolean(oneRowResult));
            }
            Iterator iterOr = orList.iterator();
            Boolean aB = null;
            while (iterOr.hasNext() && !(finalResult = (aB = (Boolean)iterOr.next()).booleanValue())) {
            }
            return finalResult;
        }

        private class AttrRow {
            private String id = null;
            private JComboBox attrBox = null;
            private JComboBox conditionBox = null;
            private JPanel attrRowPanel = null;
            private JPanel myAttrValuePanel = null;
            private JComboBox attrValueCBox = null;
            private JTextField attrValueBox = null;
            private ActionListener rowAttrBoxActionListener = null;
            private FocusListener rowAttrValueFocusListener = null;
            private CaretListener rowCaretListener = null;
            private JComboBox andOrBox = null;
            private ActionListener rowAndOrActionListener = null;
            private AttributesGuiManager myRowManager = null;
            private ActionListener setSearchButtonAsDefault = null;
            private String moType;
            private String attributeName;
            private String attributeValue;
            private String atsName;
            private String condition;
            private final Dimension fourLetterSize = new Dimension(70, 20);
            private final Dimension maxAttrValPanelSize = new Dimension(590, 30);
            private final String emptyString = "";
            private final String andString = " AND ";
            private final String orString = " OR ";
            private final String eqString = "==";
            private final String gtString = ">";
            private final String ltString = "<";
            private final String neString = "!=";
            private final String geString = ">=";
            private final String leString = "<=";
            private final String[] conditionArr = new String[]{"==", ">", "<", "!=", ">=", "<="};
            private LinkedList<Component> compList = new LinkedList();
            private LinkedList<Boolean> stateList = new LinkedList();

            public AttrRow() {
                this.setSearchButtonAsDefault = new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        MoSearchGUI.this.getRootPane().setDefaultButton(MoSearchGUI.this.searchB);
                    }
                };
                Dimension theComboSize = new Dimension(220, 20);
                this.attrBox = new JComboBox();
                this.attrBox.setName("attrBox");
                this.attrBox.setToolTipText("Attribute name to search for");
                this.attrBox.setPreferredSize(theComboSize);
                this.attrBox.setEnabled(false);
                this.rowAttrBoxActionListener = new AttrRowAttrBoxActionListener();
                this.attrBox.addActionListener(this.rowAttrBoxActionListener);
                this.attrBox.addActionListener(this.setSearchButtonAsDefault);
                this.compList.add(this.attrBox);
                this.conditionBox = new JComboBox<String>(this.conditionArr);
                this.conditionBox.setName("conditionBox");
                this.conditionBox.setPreferredSize(this.fourLetterSize);
                this.conditionBox.setAlignmentX(0.5f);
                this.conditionBox.setToolTipText("Search condition");
                this.conditionBox.setEditable(false);
                this.conditionBox.setEnabled(false);
                this.conditionBox.addActionListener(this.setSearchButtonAsDefault);
                this.compList.add(this.conditionBox);
                this.attrValueCBox = new JComboBox();
                this.attrValueCBox.setName("attrValueCBox");
                this.attrValueCBox.setPreferredSize(theComboSize);
                this.attrValueCBox.addActionListener(this.setSearchButtonAsDefault);
                this.compList.add(this.attrValueCBox);
                this.attrValueBox = new JTextField();
                this.attrValueBox.setName("attrValueBox");
                this.attrValueBox.setPreferredSize(theComboSize);
                this.attrValueBox.setEditable(true);
                this.attrValueBox.setEnabled(false);
                this.attrValueBox.setToolTipText("Attribute value to search for");
                this.attrValueBox.addActionListener(this.setSearchButtonAsDefault);
                this.attrValueBox.addKeyListener(new KeyAdapter(){

                    public void keyPressed(KeyEvent e) {
                        if (e.getKeyCode() == 10) {
                            e.consume();
                            boolean canDoSearchNow = MoSearchGUI.this.myAttributesGuiManager.validateUserInput(false);
                            if (canDoSearchNow) {
                                // empty if block
                            }
                        }
                    }
                });
                this.compList.add(this.attrValueBox);
                this.rowAttrValueFocusListener = new FocusListener(){

                    public void focusGained(FocusEvent e) {
                        AttrRow.this.attrValueBox.selectAll();
                    }

                    public void focusLost(FocusEvent e) {
                    }
                };
                this.attrValueBox.addFocusListener(this.rowAttrValueFocusListener);
                this.rowCaretListener = new CaretListener(){

                    public void caretUpdate(CaretEvent e) {
                        boolean canDoSearchNow = MoSearchGUI.this.myAttributesGuiManager.validateUserInput(false);
                        MoSearchGUI.this.searchB.setEnabled(canDoSearchNow);
                    }
                };
                this.attrValueBox.addCaretListener(this.rowCaretListener);
                this.myAttrValuePanel = new JPanel();
                this.myAttrValuePanel.setLayout(new FlowLayout(0));
                this.myAttrValuePanel.add(this.attrValueBox);
                this.myAttrValuePanel.setMaximumSize(this.maxAttrValPanelSize);
                String[] andOrItems = new String[]{MoSearchGUI.EMPTYVALUE, " AND ", " OR "};
                this.andOrBox = new JComboBox<String>(andOrItems);
                this.andOrBox.setName("combinationCBox");
                this.andOrBox.setToolTipText("How to combine with next row");
                this.andOrBox.setPreferredSize(this.fourLetterSize);
                this.rowAndOrActionListener = new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        AttrRow.this.getRowManager().refreshRowGui(AttrRow.this);
                    }
                };
                this.andOrBox.addActionListener(this.rowAndOrActionListener);
                this.andOrBox.addActionListener(this.setSearchButtonAsDefault);
                this.compList.add(this.andOrBox);
                this.attrRowPanel = new JPanel();
                this.attrRowPanel.setName("row_" + AttributesGuiManager.this.rowIdList.size());
                this.attrRowPanel.setLayout(new FlowLayout(0, 2, 2));
                this.attrRowPanel.add(this.attrBox);
                this.attrRowPanel.add(this.conditionBox);
                this.attrRowPanel.add(this.myAttrValuePanel);
                this.attrRowPanel.add(this.andOrBox);
            }

            public void destroy() {
                this.compList.clear();
                this.compList = null;
                this.stateList.clear();
                this.stateList = null;
                this.myAttrValuePanel.removeAll();
                this.myAttrValuePanel = null;
                this.attrBox.removeActionListener(this.rowAttrBoxActionListener);
                this.attrBox.removeActionListener(this.setSearchButtonAsDefault);
                this.rowAttrBoxActionListener = null;
                this.attrBox = null;
                this.conditionBox.removeActionListener(this.setSearchButtonAsDefault);
                this.conditionBox = null;
                this.attrValueCBox.removeActionListener(this.setSearchButtonAsDefault);
                this.attrValueCBox = null;
                this.attrValueBox.removeFocusListener(this.rowAttrValueFocusListener);
                this.attrValueBox.removeActionListener(this.setSearchButtonAsDefault);
                this.rowAttrValueFocusListener = null;
                this.attrValueBox.removeCaretListener(this.rowCaretListener);
                this.rowCaretListener = null;
                this.attrValueBox = null;
                this.andOrBox.removeActionListener(this.rowAndOrActionListener);
                this.andOrBox.removeActionListener(this.setSearchButtonAsDefault);
                this.rowAndOrActionListener = null;
                this.setSearchButtonAsDefault = null;
                this.attrRowPanel.removeAll();
                this.attrRowPanel = null;
                this.myRowManager = null;
            }

            public JPanel getAttrRowPanel() {
                return this.attrRowPanel;
            }

            public void setId(String aId) {
                this.id = aId;
            }

            public String getId() {
                return this.id;
            }

            public JComboBox getLogicBox() {
                return this.andOrBox;
            }

            public void setRowManager(AttributesGuiManager a) {
                this.myRowManager = a;
            }

            public AttributesGuiManager getRowManager() {
                return this.myRowManager;
            }

            public void performTypeChangedAction(String moType) {
                String str = moType;
                if (str != null) {
                    if (str.equals(MoSearchGUI.SELECT_TYPE_STRING) || str.equals(MoSearchGUI.EMPTYVALUE) || str.equals(MoSearchGUI.NO_AVAILABLE_TYPES_STRING)) {
                        this.attrBox.setEnabled(false);
                        this.attrValueBox.setText(MoSearchGUI.EMPTYVALUE);
                        this.attrValueBox.setEnabled(false);
                        this.conditionBox.setEnabled(false);
                    } else {
                        this.attrBox.setEnabled(true);
                        this.attrValueBox.setText(MoSearchGUI.EMPTYVALUE);
                        this.attrValueBox.setEnabled(true);
                        this.conditionBox.setEnabled(true);
                        MoSearchGUI.this.controller.setMoTemplate(str);
                        this.attrBox.removeAllItems();
                        Object[] attributes = MoSearchGUI.this.controller.getAttributes(str);
                        for (int i = 0; i < attributes.length; ++i) {
                            this.attrBox.addItem(attributes[i]);
                        }
                        this.attrBox.insertItemAt(MoSearchGUI.EMPTYVALUE, 0);
                        this.attrBox.setSelectedItem(MoSearchGUI.EMPTYVALUE);
                    }
                }
            }

            public void lock() {
                boolean enabled = false;
                JComponent myComp = null;
                Iterator iter = this.compList.iterator();
                this.stateList.clear();
                while (iter.hasNext()) {
                    myComp = (JComponent)iter.next();
                    enabled = myComp.isEnabled();
                    this.stateList.add(Boolean.valueOf(enabled ? "true" : "false"));
                    myComp.setEnabled(false);
                }
            }

            public void unlock() {
                boolean enabled = false;
                JComponent myComp = null;
                Iterator iter = this.compList.iterator();
                int n = 0;
                while (iter.hasNext()) {
                    myComp = (JComponent)iter.next();
                    enabled = this.stateList.get(n++);
                    myComp.setEnabled(enabled);
                }
                MoSearchGUI.this.typeBox.requestFocus();
            }

            public boolean accept(String value) {
                if (this.getAttrName().equals(MoSearchGUI.EMPTYVALUE)) {
                    return true;
                }
                String myDataType = null;
                myDataType = MoSearchGUI.this.controller.getAttributeType(this.getAttrName());
                if (myDataType == null || myDataType.equals(MoSearchGUI.EMPTYVALUE)) {
                    MoSearchLog.logger().warning("Can not get attribute type.");
                    return false;
                }
                if (myDataType.equals(((MoSearchGUI)MoSearchGUI.this).controller.stringType)) {
                    return this.acceptString(value);
                }
                if (myDataType.equals(((MoSearchGUI)MoSearchGUI.this).controller.booleanType)) {
                    return this.acceptBoolean(value);
                }
                if (myDataType.equals(((MoSearchGUI)MoSearchGUI.this).controller.integerType)) {
                    return this.acceptInteger(value);
                }
                if (myDataType.equals(((MoSearchGUI)MoSearchGUI.this).controller.enumType)) {
                    return this.acceptEnum(value);
                }
                if (myDataType.equals(((MoSearchGUI)MoSearchGUI.this).controller.classType)) {
                    return this.acceptReference(value);
                }
                if (myDataType.equals(((MoSearchGUI)MoSearchGUI.this).controller.sequenceType)) {
                    return this.acceptReference(value);
                }
                if (myDataType.equals(((MoSearchGUI)MoSearchGUI.this).controller.floatType)) {
                    return this.acceptFloat(value);
                }
                if (myDataType.equals(((MoSearchGUI)MoSearchGUI.this).controller.octetArrayType)) {
                    return this.acceptString(value);
                }
                return this.acceptString(value);
            }

            private boolean acceptBoolean(String value) {
                String myValue = this.getAttrValue().toLowerCase();
                return myValue.equalsIgnoreCase(value);
            }

            private boolean acceptReference(String value) {
                boolean result = false;
                String myTypeValue = value;
                String nullString = "null";
                if (myTypeValue == null || myTypeValue.equals(MoSearchGUI.EMPTYVALUE) || myTypeValue.equals("null")) {
                    result = true;
                    return result;
                }
                String theType = MoSearchGUI.this.controller.getAttributeType(this.getAttrName());
                if (theType.equals(((MoSearchGUI)MoSearchGUI.this).controller.classType)) {
                    result = myTypeValue == null || myTypeValue.length() == 0 || myTypeValue.equals("null");
                }
                if (theType.equals(((MoSearchGUI)MoSearchGUI.this).controller.sequenceType)) {
                    int start = 0;
                    int end = myTypeValue.length();
                    if (myTypeValue.startsWith("[")) {
                        start = 1;
                    }
                    if (myTypeValue.endsWith("]")) {
                        --end;
                    }
                    result = end - start == 0;
                }
                return result;
            }

            private boolean acceptString(String value) {
                boolean result = false;
                String attrValue = this.getAttrValue();
                String myOp = this.getOperator();
                String myTypeValue = value;
                if ((attrValue.equals("\"\"") || attrValue.equals("''")) && value.equals(MoSearchGUI.EMPTYVALUE)) {
                    myTypeValue = attrValue;
                }
                if (myTypeValue == null) {
                    result = myOp.equals(this.neString);
                    return result;
                }
                result = myOp.equals(this.eqString) ? attrValue.equals(myTypeValue) : (myOp.equals(this.neString) ? !attrValue.equals(myTypeValue) : (myOp.equals(this.gtString) ? myTypeValue.compareTo(attrValue) > 0 : (myOp.equals(this.ltString) ? myTypeValue.compareTo(attrValue) < 0 : (myOp.equals(this.geString) ? myTypeValue.compareTo(attrValue) >= 0 : (myOp.equals(this.leString) ? myTypeValue.compareTo(attrValue) <= 0 : false)))));
                return result;
            }

            private boolean acceptFloat(String value) {
                boolean result = false;
                String attrValue = this.getAttrValue();
                String myOp = this.getOperator();
                String myTypeValue = value;
                if (myTypeValue == null) {
                    result = myOp.equals(this.neString);
                    return result;
                }
                if (myTypeValue.equals(MoSearchGUI.EMPTYVALUE)) {
                    myTypeValue = "0";
                }
                try {
                    float myValue = new Float(attrValue).floatValue();
                    float otherValue = new Float(myTypeValue).floatValue();
                    result = myOp.equals(this.eqString) ? otherValue == myValue : (myOp.equals(this.neString) ? otherValue != myValue : (myOp.equals(this.gtString) ? otherValue > myValue : (myOp.equals(this.ltString) ? otherValue < myValue : (myOp.equals(this.geString) ? otherValue >= myValue : (myOp.equals(this.leString) ? otherValue <= myValue : false)))));
                }
                catch (NumberFormatException n) {
                    MoSearchLog.logger().warning("Can't convert attribute value to a proper number");
                }
                return result;
            }

            private boolean acceptInteger(String value) {
                boolean result = false;
                String attrValue = this.getAttrValue();
                String myOp = this.getOperator();
                String myTypeValue = value;
                if (myTypeValue == null) {
                    result = myOp.equals(this.neString);
                    return result;
                }
                if (myTypeValue.equals(MoSearchGUI.EMPTYVALUE)) {
                    myTypeValue = "0";
                }
                try {
                    int myValue = Integer.parseInt(attrValue);
                    int otherValue = Integer.parseInt(myTypeValue);
                    result = myOp.equals(this.eqString) ? otherValue == myValue : (myOp.equals(this.neString) ? otherValue != myValue : (myOp.equals(this.gtString) ? otherValue > myValue : (myOp.equals(this.ltString) ? otherValue < myValue : (myOp.equals(this.geString) ? otherValue >= myValue : (myOp.equals(this.leString) ? otherValue <= myValue : false)))));
                }
                catch (NumberFormatException n) {
                    MoSearchLog.logger().warning("Can't convert attribute value to a proper number");
                }
                return result;
            }

            private boolean acceptEnum(String value) {
                String myOp = this.getOperator();
                int myValue = Integer.parseInt(this.getAttrValue());
                int otherValue = Integer.parseInt(value);
                if (myOp.equals(this.eqString)) {
                    return otherValue == myValue;
                }
                if (myOp.equals(this.neString)) {
                    return otherValue != myValue;
                }
                if (myOp.equals(this.gtString)) {
                    return otherValue > myValue;
                }
                if (myOp.equals(this.ltString)) {
                    return otherValue < myValue;
                }
                if (myOp.equals(this.geString)) {
                    return otherValue >= myValue;
                }
                if (myOp.equals(this.leString)) {
                    return otherValue <= myValue;
                }
                return false;
            }

            public String getAtsName() {
                this.atsName = (String)MoSearchGUI.this.atsBox.getSelectedItem();
                return this.atsName;
            }

            public String getMoType() {
                this.moType = (String)MoSearchGUI.this.typeBox.getSelectedItem();
                return this.moType;
            }

            public String getAttrName() {
                this.attributeName = (String)this.attrBox.getSelectedItem();
                return this.attributeName;
            }

            public String getAttrValue() {
                String attr = this.getAttrName();
                String result = null;
                String key = null;
                if (MoSearchGUI.this.controller.isEnum(attr)) {
                    key = (String)this.attrValueCBox.getSelectedItem();
                    result = MoSearchGUI.this.controller.getEnumValue(attr, key);
                } else {
                    result = this.attrValueBox.getText();
                }
                return result;
            }

            public String getOperator() {
                this.condition = (String)this.conditionBox.getSelectedItem();
                return this.condition;
            }

            public boolean isRefsSearch() {
                boolean result = false;
                String aType = MoSearchGUI.this.controller.getAttributeType(this.getAttrName());
                result = aType != null && (aType.equals("sequence") || aType.equals("class"));
                return result;
            }

            private void updateConditionBox(String[] items) {
                this.conditionBox.removeAllItems();
                String aItem = null;
                for (int i = 0; i < items.length; ++i) {
                    aItem = items[i];
                    this.conditionBox.addItem(aItem);
                }
            }

            public boolean validateUserInput(boolean showInFoDialog) {
                boolean result = false;
                this.moType = (String)MoSearchGUI.this.typeBox.getSelectedItem();
                if (this.moType == null || this.moType.equals(MoSearchGUI.SELECT_TYPE_STRING) || this.moType.equals(MoSearchGUI.NO_AVAILABLE_TYPES_STRING)) {
                    if (showInFoDialog) {
                        MoSearchGUI.this.showMessage(MoSearchGUI.this.instance, "Please select an MO class to search for.");
                    }
                    result = false;
                    return result;
                }
                this.attributeName = (String)this.attrBox.getSelectedItem();
                if (this.attributeName == null || this.attributeName.equals(MoSearchGUI.EMPTYVALUE)) {
                    result = true;
                    return result;
                }
                this.attributeValue = this.getAttrValue();
                this.condition = (String)this.conditionBox.getSelectedItem();
                String attributeType = null;
                attributeType = MoSearchGUI.this.controller.getAttributeType(this.attributeName);
                if (!MoSearchGUI.this.searchModel.getStartMo().getMoRef().exists()) {
                    if (showInFoDialog) {
                        MoSearchGUI.this.showMessage(MoSearchGUI.this.instance, "An MO to start the search from must be given.");
                    }
                    result = false;
                }
                if (!(this.attributeName == null || this.attributeName.equals(MoSearchGUI.EMPTYVALUE) || this.attributeValue != null && !this.attributeValue.equals(MoSearchGUI.EMPTYVALUE) || attributeType.equals(((MoSearchGUI)MoSearchGUI.this).controller.classType) || attributeType.equals(((MoSearchGUI)MoSearchGUI.this).controller.sequenceType))) {
                    if (showInFoDialog) {
                        MoSearchGUI.this.showMessage(this.getAttrRowPanel(), "The attribute must have a value.");
                    }
                    result = false;
                } else {
                    result = true;
                }
                return result;
            }

            private void scrollRectToLeft() {
                Rectangle myRect = MoSearchGUI.this.searchOptionsPanel.getBounds();
                myRect.setLocation(myRect.x - 10, myRect.height + myRect.y);
                MoSearchGUI.this.searchOptionsPanel.scrollRectToVisible(myRect);
            }

            private String supersedeSingleQuote(String text) {
                String result = null;
                String qChar = "'";
                if (text == null) {
                    return result;
                }
                result = !text.startsWith(qChar) ? qChar + text : text;
                if (!result.endsWith(qChar)) {
                    result = result + qChar;
                }
                return result;
            }

            public String createQuery() {
                this.attributeName = this.getAttrName();
                this.attributeValue = this.getAttrValue();
                this.condition = this.getOperator();
                String tmpAttr = MoSearchGUI.EMPTYVALUE;
                if (this.attributeName != null && !this.attributeName.equals(MoSearchGUI.EMPTYVALUE) && !this.isRefsSearch()) {
                    if (this.attributeValue != null && !this.attributeValue.equals(MoSearchGUI.EMPTYVALUE)) {
                        String decoAV = this.attributeValue;
                        if (MoSearchGUI.this.controller.getAttributeType(this.attributeName).equals(((MoSearchGUI)MoSearchGUI.this).controller.stringType)) {
                            decoAV = this.supersedeSingleQuote(this.attributeValue);
                        }
                        tmpAttr = this.attributeName + this.condition + decoAV;
                    } else {
                        tmpAttr = this.attributeName + this.condition;
                    }
                }
                return tmpAttr;
            }

            private class AttrRowAttrBoxActionListener
            implements ActionListener {
                private AttrRowAttrBoxActionListener() {
                }

                public void actionPerformed(ActionEvent e) {
                    String attr = (String)AttrRow.this.attrBox.getSelectedItem();
                    if (attr == null || attr.equals(MoSearchGUI.EMPTYVALUE)) {
                        AttrRow.this.attrValueBox.setText(MoSearchGUI.EMPTYVALUE);
                        AttrRow.this.attrValueBox.setEditable(false);
                        AttrRow.this.attrValueBox.setEnabled(false);
                        AttrRow.this.conditionBox.setEnabled(false);
                    } else {
                        AttrRow.this.attrValueBox.setText(MoSearchGUI.EMPTYVALUE);
                        AttrRow.this.attrValueBox.setEditable(true);
                        AttrRow.this.attrValueBox.setEnabled(true);
                        AttrRow.this.conditionBox.setEnabled(true);
                    }
                    if (AttrRow.this.isRefsSearch()) {
                        AttrRow.this.updateConditionBox(new String[]{"=="});
                    } else {
                        AttrRow.this.updateConditionBox(AttrRow.this.conditionArr);
                    }
                    String typeHelpText = null;
                    if (attr != null) {
                        typeHelpText = MoSearchGUI.this.controller.getTypeHelpText(attr);
                    }
                    if (typeHelpText != null) {
                        AttrRow.this.attrValueBox.setToolTipText(typeHelpText);
                    } else {
                        AttrRow.this.attrValueBox.setToolTipText(MoSearchGUI.EMPTYVALUE);
                    }
                    if (AttrRow.this.isRefsSearch()) {
                        if (typeHelpText.equals(((MoSearchGUI)MoSearchGUI.this).controller.arrayRefMsg)) {
                            AttrRow.this.attrValueBox.setText("Empty array");
                        } else if (typeHelpText.equals(((MoSearchGUI)MoSearchGUI.this).controller.objectRefMsg)) {
                            AttrRow.this.attrValueBox.setText("Empty");
                        } else {
                            AttrRow.this.attrValueBox.setText(MoSearchGUI.EMPTYVALUE);
                        }
                        AttrRow.this.attrValueBox.setEditable(false);
                        AttrRow.this.attrValueBox.setEnabled(false);
                        AttrRow.this.conditionBox.setEnabled(false);
                    }
                    MoSearchGUI.this.atsBox.setEnabled(true);
                    AttrRow.this.myAttrValuePanel.removeAll();
                    if (MoSearchGUI.this.controller.isEnum(attr)) {
                        AttrRow.this.attrValueCBox.removeAllItems();
                        Object[] items = MoSearchGUI.this.controller.getEnumMembers(attr);
                        for (int i = 0; i < items.length; ++i) {
                            AttrRow.this.attrValueCBox.addItem(items[i]);
                        }
                        AttrRow.this.myAttrValuePanel.add(AttrRow.this.attrValueCBox);
                        AttrRow.this.attrValueCBox.setToolTipText(MoSearchGUI.this.controller.getTypeHelpText(attr));
                    } else {
                        AttrRow.this.myAttrValuePanel.add(AttrRow.this.attrValueBox);
                    }
                    AttrRow.this.scrollRectToLeft();
                    AttrRow.this.myAttrValuePanel.repaint();
                    boolean canDoSearchNow = MoSearchGUI.this.myAttributesGuiManager.validateUserInput(false);
                    MoSearchGUI.this.searchB.setEnabled(canDoSearchNow);
                    AttrRow.this.setSearchButtonAsDefault.actionPerformed(null);
                }
            }
        }
    }
}

