/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.motools.common.momodel.typevalue;

import java.util.logging.Level;
import se.ericsson.cello.emt.moproperties.MoPropLog;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.ClassTypeValue;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.TypeValue;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.TypeValueDecorator;
import se.ericsson.cello.mimparser.MomClass;
import se.ericsson.cello.neal.cm.CmService;
import se.ericsson.cello.neal.cm.IllegalTypeException;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;

public class ClassTypeValueImpl
extends TypeValueDecorator
implements ClassTypeValue {
    protected MomClass myMomClass = null;
    protected boolean myIsUpdated = false;
    protected NameValue myWrappedNameValue = null;

    public ClassTypeValueImpl(TypeValue aDecoratedAttrModel, MomClass aMomClass) {
        super(aDecoratedAttrModel);
        this.myMomClass = aMomClass;
        if (this.myMomClass == null) {
            throw new RuntimeException("ClassTypeValueImpl.constructor: myMomClass == null");
        }
        this.myWrappedNameValue = super.getNameValue();
    }

    public MomClass getMomClass() {
        return this.myMomClass;
    }

    public String setValue(String aNewValue) {
        if (aNewValue == null) {
            aNewValue = "";
        }
        CmService cmService = this.getCmServices();
        Mo aNewValueMo = cmService.getMo(aNewValue);
        String correctClass = this.myMomClass.getName();
        if (!(correctClass.equals("ManagedObject") || aNewValue.equals("") || aNewValueMo.getType().equals(correctClass))) {
            MoPropLog.logger().log(Level.SEVERE, "The new value is not valid. The ldn='" + aNewValue + "' is not of the correct class, that is: " + correctClass);
            throw new RuntimeException("ClassTypeValueImpl.setValue: The new value is not valid. The ldn='" + aNewValue + "' is not of the correct class, that is: " + correctClass);
        }
        if (this.myWrappedNameValue != null) {
            this.myWrappedNameValue.setMoValue(aNewValueMo);
        } else {
            this.myWrappedNameValue = cmService.getNameValueFactory().create(this.getName(), aNewValueMo);
        }
        this.myIsUpdated = true;
        return aNewValue;
    }

    public boolean isUpdated() {
        return this.myIsUpdated;
    }

    public String getValueAsString() {
        String value = this.getValue();
        return value == null ? "<null>" : value;
    }

    public NameValue getNameValue() {
        return this.myWrappedNameValue;
    }

    public String getMomXmlType() {
        return this.myMomClass.getXmlType();
    }

    public boolean isValueDefined() {
        return this.getValue() != null;
    }

    private String getValue() {
        if (this.myWrappedNameValue != null) {
            Mo refValueMo = null;
            try {
                refValueMo = this.myWrappedNameValue.getMoValue();
            }
            catch (IllegalTypeException e) {
                MoPropLog.logger().log(Level.SEVERE, "The name value is not valid: " + this.myWrappedNameValue.getName() + " Reason: " + e.getMessage());
            }
            if (refValueMo == null) {
                return null;
            }
            return refValueMo.getLdn();
        }
        return null;
    }
}

