/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.common;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;

public class StringHelper {
    private static final char INDENT_CHAR = ' ';
    private static StringHelper theStringHelper = null;

    public static final String quote(String strToQuote) {
        StringBuffer quotedString = new StringBuffer("'").append(strToQuote).append("'");
        return quotedString.toString();
    }

    public static final String doubleQuote(String strToDoubleQuote) {
        StringBuffer doubleQuotedString = new StringBuffer("\"").append(strToDoubleQuote).append("\"");
        return doubleQuotedString.toString();
    }

    public final String unQuote(String stringToUnQuote) {
        String result = stringToUnQuote;
        try {
            result = this.unQuote(stringToUnQuote, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return result;
    }

    public final String unQuote(String stringToUnQuote, boolean exceptionIfNotQuoted) {
        String result = stringToUnQuote;
        if (this.isQuoted(stringToUnQuote)) {
            result = stringToUnQuote.substring(1, stringToUnQuote.length() - 1);
        } else if (exceptionIfNotQuoted) {
            throw new IllegalArgumentException("The string " + stringToUnQuote + " is not quoted.");
        }
        return result;
    }

    private final boolean isQuoted(String string) {
        return this.isSingelQuoted(string) || this.isDoubleQuoted(string);
    }

    private final boolean isDoubleQuoted(String string) {
        return string.length() > 1 && string.indexOf(34) == 0 && string.lastIndexOf(34) == string.length() - 1;
    }

    private final boolean isSingelQuoted(String string) {
        return string.length() > 1 && string.indexOf(39) == 0 && string.lastIndexOf(39) == string.length() - 1;
    }

    public static void removeString(StringBuffer stringBufferToFilter, String stringToRemove) {
        int i = stringBufferToFilter.indexOf(stringToRemove);
        while (i != -1) {
            for (int j = 0; j < stringToRemove.length(); ++j) {
                stringBufferToFilter.deleteCharAt(i);
            }
            i = stringBufferToFilter.indexOf(stringToRemove);
        }
    }

    public static String indentString(String stringToBeIndented, int indentLevel) {
        return StringHelper.createIndentString(indentLevel) + stringToBeIndented;
    }

    public static String createIndentString(int indentLevel) {
        return StringHelper.createFilledString(' ', indentLevel * 2);
    }

    public static String replaceInString(String stringToBeReplace, String oldValue, String newValue) {
        int currentIndex = 0;
        int startIndex = 0;
        StringBuffer strBuf = new StringBuffer(stringToBeReplace);
        while (currentIndex != -1) {
            currentIndex = strBuf.indexOf(oldValue, startIndex);
            if (currentIndex <= -1) continue;
            strBuf.replace(currentIndex, currentIndex + oldValue.length(), newValue);
            startIndex = currentIndex + newValue.length();
        }
        return strBuf.toString();
    }

    public static String emptyStringToNull(String value) {
        return StringHelper.emptyStringToDefault(value, null);
    }

    public static String emptyStringToDefault(String value, String defValue) {
        String returnValue = value;
        if (value == null || value.equals("")) {
            returnValue = defValue;
        }
        return returnValue;
    }

    public static StringHelper getStringHelper() {
        if (theStringHelper == null) {
            theStringHelper = new StringHelper();
        }
        return theStringHelper;
    }

    public static String createFilledString(char charToBeFilledIntoString, int length) {
        byte[] byteArray = new byte[length];
        Arrays.fill(byteArray, (byte)charToBeFilledIntoString);
        return new String(byteArray);
    }

    public static String toString(AttrList attrList) {
        String str = "";
        for (int i = 0; i < attrList.size(); ++i) {
            try {
                str = str + "Attribute: " + attrList.getName(i) + '=' + StringHelper.objToString(attrList.getValue(i)) + '\n';
                continue;
            }
            catch (NotHandledAttributeTypeException e) {
                str = str + "!!! Error !!! " + e.getMessage();
                continue;
            }
            catch (MoNotFoundException e) {
                str = str + "!!! Error !!! " + e.getMessage();
            }
        }
        return str;
    }

    public static String toString(Map map) {
        String str = "";
        TreeSet keys = new TreeSet(map.keySet());
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            str = str + "Attribute: " + key + '=' + StringHelper.objToString(map.get(key)) + '\n';
        }
        return str;
    }

    public static String objToString(Object value) {
        String result;
        String string = result = value == null ? "NULL" : value.toString();
        if (value != null && value.getClass().isArray()) {
            StringBuffer sb = new StringBuffer();
            if (value instanceof int[]) {
                sb.append("(int[]) {");
                int[] intArray = (int[])value;
                for (int i = 0; i < intArray.length; ++i) {
                    sb.append(i == 0 ? "" : ",").append(intArray[i]);
                }
                sb.append('}');
            } else if (value instanceof long[]) {
                sb.append("(long[]) {");
                long[] longArray = (long[])value;
                for (int i = 0; i < longArray.length; ++i) {
                    sb.append(i == 0 ? "" : ",").append(longArray[i]);
                }
                sb.append('}');
            } else if (value instanceof boolean[]) {
                sb.append("(boolean[]) {");
                boolean[] booleanArray = (boolean[])value;
                for (int i = 0; i < booleanArray.length; ++i) {
                    sb.append(i == 0 ? "" : ",").append(booleanArray[i]);
                }
                sb.append('}');
            } else if (value instanceof Object[]) {
                sb.append("(" + value.getClass().getComponentType() + "[]) {");
                Object[] objArray = (Object[])value;
                for (int i = 0; i < objArray.length; ++i) {
                    sb.append(i == 0 ? "" : ",").append(StringHelper.objToString(objArray[i]));
                }
                sb.append('}');
            }
            result = sb.toString();
        }
        return result;
    }
}

