/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.commonmo.metadata.factory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.metadata.finder.MoMetaDataFinder;
import se.ericsson.crbs.omf.mao.indications.MaoFroAlarmObject;
import se.ericsson.crbs.omf.mao.xml.Parser;
import se.ericsson.crbs.omf.mao.xml.XMLElement;

public final class AlarmInfoHandler {
    private static AbstractLogger logger = LoggingService.getLogger(AlarmInfoHandler.class.getName());
    private static final Class THIS_CLASS = AlarmInfoHandler.class;

    public static void storeAlarmInfo(Parser momParser, MoMetaDataFinder finder) throws IOException {
        logger.traceEnter(THIS_CLASS, "storeAlarmInfo()");
        List alarmMomElements = momParser.getXMLelements();
        AlarmInfoHandler.storeAlarmDefinitions(alarmMomElements, finder);
        logger.traceReturn(THIS_CLASS, "storeAlarmInfo()");
    }

    static void storeAlarmDefinitions(List alarmMomElements, MoMetaDataFinder finder) throws IOException {
        Iterator alarmMomElementsIter = alarmMomElements.iterator();
        while (alarmMomElementsIter.hasNext()) {
            XMLElement alarmMomElement = (XMLElement)alarmMomElementsIter.next();
            String mimChildType = alarmMomElement.getType();
            if (!"alarmDefinition".equals(mimChildType)) continue;
            AlarmInfoHandler.storeAlarmDefinition(alarmMomElement, finder);
        }
    }

    static void storeAlarmDefinition(XMLElement alarmDefinitionElement, MoMetaDataFinder finder) throws IOException {
        Integer faultId = new Integer(alarmDefinitionElement.getAttributes().getValue("id"));
        String eventType = alarmDefinitionElement.getAttributes().getValue("eventType");
        String probableCause = alarmDefinitionElement.getAttributes().getValue("probableCause");
        String perceivedSeverity = alarmDefinitionElement.getAttributes().getValue("perceivedSeverity");
        String specificProblem = alarmDefinitionElement.getAttributes().getValue("specificProblem");
        boolean secondaryAlarm = "QUALITY_OF_SERVICE_ALARM".equals(eventType);
        String moTypes = alarmDefinitionElement.getAttributes().getValue("moType");
        String alarmClassification = alarmDefinitionElement.getAttributes().getValue("alarmClassification");
        List moList = AlarmInfoHandler.parseMoTypes(moTypes);
        MaoFroAlarmObject maoFroAlarmObject = new MaoFroAlarmObject(faultId, eventType, probableCause, perceivedSeverity, specificProblem, "", null, 0, secondaryAlarm, alarmClassification);
        HashMap<Integer, MaoFroAlarmObject> alarmMap = new HashMap<Integer, MaoFroAlarmObject>(1);
        alarmMap.put(faultId, maoFroAlarmObject);
        Iterator moListIter = moList.iterator();
        while (moListIter.hasNext()) {
            String moType = (String)moListIter.next();
            finder.getMoData(moType).addAlarmMap(alarmMap);
        }
    }

    static List parseMoTypes(String moTypes) {
        ArrayList<String> moList = new ArrayList<String>();
        String moTypesRest = moTypes;
        while (!"".equals(moTypesRest)) {
            int index = moTypesRest.indexOf(44);
            if (index == -1) {
                moList.add(moTypesRest);
                moTypesRest = "";
                continue;
            }
            moList.add(moTypesRest.substring(0, index));
            moTypesRest = moTypesRest.substring(index + 1);
        }
        return moList;
    }

    private AlarmInfoHandler() {
    }
}

