/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.commonmo.metadata.factory;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.StructImpl;
import se.ericsson.crbs.omf.mao.commonmo.metadata.AttributeMetaData;
import se.ericsson.crbs.omf.mao.commonmo.metadata.MoMetaData;
import se.ericsson.crbs.omf.mao.commonmo.metadata.factory.MetaDataParser;
import se.ericsson.crbs.omf.mao.commonmo.metadata.factory.XmlElementExporter;
import se.ericsson.crbs.omf.mao.commonmo.metadata.finder.MoMetaDataFinder;
import se.ericsson.crbs.omf.mao.xml.Parser;
import se.ericsson.crbs.omf.mao.xml.XMLElement;

public final class DesignMomHandler {
    private static final Class THIS_CLASS = DesignMomHandler.class;
    private static AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    private static Map structMap = new HashMap();

    private static Map getStructMembers(List structChildren) {
        HashMap<String, String> structMembers = new HashMap<String, String>();
        Iterator structChildIter = structChildren.iterator();
        while (structChildIter.hasNext()) {
            XMLElement currentStructChild = (XMLElement)structChildIter.next();
            if (!"structMember".equals(currentStructChild.getType())) continue;
            String currentStructMemberName = currentStructChild.getAttributes().getValue("name");
            String currentStructMemberPosition = currentStructChild.getAttributes().getValue("position");
            structMembers.put(currentStructMemberName, currentStructMemberPosition);
        }
        return structMembers;
    }

    public static Map getStructs() {
        return structMap;
    }

    private static void handelLocalTagAtStore(String moName, MoMetaDataFinder finder, String currentAttrName, XMLElement currentAttrChild) {
        AttributeMetaData amData = finder.getMoAttributes(moName, currentAttrName);
        if (amData == null) {
            String msg = "Attribute mismatch! Metadata for attribute " + currentAttrName + " not found for mo " + moName + "!";
            logger.traceAbnormal(THIS_CLASS, msg);
        } else {
            amData.setLocalStored();
        }
        List localTagChildren = currentAttrChild.getChildren();
        Iterator localTagChildrenIter = localTagChildren.iterator();
        while (localTagChildrenIter.hasNext()) {
            XMLElement localTagChild = (XMLElement)localTagChildrenIter.next();
            String propertyType = localTagChild.getType();
            if ("requiredRemote".equals(propertyType)) {
                finder.getMoAttributes(moName, currentAttrName).setRequiredRemotelyAtCreate();
            }
            if (!"systemWriteableOnly".equals(propertyType)) continue;
            finder.getMoAttributes(moName, currentAttrName).setSystemWriteableOnly();
        }
    }

    private static void storeAttribute(XMLElement attribute, String moName, MoMetaDataFinder finder) throws IOException {
        String currentAttrName = attribute.getAttributes().getValue("name");
        AttributeMetaData currentAttrMetaData = DesignMomHandler.getAttributeMetaData(moName, currentAttrName, finder);
        List attributeChildren = attribute.getChildren();
        Iterator attributeChildrenIter = attributeChildren.iterator();
        while (attributeChildrenIter.hasNext()) {
            XMLElement currentAttrChild = (XMLElement)attributeChildrenIter.next();
            if ("local".equals(currentAttrChild.getType())) {
                DesignMomHandler.handelLocalTagAtStore(moName, finder, currentAttrName, currentAttrChild);
                continue;
            }
            if ("uniqueInNode".equals(currentAttrChild.getType())) {
                finder.getMoAttributes(moName, currentAttrName).setUniqueInNode();
                continue;
            }
            if ("dataType".equals(currentAttrChild.getType())) {
                AttributeMetaData currentNonMomAttributeMetaData = MetaDataParser.getAttributeMetaData(attribute, moName);
                finder.getMoData(moName).storeNonMomAttribute(currentAttrName, currentNonMomAttributeMetaData);
                continue;
            }
            if ("replaced".equals(currentAttrChild.getType())) {
                DesignMomHandler.storeDeprecatedAttributeMetaData(moName, currentAttrChild, currentAttrMetaData, finder);
                continue;
            }
            if (!"domainSpecific".equals(currentAttrChild.getType())) continue;
            DesignMomHandler.storeDomainSpecificAttribute(finder, attribute, moName, currentAttrChild);
        }
    }

    public static void storeDesignMOMData(Parser momParser, MoMetaDataFinder finder) throws IOException {
        List designMomElements = momParser.getXMLelements();
        Iterator momClassIter = designMomElements.iterator();
        while (momClassIter.hasNext()) {
            XMLElement currentMomChild = (XMLElement)momClassIter.next();
            String mimChildType = currentMomChild.getType();
            if (!"class".equals(mimChildType)) continue;
            String currentMOName = currentMomChild.getAttributes().getValue("name");
            MoMetaData currentMoMetaData = DesignMomHandler.getMoMetaData(currentMOName, finder);
            if (currentMoMetaData == null) {
                String msg = "No meta data found for: " + currentMOName + "!";
                logger.traceAbnormal(THIS_CLASS, msg);
            } else {
                currentMoMetaData.setImplementedAsGenericMAO(true);
            }
            String currentMOServiceName = currentMomChild.getAttributes().getValue("serviceName");
            currentMoMetaData.setServiceName(currentMOServiceName);
            String currentMOFroType = currentMomChild.getAttributes().getValue("froType");
            currentMoMetaData.setFroType(currentMOFroType);
            String currentMOPvVersion = currentMomChild.getAttributes().getValue("pvVersion");
            currentMoMetaData.setFroProtocolVersion(currentMOPvVersion);
            String currentMOSwRev = currentMomChild.getAttributes().getValue("softwareRevision");
            currentMoMetaData.setSwRevision(new Integer(currentMOSwRev));
            String currentPi = currentMomChild.getAttributes().getValue("productInventory");
            currentMoMetaData.setPiType(currentPi);
            if (currentMOFroType == null) {
                DesignMomHandler.setLocalForMomWithoutFroType(finder, currentMOName, currentMoMetaData);
            }
            List moChildren = currentMomChild.getChildren();
            Iterator moChildIter = moChildren.iterator();
            while (moChildIter.hasNext()) {
                XMLElement currentMoChild = (XMLElement)moChildIter.next();
                String moChildType = currentMoChild.getType();
                if ("attribute".equals(moChildType)) {
                    DesignMomHandler.storeAttribute(currentMoChild, currentMOName, finder);
                    if (currentMOFroType != null && currentMOFroType.length() != 0 && currentMOServiceName != null && currentMOServiceName.length() != 0) continue;
                    String currentAttrName = currentMoChild.getAttributes().getValue("name");
                    AttributeMetaData amData = finder.getMoAttributes(currentMOName, currentAttrName);
                    amData.setLocalStored();
                    continue;
                }
                if ("multipleParents".equals(moChildType)) {
                    currentMoMetaData.setHasMultipleParents(true);
                    continue;
                }
                if ("partlySystemCreated".equalsIgnoreCase(moChildType)) {
                    currentMoMetaData.setPartlySystemCreated(true);
                    continue;
                }
                if ("replaced".equalsIgnoreCase(moChildType)) {
                    DesignMomHandler.storeDeprecatedMoMetaData(currentMoChild, currentMoMetaData, finder);
                    continue;
                }
                if (!"domainSpecific".equalsIgnoreCase(moChildType)) continue;
                DesignMomHandler.storeDomainSpecificDesignMOMData(finder, currentMomChild, currentMoChild);
            }
        }
    }

    private static void setLocalForMomWithoutFroType(MoMetaDataFinder finder, String currentMOName, MoMetaData currentMoMetaData) throws IOException {
        Map attributes = currentMoMetaData.getAttributes();
        String attrName = "";
        Iterator iter = attributes.keySet().iterator();
        while (iter.hasNext()) {
            attrName = (String)iter.next();
            if (attrName == null) continue;
            AttributeMetaData currentAttrMetaData = DesignMomHandler.getAttributeMetaData(currentMOName, attrName, finder);
            currentAttrMetaData.setLocalStored();
        }
    }

    public static void storeStructs(Parser momParser) throws IOException {
        List designMomElements = momParser.getXMLelements();
        Iterator momClassIter = designMomElements.iterator();
        while (momClassIter.hasNext()) {
            XMLElement currentMomChild = (XMLElement)momClassIter.next();
            String mimChildType = currentMomChild.getType();
            if (!"struct".equals(mimChildType)) continue;
            List structChildren = currentMomChild.getChildren();
            String currentStructName = currentMomChild.getAttributes().getValue("name");
            Map structMembers = DesignMomHandler.getStructMembers(structChildren);
            structMap.put(currentStructName, structMembers);
        }
    }

    private static void storeDomainSpecificDesignMOMData(MoMetaDataFinder finder, XMLElement domainSpecificClass, XMLElement domainSpecificMOType) {
        String domainSpecificContent = new XmlElementExporter().exportElement(domainSpecificMOType, false, true);
        String domainSpecificClassName = domainSpecificClass.getAttributes().getValue("name");
        String domainSpecificClassChildName = domainSpecificMOType.getAttributes().getValue("name");
        finder.getMoData(domainSpecificClassName).storeDomainSpecific(domainSpecificClassChildName, domainSpecificContent);
    }

    private static void storeDomainSpecificAttribute(MoMetaDataFinder finder, XMLElement attribute, String domainSpecificClass, XMLElement domainSpecificAttributeType) {
        String domainSpecificContent = new XmlElementExporter().exportElement(domainSpecificAttributeType, false, true);
        String attributeName = attribute.getAttributes().getValue("name");
        String currentMOName = domainSpecificAttributeType.getAttributes().getValue("name");
        finder.getMoAttributes(domainSpecificClass, attributeName).storeDomainSpecific(currentMOName, domainSpecificContent);
    }

    private static void storeDeprecatedMoMetaData(XMLElement currentMoChild, MoMetaData currentMoMetaData, MoMetaDataFinder finder) throws IOException {
        String replacingMoName = currentMoChild.getAttributes().getValue("by");
        if (replacingMoName != null) {
            MoMetaData replacingMoMetaData = DesignMomHandler.getMoMetaData(replacingMoName, finder);
            StructImpl replacedByStruct = new StructImpl();
            replacedByStruct.addElement("moName", replacingMoName);
            replacedByStruct.addElement("moMetaData", replacingMoMetaData);
            currentMoMetaData.setReplacedBy(replacedByStruct);
            StructImpl replacingStruct = new StructImpl();
            replacingStruct.addElement("moName", currentMoMetaData.getName());
            replacingStruct.addElement("moMetaData", currentMoMetaData);
            replacingMoMetaData.setReplacing(replacingStruct);
        }
    }

    private static void storeDeprecatedAttributeMetaData(String moName, XMLElement currentAttrChild, AttributeMetaData currentAttrMetaData, MoMetaDataFinder finder) throws IOException {
        String replacingAttr = currentAttrChild.getAttributes().getValue("by");
        if (replacingAttr != null) {
            AttributeMetaData replacingAttrMetaData;
            String replacingMo = null;
            int dotIndex = replacingAttr.indexOf(46);
            if (dotIndex != -1) {
                replacingMo = replacingAttr.substring(0, dotIndex);
                replacingAttr = replacingAttr.substring(dotIndex + 1);
            }
            StructImpl replacedByStruct = new StructImpl();
            StructImpl replacingStruct = new StructImpl();
            replacedByStruct.addElement("attributeName", replacingAttr);
            replacingStruct.addElement("attributeName", currentAttrMetaData.getName());
            if (replacingMo == null) {
                replacingAttrMetaData = DesignMomHandler.getAttributeMetaData(moName, replacingAttr, finder);
            } else {
                replacedByStruct.addElement("moName", replacingMo);
                replacedByStruct.addElement("moMetaData", DesignMomHandler.getMoMetaData(replacingMo, finder));
                replacingStruct.addElement("moName", moName);
                replacingStruct.addElement("moMetaData", DesignMomHandler.getMoMetaData(moName, finder));
                replacingAttrMetaData = DesignMomHandler.getAttributeMetaData(replacingMo, replacingAttr, finder);
            }
            currentAttrMetaData.setReplacedBy(replacedByStruct);
            replacingAttrMetaData.setReplacing(replacingStruct);
        }
    }

    private static MoMetaData getMoMetaData(String moName, MoMetaDataFinder finder) throws IOException {
        MoMetaData moMetaData = finder.getMoData(moName);
        if (moMetaData == null) {
            String msg = "No meta data found for MO: " + moName + "!";
            logger.traceAbnormal(THIS_CLASS, msg);
            throw new IOException(msg);
        }
        return moMetaData;
    }

    private static AttributeMetaData getAttributeMetaData(String moName, String attrName, MoMetaDataFinder finder) throws IOException {
        AttributeMetaData attrMetaData = finder.getMoAttributes(moName, attrName);
        if (attrMetaData == null) {
            String msg = "No meta data found for MO: " + moName + " attribute " + attrName + "!";
            logger.traceAbnormal(THIS_CLASS, msg);
            throw new IOException(msg);
        }
        return attrMetaData;
    }

    private DesignMomHandler() {
    }
}

