/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.commonmo.mib;

import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.metadata.finder.MoMetaDataFinder;
import se.ericsson.crbs.omf.mao.commonmo.mib.MibHandler;
import se.ericsson.crbs.omf.mao.commonmo.mib.MibHandlerFactory;
import se.ericsson.crbs.omf.mao.commonmo.mib.MibHandlerImpl;
import se.ericsson.crbs.omf.mao.commonmo.mib.MibMgrWrapper;
import se.ericsson.crbs.omf.mao.commonmo.mib.MibMgrWrapperFactory;
import se.ericsson.crbs.omf.mao.commonmo.mib.MimVersionReader;
import se.ericsson.crbs.omf.mao.commonmo.mib.MimVersionReaderFactory;
import se.ericsson.crbs.omf.mao.commonmo.transactions.TransactionServicesFactoryImpl;

public class MibHandlerFactoryImpl
implements MibHandlerFactory {
    private static final Class THIS_CLASS = MibHandlerFactory.class;
    private static AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    private static MibHandler theInstance = null;
    private final MoMetaDataFinder aFinder;
    private final MibMgrWrapperFactory theMibMgrWrapperFactory;

    public MibHandlerFactoryImpl(MoMetaDataFinder aFinder, MibMgrWrapperFactory aMibMgrWrapperFactory) {
        this.aFinder = aFinder;
        this.theMibMgrWrapperFactory = aMibMgrWrapperFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MibHandler getMibHandler() {
        logger.traceEnter(THIS_CLASS, "getMibHandler");
        MibHandlerFactoryImpl mibHandlerFactoryImpl = this;
        synchronized (mibHandlerFactoryImpl) {
            if (theInstance == null) {
                MimVersionReader reader = new MimVersionReaderFactory(this.aFinder).getMimVersionReader();
                TransactionFactory transFactory = TransactionServicesFactoryImpl.getInstance().getCppTransactionFactory();
                MibMgrWrapper mibMgrWrapper = this.theMibMgrWrapperFactory.getInstance();
                theInstance = new MibHandlerImpl(reader, transFactory, mibMgrWrapper);
            }
        }
        logger.traceReturn(THIS_CLASS, "getMibHandler");
        return theInstance;
    }
}

