/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.commonmo.mib;

import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.metadata.finder.MoMetaDataFinder;
import se.ericsson.crbs.omf.mao.commonmo.mib.MimVersionReader;

public class MimVersionReaderImpl
implements MimVersionReader {
    private static AbstractLogger logger = LoggingService.getLogger(MimVersionReaderImpl.class.getName());
    private static final Class THIS_CLASS = MimVersionReaderImpl.class;
    private final MoMetaDataFinder theFinder;

    public MimVersionReaderImpl(MoMetaDataFinder finder) {
        this.theFinder = finder;
    }

    public String getMimType() {
        logger.traceEnter(THIS_CLASS, "getMimType()");
        String res = null;
        res = this.theFinder == null ? "Support_System_A" : this.theFinder.getMimType();
        logger.traceReturn(THIS_CLASS, "getMimType() = " + res);
        return res;
    }

    public String getMimVersion() {
        logger.traceEnter(THIS_CLASS, "getMimVersion");
        String res = null;
        if (this.theFinder == null) {
            res = "1";
        } else {
            String version = this.theFinder.getMimVersion();
            StringBuffer release = new StringBuffer(this.theFinder.getMimRelease());
            res = version + '.' + release.toString();
        }
        logger.traceReturn(THIS_CLASS, "getMimVersion() = " + res);
        return res;
    }

    public String getMimRelease() {
        logger.traceEnter(THIS_CLASS, "getMimRelease");
        String res = null;
        res = this.theFinder == null ? "0" : "";
        logger.traceReturn(THIS_CLASS, "getMimRelease() = " + res);
        return res;
    }
}

