/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.genericmo.attributes.type;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.BooleanAttribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.SequenceDiffInfo;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructAttribute;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.swmanagement.LoadModuleMoImpl;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.ProcessingFailureException;
import se.ericsson.crbs.omf.mao.commonmo.metadata.finder.MoMetaDataFinder;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.SeqDataType;
import se.ericsson.crbs.omf.mao.genericmo.attributes.type.LocalAttribute;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class MaoSequenceAttribute
implements LocalAttribute {
    private static final String RESERVED_BY = "reservedBy";
    private static final String JAVA_TYPE_STRING_ARRAY = "String[]";
    private static final String JAVA_TYPE_INTEGER_ARRAY = "Integer[]";
    private static final String JAVA_TYPE_MANAGED_OBJECT_ARRAY = "ManagedObject[]";
    private static final String JAVA_TYPE_BOOLEAN_ARRAY = "Boolean[]";
    private static final String JAVA_TYPE_STRUCT_ARRAY = "struct[]";
    private static final Class THIS_CLASS = MaoSequenceAttribute.class;
    private static AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    private SequenceAttribute attributeValue = null;
    private final String attributeName;
    private final boolean isAvcNotifier;
    private final MoRepositoryWrapper moRepositoryWrapper;
    private final SeqDataType seqMetaData;

    public MaoSequenceAttribute(String moName, String attributeName, boolean isAvcNotifier, MoMetaDataFinder aFinder, MoRepositoryWrapper aMoRepositoryWrapper) throws MoAccessException {
        this.attributeName = attributeName;
        this.isAvcNotifier = isAvcNotifier;
        this.seqMetaData = (SeqDataType)aFinder.getMoAttributes(moName, attributeName).getData();
        this.moRepositoryWrapper = aMoRepositoryWrapper;
    }

    public void addElement(Attribute attrToAdd) {
        this.attributeValue.addElement(attrToAdd);
    }

    private Object attributeToObject(Attribute sequenceAttributeMember, Coordinator coordinator) throws MoAccessException {
        Object requiredValue = null;
        if (JAVA_TYPE_MANAGED_OBJECT_ARRAY.equals(this.seqMetaData.getJavaReturnType())) {
            requiredValue = ((ReferenceAttribute)sequenceAttributeMember).getValue(coordinator);
        } else if (JAVA_TYPE_INTEGER_ARRAY.equals(this.seqMetaData.getJavaReturnType())) {
            requiredValue = new Integer(((IntegerAttribute)sequenceAttributeMember).getValue(coordinator));
        } else if (JAVA_TYPE_STRING_ARRAY.equals(this.seqMetaData.getJavaReturnType())) {
            requiredValue = ((StringAttribute)sequenceAttributeMember).getValue(coordinator);
        } else if (JAVA_TYPE_BOOLEAN_ARRAY.equals(this.seqMetaData.getJavaReturnType())) {
            requiredValue = ((BooleanAttribute)sequenceAttributeMember).getValue(coordinator);
        } else if (JAVA_TYPE_STRUCT_ARRAY.equals(this.seqMetaData.getJavaReturnType())) {
            requiredValue = ((StructAttribute)sequenceAttributeMember).getValue(coordinator);
        } else {
            String type = null;
            if (this.seqMetaData != null) {
                type = this.seqMetaData.getJavaReturnType();
            }
            String msg = "Mao sequence attribute with element type other than ManagedObject, Integer, String and Boolean not implemented! JavaReturnType=" + type;
            logger.traceError(THIS_CLASS, msg);
            throw new ProcessingFailureException(msg);
        }
        return requiredValue;
    }

    private Integer[] convertToIntegerArray(int[] intArray) {
        Integer[] integerArray = new Integer[intArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            integerArray[i] = new Integer(intArray[i]);
        }
        return integerArray;
    }

    private Boolean[] convertToBooleanArray(boolean[] booleanArray) {
        Boolean[] aBooleanArray = new Boolean[booleanArray.length];
        for (int i = 0; i < aBooleanArray.length; ++i) {
            aBooleanArray[i] = booleanArray[i];
        }
        return aBooleanArray;
    }

    public void delete(ManagedObject myMo, Coordinator coord) throws MoAccessException {
        block5: {
            block6: {
                block4: {
                    if (!RESERVED_BY.equals(this.attributeName)) break block4;
                    if (this.attributeValue.getValue(coord).length > 0) {
                        String msg = myMo.getType() + " could not be deleted, there are still references to other MO(s)";
                        logger.traceAbnormal(THIS_CLASS, msg);
                        throw new ProcessingFailureException(msg);
                    }
                    break block5;
                }
                if (!JAVA_TYPE_STRUCT_ARRAY.equals(this.seqMetaData.getJavaReturnType())) break block6;
                Attribute[] arrayAttrs = this.attributeValue.getValue(coord);
                for (int i = 0; i < arrayAttrs.length; ++i) {
                    if (!(arrayAttrs[i] instanceof StructAttribute)) continue;
                    StructAttribute attribute = (StructAttribute)arrayAttrs[i];
                    Struct struct = attribute.getValue(coord);
                    Object[] members = struct.getValues();
                    String[] names = struct.getNames();
                    for (int x = 0; x < members.length; ++x) {
                        if (!(members[x] instanceof ManagedObject)) continue;
                        ManagedObject currentReferredToMO = (ManagedObject)members[x];
                        logger.traceDebug(THIS_CLASS, "Found reference in struct " + attribute.getName() + " member " + names[x] + " to " + currentReferredToMO.getFullDistinguishedName());
                        ((Reservable)currentReferredToMO).release(myMo, coord);
                        logger.traceGeneral(THIS_CLASS, "release of Mo " + currentReferredToMO.getLocalDistinguishedName());
                    }
                }
                break block5;
            }
            if (!JAVA_TYPE_MANAGED_OBJECT_ARRAY.equals(this.seqMetaData.getJavaReturnType())) break block5;
            Attribute[] referencedMOs = this.attributeValue.getValue(coord);
            for (int i = 0; i < referencedMOs.length; ++i) {
                ManagedObject currentReferredToMO = ((ReferenceAttribute)referencedMOs[i]).getValue(coord);
                ((Reservable)currentReferredToMO).release(myMo, coord);
            }
        }
    }

    public Object getValue(Coordinator coord) throws MoAccessException {
        Object[] objectValues;
        Attribute[] currentValues = this.attributeValue.getValue(coord);
        String javaReturnType = this.seqMetaData.getJavaReturnType();
        if (JAVA_TYPE_MANAGED_OBJECT_ARRAY.equals(javaReturnType)) {
            objectValues = new ManagedObject[currentValues.length];
        } else if (JAVA_TYPE_INTEGER_ARRAY.equals(javaReturnType)) {
            objectValues = new Integer[currentValues.length];
        } else if (JAVA_TYPE_STRING_ARRAY.equals(javaReturnType)) {
            objectValues = new String[currentValues.length];
        } else if (JAVA_TYPE_BOOLEAN_ARRAY.equals(javaReturnType)) {
            objectValues = new Boolean[currentValues.length];
        } else if (JAVA_TYPE_STRUCT_ARRAY.equals(javaReturnType)) {
            objectValues = new StructImpl[currentValues.length];
        } else {
            String msg = "Mao sequence attribute with element type other than ManagedObject, Integer, String and Boolean not implemented! JavaReturnType=" + javaReturnType;
            logger.traceError(THIS_CLASS, msg);
            throw new ProcessingFailureException(msg);
        }
        for (int i = 0; i < currentValues.length; ++i) {
            objectValues[i] = this.attributeToObject(currentValues[i], coord);
        }
        return objectValues;
    }

    public Attribute[] getValueAsAttributeArray(Coordinator coord) throws MoAccessException {
        return this.attributeValue.getValue(coord);
    }

    private void handleChangesToReferences(Coordinator coordinator, ManagedObject myMo, Object newValue) throws MoAccessException {
        int i;
        ManagedObject[] newMOsToReference = (ManagedObject[])newValue;
        Attribute[] currentReferencedMOsArray = this.attributeValue.getValue(coordinator);
        HashSet<String> currentReferencedMOLDNs = new HashSet<String>();
        HashSet<String> newReferencedMOLDNs = new HashSet<String>();
        HashSet<String> copyCurrentReferencedMOLDNs = new HashSet<String>();
        HashSet<String> theOtherRerefenceAttributeDueToHW79670 = new HashSet<String>();
        for (i = 0; i < currentReferencedMOsArray.length; ++i) {
            currentReferencedMOLDNs.add(((ReferenceAttribute)currentReferencedMOsArray[i]).getValue(coordinator).getLocalDistinguishedName());
        }
        for (i = 0; i < newMOsToReference.length; ++i) {
            newReferencedMOLDNs.add(newMOsToReference[i].getLocalDistinguishedName());
        }
        copyCurrentReferencedMOLDNs.addAll(currentReferencedMOLDNs);
        if ("SectorCarrier".equals(myMo.getType()) && ("rfBranchRxRef".equals(this.attributeName) || "rfBranchTxRef".equals(this.attributeName))) {
            ManagedObject[] theOtherAttributeValue = (ManagedObject[])myMo.getAttribute("rfBranchRxRef".equals(this.attributeName) ? "rfBranchTxRef" : "rfBranchRxRef", coordinator);
            for (int i2 = 0; i2 < theOtherAttributeValue.length; ++i2) {
                theOtherRerefenceAttributeDueToHW79670.add(theOtherAttributeValue[i2].getLocalDistinguishedName());
            }
            theOtherRerefenceAttributeDueToHW79670.removeAll(newReferencedMOLDNs);
        }
        currentReferencedMOLDNs.removeAll(newReferencedMOLDNs);
        currentReferencedMOLDNs.removeAll(theOtherRerefenceAttributeDueToHW79670);
        this.releaseReferences(currentReferencedMOLDNs, myMo, coordinator);
        newReferencedMOLDNs.removeAll(copyCurrentReferencedMOLDNs);
        this.reserveReferences(newReferencedMOLDNs, myMo, coordinator);
    }

    private void handleChangesToReferences(Coordinator coordinator, ManagedObject myMo, ManagedObject[] newReferences, ManagedObject[] currReferences) throws MoAccessException {
        HashSet<String> newReferencedMOLDNs = new HashSet<String>();
        for (int i = 0; i < newReferences.length; ++i) {
            newReferencedMOLDNs.add(newReferences[i].getLocalDistinguishedName());
        }
        HashSet<String> currentReferencedMOLDNs = new HashSet<String>();
        for (int i = 0; i < currReferences.length; ++i) {
            currentReferencedMOLDNs.add(currReferences[i].getLocalDistinguishedName());
        }
        HashSet<String> copyCurrentReferencedMOLDNs = new HashSet<String>();
        copyCurrentReferencedMOLDNs.addAll(currentReferencedMOLDNs);
        currentReferencedMOLDNs.removeAll(newReferencedMOLDNs);
        this.releaseReferences(currentReferencedMOLDNs, myMo, coordinator);
        newReferencedMOLDNs.removeAll(copyCurrentReferencedMOLDNs);
        this.reserveReferences(newReferencedMOLDNs, myMo, coordinator);
    }

    private void releaseReferences(Set mosToRelease, ManagedObject myMo, Coordinator coordinator) throws MoAccessException {
        Iterator mosToReleaseIter = mosToRelease.iterator();
        while (mosToReleaseIter.hasNext()) {
            String currentMOLdnToRelease = (String)mosToReleaseIter.next();
            ManagedObject currentMoToRelease = this.moRepositoryWrapper.lookup(currentMOLdnToRelease);
            ((Reservable)currentMoToRelease).release(myMo, coordinator);
        }
    }

    private void reserveReferences(Set mosToReserve, ManagedObject myMo, Coordinator coordinator) throws MoAccessException {
        Iterator mosToReserveIter = mosToReserve.iterator();
        while (mosToReserveIter.hasNext()) {
            String currentMOLdnToReserve = (String)mosToReserveIter.next();
            ManagedObject currentMoToReserve = this.moRepositoryWrapper.lookup(currentMOLdnToReserve);
            ((Reservable)currentMoToReserve).reserve(myMo, coordinator);
        }
    }

    public void init(AttrList attributes, MoDataWrapper mMoData, ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        String msg = "init() - " + mMoData.getMoTypeName();
        logger.traceEnter(THIS_CLASS, msg);
        this.attributeValue = new SequenceAttribute(this.attributeName, this.isAvcNotifier);
        mMoData.registerPersistentAttr((Attribute)this.attributeValue);
        if (!RESERVED_BY.equals(this.attributeName) && attributes.contains(new String[]{this.attributeName})) {
            Object[] sequenceValues;
            Object newValue = attributes.getValue(attributes.indexOf(this.attributeName));
            Object[] objectArray = JAVA_TYPE_INTEGER_ARRAY.equals(this.seqMetaData.getJavaReturnType()) && newValue instanceof int[] ? this.convertToIntegerArray((int[])newValue) : (sequenceValues = JAVA_TYPE_BOOLEAN_ARRAY.equals(this.seqMetaData.getJavaReturnType()) && newValue instanceof boolean[] ? this.convertToBooleanArray((boolean[])newValue) : (Object[])newValue);
            if (sequenceValues != null) {
                for (int i = 0; i < sequenceValues.length; ++i) {
                    this.attributeValue.addElement(this.objectToAttribute(i, sequenceValues[i], managedObject, coordinator, true));
                }
            }
        }
        logger.traceReturn(THIS_CLASS, msg);
    }

    private Attribute objectToAttribute(int sequenceIndex, Object sequenceIndexValue, ManagedObject managedObject, Coordinator coordinator, boolean reserveMO) throws MoAccessException {
        ReferenceAttribute requiredAttribute = null;
        if (JAVA_TYPE_MANAGED_OBJECT_ARRAY.equals(this.seqMetaData.getJavaReturnType())) {
            requiredAttribute = new ReferenceAttribute(this.attributeName + "[" + sequenceIndex + "]", this.isAvcNotifier);
            requiredAttribute.setValue((ManagedObject)sequenceIndexValue);
            if (reserveMO) {
                ((Reservable)sequenceIndexValue).reserve(managedObject, coordinator);
            }
        } else if (JAVA_TYPE_INTEGER_ARRAY.equals(this.seqMetaData.getJavaReturnType())) {
            requiredAttribute = new IntegerAttribute(this.attributeName + "[" + sequenceIndex + "]", this.isAvcNotifier);
            ((IntegerAttribute)requiredAttribute).setValue((Integer)sequenceIndexValue);
        } else if (JAVA_TYPE_STRING_ARRAY.equals(this.seqMetaData.getJavaReturnType())) {
            requiredAttribute = new StringAttribute(this.attributeName + "[" + sequenceIndex + "]", this.isAvcNotifier);
            ((StringAttribute)requiredAttribute).setValue((String)sequenceIndexValue);
        } else if (JAVA_TYPE_BOOLEAN_ARRAY.equals(this.seqMetaData.getJavaReturnType())) {
            requiredAttribute = new BooleanAttribute(this.attributeName + "[" + sequenceIndex + "]", this.isAvcNotifier, ((Boolean)sequenceIndexValue).booleanValue());
        } else if (JAVA_TYPE_STRUCT_ARRAY.equals(this.seqMetaData.getJavaReturnType())) {
            requiredAttribute = new StructAttribute(this.attributeName + "[" + sequenceIndex + "]", this.isAvcNotifier);
            Struct structValues = (Struct)sequenceIndexValue;
            String[] structNames = structValues.getNames();
            Object[] newValues = structValues.getValues();
            Attribute[] newValueAttributes = new Attribute[newValues.length];
            for (int i = 0; i < newValues.length; ++i) {
                newValueAttributes[i] = this.structObjectToAttribute(newValues[i], structNames[i], managedObject, coordinator);
                ((StructAttribute)requiredAttribute).addElement(newValueAttributes[i]);
            }
        } else {
            throw new ProcessingFailureException("Mao sequence attribute with element type other than ManagedObject, Integer, String not implemented!");
        }
        return requiredAttribute;
    }

    private Attribute structObjectToAttribute(Object structIndexValue, String structName, ManagedObject myMo, Coordinator coordinator) throws MoAccessException {
        ReferenceAttribute requiredAttribute = null;
        if (structIndexValue == null || structIndexValue instanceof ManagedObject) {
            requiredAttribute = new ReferenceAttribute(structName, this.isAvcNotifier);
            requiredAttribute.setValue((ManagedObject)structIndexValue);
            if (structIndexValue != null && !(structIndexValue instanceof LoadModuleMoImpl)) {
                ((Reservable)structIndexValue).reserve(myMo, coordinator);
            }
        } else if (structIndexValue.getClass().toString().equals("class java.lang.Integer")) {
            requiredAttribute = new IntegerAttribute(structName, this.isAvcNotifier);
            ((IntegerAttribute)requiredAttribute).setValue((Integer)structIndexValue);
        } else if (structIndexValue.getClass().toString().equals("class java.lang.String")) {
            requiredAttribute = new StringAttribute(structName, this.isAvcNotifier);
            ((StringAttribute)requiredAttribute).setValue((String)structIndexValue);
        } else if (structIndexValue.getClass().toString().equals("class java.lang.Boolean")) {
            requiredAttribute = new BooleanAttribute(structName, this.isAvcNotifier, ((Boolean)structIndexValue).booleanValue());
        } else {
            if (structIndexValue instanceof Object[]) {
                logger.traceError(THIS_CLASS, "structObjectToAttribute(), No handling of " + structIndexValue.getClass().getName());
                throw new NotHandledAttributeTypeException();
            }
            logger.traceError(THIS_CLASS, "structObjectToAttribute(), No handling of " + structIndexValue.getClass().getName());
            throw new NotHandledAttributeTypeException();
        }
        return requiredAttribute;
    }

    public void recover(Attribute newValue) {
        this.attributeValue = (SequenceAttribute)newValue;
    }

    public boolean removeElement(Attribute attrToRemove) {
        return this.attributeValue.removeElement(attrToRemove);
    }

    public void setValue(Object newValue, Coordinator coord, ManagedObject myMo) throws MoAccessException {
        if (!RESERVED_BY.equals(this.attributeName) && JAVA_TYPE_MANAGED_OBJECT_ARRAY.equals(this.seqMetaData.getJavaReturnType())) {
            this.handleChangesToReferences(coord, myMo, newValue);
        } else if (JAVA_TYPE_STRUCT_ARRAY.equals(this.seqMetaData.getJavaReturnType())) {
            this.setNewValue(newValue, coord, myMo);
        }
        Object[] newValues = JAVA_TYPE_INTEGER_ARRAY.equals(this.seqMetaData.getJavaReturnType()) && newValue instanceof int[] ? this.convertToIntegerArray((int[])newValue) : (JAVA_TYPE_BOOLEAN_ARRAY.equals(this.seqMetaData.getJavaReturnType()) && newValue instanceof boolean[] ? this.convertToBooleanArray((boolean[])newValue) : (Object[])newValue);
        Attribute[] newValueAttributes = new Attribute[newValues.length];
        for (int i = 0; i < newValues.length; ++i) {
            newValueAttributes[i] = this.objectToAttribute(i, newValues[i], myMo, coord, false);
        }
        this.attributeValue.setValue(newValueAttributes);
    }

    private void setNewValue(Object newValue, Coordinator coord, ManagedObject myMo) throws MoAccessException {
        ArrayList<Object> newRefMoList = new ArrayList<Object>();
        Struct[] newStructArray = (Struct[])newValue;
        for (int i = 0; i < newStructArray.length; ++i) {
            Struct struct = newStructArray[i];
            Object[] members = struct.getValues();
            for (int x = 0; x < members.length; ++x) {
                if (members[x] == null || !(members[x] instanceof ManagedObject)) continue;
                newRefMoList.add(members[x]);
            }
        }
        ManagedObject[] newRefMos = newRefMoList.toArray(new ManagedObject[newRefMoList.size()]);
        ArrayList<Object> currRefMoList = new ArrayList<Object>();
        SequenceAttribute currSeqAttr = this.attributeValue;
        Attribute[] currAttrs = currSeqAttr.getValue(coord);
        for (int i = 0; i < currAttrs.length; ++i) {
            StructAttribute structAttr = (StructAttribute)currAttrs[i];
            Struct struct = structAttr.getValue(coord);
            Object[] members = struct.getValues();
            for (int x = 0; x < members.length; ++x) {
                if (members[x] == null || !(members[x] instanceof ManagedObject)) continue;
                currRefMoList.add(members[x]);
            }
        }
        ManagedObject[] currRefMos = currRefMoList.toArray(new ManagedObject[currRefMoList.size()]);
        this.handleChangesToReferences(coord, myMo, newRefMos, currRefMos);
    }

    public String toString() {
        return "Name: " + this.attributeName + " Value: " + this.attributeValue + " AVCNotifier " + this.isAvcNotifier;
    }

    public SequenceDiffInfo getSequenceDiffInfo(Coordinator coordinator) {
        return this.attributeValue.getSequenceDiffInfo(coordinator);
    }

    public void setValueAsAttributeArray(Attribute[] attributes) throws MoAccessException {
        this.attributeValue.setValue(attributes);
    }
}

