/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.connection.comm;

import com.ibm.oti.connection.comm.Connection;
import com.ibm.oti.util.Msg;
import java.io.IOException;
import java.io.OutputStream;

final class CommOutputStream
extends OutputStream {
    private Connection connection;
    private boolean open;
    private byte[] aByte = new byte[1];

    CommOutputStream(Connection connection) {
        this.connection = connection;
        this.open = true;
    }

    public void close() throws IOException {
        if (this.open) {
            this.connection.closeStream(false);
        }
        this.open = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(byte[] b, int offset, int length) throws IOException {
        if (!this.open) throw new IOException(Msg.getString("K0059"));
        if (b == null) throw new NullPointerException();
        if (offset < 0 || length < 0 || offset > b.length || b.length - offset < length) {
            throw new IndexOutOfBoundsException();
        }
        this.connection.write(b, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int oneByte) throws IOException {
        if (this.open) {
            CommOutputStream commOutputStream = this;
            synchronized (commOutputStream) {
                this.aByte[0] = (byte)oneByte;
                this.connection.write(this.aByte, 0, 1);
            }
        } else {
            throw new IOException(Msg.getString("K0059"));
        }
    }
}

