/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.crypto;

import com.ibm.oti.crypto.Provider;
import com.ibm.oti.util.Msg;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.spec.KeySpec;

public class Key {
    public static final int OPERATION_ENCRYPT = 1;
    public static final int OPERATION_DECRYPT = 2;
    private static final int MAX_BLOCK_SIZE = 200;
    Provider provider;
    byte[] key;
    int operation;
    java.security.Key jceKey;
    private boolean cryptInit;
    private byte[] buffInput;
    private int buffInputCount = 0;
    private ByteArrayOutputStream buffOutput = new ByteArrayOutputStream();
    KeySpec keySpec;

    Key(Provider provider, byte[] key) throws IOException {
        if (provider.isDestroyed()) {
            throw new IOException(Msg.getString("K01f8"));
        }
        if (key.length != provider.getKeyLength()) {
            throw new IOException(Msg.getString("K01f9"));
        }
        this.provider = provider;
        this.key = key;
        this.buffInput = new byte[200];
    }

    public Key(Provider provider, KeySpec keySpec) throws IOException {
        if (provider.isDestroyed()) {
            throw new IOException(Msg.getString("K01f8"));
        }
        this.buffInput = new byte[200];
        this.provider = provider;
        this.keySpec = keySpec;
    }

    public Key(Provider provider, java.security.Key key) throws IOException {
        if (provider.isDestroyed()) {
            throw new IOException(Msg.getString("K01f8"));
        }
        this.buffInput = new byte[200];
        this.provider = provider;
        this.jceKey = key;
    }

    public void cryptInit(int operation, int padType, byte[] iv) throws IOException {
        if (operation != 1 && operation != 2) {
            throw new IOException(Msg.getString("K01fb"));
        }
        this.operation = operation;
        this.provider.cryptInit(this, operation, padType, iv);
        this.cryptInit = true;
        this.buffInputCount = 0;
        this.buffOutput.reset();
    }

    public void cryptUpdate(byte[] bytes, int offset, int length) throws IOException {
        int buffRemaining;
        if (!this.cryptInit) {
            throw new IllegalStateException();
        }
        if (this.buffInputCount > 0 && length >= (buffRemaining = this.buffInput.length - this.buffInputCount)) {
            System.arraycopy((Object)bytes, offset, (Object)this.buffInput, this.buffInputCount, buffRemaining);
            this.buffOutput.write(this.provider.cryptUpdate(this, this.buffInput, 0, this.buffInput.length, false));
            offset += buffRemaining;
            length -= buffRemaining;
            this.buffInputCount = 0;
        }
        if (this.provider.getBlockLength() > 0) {
            int blockcount = (length - 1) / this.provider.getBlockLength();
            if (blockcount > 0) {
                this.buffOutput.write(this.provider.cryptUpdate(this, bytes, offset, blockcount * this.provider.getBlockLength() - offset, false));
                offset += blockcount * this.provider.getBlockLength();
                length -= blockcount * this.provider.getBlockLength();
            }
        } else {
            this.buffOutput.write(this.provider.cryptUpdate(this, bytes, offset, length - offset, false));
            offset += length;
            length -= length;
        }
        if (length > 0) {
            System.arraycopy((Object)bytes, offset, (Object)this.buffInput, this.buffInputCount, length);
            this.buffInputCount += length;
        }
    }

    public byte[] cryptFinish() throws IOException {
        if (this.buffInputCount > 0) {
            this.buffOutput.write(this.provider.cryptUpdate(this, this.buffInput, 0, this.buffInputCount, true));
        } else {
            this.buffOutput.write(this.provider.cryptUpdate(this, new byte[0], 0, 0, true));
        }
        this.cryptInit = false;
        return this.buffOutput.toByteArray();
    }
}

