/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.security.provider;

import com.ibm.oti.util.ASN1Decoder;
import com.ibm.oti.util.ASN1Encoder;
import com.ibm.oti.util.Msg;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class AlgorithmParametersDSA
extends AlgorithmParametersSpi {
    private DSAParameterSpec paramSpec;
    private boolean initialized = false;
    static /* synthetic */ Class class$0;

    protected byte[] engineGetEncoded(String format) throws IOException {
        if (!this.initialized) {
            throw new IOException();
        }
        if (format == null || format.equals("ASN.1")) {
            BigInteger[] pqg = new BigInteger[]{this.paramSpec.getP(), this.paramSpec.getQ(), this.paramSpec.getG()};
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ASN1Encoder encoder = new ASN1Encoder(out);
            try {
                encoder.writeIntegers(pqg);
            }
            catch (IOException ioe) {
                throw new Error(ioe.toString());
            }
            return out.toByteArray();
        }
        throw new IOException(Msg.getString("JCP000"));
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
        if (paramSpec == null) {
            throw new NullPointerException();
        }
        Class clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.security.spec.DSAParameterSpec");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (paramSpec != clazz) {
            throw new InvalidParameterSpecException();
        }
        return this.paramSpec;
    }

    protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (!(paramSpec instanceof DSAParameterSpec)) {
            throw new InvalidParameterSpecException();
        }
        this.paramSpec = (DSAParameterSpec)paramSpec;
        this.initialized = true;
    }

    protected void engineInit(byte[] params, String format) throws IOException {
        if (format == null || format.equals("ASN.1")) {
            ByteArrayInputStream stream = new ByteArrayInputStream(params);
            ASN1Decoder decoder = new ASN1Decoder(stream);
            try {
                ASN1Decoder.Node[] decodedStructure = (ASN1Decoder.Node[])decoder.readContents().data;
                BigInteger p = (BigInteger)decodedStructure[0].data;
                BigInteger q = (BigInteger)decodedStructure[1].data;
                BigInteger g = (BigInteger)decodedStructure[2].data;
                this.paramSpec = new DSAParameterSpec(p, q, g);
            }
            catch (ClassCastException classCastException) {
                throw new IOException(Msg.getString("JCP000"));
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IOException(Msg.getString("JCP000"));
            }
            this.initialized = true;
            return;
        }
        throw new IOException(Msg.getString("JCP000"));
    }

    protected String engineToString() {
        return this.toString();
    }

    protected byte[] engineGetEncoded() throws IOException {
        return this.engineGetEncoded("ASN.1");
    }

    protected void engineInit(byte[] params) throws IOException {
        this.engineInit(params, "ASN.1");
    }
}

