/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.security.provider;

import com.ibm.oti.security.provider.AlgorithmParameterGeneratorDSA;
import com.ibm.oti.security.provider.DSAPrivateKey;
import com.ibm.oti.security.provider.DSAPublicKey;
import com.ibm.oti.util.SHAOutputStream;
import java.math.BigInteger;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.DSAKeyPairGenerator;
import java.security.interfaces.DSAParams;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class KeyPairGeneratorDSA
extends KeyPairGenerator
implements DSAKeyPairGenerator {
    protected int keySize = 512;
    protected SecureRandom random;
    protected DSAParams params;
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private static final int PRIME_CERTAINTY = 8;
    static /* synthetic */ Class class$0;

    public KeyPairGeneratorDSA() {
        super("DSA");
    }

    public void initialize(DSAParams params, SecureRandom random) throws InvalidParameterException {
        if (!this.isDSAParamsValid(params)) {
            throw new InvalidParameterException("K039c");
        }
        this.params = params;
        this.random = random;
    }

    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        DSAParameterSpec dsaParams = null;
        try {
            if (!(params instanceof DSAParameterSpec)) {
                throw new InvalidAlgorithmParameterException();
            }
            dsaParams = (DSAParameterSpec)params;
            this.initialize(dsaParams, random);
        }
        catch (InvalidParameterException e) {
            throw new InvalidAlgorithmParameterException(e.getMessage());
        }
    }

    public void initialize(int keySize, boolean genParams, SecureRandom random) throws InvalidParameterException {
        if (keySize < 512 || keySize > 1024 || keySize % 64 != 0) {
            this.throwCorrectInvalidParameterException("K0191");
        }
        this.keySize = keySize;
        this.random = random;
        this.params = null;
        if (genParams) {
            this.doGenerateParameters();
        } else {
            switch (this.keySize) {
                case 512: {
                    this.params = new DSAParameterSpec(AlgorithmParameterGeneratorDSA.p_512, AlgorithmParameterGeneratorDSA.q_512, AlgorithmParameterGeneratorDSA.g_512);
                    return;
                }
                case 768: {
                    this.params = new DSAParameterSpec(AlgorithmParameterGeneratorDSA.p_768, AlgorithmParameterGeneratorDSA.q_768, AlgorithmParameterGeneratorDSA.g_768);
                    return;
                }
                case 1024: {
                    this.params = new DSAParameterSpec(AlgorithmParameterGeneratorDSA.p_1024, AlgorithmParameterGeneratorDSA.q_1024, AlgorithmParameterGeneratorDSA.g_1024);
                    return;
                }
            }
            this.throwCorrectInvalidParameterException("K039b");
        }
    }

    public void initialize(int keySize, SecureRandom random) throws InvalidParameterException {
        this.initialize(keySize, false, random);
    }

    protected BigInteger generatePrivateKey() {
        int L = this.keySize;
        int n = (L - 1) / 160;
        int b = L - 1 - 160 * n;
        int XKEY_SIZE = 20;
        byte[] XKEY = new byte[XKEY_SIZE];
        this.random.nextBytes(XKEY);
        byte[] XSEED = new byte[XKEY_SIZE];
        this.random.nextBytes(XSEED);
        BigInteger sum = new BigInteger(1, XKEY).add(new BigInteger(1, XSEED));
        BigInteger XVAL = sum.mod(TWO.pow(b));
        byte[] XVALByteArray = XVAL.toByteArray();
        SHAOutputStream sha = new SHAOutputStream();
        sha.write(XVALByteArray, 0, XVALByteArray.length);
        byte[] digest = sha.getHashAsBytes();
        return new BigInteger(1, digest).mod(this.params.getQ());
    }

    protected BigInteger generatePublicKey(BigInteger x) {
        BigInteger g = this.params.getG();
        return g.modPow(x, this.params.getP());
    }

    public KeyPair generateKeyPair() {
        if (this.params == null) {
            this.generateParameters();
        }
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        BigInteger x = this.generatePrivateKey();
        DSAPrivateKey priv = new DSAPrivateKey(this.params, x);
        BigInteger y = this.generatePublicKey(x);
        DSAPublicKey pub = new DSAPublicKey(this.params, y);
        return new KeyPair(pub, priv);
    }

    protected void generateParameters() {
        switch (this.keySize) {
            case 512: {
                this.params = new DSAParameterSpec(AlgorithmParameterGeneratorDSA.p_512, AlgorithmParameterGeneratorDSA.q_512, AlgorithmParameterGeneratorDSA.g_512);
                return;
            }
            case 768: {
                this.params = new DSAParameterSpec(AlgorithmParameterGeneratorDSA.p_768, AlgorithmParameterGeneratorDSA.q_768, AlgorithmParameterGeneratorDSA.g_768);
                return;
            }
            case 1024: {
                this.params = new DSAParameterSpec(AlgorithmParameterGeneratorDSA.p_1024, AlgorithmParameterGeneratorDSA.q_1024, AlgorithmParameterGeneratorDSA.g_1024);
                return;
            }
        }
        this.doGenerateParameters();
    }

    protected void doGenerateParameters() {
        AlgorithmParameterGenerator gen;
        try {
            gen = AlgorithmParameterGenerator.getInstance("DSA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new Error();
        }
        gen.init(this.keySize, this.random);
        AlgorithmParameters algParams = gen.generateParameters();
        try {
            Class clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.security.spec.DSAParameterSpec");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.params = (DSAParameterSpec)algParams.getParameterSpec(clazz);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new Error();
        }
    }

    private boolean isDSAParamsValid(DSAParams params) {
        if (params == null) {
            return false;
        }
        boolean result = false;
        BigInteger p = params.getP();
        int l = 512;
        while (l <= 1024) {
            if (p.compareTo(TWO.pow(l - 1)) > 0 || p.compareTo(TWO.pow(l)) < 0) {
                result = true;
                break;
            }
            l += 64;
        }
        if (!result) {
            return false;
        }
        if (!p.isProbablePrime(8)) {
            return false;
        }
        BigInteger q = params.getQ();
        if (p.subtract(BigInteger.ONE).mod(q).compareTo(BigInteger.ZERO) != 0) {
            return false;
        }
        if (q.compareTo(TWO.pow(159)) <= 0 || q.compareTo(TWO.pow(160)) >= 0) {
            return false;
        }
        return q.isProbablePrime(8);
    }

    private void throwCorrectInvalidParameterException(String msg) {
        throw new InvalidParameterException(msg);
    }
}

