/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.security.provider;

import com.ibm.j9.bluez.crypto.CL3;
import com.ibm.oti.security.provider.ASN1OID;
import com.ibm.oti.security.provider.X500Principal;
import com.ibm.oti.security.provider.X509CRL;
import com.ibm.oti.security.provider.X509CertImpl;
import com.ibm.oti.security.provider.X509Certificate;
import com.ibm.oti.util.ASN1Decoder;
import com.ibm.oti.util.ASN1Encoder;
import com.ibm.oti.util.ASN1Exception;
import com.ibm.oti.util.OIDDatabase;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.Principal;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class PKCS7 {
    private ASN1Decoder decoder;
    private ASN1Decoder.Node contents;
    private byte[] encoded;
    static final int[] DATA_OID = new int[]{1, 2, 840, 113549, 1, 7, 1};
    static final int[] SIGNED_DATA_OID = new int[]{1, 2, 840, 113549, 1, 7, 2};
    static final int[] ENVELOPED_DATA_OID = new int[]{1, 2, 840, 113549, 1, 7, 3};
    static final int[] SIGNED_AND_ENVELOPED_DATA_OID = new int[]{1, 2, 840, 113549, 1, 7, 4};
    static final int[] DIGESTED_DATA_OID = new int[]{1, 2, 840, 113549, 1, 7, 5};
    static final int[] ENCRYPTED_DATA_OID = new int[]{1, 2, 840, 113549, 1, 7, 6};
    static final int[][] POSSIBLE_CONTENTS = new int[6][];

    static {
        PKCS7.POSSIBLE_CONTENTS[0] = DATA_OID;
        PKCS7.POSSIBLE_CONTENTS[1] = SIGNED_DATA_OID;
        PKCS7.POSSIBLE_CONTENTS[2] = ENVELOPED_DATA_OID;
        PKCS7.POSSIBLE_CONTENTS[3] = SIGNED_AND_ENVELOPED_DATA_OID;
        PKCS7.POSSIBLE_CONTENTS[4] = DIGESTED_DATA_OID;
        PKCS7.POSSIBLE_CONTENTS[5] = ENCRYPTED_DATA_OID;
    }

    public static ASN1Decoder decoder(InputStream inStream) {
        ASN1Decoder decoder = new ASN1Decoder(inStream);
        ASN1Decoder.TypeMapper mapper = new ASN1Decoder.TypeMapper(){

            public int map(int originalType, int nesting, int sequenceItem) {
                if (originalType == 0) {
                    return 16;
                }
                return originalType;
            }
        };
        decoder.configureTypeRedirection(1, mapper);
        mapper = new ASN1Decoder.TypeMapper(){

            public int map(int originalType, int nesting, int sequenceItem) {
                if (originalType == 0 || originalType == 1) {
                    return 17;
                }
                return originalType;
            }
        };
        decoder.configureTypeRedirection(3, mapper);
        mapper = new ASN1Decoder.TypeMapper(){

            public int map(int originalType, int nesting, int sequenceItem) {
                if (originalType == 0) {
                    return 16;
                }
                return originalType;
            }
        };
        decoder.configureTypeRedirection(4, mapper);
        mapper = new ASN1Decoder.TypeMapper(){

            public int map(int originalType, int nesting, int sequenceItem) {
                if (originalType == 0 && sequenceItem == 4) {
                    return 17;
                }
                if (originalType == 0) {
                    return 16;
                }
                return originalType;
            }
        };
        decoder.configureTypeRedirection(5, mapper);
        decoder.configureTypeRedirection(6, X509CertImpl.X509_MAPPER);
        return decoder;
    }

    public static byte[] encodeCertList(List certificates) throws ASN1Exception {
        Object[] certNodes = new Object[certificates.size()];
        int i = 0;
        Iterator iter = certificates.iterator();
        while (iter.hasNext()) {
            try {
                Certificate cert = (Certificate)iter.next();
                byte[] certEncoding = cert.getEncoded();
                ASN1Decoder.Data newCertNode = new ASN1Decoder.Data(certEncoding);
                certNodes[i++] = newCertNode;
            }
            catch (CertificateEncodingException certificateEncodingException) {
                return null;
            }
        }
        ASN1Decoder.CertificateSet certSet = new ASN1Decoder.CertificateSet(certNodes);
        Object[] fields = new Object[]{BigInteger.ONE, new ASN1Decoder.Set2(new Object[0]), DATA_OID, certSet, new ASN1Decoder.Set2(new Object[0])};
        Object[] data = new Object[]{fields};
        Object[] PKCS7Object = new Object[]{SIGNED_DATA_OID, data};
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ASN1Encoder encoder = new ASN1Encoder(os);
        encoder.writeObject(PKCS7Object);
        byte[] encodedBytes = os.toByteArray();
        return encodedBytes;
    }

    public static byte[] getASN1DEREncoded(Certificate[] signerCertChain, String digestAlgorithm, String encryptionAlgorithm, byte[] encryptedDigest) throws IOException {
        return PKCS7.getASN1DEREncoded(signerCertChain, digestAlgorithm, encryptionAlgorithm, encryptedDigest, true, null, null);
    }

    public static byte[] getASN1DEREncoded(Certificate[] signerCertChain, String digestAlgorithm, String encryptionAlgorithm, byte[] encryptedDigest, boolean includeCertificates, byte[] dataSigned, ASN1Decoder.Set2 signedAttributes) throws IOException {
        Object[] certNodes = new Object[signerCertChain.length];
        int i = 0;
        while (i < signerCertChain.length) {
            try {
                Certificate cert = signerCertChain[i];
                byte[] certEncoding = cert.getEncoded();
                ASN1Decoder.Data newCertNode = new ASN1Decoder.Data(certEncoding);
                certNodes[i] = newCertNode;
            }
            catch (CertificateEncodingException certificateEncodingException) {
                return null;
            }
            ++i;
        }
        ASN1Decoder.CertificateSet certSet = new ASN1Decoder.CertificateSet(certNodes);
        Object[] fields = null;
        fields = includeCertificates ? new Object[5] : new Object[4];
        fields[0] = BigInteger.ONE;
        Object[] da = new Object[]{PKCS7.algorithmNameToOID(digestAlgorithm), null};
        fields[1] = new ASN1Decoder.Set2(new Object[]{da});
        Object[] contentInfo = null;
        if (dataSigned == null) {
            contentInfo = new Object[]{DATA_OID};
        } else {
            contentInfo = new Object[2];
            contentInfo[0] = DATA_OID;
            ASN1Decoder.Explicit explicitData = new ASN1Decoder.Explicit(dataSigned);
            contentInfo[1] = explicitData;
        }
        fields[2] = contentInfo;
        int signerInfosIndex = 3;
        if (includeCertificates) {
            fields[3] = certSet;
            signerInfosIndex = 4;
        }
        java.security.cert.X509Certificate signerCert = null;
        if (signerCertChain == null || signerCertChain.length <= 0) {
            return null;
        }
        signerCert = (java.security.cert.X509Certificate)signerCertChain[0];
        byte[] encodedSignerInfo = SignerInfo.getASN1DEREncoded(signerCert, digestAlgorithm, encryptionAlgorithm, encryptedDigest, signedAttributes);
        fields[signerInfosIndex] = new ASN1Decoder.Set2(new Object[]{new ASN1Decoder.Data(encodedSignerInfo)});
        Object[] data = new Object[]{fields};
        Object[] PKCS7Object = new Object[]{SIGNED_DATA_OID, data};
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ASN1Encoder encoder = new ASN1Encoder(os);
        encoder.writeObject(PKCS7Object);
        byte[] encodedBytes = os.toByteArray();
        return encodedBytes;
    }

    static int[] algorithmNameToOID(String algorithmName) {
        String oidString = OIDDatabase.getInstance().getFirstOIDForAlgorithm(algorithmName);
        return ASN1OID.stringToIntOID(oidString);
    }

    public PKCS7(InputStream encodedStream) {
        this.decoder = PKCS7.decoder(encodedStream);
        try {
            this.decoder.collectBytes(true);
            this.contents = this.decoder.readContents();
            this.encoded = this.decoder.collectedBytes();
        }
        catch (ASN1Exception aSN1Exception) {
            throw new IllegalArgumentException();
        }
        if (!this.contentsIsPKCS7()) {
            throw new IllegalArgumentException();
        }
    }

    public PKCS7(byte[] encoded) throws IllegalArgumentException {
        ByteArrayInputStream in = new ByteArrayInputStream(encoded);
        this.decoder = PKCS7.decoder(in);
        try {
            this.contents = this.decoder.readContents();
            this.encoded = encoded;
        }
        catch (ASN1Exception aSN1Exception) {
            throw new IllegalArgumentException();
        }
        if (!this.contentsIsPKCS7()) {
            throw new IllegalArgumentException();
        }
    }

    public boolean isSignedData() {
        try {
            ASN1Decoder.Node subnode = this.contents.subnode(0);
            if (subnode == null) {
                return false;
            }
            int[] id = (int[])subnode.data;
            return Arrays.equals(SIGNED_DATA_OID, id);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public SignedData signedData() {
        try {
            if (!this.isSignedData()) {
                return null;
            }
            int[] nArray = new int[2];
            nArray[0] = 1;
            int[] coords = nArray;
            return new SignedData((ASN1Decoder.Node)this.contents.subnode(coords), this.encoded);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public ASN1Decoder.Node contents() {
        return this.contents;
    }

    boolean contentsIsPKCS7() {
        int[] id = null;
        try {
            ASN1Decoder.Node subnode = this.contents.subnode(0);
            if (subnode == null) {
                return false;
            }
            id = (int[])subnode.data;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        int i = 0;
        while (i < POSSIBLE_CONTENTS.length) {
            if (Arrays.equals(POSSIBLE_CONTENTS[i], id)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static ASN1Decoder.Set2 getSignedAttributes(byte[] data, String digestAlg) {
        byte[] dataToDigest = data;
        byte[] messageDigest = null;
        if (digestAlg.equals("SHA")) {
            messageDigest = new byte[20];
            CL3.sha(null, dataToDigest, 0, dataToDigest.length, messageDigest, 0);
        } else if (digestAlg.equals("MD5")) {
            messageDigest = new byte[16];
            CL3.md5(null, dataToDigest, 0, dataToDigest.length, messageDigest, 0);
        }
        Object[] contenttype = new Object[2];
        Object[] contenttypeAttributeSet = new Object[]{DATA_OID};
        contenttype[0] = ASN1OID.stringToIntOID("1.2.840.113549.1.9.3");
        contenttype[1] = new ASN1Decoder.Set2(contenttypeAttributeSet);
        Object[] messagedigest = new Object[2];
        Object[] messagedigestAttributeSet = new Object[]{messageDigest};
        messagedigest[0] = ASN1OID.stringToIntOID("1.2.840.113549.1.9.4");
        messagedigest[1] = new ASN1Decoder.Set2(messagedigestAttributeSet);
        Object[] signingTime = new Object[2];
        Object[] signingTimeAttributeSet = new Object[]{new ASN1Decoder.UTCTime(new Date())};
        signingTime[0] = ASN1OID.stringToIntOID("1.2.840.113549.1.9.5");
        signingTime[1] = new ASN1Decoder.Set2(signingTimeAttributeSet);
        return new ASN1Decoder.Set2(new Object[]{contenttype, messagedigest, signingTime});
    }

    public static byte[] encodeSignedAttributesForDigest(ASN1Decoder.Set2 signedAttributes) {
        byte[] result = ASN1Encoder.getEncoding(signedAttributes);
        return result;
    }

    public static class SignedData {
        private ASN1Decoder.Node contents;
        private byte[] encoded;

        SignedData(ASN1Decoder.Node contents, byte[] encoded) {
            this.contents = contents;
            this.encoded = encoded;
        }

        public SignerInfo[] signerInfos() {
            try {
                ASN1Decoder.Node[] signedDataContents = (ASN1Decoder.Node[])this.contents.data;
                ASN1Decoder.Node[] signerInfos = (ASN1Decoder.Node[])signedDataContents[signedDataContents.length - 1].data;
                SignerInfo[] result = new SignerInfo[signerInfos.length];
                int i = 0;
                while (i < signerInfos.length) {
                    result[i] = new SignerInfo(signerInfos[i]);
                    ++i;
                }
                return result;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return null;
            }
            catch (ClassCastException classCastException) {
                return null;
            }
        }

        public Vector certificates() throws CertificateException {
            Vector certificates = new Vector();
            try {
                ASN1Decoder.Node certSequence = ((ASN1Decoder.Node[])this.contents.data)[3];
                if (certSequence.originalType != 0) {
                    return certificates;
                }
                ASN1Decoder.Node[] certNodes = (ASN1Decoder.Node[])certSequence.data;
                int i = 0;
                while (i < certNodes.length) {
                    certificates.add(X509Certificate.certificateFromASN1Object(certNodes[i], this.encoded));
                    ++i;
                }
                return certificates;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return certificates;
            }
            catch (ClassCastException classCastException) {
                return certificates;
            }
        }

        public Vector CRLs() throws CRLException {
            Vector crls = new Vector();
            try {
                ASN1Decoder.Node crlSequence = ((ASN1Decoder.Node[])this.contents.data)[3];
                if (crlSequence.originalType != 1) {
                    crlSequence = ((ASN1Decoder.Node[])this.contents.data)[4];
                    if (crlSequence.originalType != 1) {
                        return crls;
                    }
                }
                ASN1Decoder.Node[] certNodes = (ASN1Decoder.Node[])crlSequence.data;
                int i = 0;
                while (i < certNodes.length) {
                    crls.add(X509CRL.CRLFromASN1Object(certNodes[i], this.encoded));
                    ++i;
                }
                return crls;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return crls;
            }
            catch (ClassCastException classCastException) {
                return crls;
            }
        }
    }

    public static class SignerInfo {
        private ASN1Decoder.Node contents;
        private Principal issuer = null;
        private BigInteger serialNumber = null;
        private static final int[] ATTRIBUTE_MESSAGE_DIGEST = new int[]{1, 2, 840, 113549, 1, 9, 4};
        private ASN1Decoder.Set2 signedAttributes = null;
        private String digestAlgorithmName;
        private String encryptionAlgorithmName;
        private byte[] encryptedDigest;

        SignerInfo(ASN1Decoder.Node contents) {
            this.contents = contents;
        }

        public byte[] encryptedDigest() {
            try {
                ASN1Decoder.Node[] signerInfoContents = (ASN1Decoder.Node[])this.contents.data;
                int index = 0;
                while (signerInfoContents[index].type != 4) {
                    ++index;
                }
                return (byte[])signerInfoContents[index].data;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return null;
            }
            catch (ClassCastException classCastException) {
                return null;
            }
        }

        public String digestEncryptionAlgorithm() {
            int[] oid = this.digestEncryptionAlgorithmOID();
            if (oid == null) {
                return null;
            }
            String oidAsStr = ASN1OID.OIDToString(oid);
            return X509Certificate.getAlias("Alg.Alias.KeyFactory.", oidAsStr, null);
        }

        public String digestAlgorithm() {
            int[] oid = this.digestAlgorithmOID();
            if (oid == null) {
                return null;
            }
            String oidAsStr = ASN1OID.OIDToString(oid);
            return X509Certificate.getAlias("Alg.Alias.MessageDigest.", oidAsStr, null);
        }

        public int[] digestEncryptionAlgorithmOID() {
            try {
                ASN1Decoder.Node[] signerInfoContents = (ASN1Decoder.Node[])this.contents.data;
                int index = 0;
                while (signerInfoContents[index].type != 4) {
                    ++index;
                }
                ASN1Decoder.Node[] algData = (ASN1Decoder.Node[])signerInfoContents[--index].data;
                return (int[])algData[0].data;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return null;
            }
            catch (ClassCastException classCastException) {
                return null;
            }
        }

        public int[] digestAlgorithmOID() {
            try {
                ASN1Decoder.Node[] signerInfoContents = (ASN1Decoder.Node[])this.contents.data;
                ASN1Decoder.Node[] algData = (ASN1Decoder.Node[])signerInfoContents[2].data;
                return (int[])algData[0].data;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return null;
            }
            catch (ClassCastException classCastException) {
                return null;
            }
        }

        public String signatureName() {
            String digestAlgorithm = this.digestAlgorithm();
            String digestEncryptionAlgorithm = this.digestEncryptionAlgorithm();
            if (digestAlgorithm == null || digestEncryptionAlgorithm == null) {
                return null;
            }
            return String.valueOf(digestAlgorithm) + "with" + digestEncryptionAlgorithm;
        }

        public ASN1Decoder.Node[] authenticatedAttributes() {
            ASN1Decoder.Node attributeSetNode = this.contents.subnodeWithOriginalType(0);
            if (attributeSetNode == null || attributeSetNode.data == null) {
                return new ASN1Decoder.Node[0];
            }
            return (ASN1Decoder.Node[])attributeSetNode.data;
        }

        public byte[] contentMessageDigest() {
            ASN1Decoder.Node[] attributes = this.authenticatedAttributes();
            int i = 0;
            while (i < attributes.length) {
                int[] attributeOid = (int[])attributes[i].subnode((int)0).data;
                if (Arrays.equals(attributeOid, ATTRIBUTE_MESSAGE_DIGEST)) {
                    ASN1Decoder.Node value = attributes[i].subnode(1).subnode(0);
                    return (byte[])value.data;
                }
                ++i;
            }
            return null;
        }

        public Principal getIssuer() {
            if (this.issuer == null) {
                X500Principal principal = new X500Principal(this.contents.subnode(1).subnode(0));
                this.issuer = principal;
            }
            return this.issuer;
        }

        public BigInteger getSerialNumber() {
            if (this.serialNumber == null) {
                this.serialNumber = (BigInteger)this.contents.subnode((int)1).subnode((int)1).data;
            }
            return this.serialNumber;
        }

        private SignerInfo(java.security.cert.X509Certificate signerCert, String digestAlgorithm, String encryptionAlgorithm, byte[] encryptedDigest, ASN1Decoder.Set2 signedAttributes) {
            this.digestAlgorithmName = digestAlgorithm;
            this.encryptionAlgorithmName = encryptionAlgorithm;
            this.encryptedDigest = encryptedDigest;
            this.signedAttributes = signedAttributes;
            this.issuer = signerCert.getIssuerDN();
            this.serialNumber = signerCert.getSerialNumber();
        }

        private byte[] getEncoded() throws IOException {
            Object[] encSignedInfo;
            int signedAttributesOffset = 0;
            if (this.signedAttributes == null) {
                encSignedInfo = new Object[5];
            } else {
                encSignedInfo = new Object[6];
                signedAttributesOffset = 1;
            }
            encSignedInfo[0] = BigInteger.ONE;
            Object[] encIASN = new Object[]{!(this.issuer instanceof X500Principal) ? new ASN1Decoder.Data(new X500Principal(this.issuer.getName()).getEncoded()) : new ASN1Decoder.Data(((X500Principal)this.issuer).getEncoded()), this.serialNumber};
            encSignedInfo[1] = encIASN;
            Object[] da = new Object[]{PKCS7.algorithmNameToOID(this.digestAlgorithmName), null};
            encSignedInfo[2] = da;
            if (this.signedAttributes != null) {
                encSignedInfo[3] = new ASN1Decoder.ImplicitSet(this.signedAttributes, 0);
            }
            Object[] dea = new Object[]{PKCS7.algorithmNameToOID(this.encryptionAlgorithmName), null};
            encSignedInfo[3 + signedAttributesOffset] = dea;
            encSignedInfo[4 + signedAttributesOffset] = this.encryptedDigest;
            byte[] encoding = ASN1Encoder.getEncoding(encSignedInfo);
            return encoding;
        }

        public static byte[] getASN1DEREncoded(java.security.cert.X509Certificate signerCert, String digestAlgorithm, String encryptionAlgorithm, byte[] encryptedDigest, ASN1Decoder.Set2 signedAttributes) throws IOException {
            return new SignerInfo(signerCert, digestAlgorithm, encryptionAlgorithm, encryptedDigest, signedAttributes).getEncoded();
        }
    }
}

