/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.vm;

import com.ibm.oti.net.www.protocol.jxe.Handler;
import com.ibm.oti.util.Util;
import com.ibm.oti.vm.Jxe;
import com.ibm.oti.vm.JxePermission;
import com.ibm.oti.vm.VM;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public abstract class AbstractClassLoader
extends ClassLoader {
    private static ClassLoader systemClassLoader;
    String[] parsedPath;
    int[] types;
    Object[] cache;
    static Object cacheLock;
    FilePermission[] permissions;
    private static final RuntimePermission permissionToExitVM;
    private static Object manifestLock;

    static {
        cacheLock = new CacheLock();
        permissionToExitVM = new RuntimePermission("exitVM");
        manifestLock = new ManifestLock();
    }

    public AbstractClassLoader() {
    }

    public AbstractClassLoader(ClassLoader p1) {
        super(p1);
    }

    String parsePath(String classPath) {
        char pathSeparatorChar = File.pathSeparatorChar;
        int index = 0;
        int count = 0;
        int end = classPath.length();
        while (index < end) {
            int next = classPath.indexOf(pathSeparatorChar, index);
            if (next == -1) {
                next = end;
            }
            if (next - index > 0) {
                ++count;
            }
            index = next + 1;
        }
        this.parsedPath = new String[count];
        this.types = new int[count];
        this.cache = new Object[count];
        count = 0;
        index = 0;
        StringBuffer newPath = new StringBuffer();
        while (index < end) {
            int next = classPath.indexOf(pathSeparatorChar, index);
            if (next == -1) {
                next = end;
            }
            if (next - index > 0) {
                String path = classPath.substring(index, next);
                newPath.append(path);
                if (next < end) {
                    newPath.append(pathSeparatorChar);
                }
                this.parsedPath[count++] = path;
            }
            index = next + 1;
        }
        return newPath.toString();
    }

    void fillCache(int i) {
        this.setTypeElement(i, VM.getClassPathEntryType(this, i));
        switch (this.types[i]) {
            case 0: {
                this.setCacheElement(i, this.cache);
                return;
            }
            case 1: 
            case 2: {
                String path;
                if (this.parsedPath[i] == null) {
                    this.setParsedPathElement(i, Util.toString(VM.getPathFromClassPath(i)));
                }
                File f = new File(this.parsedPath[i]);
                try {
                    path = f.getCanonicalPath();
                }
                catch (IOException iOException) {
                    path = f.getAbsolutePath();
                }
                if (this.types[i] == 1) {
                    if (path.charAt(path.length() - 1) != File.separatorChar) {
                        path = new StringBuffer(path.length() + 1).append(path).append(File.separatorChar).toString();
                    }
                    this.setParsedPathElement(i, path);
                    this.setCacheElement(i, this.cache);
                } else {
                    this.setParsedPathElement(i, path);
                    try {
                        JarFile zf = new JarFile(this.parsedPath[i]);
                        this.setCacheElement(i, zf);
                        return;
                    }
                    catch (IOException iOException) {
                        this.setTypeElement(i, 5);
                        this.setCacheElement(i, this.cache);
                    }
                }
                return;
            }
            case 4: 
            case 8: {
                Jxe jxe = VM.getJxeFromClassPath(this, i);
                if (jxe != null) {
                    this.setCacheElement(i, jxe);
                    return;
                }
            }
            case 3: 
            case 5: {
                this.setCacheElement(i, this.cache);
                return;
            }
        }
    }

    public InputStream getResourceAsStream(String resName) {
        InputStream answer;
        if (resName == null || resName.length() < 1 || resName.charAt(0) == '/') {
            return null;
        }
        if (this != systemClassLoader && (answer = this.getParent() == null ? systemClassLoader.getResourceAsStream(resName) : this.getParent().getResourceAsStream(resName)) != null) {
            return answer;
        }
        int length = this.cache.length;
        int i = 0;
        while (i < length) {
            try {
                if (this.cache[i] == null) {
                    this.fillCache(i);
                }
                switch (this.types[i]) {
                    case 2: {
                        ZipFile zf = (ZipFile)this.cache[i];
                        ZipEntry entry = zf.getEntry(resName);
                        if (entry != null) {
                            SecurityManager security = System.getSecurityManager();
                            if (security != null) {
                                this.initalizePermissions();
                                if (this.permissions[i] == null) {
                                    this.setPermissionElement(i, new FilePermission(this.parsedPath[i], "read"));
                                }
                                security.checkPermission(this.permissions[i]);
                            }
                            try {
                                return zf.getInputStream(entry);
                            }
                            catch (IOException iOException) {
                            }
                        }
                        break;
                    }
                    case 4: 
                    case 8: {
                        Jxe jxe = (Jxe)this.cache[i];
                        InputStream jxeStream = jxe.getResourceAsStream(resName);
                        if (jxeStream != null) {
                            return jxeStream;
                        }
                        break;
                    }
                    case 1: {
                        String resourcePath = new StringBuffer(this.parsedPath[i].length() + resName.length()).append(this.parsedPath[i]).append(resName).toString();
                        InputStream result = this.openFile(resourcePath);
                        if (result != null) {
                            return result;
                        }
                        break;
                    }
                }
            }
            catch (SecurityException securityException) {}
            ++i;
        }
        return null;
    }

    private void setCacheElement(int i, Object value) {
        this.cache[i] = value;
    }

    private void setTypeElement(int i, int value) {
        this.types[i] = value;
    }

    private void setParsedPathElement(int i, String value) {
        this.parsedPath[i] = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initalizePermissions() {
        Object object = cacheLock;
        synchronized (object) {
            if (this.permissions == null) {
                this.permissions = new FilePermission[this.cache.length];
            }
        }
    }

    private void setPermissionElement(int i, FilePermission value) {
        this.permissions[i] = value;
    }

    private InputStream openFile(String resourcePath) {
        File f = new File(resourcePath);
        if (f.exists()) {
            try {
                return new BufferedInputStream(new FileInputStream(f));
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        return null;
    }

    protected URL findResource(final String res) {
        SecurityManager sm;
        URL result = (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                int i = 0;
                while (i < AbstractClassLoader.this.cache.length) {
                    URL result = AbstractClassLoader.this.findResourceImpl(i, res);
                    if (result != null) {
                        return result;
                    }
                    ++i;
                }
                return null;
            }
        });
        if (result != null && (sm = System.getSecurityManager()) != null) {
            try {
                sm.checkPermission(result.openConnection().getPermission());
            }
            catch (IOException iOException) {
                return null;
            }
            catch (SecurityException securityException) {
                return null;
            }
        }
        return result;
    }

    private URL findResourceImpl(int i, String res) {
        if (res.length() > 0 && res.charAt(0) == '/') {
            return null;
        }
        if (this.cache[i] == null) {
            this.fillCache(i);
        }
        try {
            switch (this.types[i]) {
                case 2: {
                    ZipFile zf = (ZipFile)this.cache[i];
                    if (zf.getEntry(res) != null) {
                        return new URL("jar", null, -1, String.valueOf(AbstractClassLoader.toURLString(this.parsedPath[i])) + "!/" + res, null);
                    }
                    return null;
                }
                case 4: 
                case 8: {
                    Jxe jxe = (Jxe)this.cache[i];
                    InputStream stream = jxe.getResourceAsStream(res);
                    if (stream != null) {
                        return new URL("jxe", jxe.getUuid(), -1, "/" + res, new Handler(jxe));
                    }
                    return null;
                }
                case 1: {
                    String resourcePath = new StringBuffer(this.parsedPath[i].length() + res.length()).append(this.parsedPath[i]).append(res).toString();
                    File f = new File(resourcePath);
                    if (f.exists()) {
                        return new URL(AbstractClassLoader.toURLString(resourcePath));
                    }
                    return null;
                }
            }
        }
        catch (MalformedURLException malformedURLException) {}
        return null;
    }

    protected Enumeration findResources(final String res) throws IOException {
        SecurityManager sm;
        Vector result = (Vector)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Vector resources = new Vector();
                int i = 0;
                while (i < AbstractClassLoader.this.cache.length) {
                    URL resource = AbstractClassLoader.this.findResourceImpl(i, res);
                    if (resource != null) {
                        resources.addElement(resource);
                    }
                    ++i;
                }
                return resources;
            }
        });
        int length = result.size();
        if (length > 0 && (sm = System.getSecurityManager()) != null) {
            Vector reduced = new Vector(length);
            int i = 0;
            while (i < length) {
                URL url = (URL)result.elementAt(i);
                try {
                    sm.checkPermission(url.openConnection().getPermission());
                    reduced.addElement(url);
                }
                catch (IOException iOException) {
                }
                catch (SecurityException securityException) {}
                ++i;
            }
            result = reduced;
        }
        return result.elements();
    }

    static String toURLString(String filename) {
        String name = filename;
        if (File.separatorChar != '/') {
            name = name.replace(File.separatorChar, '/');
        }
        StringBuffer buf = new StringBuffer(name.length() + 6).append("file:");
        if (!name.startsWith("/")) {
            buf.append('/');
        }
        name = buf.append(name).toString();
        return name;
    }

    public static void setBootstrapClassLoader(ClassLoader bootstrapClassLoader) {
        if (systemClassLoader != null) {
            throw new IllegalArgumentException();
        }
        systemClassLoader = bootstrapClassLoader;
    }

    Object getFilePD(int index) {
        String path;
        boolean isJxe = false;
        if (index >= 0) {
            if (this.cache[index] == null) {
                this.fillCache(index);
            }
            if (this.types[index] == 4 || this.types[index] == 8) {
                isJxe = true;
                path = ((Jxe)this.cache[index]).getUuid();
            } else {
                path = this.parsedPath[index];
            }
        } else {
            path = File.separator;
        }
        ProtectionDomain pd = (ProtectionDomain)this.getProtectionDomainCache().get(path);
        if (pd == null) {
            URL url = null;
            String urlString = isJxe ? "jxe://" + path + "/" : AbstractClassLoader.toURLString(path);
            try {
                url = new URL(urlString);
            }
            catch (MalformedURLException malformedURLException) {}
            CodeSource cs = new CodeSource(url, null);
            Permissions pc = new Permissions();
            if (isJxe) {
                ((PermissionCollection)pc).add(new JxePermission(path));
            } else if (path != null && url.getProtocol().equals("file")) {
                if (path.endsWith(File.separator)) {
                    ((PermissionCollection)pc).add(new FilePermission(String.valueOf(path) + "-", "read"));
                } else {
                    ((PermissionCollection)pc).add(new FilePermission(path, "read"));
                }
            }
            if (this.addExitPermission()) {
                ((PermissionCollection)pc).add(permissionToExitVM);
            }
            pd = new ProtectionDomain(cs, pc);
            this.getProtectionDomainCache().put(path, pd);
        }
        return pd;
    }

    boolean addExitPermission() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void definePackage(String packageName, final int cacheIndex) {
        if (cacheIndex >= 0 && this.cache[cacheIndex] == null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    AbstractClassLoader.this.fillCache(cacheIndex);
                    return null;
                }
            });
        }
        if (cacheIndex >= 0 && this.types[cacheIndex] == 2) {
            Manifest manifest = null;
            try {
                JarFile jf = (JarFile)this.cache[cacheIndex];
                manifest = jf.getManifest();
            }
            catch (IOException iOException) {}
            if (manifest != null) {
                Object object = manifestLock;
                synchronized (object) {
                    String specTitle = null;
                    String specVersion = null;
                    String specVendor = null;
                    String implTitle = null;
                    String implVersion = null;
                    String implVendor = null;
                    if (super.getPackage(packageName) != null) {
                        return;
                    }
                    Attributes mainAttributes = manifest.getMainAttributes();
                    String value = mainAttributes.getValue(Attributes.Name.SEALED);
                    boolean sealed = value != null && value.toLowerCase().equals("true");
                    String dirName = String.valueOf(packageName.replace('.', '/')) + "/";
                    Attributes attributes = manifest.getAttributes(dirName);
                    if (attributes != null) {
                        value = attributes.getValue(Attributes.Name.SEALED);
                        if (value != null) {
                            sealed = value.toLowerCase().equals("true");
                        }
                        specTitle = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
                        specVersion = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
                        specVendor = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
                        implTitle = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
                        implVersion = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                        implVendor = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
                    }
                    URL url = null;
                    try {
                        if (sealed) {
                            url = new URL(AbstractClassLoader.toURLString(this.parsedPath[cacheIndex]));
                        }
                    }
                    catch (MalformedURLException malformedURLException) {}
                    if (specTitle == null) {
                        specTitle = mainAttributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
                    }
                    if (specVersion == null) {
                        specVersion = mainAttributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
                    }
                    if (specVendor == null) {
                        specVendor = mainAttributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
                    }
                    if (implTitle == null) {
                        implTitle = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
                    }
                    if (implVersion == null) {
                        implVersion = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                    }
                    if (implVendor == null) {
                        implVendor = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
                    }
                    this.definePackage(packageName, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, url);
                    return;
                }
            }
        }
        Object object = manifestLock;
        synchronized (object) {
            if (super.getPackage(packageName) != null) {
                return;
            }
            this.definePackage(packageName, null, null, null, null, null, null, null);
        }
    }

    Hashtable getProtectionDomainCache() {
        return null;
    }

    String getPackageName(Class theClass) {
        String name = theClass.getName();
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        return name.substring(0, index);
    }

    private static class CacheLock {
        CacheLock() {
        }
    }

    private static class ManifestLock {
        ManifestLock() {
        }
    }
}

