/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.vm;

import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.AbstractClassLoader;
import com.ibm.oti.vm.VM;
import java.util.Enumeration;
import java.util.Hashtable;

public final class BootstrapClassLoader
extends AbstractClassLoader {
    private static BootstrapClassLoader singleton;
    private static Object findClassLock;
    private Hashtable packages = new Hashtable();
    private volatile boolean defining = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class clazz;
        VM.initializeVM();
        Class clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("java.util.Arrays");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        findClassLock = new FindClassLock();
    }

    private BootstrapClassLoader() {
        int count = VM.getClassPathCount();
        this.types = new int[count];
        this.cache = new Object[count];
        this.parsedPath = new String[count];
        VM.initializeClassLoader(this, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadClass(String className) throws ClassNotFoundException {
        String packageName;
        Class loadedClass;
        Object object = findClassLock;
        synchronized (object) {
            loadedClass = VM.findClassOrNull(className, this);
        }
        if (loadedClass != null && (packageName = this.getPackageName(loadedClass)) != null && super.getPackage(packageName) == null) {
            int index = VM.getCPIndexImpl(loadedClass);
            this.addPackage(packageName, index);
        }
        return loadedClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPackage(String packageName, int index) {
        Hashtable hashtable = this.packages;
        synchronized (hashtable) {
            if (!this.packages.containsKey(packageName)) {
                this.packages.put(packageName, new Integer(index));
            }
        }
    }

    public static ClassLoader singleton() {
        if (singleton != null) {
            throw new SecurityException(Msg.getString("K0084"));
        }
        singleton = new BootstrapClassLoader();
        return singleton;
    }

    protected Package getPackage(String name) {
        if (this.packages.size() > 0) {
            this.definePackages();
        }
        return super.getPackage(name);
    }

    protected Package[] getPackages() {
        if (this.packages.size() > 0) {
            this.definePackages();
        }
        return super.getPackages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void definePackages() {
        if (this.defining) {
            return;
        }
        while (true) {
            Hashtable toDefine = null;
            Hashtable hashtable = this.packages;
            synchronized (hashtable) {
                if (this.packages.size() == 0) {
                    return;
                }
                toDefine = (Hashtable)this.packages.clone();
                this.packages.clear();
            }
            if (toDefine == null) continue;
            this.defining = true;
            try {
                this.definePackages(toDefine);
                continue;
            }
            finally {
                this.defining = false;
                continue;
            }
            break;
        }
    }

    private void definePackages(Hashtable toDefine) {
        Enumeration keys = toDefine.keys();
        while (keys.hasMoreElements()) {
            String packageName = (String)keys.nextElement();
            this.definePackage(packageName, (Integer)toDefine.get(packageName));
        }
    }

    private static class FindClassLock {
        FindClassLock() {
        }
    }
}

