/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.ibm.oti.util.Msg;
import com.ibm.oti.util.PriviAction;
import com.ibm.oti.vm.VM;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EmulatedFields;
import java.io.EmulatedFieldsForLoading;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectInput;
import java.io.ObjectInputValidation;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamConstants;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.io.WriteAbortedException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;

public class ObjectInputStream
extends InputStream
implements ObjectInput,
ObjectStreamConstants {
    private static InputStream emptyStream = new ByteArrayInputStream(new byte[0]);
    private boolean hasPushbackTC;
    private byte pushbackTC;
    private int nestedLevels;
    private int currentHandle;
    private DataInputStream input;
    private DataInputStream primitiveTypes;
    private InputStream primitiveData = emptyStream;
    private boolean enableResolve;
    private Hashtable objectsRead;
    private Object currentObject;
    private ObjectStreamClass currentClass;
    private InputValidationDesc[] validations;
    private boolean subclassOverridingImplementation;
    private ClassLoader callerClassLoader;
    private boolean mustResolve = true;
    private Integer descriptorHandle;
    private IdentityHashMap readResolveCache;
    static /* synthetic */ Class class$0;

    protected ObjectInputStream() throws IOException, SecurityException {
        SecurityManager currentManager = System.getSecurityManager();
        if (currentManager != null) {
            currentManager.checkPermission(SUBCLASS_IMPLEMENTATION_PERMISSION);
        }
        this.subclassOverridingImplementation = true;
    }

    public ObjectInputStream(InputStream input) throws StreamCorruptedException, IOException {
        boolean mustCheck;
        final Class implementationClass = this.getClass();
        Class clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.io.ObjectInputStream");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        final Class thisClass = clazz;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && implementationClass != thisClass && (mustCheck = ((Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Method method;
                try {
                    method = implementationClass.getMethod("readFields", ObjectStreamClass.EMPTY_CONSTRUCTOR_PARAM_TYPES);
                    if (method.getDeclaringClass() != thisClass) {
                        return Boolean.TRUE;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {}
                try {
                    method = implementationClass.getMethod("readUnshared", ObjectStreamClass.EMPTY_CONSTRUCTOR_PARAM_TYPES);
                    if (method.getDeclaringClass() != thisClass) {
                        return Boolean.TRUE;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {}
                return Boolean.FALSE;
            }
        })).booleanValue())) {
            sm.checkPermission(ObjectStreamConstants.SUBCLASS_IMPLEMENTATION_PERMISSION);
        }
        this.input = input instanceof DataInputStream ? (DataInputStream)input : new DataInputStream(input);
        this.primitiveTypes = new DataInputStream(this);
        this.enableResolve = false;
        this.subclassOverridingImplementation = false;
        this.readResolveCache = new IdentityHashMap();
        this.resetState();
        this.nestedLevels = 0;
        this.primitiveData = this.input;
        this.readStreamHeader();
        this.primitiveData = emptyStream;
    }

    public int available() throws IOException {
        this.checkReadPrimitiveTypes();
        return this.primitiveData.available();
    }

    private void checkReadPrimitiveTypes() throws IOException {
        int next;
        if (this.primitiveData == this.input || this.primitiveData.available() > 0) {
            return;
        }
        block5: while (true) {
            next = 0;
            if (this.hasPushbackTC) {
                this.hasPushbackTC = false;
            } else {
                next = this.input.read();
                this.pushbackTC = (byte)next;
            }
            switch (this.pushbackTC) {
                case 119: {
                    this.primitiveData = new ByteArrayInputStream(this.readBlockData());
                    return;
                }
                case 122: {
                    this.primitiveData = new ByteArrayInputStream(this.readBlockDataLong());
                    return;
                }
                case 121: {
                    this.resetState();
                    continue block5;
                }
            }
            break;
        }
        if (next != -1) {
            this.pushbackTC();
        }
    }

    public void close() throws IOException {
        this.input.close();
    }

    public void defaultReadObject() throws IOException, ClassNotFoundException, NotActiveException {
        if (this.currentObject == null && this.mustResolve) {
            throw new NotActiveException();
        }
        this.readFieldValues(this.currentObject, this.currentClass);
    }

    protected boolean enableResolveObject(boolean enable) throws SecurityException {
        SecurityManager currentManager;
        if (enable && (currentManager = System.getSecurityManager()) != null) {
            currentManager.checkPermission(SUBSTITUTION_PERMISSION);
        }
        boolean originalValue = this.enableResolve;
        this.enableResolve = enable;
        return originalValue;
    }

    private boolean inSamePackage(Class c1, Class c2) {
        String nameC1 = c1.getName();
        String nameC2 = c2.getName();
        int indexDotC1 = nameC1.lastIndexOf(46);
        int indexDotC2 = nameC2.lastIndexOf(46);
        if (indexDotC1 != indexDotC1) {
            return false;
        }
        if (indexDotC1 < 0) {
            return true;
        }
        return nameC1.substring(0, indexDotC1).equals(nameC2.substring(0, indexDotC2));
    }

    private static native Object newInstance(Class var0, Class var1);

    private int nextHandle() {
        return this.currentHandle++;
    }

    private byte nextTC() throws IOException {
        if (this.hasPushbackTC) {
            this.hasPushbackTC = false;
        } else {
            this.pushbackTC = this.input.readByte();
        }
        return this.pushbackTC;
    }

    private void pushbackTC() throws IOException {
        this.hasPushbackTC = true;
    }

    public int read() throws IOException {
        this.checkReadPrimitiveTypes();
        return this.primitiveData.read();
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (buffer != null) {
            if (offset >= 0 && offset <= buffer.length && length >= 0 && length <= buffer.length - offset) {
                if (length == 0) {
                    return 0;
                }
                this.checkReadPrimitiveTypes();
                return this.primitiveData.read(buffer, offset, length);
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        throw new NullPointerException();
    }

    private byte[] readBlockData() throws IOException {
        byte[] result = new byte[this.input.readByte() & 0xFF];
        this.input.readFully(result);
        return result;
    }

    private byte[] readBlockDataLong() throws IOException {
        byte[] result = new byte[this.input.readInt()];
        this.input.readFully(result);
        return result;
    }

    public boolean readBoolean() throws IOException {
        return this.primitiveTypes.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.primitiveTypes.readByte();
    }

    public char readChar() throws IOException {
        return this.primitiveTypes.readChar();
    }

    private void discardData() throws ClassNotFoundException, IOException {
        this.primitiveData = emptyStream;
        boolean resolve = this.mustResolve;
        this.mustResolve = false;
        while (true) {
            byte tc;
            if ((tc = this.nextTC()) == 120) {
                this.mustResolve = resolve;
                return;
            }
            this.readContent(tc);
        }
    }

    private ObjectStreamClass readClassDesc() throws ClassNotFoundException, IOException {
        byte tc = this.nextTC();
        switch (tc) {
            case 114: {
                return this.readNewClassDesc(false);
            }
            case 125: {
                Class proxyClass = this.readNewProxyClassDesc();
                ObjectStreamClass streamClass = ObjectStreamClass.lookup(proxyClass);
                streamClass.setLoadFields(new ObjectStreamField[0]);
                this.registerObjectRead(streamClass, new Integer(this.nextHandle()));
                streamClass.setSuperclass(this.readClassDesc());
                return streamClass;
            }
            case 113: {
                return (ObjectStreamClass)this.readCyclicReference();
            }
            case 112: {
                return null;
            }
        }
        throw new StreamCorruptedException(Msg.getString("K00d2", Integer.toHexString(tc & 0xFF)));
    }

    private Object readContent(byte tc) throws ClassNotFoundException, IOException {
        switch (tc) {
            case 119: {
                return this.readBlockData();
            }
            case 122: {
                return this.readBlockDataLong();
            }
            case 118: {
                return this.readNewClass(false);
            }
            case 114: {
                return this.readNewClassDesc(false);
            }
            case 117: {
                return this.readNewArray(false);
            }
            case 115: {
                return this.readNewObject(false);
            }
            case 116: {
                return this.readNewString(false);
            }
            case 124: {
                return this.readNewLongString(false);
            }
            case 113: {
                return this.readCyclicReference();
            }
            case 112: {
                return null;
            }
            case 123: {
                Exception exc = this.readException();
                throw new WriteAbortedException(Msg.getString("K00d3"), exc);
            }
            case 121: {
                this.resetState();
                return null;
            }
        }
        throw new StreamCorruptedException(Msg.getString("K00d2", Integer.toHexString(tc & 0xFF)));
    }

    private Object readNonPrimitiveContent(boolean unshared) throws ClassNotFoundException, IOException {
        byte tc;
        this.checkReadPrimitiveTypes();
        if (this.primitiveData.available() > 0) {
            OptionalDataException e = new OptionalDataException();
            e.length = this.primitiveData.available();
            throw e;
        }
        block13: while (true) {
            tc = this.nextTC();
            switch (tc) {
                case 118: {
                    return this.readNewClass(unshared);
                }
                case 114: {
                    return this.readNewClassDesc(unshared);
                }
                case 117: {
                    return this.readNewArray(unshared);
                }
                case 115: {
                    return this.readNewObject(unshared);
                }
                case 116: {
                    return this.readNewString(unshared);
                }
                case 124: {
                    return this.readNewLongString(unshared);
                }
                case 113: {
                    if (unshared) {
                        this.readNewHandle();
                        throw new InvalidObjectException(Msg.getString("K0343"));
                    }
                    return this.readCyclicReference();
                }
                case 112: {
                    return null;
                }
                case 123: {
                    Exception exc = this.readException();
                    throw new WriteAbortedException(Msg.getString("K00d3"), exc);
                }
                case 121: {
                    this.resetState();
                    continue block13;
                }
                case 120: {
                    this.pushbackTC();
                    OptionalDataException e = new OptionalDataException();
                    e.eof = true;
                    throw e;
                }
            }
            break;
        }
        throw new StreamCorruptedException(Msg.getString("K00d2", Integer.toHexString(tc & 0xFF)));
    }

    private Object readCyclicReference() throws InvalidObjectException, IOException {
        return this.registeredObjectRead(this.readNewHandle());
    }

    public double readDouble() throws IOException {
        return this.primitiveTypes.readDouble();
    }

    private Exception readException() throws WriteAbortedException, OptionalDataException, ClassNotFoundException, IOException {
        this.resetSeenObjects();
        Exception exc = (Exception)this.readObject();
        this.resetSeenObjects();
        return exc;
    }

    private void readFieldDescriptors(ObjectStreamClass cDesc) throws ClassNotFoundException, IOException {
        short numFields = this.input.readShort();
        ObjectStreamField[] fields = new ObjectStreamField[numFields];
        cDesc.setLoadFields(fields);
        short i = 0;
        while (i < numFields) {
            ObjectStreamField f;
            char typecode = (char)this.input.readByte();
            String fieldName = this.input.readUTF();
            boolean isPrimType = ObjectStreamClass.isPrimitiveType(typecode);
            String classSig = isPrimType ? String.valueOf(typecode) : (String)this.readObject();
            fields[i] = f = new ObjectStreamField(classSig, fieldName);
            i = (short)(i + 1);
        }
    }

    public GetField readFields() throws IOException, ClassNotFoundException, NotActiveException {
        if (this.currentObject != null) {
            EmulatedFieldsForLoading result = new EmulatedFieldsForLoading(this.currentClass);
            this.readFieldValues(result);
            return result;
        }
        throw new NotActiveException();
    }

    private void readFieldValues(EmulatedFieldsForLoading emulatedFields) throws OptionalDataException, InvalidClassException, IOException {
        EmulatedFields.ObjectSlot[] slots = emulatedFields.emulatedFields().slots();
        int i = 0;
        while (i < slots.length) {
            slots[i].defaulted = false;
            Class type = slots[i].field.getType();
            if (type == Integer.TYPE) {
                slots[i].fieldValue = new Integer(this.input.readInt());
            } else if (type == Byte.TYPE) {
                slots[i].fieldValue = new Byte(this.input.readByte());
            } else if (type == Character.TYPE) {
                slots[i].fieldValue = new Character(this.input.readChar());
            } else if (type == Short.TYPE) {
                slots[i].fieldValue = new Short(this.input.readShort());
            } else if (type == Boolean.TYPE) {
                slots[i].fieldValue = new Boolean(this.input.readBoolean());
            } else if (type == Long.TYPE) {
                slots[i].fieldValue = new Long(this.input.readLong());
            } else if (type == Float.TYPE) {
                slots[i].fieldValue = new Float(this.input.readFloat());
            } else if (type == Double.TYPE) {
                slots[i].fieldValue = new Double(this.input.readDouble());
            } else {
                try {
                    slots[i].fieldValue = this.readObject();
                }
                catch (ClassNotFoundException cnf) {
                    throw new InvalidClassException(cnf.toString());
                }
            }
            ++i;
        }
    }

    private void readFieldValues(Object obj, ObjectStreamClass classDesc) throws OptionalDataException, ClassNotFoundException, IOException {
        ObjectStreamField[] fields = classDesc.getLoadFields();
        Class declaringClass = classDesc.forClass();
        if (declaringClass == null && this.mustResolve) {
            throw new ClassNotFoundException(classDesc.getName());
        }
        int i = 0;
        while (i < fields.length) {
            ObjectStreamField fieldDesc = fields[i];
            if (fieldDesc.isPrimitive()) {
                try {
                    switch (fieldDesc.getTypeCode()) {
                        case 'B': {
                            ObjectInputStream.setField(obj, declaringClass, fieldDesc.getName(), this.input.readByte());
                            break;
                        }
                        case 'C': {
                            ObjectInputStream.setField(obj, declaringClass, fieldDesc.getName(), this.input.readChar());
                            break;
                        }
                        case 'D': {
                            ObjectInputStream.setField(obj, declaringClass, fieldDesc.getName(), this.input.readDouble());
                            break;
                        }
                        case 'F': {
                            ObjectInputStream.setField(obj, declaringClass, fieldDesc.getName(), this.input.readFloat());
                            break;
                        }
                        case 'I': {
                            ObjectInputStream.setField(obj, declaringClass, fieldDesc.getName(), this.input.readInt());
                            break;
                        }
                        case 'J': {
                            ObjectInputStream.setField(obj, declaringClass, fieldDesc.getName(), this.input.readLong());
                            break;
                        }
                        case 'S': {
                            ObjectInputStream.setField(obj, declaringClass, fieldDesc.getName(), this.input.readShort());
                            break;
                        }
                        case 'Z': {
                            ObjectInputStream.setField(obj, declaringClass, fieldDesc.getName(), this.input.readBoolean());
                            break;
                        }
                        default: {
                            throw new StreamCorruptedException(Msg.getString("K00d5", fieldDesc.getTypeCode()));
                        }
                    }
                }
                catch (NoSuchFieldError noSuchFieldError) {}
            } else {
                String fieldName = fieldDesc.getName();
                boolean setBack = false;
                ObjectStreamField field = classDesc.getField(fieldName);
                if (this.mustResolve && field == null) {
                    setBack = true;
                    this.mustResolve = false;
                }
                Object toSet = field != null && field.getUnshared() ? this.readUnshared() : this.readObject();
                if (setBack) {
                    this.mustResolve = true;
                }
                if (field != null && toSet != null) {
                    Class valueType;
                    Class fieldType = field.getType();
                    if (!fieldType.isAssignableFrom(valueType = toSet.getClass())) {
                        throw new ClassCastException(Msg.getString("K00d4", new String[]{fieldType.toString(), valueType.toString(), String.valueOf(classDesc.getName()) + "." + fieldName}));
                    }
                    try {
                        ObjectInputStream.objSetField(obj, declaringClass, fieldName, field.getTypeString(), toSet);
                    }
                    catch (NoSuchFieldError noSuchFieldError) {}
                }
            }
            ++i;
        }
    }

    public float readFloat() throws IOException {
        return this.primitiveTypes.readFloat();
    }

    public void readFully(byte[] buffer) throws IOException {
        this.primitiveTypes.readFully(buffer);
    }

    public void readFully(byte[] buffer, int offset, int length) throws IOException {
        this.primitiveTypes.readFully(buffer, offset, length);
    }

    private void readHierarchy(Object object, ObjectStreamClass classDesc) throws IOException, ClassNotFoundException, NotActiveException {
        if (object == null && this.mustResolve) {
            throw new NotActiveException();
        }
        ArrayList streamClassList = new ArrayList(32);
        ObjectStreamClass nextStreamClass = classDesc;
        while (nextStreamClass != null) {
            streamClassList.add(0, nextStreamClass);
            nextStreamClass = nextStreamClass.getSuperclass();
        }
        if (object == null) {
            Iterator streamIt = streamClassList.iterator();
            while (streamIt.hasNext()) {
                ObjectStreamClass streamClass = (ObjectStreamClass)streamIt.next();
                this.readObjectForClass(object, streamClass);
            }
        } else {
            ArrayList classList = new ArrayList(32);
            Class nextClass = object.getClass();
            while (nextClass != null) {
                Class testClass = nextClass.getSuperclass();
                if (testClass != null) {
                    classList.add(0, nextClass);
                }
                nextClass = testClass;
            }
            int lastIndex = 0;
            int i = 0;
            while (i < classList.size()) {
                Class superclass = (Class)classList.get(i);
                int index = this.findStreamSuperclass(superclass, streamClassList, lastIndex);
                if (index == -1) {
                    this.readObjectNoData(object, superclass);
                } else {
                    int j = lastIndex;
                    while (j <= index) {
                        this.readObjectForClass(object, (ObjectStreamClass)streamClassList.get(j));
                        ++j;
                    }
                }
                lastIndex = index + 1;
                ++i;
            }
        }
    }

    private int findStreamSuperclass(Class cl, ArrayList classList, int lastIndex) {
        int i = lastIndex;
        while (i < classList.size()) {
            if (cl.getName().equals(((ObjectStreamClass)classList.get(i)).getName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void readObjectNoData(Object object, Class cl) throws ObjectStreamException {
        if (!ObjectStreamClass.isSerializable(cl)) {
            return;
        }
        Method readMethod = ObjectStreamClass.getPrivateReadObjectNoDataMethod(cl);
        if (readMethod != null) {
            AccessController.doPrivileged(new PriviAction(readMethod));
            try {
                readMethod.invoke(object, new Object[0]);
            }
            catch (InvocationTargetException e) {
                Throwable ex = e.getTargetException();
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                if (ex instanceof Error) {
                    throw (Error)ex;
                }
                throw (ObjectStreamException)ex;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e.toString());
            }
        }
    }

    private void readObjectForClass(Object object, ObjectStreamClass classDesc) throws IOException, ClassNotFoundException, NotActiveException {
        this.currentObject = object;
        this.currentClass = classDesc;
        boolean hadWriteMethod = (classDesc.getFlags() & 1) > 0;
        Class targetClass = classDesc.forClass();
        Method readMethod = targetClass == null || !this.mustResolve ? null : ObjectStreamClass.getPrivateReadObjectMethod(targetClass);
        try {
            if (readMethod != null) {
                AccessController.doPrivileged(new PriviAction(readMethod));
                try {
                    readMethod.invoke(object, new Object[]{this});
                }
                catch (InvocationTargetException e) {
                    Throwable ex = e.getTargetException();
                    if (ex instanceof ClassNotFoundException) {
                        throw (ClassNotFoundException)ex;
                    }
                    if (ex instanceof RuntimeException) {
                        throw (RuntimeException)ex;
                    }
                    if (ex instanceof Error) {
                        throw (Error)ex;
                    }
                    throw (IOException)ex;
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e.toString());
                }
            } else {
                this.defaultReadObject();
            }
            if (hadWriteMethod) {
                this.discardData();
            }
        }
        finally {
            this.currentObject = null;
            this.currentClass = null;
        }
    }

    public int readInt() throws IOException {
        return this.primitiveTypes.readInt();
    }

    public String readLine() throws IOException {
        return this.primitiveTypes.readLine();
    }

    public long readLong() throws IOException {
        return this.primitiveTypes.readLong();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object readNewArray(boolean unshared) throws OptionalDataException, ClassNotFoundException, IOException {
        ObjectStreamClass classDesc = this.readClassDesc();
        if (classDesc == null) {
            throw new InvalidClassException(Msg.getString("K00d1"));
        }
        Integer newHandle = new Integer(this.nextHandle());
        int size = this.input.readInt();
        Class arrayClass = classDesc.forClass();
        Class componentType = arrayClass.getComponentType();
        Object result = Array.newInstance(componentType, size);
        if (!unshared) {
            this.registerObjectRead(result, newHandle);
        }
        if (componentType.isPrimitive()) {
            if (componentType == Integer.TYPE) {
                int[] intArray = (int[])result;
                int i = 0;
                while (i < size) {
                    intArray[i] = this.input.readInt();
                    ++i;
                }
            } else if (componentType == Byte.TYPE) {
                byte[] byteArray = (byte[])result;
                this.input.readFully(byteArray, 0, size);
            } else if (componentType == Character.TYPE) {
                char[] charArray = (char[])result;
                int i = 0;
                while (i < size) {
                    charArray[i] = this.input.readChar();
                    ++i;
                }
            } else if (componentType == Short.TYPE) {
                short[] shortArray = (short[])result;
                int i = 0;
                while (i < size) {
                    shortArray[i] = this.input.readShort();
                    ++i;
                }
            } else if (componentType == Boolean.TYPE) {
                boolean[] booleanArray = (boolean[])result;
                int i = 0;
                while (i < size) {
                    booleanArray[i] = this.input.readBoolean();
                    ++i;
                }
            } else if (componentType == Long.TYPE) {
                long[] longArray = (long[])result;
                int i = 0;
                while (i < size) {
                    longArray[i] = this.input.readLong();
                    ++i;
                }
            } else if (componentType == Float.TYPE) {
                float[] floatArray = (float[])result;
                int i = 0;
                while (i < size) {
                    floatArray[i] = this.input.readFloat();
                    ++i;
                }
            } else {
                if (componentType != Double.TYPE) throw new ClassNotFoundException(Msg.getString("K00d7", classDesc.getName()));
                double[] doubleArray = (double[])result;
                int i = 0;
                while (i < size) {
                    doubleArray[i] = this.input.readDouble();
                    ++i;
                }
            }
        } else {
            Object[] objectArray = (Object[])result;
            int i = 0;
            while (i < size) {
                objectArray[i] = this.readObject();
                ++i;
            }
        }
        if (!this.enableResolve) return result;
        result = this.resolveObject(result);
        this.registerObjectRead(result, newHandle);
        return result;
    }

    private Class readNewClass(boolean unshared) throws ClassNotFoundException, IOException {
        ObjectStreamClass classDesc = this.readClassDesc();
        if (classDesc != null) {
            Integer newHandle = new Integer(this.nextHandle());
            Class localClass = classDesc.forClass();
            if (localClass != null && !unshared) {
                this.registerObjectRead(localClass, newHandle);
            }
            return localClass;
        }
        throw new InvalidClassException(Msg.getString("K00d1"));
    }

    private ObjectStreamClass readNewClassDesc(boolean unshared) throws ClassNotFoundException, IOException {
        ObjectStreamClass newClassDesc;
        block4: {
            this.primitiveData = this.input;
            Integer oldHandle = this.descriptorHandle;
            this.descriptorHandle = new Integer(this.nextHandle());
            newClassDesc = this.readClassDescriptor();
            if (this.descriptorHandle != null && !unshared) {
                this.registerObjectRead(newClassDesc, this.descriptorHandle);
            }
            this.descriptorHandle = oldHandle;
            this.primitiveData = emptyStream;
            try {
                newClassDesc.setClass(this.resolveClass(newClassDesc));
                this.verifySUID(newClassDesc);
            }
            catch (ClassNotFoundException e) {
                if (!this.mustResolve) break block4;
                throw e;
            }
        }
        ObjectStreamField[] fields = newClassDesc.getLoadFields();
        ClassLoader loader = newClassDesc.forClass() == null ? this.callerClassLoader : newClassDesc.forClass().getClassLoader();
        int i = 0;
        while (i < fields.length) {
            fields[i].resolve(loader);
            ++i;
        }
        this.discardData();
        newClassDesc.setSuperclass(this.readClassDesc());
        return newClassDesc;
    }

    private Class readNewProxyClassDesc() throws ClassNotFoundException, IOException {
        int count = this.input.readInt();
        String[] interfaceNames = new String[count];
        int i = 0;
        while (i < count) {
            interfaceNames[i] = this.input.readUTF();
            ++i;
        }
        Class proxy = this.resolveProxyClass(interfaceNames);
        this.discardData();
        return proxy;
    }

    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        if (this.descriptorHandle == null) {
            throw new NotActiveException();
        }
        ObjectStreamClass newClassDesc = new ObjectStreamClass();
        newClassDesc.setName(this.input.readUTF());
        newClassDesc.setSerialVersionUID(this.input.readLong());
        newClassDesc.setFlags(this.input.readByte());
        this.registerObjectRead(newClassDesc, this.descriptorHandle);
        this.descriptorHandle = null;
        this.readFieldDescriptors(newClassDesc);
        return newClassDesc;
    }

    protected Class resolveProxyClass(String[] interfaceNames) throws IOException, ClassNotFoundException {
        ClassLoader loader = VM.getNonBootstrapClassLoader();
        Class[] interfaces = new Class[interfaceNames.length];
        int i = 0;
        while (i < interfaceNames.length) {
            interfaces[i] = Class.forName(interfaceNames[i], false, loader);
            ++i;
        }
        try {
            return Proxy.getProxyClass(loader, interfaces);
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(e.toString(), e);
        }
    }

    private Integer readNewHandle() throws IOException {
        return new Integer(this.input.readInt());
    }

    private Object readNewObject(boolean unshared) throws OptionalDataException, ClassNotFoundException, IOException {
        Object readResolveMethod;
        Object result;
        ObjectStreamClass classDesc = this.readClassDesc();
        if (classDesc == null) {
            throw new InvalidClassException(Msg.getString("K00d1"));
        }
        Integer newHandle = new Integer(this.nextHandle());
        boolean wasExternalizable = (classDesc.getFlags() & 4) > 0;
        boolean wasSerializable = (classDesc.getFlags() & 2) > 0;
        Class objectClass = classDesc.forClass();
        Object registeredResult = null;
        if (objectClass != null) {
            Constructor constructor;
            Class constructorClass = objectClass;
            if (wasSerializable) {
                while (constructorClass != null & ObjectStreamClass.isSerializable(constructorClass)) {
                    constructorClass = constructorClass.getSuperclass();
                }
            }
            try {
                constructor = constructorClass.getDeclaredConstructor(ObjectStreamClass.EMPTY_CONSTRUCTOR_PARAM_TYPES);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                constructor = null;
            }
            if (constructor == null) {
                throw new InvalidClassException(constructorClass.getName(), Msg.getString("K00dc"));
            }
            int constructorModifiers = constructor.getModifiers();
            if (Modifier.isPrivate(constructorModifiers) || wasExternalizable && !Modifier.isPublic(constructorModifiers)) {
                throw new InvalidClassException(constructorClass.getName(), Msg.getString("K00dc"));
            }
            if (!(Modifier.isPublic(constructorModifiers) || Modifier.isProtected(constructorModifiers) || this.inSamePackage(constructorClass, objectClass))) {
                throw new InvalidClassException(constructorClass.getName(), Msg.getString("K00dc"));
            }
            result = ObjectInputStream.newInstance(objectClass, constructorClass);
            if (!unshared) {
                this.registerObjectRead(result, newHandle);
            }
            registeredResult = result;
        } else {
            result = null;
        }
        try {
            this.currentObject = result;
            this.currentClass = classDesc;
            if (wasExternalizable) {
                boolean blockData;
                boolean bl = blockData = (classDesc.getFlags() & 8) > 0;
                if (!blockData) {
                    this.primitiveData = this.input;
                }
                if (this.mustResolve) {
                    Externalizable extern = (Externalizable)result;
                    extern.readExternal(this);
                }
                if (blockData) {
                    this.discardData();
                } else {
                    this.primitiveData = emptyStream;
                }
            } else {
                this.readHierarchy(result, classDesc);
            }
        }
        finally {
            this.currentObject = null;
            this.currentClass = null;
        }
        if (objectClass != null && (readResolveMethod = this.readResolveCache.get(objectClass)) != this) {
            if (readResolveMethod == null) {
                Method readResolve = ObjectStreamClass.methodReadResolve(objectClass);
                if (readResolve == null) {
                    this.readResolveCache.put(objectClass, this);
                    readResolveMethod = null;
                } else {
                    AccessController.doPrivileged(new PriviAction(readResolve));
                    this.readResolveCache.put(objectClass, readResolve);
                    readResolveMethod = readResolve;
                }
            }
            if (readResolveMethod != null) {
                try {
                    result = ((Method)readResolveMethod).invoke(result, null);
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException ite) {
                    Throwable target = ite.getTargetException();
                    if (target instanceof ObjectStreamException) {
                        throw (ObjectStreamException)target;
                    }
                    if (target instanceof Error) {
                        throw (Error)target;
                    }
                    throw (RuntimeException)target;
                }
            }
        }
        if (result != null && this.enableResolve) {
            result = this.resolveObject(result);
        }
        if (registeredResult != result && !unshared) {
            this.registerObjectRead(result, newHandle);
        }
        return result;
    }

    private Object readNewString(boolean unshared) throws IOException {
        Object result = this.input.readUTF();
        if (this.enableResolve) {
            result = this.resolveObject(result);
        }
        int newHandle = this.nextHandle();
        if (!unshared) {
            this.registerObjectRead(result, new Integer(newHandle));
        }
        return result;
    }

    private Object readNewLongString(boolean unshared) throws IOException {
        long length = this.input.readLong();
        Object result = this.input.decodeUTF((int)length);
        if (this.enableResolve) {
            result = this.resolveObject(result);
        }
        int newHandle = this.nextHandle();
        if (!unshared) {
            this.registerObjectRead(result, new Integer(newHandle));
        }
        return result;
    }

    public final Object readObject() throws OptionalDataException, ClassNotFoundException, IOException {
        return this.readObject(false);
    }

    public Object readUnshared() throws IOException, ClassNotFoundException {
        return this.readObject(true);
    }

    private Object readObject(boolean unshared) throws OptionalDataException, ClassNotFoundException, IOException {
        Object result;
        boolean restoreInput = this.primitiveData == this.input;
        if (restoreInput) {
            this.primitiveData = emptyStream;
        }
        if (this.subclassOverridingImplementation && !unshared) {
            return this.readObjectOverride();
        }
        try {
            if (++this.nestedLevels == 1) {
                this.callerClassLoader = VM.getNonBootstrapClassLoader();
            }
            result = this.readNonPrimitiveContent(unshared);
            if (restoreInput) {
                this.primitiveData = this.input;
            }
        }
        finally {
            if (--this.nestedLevels == 0) {
                this.callerClassLoader = null;
            }
        }
        if (this.nestedLevels == 0 && this.validations != null) {
            try {
                int i = 0;
                while (i < this.validations.length) {
                    this.validations[i].validator.validateObject();
                    ++i;
                }
            }
            finally {
                this.validations = null;
            }
        }
        return result;
    }

    protected Object readObjectOverride() throws OptionalDataException, ClassNotFoundException, IOException {
        throw new IOException();
    }

    public short readShort() throws IOException {
        return this.primitiveTypes.readShort();
    }

    protected void readStreamHeader() throws IOException, StreamCorruptedException {
        if (this.input.readShort() == -21267 && this.input.readShort() == 5) {
            return;
        }
        throw new StreamCorruptedException();
    }

    public int readUnsignedByte() throws IOException {
        return this.primitiveTypes.readUnsignedByte();
    }

    public int readUnsignedShort() throws IOException {
        return this.primitiveTypes.readUnsignedShort();
    }

    public String readUTF() throws IOException {
        return this.primitiveTypes.readUTF();
    }

    private Object registeredObjectRead(Integer handle) throws InvalidObjectException {
        return this.objectsRead.get(handle);
    }

    private void registerObjectRead(Object obj, Integer handle) {
        this.objectsRead.put(handle, obj);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void registerValidation(ObjectInputValidation object, int priority) throws NotActiveException, InvalidObjectException {
        if (object == null) throw new InvalidObjectException(Msg.getString("K00d9"));
        Object instanceBeingRead = this.currentObject;
        if (instanceBeingRead == null) throw new NotActiveException();
        InputValidationDesc desc = new InputValidationDesc();
        desc.validator = object;
        desc.priority = priority;
        if (this.validations == null) {
            this.validations = new InputValidationDesc[1];
            this.validations[0] = desc;
            return;
        } else {
            int i = 0;
            while (i < this.validations.length) {
                InputValidationDesc validation = this.validations[i];
                if (priority >= validation.priority) break;
                ++i;
            }
            InputValidationDesc[] oldValidations = this.validations;
            int currentSize = oldValidations.length;
            this.validations = new InputValidationDesc[currentSize + 1];
            System.arraycopy((Object)oldValidations, 0, (Object)this.validations, 0, i);
            System.arraycopy((Object)oldValidations, i, (Object)this.validations, i + 1, currentSize - i);
            this.validations[i] = desc;
        }
    }

    private void resetSeenObjects() {
        this.objectsRead = new Hashtable();
        this.currentHandle = 0x7E0000;
        this.primitiveData = emptyStream;
    }

    private void resetState() {
        this.resetSeenObjects();
        this.hasPushbackTC = false;
        this.pushbackTC = 0;
    }

    protected Class resolveClass(ObjectStreamClass osClass) throws IOException, ClassNotFoundException {
        try {
            return Class.forName(osClass.getName(), true, this.callerClassLoader);
        }
        catch (ClassNotFoundException e) {
            String name = osClass.getName();
            if (name.equals("int")) {
                return Integer.TYPE;
            }
            if (name.equals("long")) {
                return Long.TYPE;
            }
            if (name.equals("char")) {
                return Character.TYPE;
            }
            if (name.equals("byte")) {
                return Byte.TYPE;
            }
            if (name.equals("boolean")) {
                return Boolean.TYPE;
            }
            if (name.equals("double")) {
                return Double.TYPE;
            }
            if (name.equals("float")) {
                return Float.TYPE;
            }
            if (name.equals("void")) {
                return Void.TYPE;
            }
            if (name.equals("short")) {
                return Short.TYPE;
            }
            throw e;
        }
    }

    protected Object resolveObject(Object object) throws IOException {
        return object;
    }

    private static native void setField(Object var0, Class var1, String var2, byte var3) throws NoSuchFieldError;

    private static native void setField(Object var0, Class var1, String var2, char var3) throws NoSuchFieldError;

    private static native void setField(Object var0, Class var1, String var2, double var3) throws NoSuchFieldError;

    private static native void setField(Object var0, Class var1, String var2, float var3) throws NoSuchFieldError;

    private static native void setField(Object var0, Class var1, String var2, int var3) throws NoSuchFieldError;

    private static native void setField(Object var0, Class var1, String var2, long var3) throws NoSuchFieldError;

    private static native void objSetField(Object var0, Class var1, String var2, String var3, Object var4) throws NoSuchFieldError;

    private static native void setField(Object var0, Class var1, String var2, short var3) throws NoSuchFieldError;

    private static native void setField(Object var0, Class var1, String var2, boolean var3) throws NoSuchFieldError;

    public int skipBytes(int length) throws IOException {
        int offset = 0;
        while (offset < length) {
            this.checkReadPrimitiveTypes();
            long skipped = this.primitiveData.skip(length - offset);
            if (skipped == 0L) {
                return offset;
            }
            offset += (int)skipped;
        }
        return length;
    }

    private void verifySUID(ObjectStreamClass loadedStreamClass) throws InvalidClassException {
        Class localClass = loadedStreamClass.forClass();
        ObjectStreamClass localStreamClass = ObjectStreamClass.lookupStreamClass(localClass);
        if (loadedStreamClass.getSerialVersionUID() != localStreamClass.getSerialVersionUID()) {
            throw new InvalidClassException(loadedStreamClass.getName(), Msg.getString("K00da", loadedStreamClass, localStreamClass));
        }
    }

    class InputValidationDesc {
        ObjectInputValidation validator;
        int priority;

        InputValidationDesc() {
        }
    }

    public static abstract class GetField {
        public abstract ObjectStreamClass getObjectStreamClass();

        public abstract boolean defaulted(String var1) throws IOException, IllegalArgumentException;

        public abstract boolean get(String var1, boolean var2) throws IOException, IllegalArgumentException;

        public abstract char get(String var1, char var2) throws IOException, IllegalArgumentException;

        public abstract byte get(String var1, byte var2) throws IOException, IllegalArgumentException;

        public abstract short get(String var1, short var2) throws IOException, IllegalArgumentException;

        public abstract int get(String var1, int var2) throws IOException, IllegalArgumentException;

        public abstract long get(String var1, long var2) throws IOException, IllegalArgumentException;

        public abstract float get(String var1, float var2) throws IOException, IllegalArgumentException;

        public abstract double get(String var1, double var2) throws IOException, IllegalArgumentException;

        public abstract Object get(String var1, Object var2) throws IOException, IllegalArgumentException;
    }
}

