/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.ibm.oti.util.Msg;
import com.ibm.oti.util.Util;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UTFDataFormatException;

public class RandomAccessFile
implements DataInput,
DataOutput {
    private static final int WRITABLE = 1;
    private static final int SYNC = 2;
    FileDescriptor fd;
    private boolean syncMetadata = false;

    static {
        RandomAccessFile.oneTimeInitialization();
    }

    private static native void oneTimeInitialization();

    public RandomAccessFile(File file, String mode) throws FileNotFoundException {
        if (mode.equals("r") || mode.equals("rw") || mode.equals("rws") || mode.equals("rwd")) {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkRead(file.getPath());
                if (!mode.equals("r")) {
                    security.checkWrite(file.getPath());
                }
            }
            this.fd = new FileDescriptor();
            if (this.openImpl2(file.properPath(true), this.getOptions(mode)) != 0) {
                throw new FileNotFoundException(file.getPath());
            }
            if (this.syncMetadata) {
                try {
                    this.fd.sync();
                }
                catch (IOException iOException) {}
            }
        } else {
            throw new IllegalArgumentException(Msg.getString("K03bb"));
        }
    }

    public RandomAccessFile(String fileName, String mode) throws FileNotFoundException {
        if (mode.equals("r") || mode.equals("rw") || mode.equals("rws") || mode.equals("rwd")) {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkRead(fileName);
                if (!mode.equals("r")) {
                    security.checkWrite(fileName);
                }
            }
            this.fd = new FileDescriptor();
            File f = new File(fileName);
            if (this.openImpl2(f.properPath(true), this.getOptions(mode)) != 0) {
                throw new FileNotFoundException(fileName);
            }
            if (this.syncMetadata) {
                try {
                    this.fd.sync();
                }
                catch (IOException iOException) {}
            }
        } else {
            throw new IllegalArgumentException(Msg.getString("K03bb"));
        }
    }

    private int getOptions(String mode) {
        int options = 0;
        if (!mode.equals("r")) {
            options |= 1;
        }
        if (mode.equals("rwd")) {
            options |= 2;
        } else if (mode.equals("rws")) {
            this.syncMetadata = true;
        }
        return options;
    }

    public void close() throws IOException {
        this.closeImpl();
    }

    private native void closeImpl() throws IOException;

    public final FileDescriptor getFD() throws IOException {
        return this.fd;
    }

    public native long getFilePointer() throws IOException;

    public native long length() throws IOException;

    private native int openImpl2(byte[] var1, int var2);

    public int read() throws IOException {
        if (this.fd != null) {
            return this.readByteImpl(this.fd.descriptor);
        }
        throw new IOException();
    }

    private native int readByteImpl(long var1) throws IOException;

    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    public int read(byte[] buffer, int offset, int count) throws IOException {
        if (this.fd != null) {
            return this.readImpl(buffer, offset, count, this.fd.descriptor);
        }
        throw new IOException();
    }

    private native int readImpl(byte[] var1, int var2, int var3, long var4) throws IOException;

    public final boolean readBoolean() throws IOException {
        int temp = this.read();
        if (temp >= 0) {
            return temp != 0;
        }
        throw new EOFException();
    }

    public final byte readByte() throws IOException {
        int temp = this.read();
        if (temp >= 0) {
            return (byte)temp;
        }
        throw new EOFException();
    }

    public final char readChar() throws IOException {
        byte[] buffer = new byte[2];
        if (this.read(buffer, 0, buffer.length) == buffer.length) {
            return (char)(((buffer[0] & 0xFF) << 8) + (buffer[1] & 0xFF));
        }
        throw new EOFException();
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final void readFully(byte[] buffer) throws IOException {
        this.readFully(buffer, 0, buffer.length);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void readFully(byte[] buffer, int offset, int count) throws IOException {
        if (buffer == null) throw new NullPointerException(Msg.getString("K0047"));
        if (offset < 0 || offset > buffer.length || count < 0 || count > buffer.length - offset) throw new IndexOutOfBoundsException();
        while (count > 0) {
            int result = this.read(buffer, offset, count);
            if (result < 0) throw new EOFException();
            offset += result;
            count -= result;
        }
    }

    public final int readInt() throws IOException {
        byte[] buffer = new byte[4];
        if (this.read(buffer, 0, buffer.length) == buffer.length) {
            return ((buffer[0] & 0xFF) << 24) + ((buffer[1] & 0xFF) << 16) + ((buffer[2] & 0xFF) << 8) + (buffer[3] & 0xFF);
        }
        throw new EOFException();
    }

    public final String readLine() throws IOException {
        StringBuffer line = new StringBuffer(80);
        boolean foundTerminator = false;
        long unreadPosition = 0L;
        block5: while (true) {
            int nextByte = this.read();
            switch (nextByte) {
                case -1: {
                    return line.length() != 0 ? line.toString() : null;
                }
                case 13: {
                    if (foundTerminator) {
                        this.seek(unreadPosition);
                        return line.toString();
                    }
                    foundTerminator = true;
                    unreadPosition = this.getFilePointer();
                    continue block5;
                }
                case 10: {
                    return line.toString();
                }
            }
            if (foundTerminator) {
                this.seek(unreadPosition);
                return line.toString();
            }
            line.append((char)nextByte);
        }
    }

    public final long readLong() throws IOException {
        byte[] buffer = new byte[8];
        if (this.read(buffer, 0, buffer.length) == buffer.length) {
            return ((long)(((buffer[0] & 0xFF) << 24) + ((buffer[1] & 0xFF) << 16) + ((buffer[2] & 0xFF) << 8) + (buffer[3] & 0xFF)) << 32) + ((long)(buffer[4] & 0xFF) << 24) + (long)((buffer[5] & 0xFF) << 16) + (long)((buffer[6] & 0xFF) << 8) + (long)(buffer[7] & 0xFF);
        }
        throw new EOFException();
    }

    public final short readShort() throws IOException {
        byte[] buffer = new byte[2];
        if (this.read(buffer, 0, buffer.length) == buffer.length) {
            return (short)(((buffer[0] & 0xFF) << 8) + (buffer[1] & 0xFF));
        }
        throw new EOFException();
    }

    public final int readUnsignedByte() throws IOException {
        int temp = this.read();
        if (temp >= 0) {
            return temp;
        }
        throw new EOFException();
    }

    public final int readUnsignedShort() throws IOException {
        byte[] buffer = new byte[2];
        if (this.read(buffer, 0, buffer.length) == buffer.length) {
            return ((buffer[0] & 0xFF) << 8) + (buffer[1] & 0xFF);
        }
        throw new EOFException();
    }

    public final String readUTF() throws IOException {
        int utfSize = this.readUnsignedShort();
        if (utfSize == 0) {
            return new String();
        }
        byte[] buf = new byte[utfSize];
        if (this.read(buf, 0, buf.length) == buf.length) {
            return Util.convertFromUTF8(buf, 0, utfSize);
        }
        throw new EOFException();
    }

    public native void seek(long var1) throws IOException;

    public void setLength(long newLength) throws IOException {
        this.setLengthImpl(newLength);
        if (this.syncMetadata) {
            this.fd.sync();
        }
    }

    private native void setLengthImpl(long var1) throws IOException;

    public int skipBytes(int count) throws IOException {
        if (count > 0) {
            long eof;
            long currentPos = this.getFilePointer();
            int newCount = (int)(currentPos + (long)count > (eof = this.length()) ? eof - currentPos : (long)count);
            this.seek(currentPos + (long)newCount);
            return newCount;
        }
        return 0;
    }

    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    public void write(byte[] buffer, int offset, int count) throws IOException {
        if (this.fd != null) {
            this.writeImpl(buffer, offset, count, this.fd.descriptor);
            if (this.syncMetadata) {
                this.fd.sync();
            }
        } else {
            throw new IOException();
        }
    }

    private native void writeImpl(byte[] var1, int var2, int var3, long var4) throws IOException;

    public void write(int oneByte) throws IOException {
        if (this.fd == null) {
            throw new IOException();
        }
        this.writeByteImpl(oneByte, this.fd.descriptor);
    }

    private native void writeByteImpl(int var1, long var2) throws IOException;

    public final void writeBoolean(boolean val) throws IOException {
        this.write(val ? 1 : 0);
    }

    public final void writeByte(int val) throws IOException {
        this.write(val & 0xFF);
    }

    public final void writeBytes(String str) throws IOException {
        byte[] bytes = new byte[str.length()];
        int index = 0;
        while (index < str.length()) {
            bytes[index] = (byte)(str.charAt(index) & 0xFF);
            ++index;
        }
        this.write(bytes);
    }

    public final void writeChar(int val) throws IOException {
        byte[] buffer = new byte[]{(byte)(val >> 8), (byte)val};
        this.write(buffer, 0, buffer.length);
    }

    public final void writeChars(String str) throws IOException {
        byte[] newBytes = new byte[str.length() * 2];
        int index = 0;
        while (index < str.length()) {
            int newIndex = index == 0 ? index : index * 2;
            newBytes[newIndex] = (byte)(str.charAt(index) >> 8 & 0xFF);
            newBytes[newIndex + 1] = (byte)(str.charAt(index) & 0xFF);
            ++index;
        }
        this.write(newBytes);
    }

    public final void writeDouble(double val) throws IOException {
        this.writeLong(Double.doubleToLongBits(val));
    }

    public final void writeFloat(float val) throws IOException {
        this.writeInt(Float.floatToIntBits(val));
    }

    public final void writeInt(int val) throws IOException {
        byte[] buffer = new byte[]{(byte)(val >> 24), (byte)(val >> 16), (byte)(val >> 8), (byte)val};
        this.write(buffer, 0, buffer.length);
    }

    public final void writeLong(long val) throws IOException {
        byte[] buffer = new byte[8];
        int t = (int)(val >> 32);
        buffer[0] = (byte)(t >> 24);
        buffer[1] = (byte)(t >> 16);
        buffer[2] = (byte)(t >> 8);
        buffer[3] = (byte)t;
        buffer[4] = (byte)(val >> 24);
        buffer[5] = (byte)(val >> 16);
        buffer[6] = (byte)(val >> 8);
        buffer[7] = (byte)val;
        this.write(buffer, 0, buffer.length);
    }

    public final void writeShort(int val) throws IOException {
        this.writeChar(val);
    }

    public final void writeUTF(String str) throws IOException {
        byte[] utfBytes;
        int utfCount = 0;
        int length = str.length();
        int i = 0;
        while (i < length) {
            char charValue = str.charAt(i);
            utfCount = charValue > '\u0000' && charValue <= '\u007f' ? ++utfCount : (charValue <= '\u07ff' ? (utfCount += 2) : (utfCount += 3));
            ++i;
        }
        if (utfCount <= 65535) {
            utfBytes = new byte[utfCount + 2];
            int utfIndex = 2;
            int i2 = 0;
            while (i2 < length) {
                char charValue = str.charAt(i2);
                if (charValue > '\u0000' && charValue <= '\u007f') {
                    utfBytes[utfIndex++] = (byte)charValue;
                } else if (charValue <= '\u07ff') {
                    utfBytes[utfIndex++] = (byte)(0xC0 | 0x1F & charValue >> 6);
                    utfBytes[utfIndex++] = (byte)(0x80 | 0x3F & charValue);
                } else {
                    utfBytes[utfIndex++] = (byte)(0xE0 | 0xF & charValue >> 12);
                    utfBytes[utfIndex++] = (byte)(0x80 | 0x3F & charValue >> 6);
                    utfBytes[utfIndex++] = (byte)(0x80 | 0x3F & charValue);
                }
                ++i2;
            }
        } else {
            throw new UTFDataFormatException(Msg.getString("K0068"));
        }
        utfBytes[0] = (byte)(utfCount >> 8);
        utfBytes[1] = (byte)utfCount;
        this.write(utfBytes);
    }
}

