/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.oti.lang.SystemProcess;
import com.ibm.oti.vm.VM;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;

public class Runtime {
    private static final Runtime runtime = new Runtime();

    private Runtime() {
    }

    public Process exec(String[] progArray) throws IOException {
        return this.exec(progArray, null);
    }

    public Process exec(String[] progArray, String[] envp) throws IOException {
        return this.exec(progArray, envp, null);
    }

    public Process exec(String[] progArray, String[] envp, File directory) throws IOException {
        SecurityManager smngr = System.getSecurityManager();
        if (smngr != null) {
            smngr.checkExec(progArray[0]);
        }
        if (envp == null) {
            envp = new String[]{};
        }
        return SystemProcess.create(progArray, envp, directory);
    }

    public Process exec(String prog) throws IOException {
        return this.exec(prog, null);
    }

    public Process exec(String prog, String[] envp) throws IOException {
        return this.exec(prog, envp, null);
    }

    public Process exec(String prog, String[] envp, File directory) throws IOException {
        int i = 0;
        StringTokenizer slicer = new StringTokenizer(prog);
        int argsLenghPlusOne = slicer.countTokens();
        String[] command = new String[argsLenghPlusOne];
        while (i < argsLenghPlusOne) {
            command[i++] = slicer.nextToken();
        }
        return this.exec(command, envp, directory);
    }

    public void exit(int code) {
        SecurityManager smngr = System.getSecurityManager();
        if (smngr != null) {
            smngr.checkExit(code);
        }
        this.exitImpl(code);
    }

    private native void exitImpl(int var1);

    public native long freeMemory();

    public native void gc();

    public static Runtime getRuntime() {
        return runtime;
    }

    public synchronized void load(String pathName) {
        SecurityManager smngr = System.getSecurityManager();
        if (smngr != null) {
            smngr.checkLink(pathName);
        }
        ClassLoader.loadLibraryWithPath(pathName, ClassLoader.callerClassLoader(), null);
    }

    public void loadLibrary(String libName) {
        ClassLoader.loadLibraryWithClassLoader(libName, ClassLoader.callerClassLoader());
    }

    public native void runFinalization();

    public native long totalMemory();

    public void traceInstructions(boolean enable) {
    }

    public void traceMethodCalls(boolean enable) {
    }

    public void addShutdownHook(Thread hook) {
        VM.addShutdownHook(hook);
    }

    public boolean removeShutdownHook(Thread hook) {
        return VM.removeShutdownHook(hook);
    }

    public void halt(int code) {
        SecurityManager smngr = System.getSecurityManager();
        if (smngr != null) {
            smngr.checkExit(code);
        }
        this.haltImpl(code);
    }

    private native void haltImpl(int var1);

    public int availableProcessors() {
        return this.availableProcessorsImpl();
    }

    private native int availableProcessorsImpl();

    public long maxMemory() {
        return this.maxMemoryImpl();
    }

    private native long maxMemoryImpl();
}

