/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;

public final class Constructor
extends AccessibleObject
implements Member {
    private Class declaringClass;
    private Class[] parameterTypes;
    private Class[] exceptionTypes;
    private Class returnType;
    private String name;
    private long vm1;

    private Constructor() {
    }

    public boolean equals(Object object) {
        Class[] array2;
        if (this == object) {
            return true;
        }
        if (!(object instanceof Constructor)) {
            return false;
        }
        Constructor method = (Constructor)object;
        if (this.getDeclaringClass() != method.getDeclaringClass()) {
            return false;
        }
        Class[] array1 = this.getParameterTypes();
        if (array1.length != (array2 = method.getParameterTypes()).length) {
            return false;
        }
        int i = 0;
        while (i < array1.length) {
            if (array1[i] != array2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Class getDeclaringClass() {
        return this.declaringClass;
    }

    public Class[] getExceptionTypes() {
        if (this.exceptionTypes == null) {
            this.getExceptionTypesImpl();
        }
        return (Class[])this.exceptionTypes.clone();
    }

    public int getModifiers() {
        return super.getModifiers();
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        this.name = this.getDeclaringClass().getName();
        return this.name;
    }

    public Class[] getParameterTypes() {
        if (this.parameterTypes == null) {
            this.getParameterTypesImpl();
        }
        return (Class[])this.parameterTypes.clone();
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public Object newInstance(Object[] args) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class callerClass;
        Object newInstance;
        if (args == null) {
            args = emptyArgs;
        }
        if ((newInstance = this.newInstanceImpl()) == null) {
            throw new InstantiationException();
        }
        if (!this.isAccessible() && !this.checkAccessibility(callerClass = Constructor.getStackClass(-1), newInstance)) {
            throw new IllegalAccessException();
        }
        if (this.parameterTypes == null) {
            this.getParameterTypesImpl();
        }
        args = Constructor.marshallArguments(this.parameterTypes, args);
        try {
            Constructor.initializeClass(this.getDeclaringClass());
        }
        catch (Throwable e) {
            throw new InvocationTargetException(e);
        }
        this.invokeV(newInstance, args);
        return newInstance;
    }

    private native Object newInstanceImpl();

    public String toString() {
        Class current;
        StringBuffer buf = new StringBuffer();
        String mods = Modifier.toString(this.getModifiers());
        if (mods.length() != 0) {
            buf.append(mods);
            buf.append(" ");
        }
        buf.append(this.getName());
        buf.append("(");
        Class[] types = this.getParameterTypes();
        int i = 0;
        while (i < types.length) {
            current = types[i];
            int arity = 0;
            while (current.isArray()) {
                current = current.getComponentType();
                ++arity;
            }
            buf.append(current.getName());
            while (arity > 0) {
                buf.append("[]");
                --arity;
            }
            if (i != types.length - 1) {
                buf.append(",");
            }
            ++i;
        }
        buf.append(")");
        types = this.getExceptionTypes();
        if (types.length > 0) {
            buf.append(" throws ");
            i = 0;
            while (i < types.length) {
                current = types[i];
                buf.append(current.getName());
                if (i != types.length - 1) {
                    buf.append(",");
                }
                ++i;
            }
        }
        return buf.toString();
    }
}

