/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import com.ibm.oti.lang.reflect.ProxyClassFile;
import com.ibm.oti.util.Msg;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public class Proxy
implements Serializable {
    private static final long serialVersionUID = -2222568056686623797L;
    private static Map loaderCache = new WeakHashMap();
    private static Map proxyCache = new WeakHashMap();
    private static int NextClassNameIndex = 0;
    protected InvocationHandler h;
    static /* synthetic */ Class class$0;

    private Proxy() {
    }

    protected Proxy(InvocationHandler h) {
        this.h = h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class getProxyClass(ClassLoader loader, Class[] interfaces) throws IllegalArgumentException {
        if (interfaces == null) {
            throw new NullPointerException();
        }
        String commonPackageName = null;
        int i = 0;
        int length = interfaces.length;
        while (i < length) {
            Class next = interfaces[i];
            if (next == null) {
                throw new NullPointerException();
            }
            String name = next.getName();
            if (!next.isInterface()) {
                throw new IllegalArgumentException(Msg.getString("K00ed", name));
            }
            if (loader != next.getClassLoader()) {
                try {
                    if (next != Class.forName(name, false, loader)) {
                        throw new IllegalArgumentException(Msg.getString("K00ee", name));
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new IllegalArgumentException(Msg.getString("K00ee", name));
                }
            }
            int j = i + 1;
            while (j < length) {
                if (next == interfaces[j]) {
                    throw new IllegalArgumentException(Msg.getString("K00ef", name));
                }
                ++j;
            }
            if (!Modifier.isPublic(next.getModifiers())) {
                String p;
                int last = name.lastIndexOf(46);
                String string = p = last == -1 ? "" : name.substring(0, last);
                if (commonPackageName == null) {
                    commonPackageName = p;
                } else if (!commonPackageName.equals(p)) {
                    throw new IllegalArgumentException(Msg.getString("K00f0"));
                }
            }
            ++i;
        }
        Map map = loaderCache;
        synchronized (map) {
            Class newClass;
            Map interfaceCache = (Map)loaderCache.get(loader);
            if (interfaceCache == null) {
                interfaceCache = new HashMap();
                loaderCache.put(loader, interfaceCache);
            }
            String interfaceKey = "";
            if (interfaces.length == 1) {
                interfaceKey = interfaces[0].getName();
            } else {
                StringBuffer names = new StringBuffer();
                int i2 = 0;
                int length2 = interfaces.length;
                while (i2 < length2) {
                    names.append(interfaces[i2].getName());
                    names.append(' ');
                    ++i2;
                }
                interfaceKey = names.toString();
            }
            WeakReference ref = (WeakReference)interfaceCache.get(interfaceKey);
            if (ref == null) {
                String nextClassName = "$Proxy" + NextClassNameIndex++;
                if (commonPackageName != null && commonPackageName.length() > 0) {
                    nextClassName = String.valueOf(commonPackageName) + "." + nextClassName;
                }
                byte[] classFileBytes = ProxyClassFile.generateBytes(nextClassName, interfaces);
                if (loader == null) {
                    loader = ClassLoader.getSystemClassLoader();
                }
                newClass = Proxy.defineClassImpl(loader, nextClassName.replace('.', '/'), classFileBytes);
                interfaceCache.put(interfaceKey, new WeakReference(newClass));
                Map map2 = proxyCache;
                synchronized (map2) {
                    proxyCache.put(newClass, "");
                }
            } else {
                newClass = (Class)ref.get();
            }
            return newClass;
        }
    }

    public static Object newProxyInstance(ClassLoader loader, Class[] interfaces, InvocationHandler h) throws IllegalArgumentException {
        if (h != null) {
            try {
                Class clazz = Proxy.getProxyClass(loader, interfaces);
                Class[] classArray = new Class[1];
                Class clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("java.lang.reflect.InvocationHandler");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz2;
                return clazz.getConstructor(classArray).newInstance(new Object[]{h});
            }
            catch (NoSuchMethodException ex) {
                throw new InternalError(ex.toString());
            }
            catch (IllegalAccessException ex) {
                throw new InternalError(ex.toString());
            }
            catch (InstantiationException ex) {
                throw new InternalError(ex.toString());
            }
            catch (InvocationTargetException ex) {
                throw new InternalError(ex.getTargetException().toString());
            }
        }
        throw new NullPointerException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isProxyClass(Class cl) {
        if (cl != null) {
            Map map = proxyCache;
            synchronized (map) {
                return proxyCache.containsKey(cl);
            }
        }
        throw new NullPointerException();
    }

    public static InvocationHandler getInvocationHandler(Object proxy) throws IllegalArgumentException {
        if (Proxy.isProxyClass(proxy.getClass())) {
            return ((Proxy)proxy).h;
        }
        throw new IllegalArgumentException(Msg.getString("K00f1"));
    }

    private static native Class defineClassImpl(ClassLoader var0, String var1, byte[] var2);
}

