/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import com.ibm.oti.util.Msg;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.util.Random;

public class BigInteger
extends Number
implements Comparable {
    private static final long serialVersionUID = -8287574255936472291L;
    private long[] data;
    private static final BigInteger NEGATIVE_ONE = new BigInteger(new long[]{-1L});
    public static final BigInteger ZERO = BigInteger.valueOf(0L);
    public static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final ObjectStreamField[] serialPersistentFields;
    static /* synthetic */ Class class$0;

    static {
        ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[6];
        objectStreamFieldArray[0] = new ObjectStreamField("bitCount", Integer.TYPE);
        objectStreamFieldArray[1] = new ObjectStreamField("bitLength", Integer.TYPE);
        objectStreamFieldArray[2] = new ObjectStreamField("firstNonzeroByteNum", Integer.TYPE);
        objectStreamFieldArray[3] = new ObjectStreamField("lowestSetBit", Integer.TYPE);
        Class clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[B");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectStreamFieldArray[4] = new ObjectStreamField("magnitude", clazz);
        objectStreamFieldArray[5] = new ObjectStreamField("signum", Integer.TYPE);
        serialPersistentFields = objectStreamFieldArray;
    }

    private BigInteger(long[] data) {
        this.data = data;
    }

    public BigInteger(int bitLength, Random rnd) {
        if (bitLength < 0) {
            throw new IllegalArgumentException(Msg.getString("K040c"));
        }
        this.randomData(bitLength, rnd);
    }

    public BigInteger(int bitLength, int certainty, Random rnd) {
        if (bitLength < 2) {
            throw new ArithmeticException(Msg.getString("K0409"));
        }
        do {
            this.randomData(bitLength, rnd);
            this.data[0] = this.data[0] | 1L;
        } while (!this.isProbablePrime(certainty, rnd));
    }

    private void randomData(int bitLength, Random rnd) {
        int longLength = (bitLength + 64) / 64;
        this.data = new long[longLength];
        int rem = bitLength % 64;
        if (rem == 0) {
            if (bitLength == 0) {
                return;
            }
            --longLength;
            rem = 64;
        }
        int i = 0;
        while (i < longLength) {
            while ((this.data[i] = rnd.nextLong()) == 0L) {
            }
            ++i;
        }
        int bits = this.getHighestSetBit() % 64 + 1;
        if (bits > rem) {
            int n = longLength - 1;
            this.data[n] = this.data[n] >>> bits - rem;
        } else if (bits < rem) {
            int n = longLength - 1;
            this.data[n] = this.data[n] << rem - bits;
        }
        this.normalize();
    }

    private BigInteger normalize() {
        int len = this.data.length;
        while (len >= 2 && (this.data[len - 1] == 0L && this.data[len - 2] >= 0L || this.data[len - 1] == -1L && this.data[len - 2] < 0L)) {
            --len;
        }
        if (len < this.data.length) {
            long[] temp = this.data;
            this.data = new long[len];
            System.arraycopy((Object)temp, 0, (Object)this.data, 0, len);
        }
        return this;
    }

    public BigInteger(byte[] bytes) {
        int bytelen = bytes.length;
        if (bytelen == 0) {
            throw new NumberFormatException(Msg.getString("K040e"));
        }
        long sign = bytes[0] < 0 ? 255L : 0L;
        int longLength = bytelen / 8 + 1;
        this.data = new long[longLength];
        int longPtr = 0;
        int bytePtr = bytelen - 1;
        int modCtr = 0;
        while (bytePtr >= 0) {
            int n = longPtr++;
            this.data[n] = this.data[n] | ((long)bytes[bytePtr] & 0xFFL) << modCtr * 8;
            if ((modCtr = (modCtr + 1) % 8) == 0) {
                // empty if block
            }
            --bytePtr;
        }
        while (longPtr < longLength) {
            int n = longPtr++;
            this.data[n] = this.data[n] | sign << modCtr * 8;
            if ((modCtr = (modCtr + 1) % 8) != 0) continue;
        }
        this.normalize();
    }

    public BigInteger(int sign, byte[] bytes) {
        this.fromBytes(sign, bytes);
    }

    private void fromBytes(int sign, byte[] bytes) {
        if (sign == 0) {
            int i = bytes.length;
            while (--i >= 0) {
                if (bytes[i] == 0) continue;
                throw new NumberFormatException(Msg.getString("K040f"));
            }
            this.data = BigInteger.ZERO.data;
        } else {
            if (sign < -1 || sign > 1) {
                throw new NumberFormatException(Msg.getString("K0410"));
            }
            int longLength = bytes.length == 0 ? 1 : (bytes.length + (bytes[0] < 0 ? 1 : 0)) / 8 + 1;
            this.data = new long[longLength];
            int longPtr = 0;
            int modCtr = 0;
            int bytePtr = bytes.length;
            while (--bytePtr >= 0) {
                int n = longPtr++;
                this.data[n] = this.data[n] | ((long)bytes[bytePtr] & 0xFFL) << modCtr * 8;
                if ((modCtr = (modCtr + 1) % 8) != 0) continue;
            }
            this.normalize();
            if (sign < 0) {
                this.data = com.ibm.oti.util.math.BigInteger.negImpl(this.data);
            }
        }
    }

    public byte[] toByteArray() {
        int len = this.data.length;
        int bytePtr = len * 8;
        byte[] bytes = new byte[bytePtr--];
        int i = 0;
        while (i < len) {
            long work = this.data[i];
            int j = 0;
            while (j < 8) {
                bytes[bytePtr--] = (byte)work;
                work >>>= 8;
                ++j;
            }
            ++i;
        }
        int start = 0;
        len *= 8;
        while (start <= len - 2 && (bytes[start] == 0 && bytes[start + 1] >= 0 || bytes[start] == -1 && bytes[start + 1] < 0)) {
            ++start;
        }
        if (start > 0) {
            byte[] temp = bytes;
            bytes = new byte[len - start];
            System.arraycopy((Object)temp, start, (Object)bytes, 0, len - start);
        }
        return bytes;
    }

    public boolean isProbablePrime(int certainty) {
        return this.isProbablePrime(certainty, new Random());
    }

    private boolean isProbablePrime(int certainty, Random rnd) {
        if (certainty < 1) {
            return true;
        }
        BigInteger w = this.abs();
        if (w.data.length == 1) {
            if (w.data[0] == 1L) {
                return false;
            }
            if (w.data[0] == 2L) {
                return true;
            }
        }
        if ((w.data[0] & 1L) == 0L) {
            return false;
        }
        int bitSize = w.getHighestSetBit() + 1;
        if (bitSize <= 3) {
            return true;
        }
        BigInteger wMinus1 = w.subtract(ONE);
        int a = wMinus1.getLowestSetBit();
        if (a == -1) {
            a = 0;
        }
        BigInteger m = wMinus1.shiftRight(a);
        int n = certainty / 2 + 1;
        int i = 0;
        while (i < n) {
            BigInteger b;
            while ((b = new BigInteger(bitSize - 1, rnd)).equals(ZERO)) {
            }
            int j = 0;
            BigInteger z = b.modPow(m, w);
            while (true) {
                boolean zEqONE = z.equals(ONE);
                if (j == 0 && zEqONE || z.equals(wMinus1)) break;
                if (j > 0 && zEqONE) {
                    return false;
                }
                if (++j >= a) {
                    return false;
                }
                z = z.multiply(z).mod(w);
            }
            ++i;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BigInteger)) {
            return false;
        }
        BigInteger bi = (BigInteger)o;
        if (this.data.length != bi.data.length) {
            return false;
        }
        int a = 0;
        while (a < this.data.length) {
            if (this.data[a] != bi.data[a]) {
                return false;
            }
            ++a;
        }
        return true;
    }

    public int compareTo(BigInteger val) {
        boolean neg2;
        int len1 = this.data.length;
        int len2 = val.data.length;
        boolean neg1 = this.data[len1 - 1] < 0L;
        boolean bl = neg2 = val.data[len2 - 1] < 0L;
        if (neg1 != neg2) {
            return neg2 ? 1 : -1;
        }
        if (len1 != len2) {
            if (!neg1) {
                return len1 > len2 ? 1 : -1;
            }
            return len1 > len2 ? -1 : 1;
        }
        if (this.data[len1 - 1] != val.data[len1 - 1]) {
            return this.data[len1 - 1] > val.data[len1 - 1] ? 1 : -1;
        }
        int i = len1 - 2;
        while (i >= 0) {
            if (this.data[i] != val.data[i]) {
                boolean s2;
                boolean s1 = this.data[i] < 0L;
                boolean bl2 = s2 = val.data[i] < 0L;
                if (s1 == s2) {
                    return this.data[i] > val.data[i] ? 1 : -1;
                }
                return s1 ? 1 : -1;
            }
            --i;
        }
        return 0;
    }

    public int compareTo(Object o) {
        if (!(o instanceof BigInteger)) {
            throw new ClassCastException();
        }
        return this.compareTo((BigInteger)o);
    }

    public int intValue() {
        return (int)this.data[0];
    }

    public long longValue() {
        return this.data[0];
    }

    public static BigInteger valueOf(long val) {
        long[] temp = new long[]{val};
        return new BigInteger(temp);
    }

    public BigInteger add(BigInteger val) {
        return new BigInteger(com.ibm.oti.util.math.BigInteger.addImpl(this.data, val.data));
    }

    public BigInteger negate() {
        return new BigInteger(com.ibm.oti.util.math.BigInteger.negImpl(this.data));
    }

    public int signum() {
        if (this.data[this.data.length - 1] < 0L) {
            return -1;
        }
        if (this.data[this.data.length - 1] == 0L && this.data.length == 1) {
            return 0;
        }
        return 1;
    }

    public BigInteger abs() {
        if (this.data[this.data.length - 1] < 0L) {
            return this.negate();
        }
        return this;
    }

    public BigInteger pow(int exponent) {
        if (exponent < 0) {
            throw new ArithmeticException(Msg.getString("K040a"));
        }
        long[] powersOf2 = this.data;
        long[] answer = BigInteger.ONE.data;
        while (exponent != 0) {
            if ((exponent & 1) == 1) {
                answer = com.ibm.oti.util.math.BigInteger.mulImpl(answer, powersOf2);
            }
            powersOf2 = com.ibm.oti.util.math.BigInteger.mulImpl(powersOf2, powersOf2);
            exponent >>>= 1;
        }
        return new BigInteger(answer);
    }

    public BigInteger modPow(BigInteger exponent, BigInteger modulo) {
        if (modulo.signum() <= 0) {
            throw new ArithmeticException(Msg.getString("K0408"));
        }
        long[] powersOf2 = this.data;
        if (exponent.signum() < 0) {
            exponent = exponent.negate();
            powersOf2 = this.modInverse((BigInteger)modulo).data;
        }
        long[] exp = exponent.data;
        long[] mod = modulo.data;
        long[] answer = BigInteger.ONE.data;
        int explen = exp.length;
        if (explen == 1 && exp[0] == 0L) {
            answer = com.ibm.oti.util.math.BigInteger.remImpl(answer, mod);
        } else {
            int i = 0;
            while (i < explen) {
                long work = exp[i];
                int j = 0;
                while (j < 64) {
                    if ((work & 1L) == 1L) {
                        answer = com.ibm.oti.util.math.BigInteger.remImpl(com.ibm.oti.util.math.BigInteger.mulImpl(answer, powersOf2), mod);
                    }
                    powersOf2 = com.ibm.oti.util.math.BigInteger.remImpl(com.ibm.oti.util.math.BigInteger.mulImpl(powersOf2, powersOf2), mod);
                    work >>>= 1;
                    ++j;
                }
                ++i;
            }
        }
        if (answer[answer.length - 1] < 0L) {
            return new BigInteger(com.ibm.oti.util.math.BigInteger.addImpl(answer, mod));
        }
        return new BigInteger(answer);
    }

    public BigInteger gcd(BigInteger val) {
        long[] u;
        long[] v;
        switch (this.signum()) {
            case 0: {
                return val.abs();
            }
            case -1: {
                v = com.ibm.oti.util.math.BigInteger.negImpl(this.data);
                break;
            }
            default: {
                v = this.data;
            }
        }
        switch (val.signum()) {
            case 0: {
                return this.abs();
            }
            case -1: {
                u = com.ibm.oti.util.math.BigInteger.negImpl(val.data);
                break;
            }
            default: {
                u = val.data;
            }
        }
        while (v.length != 1 || v[0] != 0L) {
            long[] r = com.ibm.oti.util.math.BigInteger.remImpl(u, v);
            u = v;
            v = r;
        }
        return new BigInteger(u);
    }

    public BigInteger modInverse(BigInteger modulo) {
        if (modulo.compareTo(ZERO) > 0) {
            BigInteger q;
            BigInteger s1 = ONE;
            BigInteger s = ZERO;
            BigInteger r1 = this;
            BigInteger r = modulo;
            do {
                q = r1.divide(r);
                BigInteger bigInteger = s1;
                s1 = s;
                s = bigInteger.subtract(q.multiply(s1));
            } while (!(r = r1.subtract(q.multiply(r1 = r))).equals(ZERO));
            if (r1.equals(NEGATIVE_ONE)) {
                s1 = s1.negate();
                r1 = ONE;
            }
            if (r1.equals(ONE)) {
                if (s1.compareTo(ZERO) < 0) {
                    return s1.add(modulo);
                }
                return s1;
            }
        }
        throw new ArithmeticException(Msg.getString("K0408"));
    }

    public int getLowestSetBit() {
        int longNum = 0;
        while (longNum < this.data.length) {
            if (this.data[longNum] != 0L) {
                long word = this.data[longNum];
                int byteNum = 0;
                while (true) {
                    if ((word & 0xFFL) != 0L) {
                        int val = (int)(word & 0xFFL);
                        int answer = longNum * 64 + byteNum * 8;
                        while (true) {
                            if ((val & 1) != 0) {
                                return answer;
                            }
                            ++answer;
                            val >>>= 1;
                        }
                    }
                    ++byteNum;
                    word >>>= 8;
                }
            }
            ++longNum;
        }
        return -1;
    }

    private int getHighestSetBit() {
        int longNum = this.data.length - 1;
        while (longNum >= 0) {
            if (this.data[longNum] != 0L) {
                long word = this.data[longNum];
                int byteNum = 7;
                while (true) {
                    if ((word & 0xFF00000000000000L) != 0L) {
                        int val = (int)(word >>> 56);
                        int answer = longNum * 64 + byteNum * 8 + 7;
                        while (true) {
                            if ((val & 0x80) != 0) {
                                return answer;
                            }
                            --answer;
                            val <<= 1;
                        }
                    }
                    --byteNum;
                    word <<= 8;
                }
            }
            --longNum;
        }
        return -1;
    }

    private int getHighestUnSetBit() {
        int longNum = this.data.length - 1;
        while (longNum >= 0) {
            if (this.data[longNum] != -1L) {
                long word = this.data[longNum];
                int byteNum = 7;
                while (true) {
                    if ((word & 0xFF00000000000000L) != -72057594037927936L) {
                        int val = (int)(word >>> 56);
                        int answer = longNum * 64 + byteNum * 8 + 7;
                        while (true) {
                            if ((val & 0x80) != 128) {
                                return answer;
                            }
                            --answer;
                            val <<= 1;
                        }
                    }
                    --byteNum;
                    word <<= 8;
                }
            }
            --longNum;
        }
        return -1;
    }

    public BigInteger shiftRight(int shiftval) {
        return new BigInteger(com.ibm.oti.util.math.BigInteger.shlImpl(this.data, -shiftval));
    }

    public BigInteger shiftLeft(int shiftval) {
        return new BigInteger(com.ibm.oti.util.math.BigInteger.shlImpl(this.data, shiftval));
    }

    public BigInteger subtract(BigInteger val) {
        return new BigInteger(com.ibm.oti.util.math.BigInteger.subImpl(this.data, val.data));
    }

    public BigInteger multiply(BigInteger val) {
        return new BigInteger(com.ibm.oti.util.math.BigInteger.mulImpl(this.data, val.data));
    }

    final BigInteger multiplyByTen() {
        return this.shiftLeft(1).add(this.shiftLeft(3));
    }

    public BigInteger divide(BigInteger val) {
        if (val.data.length == 1 && val.data[0] == 0L) {
            throw new ArithmeticException(Msg.getString("K0407"));
        }
        return new BigInteger(com.ibm.oti.util.math.BigInteger.divImpl(this.data, val.data));
    }

    public BigInteger remainder(BigInteger val) {
        if (val.data.length == 1 && val.data[0] == 0L) {
            throw new ArithmeticException(Msg.getString("K0407"));
        }
        return new BigInteger(com.ibm.oti.util.math.BigInteger.remImpl(this.data, val.data));
    }

    public BigInteger mod(BigInteger val) {
        if (val.signum() <= 0) {
            throw new ArithmeticException(Msg.getString("K0408"));
        }
        BigInteger temp = new BigInteger(com.ibm.oti.util.math.BigInteger.remImpl(this.data, val.data));
        if (temp.signum() == -1) {
            temp.data = com.ibm.oti.util.math.BigInteger.addImpl(temp.data, val.data);
        }
        return temp;
    }

    public BigInteger[] divideAndRemainder(BigInteger val) {
        if (val.data.length == 1 && val.data[0] == 0L) {
            throw new ArithmeticException(Msg.getString("K0407"));
        }
        BigInteger[] ar = new BigInteger[]{new BigInteger(com.ibm.oti.util.math.BigInteger.divImpl(this.data, val.data)), new BigInteger(com.ibm.oti.util.math.BigInteger.remImpl(this.data, val.data))};
        return ar;
    }

    public BigInteger(String val) {
        this(val, 10);
    }

    public BigInteger(String val, int radix) {
        int max = val.length() - 1;
        if (radix < 2 || radix > 36) {
            throw new NumberFormatException(Msg.getString("K040d"));
        }
        if (max < 0) {
            throw new NumberFormatException(Msg.getString("K040e"));
        }
        this.data = BigInteger.ZERO.data;
        long[] bigRadix = new long[]{radix};
        long[] digitAr = new long[1];
        boolean negative = val.charAt(0) == '-';
        int at = negative ? 1 : 0;
        while (at <= max) {
            int digit = Character.digit(val.charAt(at), radix);
            if (digit == -1) {
                throw new NumberFormatException(val);
            }
            this.data = com.ibm.oti.util.math.BigInteger.mulImpl(this.data, bigRadix);
            if (digit != 0) {
                digitAr[0] = digit;
                this.data = com.ibm.oti.util.math.BigInteger.addImpl(this.data, digitAr);
            }
            ++at;
        }
        this.normalize();
        if (negative) {
            this.data = com.ibm.oti.util.math.BigInteger.negImpl(this.data);
        }
    }

    public String toString() {
        return this.toString(10);
    }

    public String toString(int radix) {
        int count;
        BigInteger temp;
        if (radix < 2 || radix > 36) {
            radix = 10;
        }
        BigInteger bigRadix = BigInteger.valueOf(radix);
        if (this.equals(ZERO)) {
            return "0";
        }
        boolean negative = this.signum() < 0;
        if (negative) {
            temp = this.negate();
            count = 2;
        } else {
            temp = this;
            count = 1;
        }
        BigInteger temp2 = temp;
        while (!(temp2 = temp2.divide(bigRadix)).equals(ZERO)) {
            ++count;
        }
        int i = count;
        char[] buffer = new char[i];
        do {
            BigInteger[] result = temp.divideAndRemainder(bigRadix);
            temp = result[0];
            buffer[--i] = Character.forDigit(result[1].intValue(), radix);
        } while (!temp.equals(ZERO));
        if (negative) {
            buffer[0] = 45;
        }
        return new String(buffer, 0, count);
    }

    public BigInteger max(BigInteger val) {
        return com.ibm.oti.util.math.BigInteger.compImpl(this.data, val.data) >= 0 ? this : val;
    }

    public BigInteger min(BigInteger val) {
        return com.ibm.oti.util.math.BigInteger.compImpl(this.data, val.data) <= 0 ? this : val;
    }

    public int hashCode() {
        long hash = 0L;
        int i = this.data.length - 1;
        while (i >= 0) {
            hash = hash * 31L + this.data[i];
            --i;
        }
        return (int)(hash ^ hash >>> 32);
    }

    public boolean testBit(int n) {
        if (n < 0) {
            throw new ArithmeticException(Msg.getString("K0006"));
        }
        int wordnum = n / 64;
        if (wordnum >= this.data.length) {
            return this.signum() == -1;
        }
        int bit = n % 64;
        return (this.data[wordnum] >> bit & 1L) == 1L;
    }

    public BigInteger setBit(int n) {
        if (n < 0) {
            throw new ArithmeticException(Msg.getString("K0006"));
        }
        int wordnum = n / 64;
        int bit = n % 64;
        int newlen = this.data.length;
        int sign = this.signum();
        if (wordnum >= this.data.length) {
            if (sign == -1) {
                return this;
            }
            newlen = wordnum + (bit == 63 ? 2 : 1);
        } else {
            if ((this.data[wordnum] >> bit & 1L) == 1L) {
                return this;
            }
            if (bit == 63 && wordnum == this.data.length - 1 && sign >= 0) {
                ++newlen;
            }
        }
        long[] newdata = new long[newlen];
        System.arraycopy((Object)this.data, 0, (Object)newdata, 0, this.data.length);
        int n2 = wordnum;
        newdata[n2] = newdata[n2] | 1L << bit;
        return new BigInteger(newdata).normalize();
    }

    public BigInteger clearBit(int n) {
        if (n < 0) {
            throw new ArithmeticException(Msg.getString("K0006"));
        }
        int wordnum = n / 64;
        int bit = n % 64;
        int newlen = this.data.length;
        int sign = this.signum();
        if (wordnum >= this.data.length) {
            if (sign >= 0) {
                return this;
            }
            newlen = wordnum + (bit == 63 ? 2 : 1);
        } else {
            if ((this.data[wordnum] >> bit & 1L) == 0L) {
                return this;
            }
            if (bit == 63 && wordnum == this.data.length - 1 && sign < 0) {
                ++newlen;
            }
        }
        long[] newdata = new long[newlen];
        System.arraycopy((Object)this.data, 0, (Object)newdata, 0, this.data.length);
        long extend = sign < 0 ? -1 : 0;
        int i = this.data.length;
        while (i < newlen) {
            newdata[i] = extend;
            ++i;
        }
        int n2 = wordnum;
        newdata[n2] = newdata[n2] ^ 1L << bit;
        return new BigInteger(newdata).normalize();
    }

    public BigInteger flipBit(int n) {
        return this.testBit(n) ? this.clearBit(n) : this.setBit(n);
    }

    /*
     * Unable to fully structure code
     */
    public BigInteger and(BigInteger val) {
        block6: {
            block5: {
                longer = this.data;
                longlen = longer.length;
                shorter = val.data;
                shortlen = shorter.length;
                if (longlen != shortlen) break block5;
                temp = new long[longlen];
                i = 0;
                while (i < longlen) {
                    temp[i] = longer[i] & shorter[i];
                    ++i;
                }
                break block6;
            }
            if (longlen < shortlen) {
                swaptemp = longer;
                longer = shorter;
                shorter = swaptemp;
                swapint = longlen;
                longlen = shortlen;
                shortlen = swapint;
            }
            temp = new long[longlen];
            i = 0;
            while (i < shortlen) {
                temp[i] = longer[i] & shorter[i];
                ++i;
            }
            if (shorter[shortlen - 1] >= 0L) ** GOTO lbl35
            while (i < longlen) {
                temp[i] = longer[i];
                ++i;
            }
            break block6;
lbl-1000:
            // 1 sources

            {
                temp[i] = 0L;
                ++i;
lbl35:
                // 2 sources

                ** while (i < longlen)
            }
        }
        return new BigInteger(temp).normalize();
    }

    /*
     * Unable to fully structure code
     */
    public BigInteger or(BigInteger val) {
        block6: {
            block5: {
                longer = this.data;
                longlen = longer.length;
                shorter = val.data;
                shortlen = shorter.length;
                if (longlen != shortlen) break block5;
                temp = new long[longlen];
                i = 0;
                while (i < longlen) {
                    temp[i] = longer[i] | shorter[i];
                    ++i;
                }
                break block6;
            }
            if (longlen < shortlen) {
                swaptemp = longer;
                longer = shorter;
                shorter = swaptemp;
                swapint = longlen;
                longlen = shortlen;
                shortlen = swapint;
            }
            temp = new long[longlen];
            i = 0;
            while (i < shortlen) {
                temp[i] = longer[i] | shorter[i];
                ++i;
            }
            if (shorter[shortlen - 1] >= 0L) ** GOTO lbl35
            while (i < longlen) {
                temp[i] = -1L;
                ++i;
            }
            break block6;
lbl-1000:
            // 1 sources

            {
                temp[i] = longer[i];
                ++i;
lbl35:
                // 2 sources

                ** while (i < longlen)
            }
        }
        return new BigInteger(temp).normalize();
    }

    /*
     * Unable to fully structure code
     */
    public BigInteger xor(BigInteger val) {
        block6: {
            block5: {
                longer = this.data;
                longlen = longer.length;
                shorter = val.data;
                shortlen = shorter.length;
                if (longlen != shortlen) break block5;
                temp = new long[longlen];
                i = 0;
                while (i < longlen) {
                    temp[i] = longer[i] ^ shorter[i];
                    ++i;
                }
                break block6;
            }
            if (longlen < shortlen) {
                swaptemp = longer;
                longer = shorter;
                shorter = swaptemp;
                swapint = longlen;
                longlen = shortlen;
                shortlen = swapint;
            }
            temp = new long[longlen];
            i = 0;
            while (i < shortlen) {
                temp[i] = longer[i] ^ shorter[i];
                ++i;
            }
            if (shorter[shortlen - 1] >= 0L) ** GOTO lbl35
            while (i < longlen) {
                temp[i] = longer[i] ^ -1L;
                ++i;
            }
            break block6;
lbl-1000:
            // 1 sources

            {
                temp[i] = longer[i];
                ++i;
lbl35:
                // 2 sources

                ** while (i < longlen)
            }
        }
        return new BigInteger(temp).normalize();
    }

    public BigInteger not() {
        int len = this.data.length;
        long[] temp = new long[len];
        int i = 0;
        while (i < len) {
            temp[i] = this.data[i] ^ 0xFFFFFFFFFFFFFFFFL;
            ++i;
        }
        return new BigInteger(temp).normalize();
    }

    /*
     * Unable to fully structure code
     */
    public BigInteger andNot(BigInteger val) {
        block8: {
            block9: {
                block7: {
                    longer = this.data;
                    longlen = longer.length;
                    shorter = val.data;
                    shortlen = shorter.length;
                    if (longlen != shortlen) break block7;
                    temp = new long[longlen];
                    i = 0;
                    while (i < longlen) {
                        temp[i] = longer[i] & (shorter[i] ^ -1L);
                        ++i;
                    }
                    break block8;
                }
                if (longlen >= shortlen) break block9;
                temp = new long[shortlen];
                i = 0;
                while (i < longlen) {
                    temp[i] = (shorter[i] ^ -1L) & longer[i];
                    ++i;
                }
                if (longer[longlen - 1] >= 0L) ** GOTO lbl29
                while (i < shortlen) {
                    temp[i] = shorter[i] ^ -1L;
                    ++i;
                }
                break block8;
lbl-1000:
                // 1 sources

                {
                    temp[i] = 0L;
                    ++i;
lbl29:
                    // 2 sources

                    ** while (i < shortlen)
                }
lbl30:
                // 1 sources

                break block8;
            }
            temp = new long[longlen];
            i = 0;
            while (i < shortlen) {
                temp[i] = longer[i] & (shorter[i] ^ -1L);
                ++i;
            }
            if (shorter[shortlen - 1] >= 0L) ** GOTO lbl46
            while (i < longlen) {
                temp[i] = 0L;
                ++i;
            }
            break block8;
lbl-1000:
            // 1 sources

            {
                temp[i] = longer[i];
                ++i;
lbl46:
                // 2 sources

                ** while (i < longlen)
            }
        }
        return new BigInteger(temp).normalize();
    }

    public int bitLength() {
        int len = this.signum() >= 0 ? this.getHighestSetBit() : this.getHighestUnSetBit();
        return len + 1;
    }

    public int bitCount() {
        int bit;
        long tag;
        int sign = this.signum();
        if (sign == 0) {
            return 0;
        }
        int cnt = 0;
        if (sign > 0) {
            tag = 0L;
            bit = 1;
        } else {
            tag = -1L;
            bit = 0;
        }
        int i = this.data.length;
        while (--i >= 0) {
            long work = this.data[i];
            if (work == tag) continue;
            int j = 0;
            while (j < 64) {
                if ((work & 1L) == (long)bit) {
                    ++cnt;
                }
                work >>>= 1;
                ++j;
            }
        }
        return cnt;
    }

    public double doubleValue() {
        if (this.signum() > 0) {
            int bitLength = this.bitLength();
            long e = bitLength - 53 + 1075;
            if (e >= 2047L) {
                return Double.POSITIVE_INFINITY;
            }
            e <<= 52;
            long m = 0L;
            if (bitLength < 53) {
                m = this.data[0] << 53 - bitLength;
            } else if (bitLength > 53) {
                m = this.shiftRight((int)(bitLength - 53)).data[0];
                if (this.testBit(bitLength - 54) && (this.getLowestSetBit() != bitLength - 54 || (m & 1L) == 1L) && (++m & 0xFFFFFFFFFFFFFL) == 0L) {
                    if (e != 0x7FF0000000000000L) {
                        m >>= 1;
                        e += 0x10000000000000L;
                    } else {
                        m = 0xFFFFFFFFFFFFFL;
                    }
                }
            } else {
                m = this.data[0];
            }
            m = m & 0xFFFFFFFFFFFFFL | e;
            return Double.longBitsToDouble(m);
        }
        if (this.signum() < 0) {
            return -this.negate().doubleValue();
        }
        return 0.0;
    }

    public float floatValue() {
        return (float)this.doubleValue();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        ObjectOutputStream.PutField fields = stream.putFields();
        fields.put("bitCount", -1);
        fields.put("bitLength", -1);
        fields.put("firstNonzeroByteNum", -2);
        fields.put("lowestSetBit", -2);
        int signum = this.signum();
        byte[] bytes = signum == -1 ? this.negate().toByteArray() : this.toByteArray();
        if (bytes[0] == 0) {
            byte[] b = new byte[bytes.length - 1];
            System.arraycopy((Object)bytes, 1, (Object)b, 0, b.length);
            bytes = b;
        }
        fields.put("magnitude", bytes);
        fields.put("signum", signum);
        stream.writeFields();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = stream.readFields();
        byte[] bytes = (byte[])fields.get("magnitude", null);
        int signum = fields.get("signum", 0);
        this.fromBytes(signum, bytes);
    }
}

