/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.ObjectStreamException;
import java.net.InetAddress;

public final class Inet4Address
extends InetAddress {
    private static final long serialVersionUID = 3286316764910316507L;

    Inet4Address(byte[] address) {
        this.ipaddress = address;
    }

    Inet4Address(byte[] address, String name) {
        this.ipaddress = address;
        this.hostName = name;
    }

    public boolean isMulticastAddress() {
        return (this.ipaddress[0] & 0xF0) == 224;
    }

    public boolean isAnyLocalAddress() {
        int i = 0;
        while (i < this.ipaddress.length) {
            if (this.ipaddress[i] != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isLoopbackAddress() {
        return (this.ipaddress[0] & 0xFF) == 127;
    }

    public boolean isLinkLocalAddress() {
        return (this.ipaddress[0] & 0xFF) == 169 && (this.ipaddress[1] & 0xFF) == 254;
    }

    public boolean isSiteLocalAddress() {
        return (this.ipaddress[0] & 0xFF) == 10 || (this.ipaddress[0] & 0xFF) == 172 && (this.ipaddress[1] & 0xFF) > 15 && (this.ipaddress[1] & 0xFF) < 32 || (this.ipaddress[0] & 0xFF) == 192 && (this.ipaddress[1] & 0xFF) == 168;
    }

    public boolean isMCGlobal() {
        if (!this.isMulticastAddress()) {
            return false;
        }
        int address = InetAddress.bytesToInt(this.ipaddress, 0);
        if (address >>> 8 < 0xE00001) {
            return false;
        }
        return address >>> 24 <= 238;
    }

    public boolean isMCNodeLocal() {
        return false;
    }

    public boolean isMCLinkLocal() {
        return InetAddress.bytesToInt(this.ipaddress, 0) >>> 8 == 0xE00000;
    }

    public boolean isMCSiteLocal() {
        return InetAddress.bytesToInt(this.ipaddress, 0) >>> 16 == 61439;
    }

    public boolean isMCOrgLocal() {
        int prefix = InetAddress.bytesToInt(this.ipaddress, 0) >>> 16;
        return prefix >= 61376 && prefix <= 61379;
    }

    public String getHostAddress() {
        String hostAddress = "";
        int i = 0;
        while (i < 4) {
            hostAddress = String.valueOf(hostAddress) + (this.ipaddress[i] & 0xFF);
            if (i != 3) {
                hostAddress = String.valueOf(hostAddress) + ".";
            }
            ++i;
        }
        return hostAddress;
    }

    public int hashCode() {
        return InetAddress.bytesToInt(this.ipaddress, 0);
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    private Object writeReplace() throws ObjectStreamException {
        return new InetAddress(this.ipaddress, this.hostName);
    }
}

