/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;

public class InetSocketAddress
extends SocketAddress {
    private static final long serialVersionUID = 5076001401234631237L;
    private String hostName;
    private InetAddress addr;
    private int port;

    public InetSocketAddress(int port) {
        this((InetAddress)null, port);
    }

    public InetSocketAddress(InetAddress address, int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException();
        }
        this.addr = address == null ? InetAddress.ANY : address;
        this.port = port;
    }

    public InetSocketAddress(String host, int port) {
        if (host == null || port < 0 || port > 65535) {
            throw new IllegalArgumentException();
        }
        this.port = port;
        try {
            this.addr = InetAddress.getByName(host);
        }
        catch (UnknownHostException unknownHostException) {
            this.hostName = host;
        }
    }

    public final int getPort() {
        return this.port;
    }

    public final InetAddress getAddress() {
        return this.addr;
    }

    public final String getHostName() {
        if (this.addr != null) {
            return this.addr.getHostName();
        }
        return this.hostName;
    }

    public final boolean isUnresolved() {
        return this.addr == null;
    }

    public String toString() {
        String host = this.addr != null ? this.addr.toString() : this.hostName;
        return String.valueOf(host) + ":" + this.port;
    }

    public final boolean equals(Object socketAddr) {
        if (this == socketAddr) {
            return true;
        }
        if (!(socketAddr instanceof InetSocketAddress)) {
            return false;
        }
        InetSocketAddress iSockAddr = (InetSocketAddress)socketAddr;
        if (this.port != iSockAddr.port) {
            return false;
        }
        if (this.addr == null && iSockAddr.addr == null) {
            return this.hostName.equals(iSockAddr.hostName);
        }
        if (this.addr == null) {
            return false;
        }
        return this.addr.equals(iSockAddr.addr);
    }

    public final int hashCode() {
        if (this.addr == null) {
            return this.hostName.hashCode() + this.port;
        }
        return this.addr.hashCode() + this.port;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.addr == null) {
            try {
                this.addr = InetAddress.getByName(this.hostName);
            }
            catch (UnknownHostException unknownHostException) {}
        }
    }
}

