/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import com.ibm.oti.net.www.protocol.jxe.JxeURLConnection;
import com.ibm.oti.util.AccessibleByteArrayInputStream;
import com.ibm.oti.util.InvalidJarIndexException;
import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.Jxe;
import com.ibm.oti.vm.JxeException;
import com.ibm.oti.vm.JxePermission;
import com.ibm.oti.vm.JxeUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public class URLClassLoader
extends SecureClassLoader {
    private static URL[] NO_PATH = new URL[0];
    private static Class JxeHandler;
    URL[] urls;
    URL[] orgUrls;
    private IdentityHashMap resCache = new IdentityHashMap(32);
    private URLStreamHandlerFactory factory;
    HashMap extensions;
    Hashtable[] indexes;
    private Hashtable jxeManifestCache = new Hashtable(8);
    private AccessControlContext currentContext = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public URLClassLoader(URL[] urls) {
        this(urls, ClassLoader.getSystemClassLoader(), null);
    }

    public URLClassLoader(URL[] urls, ClassLoader parent) {
        this(urls, parent, null);
    }

    protected void addURL(URL url) {
        try {
            URL search = this.createSearchURL(url);
            this.urls = this.addURL(this.urls, search);
            this.orgUrls = this.addURL(this.orgUrls, url);
            this.extensions.put(search, null);
        }
        catch (MalformedURLException malformedURLException) {}
    }

    URL[] addURL(URL[] urlArray, URL url) {
        URL[] newPath = new URL[urlArray.length + 1];
        System.arraycopy((Object)urlArray, 0, (Object)newPath, 0, urlArray.length);
        newPath[urlArray.length] = url;
        Hashtable[] newIndexes = new Hashtable[this.indexes.length + 1];
        System.arraycopy((Object)this.indexes, 0, (Object)newIndexes, 0, this.indexes.length);
        this.indexes = newIndexes;
        return newPath;
    }

    public Enumeration findResources(final String name) throws IOException {
        SecurityManager sm;
        if (name == null) {
            return null;
        }
        Vector result = (Vector)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return URLClassLoader.this.findResources(URLClassLoader.this.urls, name, new Vector());
            }
        }, this.currentContext);
        int length = result.size();
        if (length > 0 && (sm = System.getSecurityManager()) != null) {
            Vector reduced = new Vector(length);
            int i = 0;
            while (i < length) {
                URL url = (URL)result.elementAt(i);
                try {
                    sm.checkPermission(url.openConnection().getPermission());
                    reduced.addElement(url);
                }
                catch (IOException iOException) {
                }
                catch (SecurityException securityException) {}
                ++i;
            }
            result = reduced;
        }
        return result.elements();
    }

    Vector findResources(URL[] searchURLs, String name, Vector result) {
        boolean findInExtensions = searchURLs == this.urls;
        int i = 0;
        while (i < searchURLs.length) {
            if (searchURLs[i] != null) {
                URL[] search = new URL[]{searchURLs[i]};
                URL res = this.findResourceImpl(search, name);
                if (search[0] == null) {
                    searchURLs[i] = null;
                } else {
                    if (res != null && !result.contains(res)) {
                        result.addElement(res);
                    }
                    if (findInExtensions) {
                        this.findInExtensions(this.explore(searchURLs[i], i), name, i, result, false);
                    }
                }
            }
            ++i;
        }
        return result;
    }

    Object findInIndex(int i, String name, Vector resources, boolean url) {
        Hashtable index = this.indexes[i];
        if (index != null) {
            String indexedName;
            int pos = name.lastIndexOf("/");
            String string = indexedName = pos > 0 ? name.substring(0, pos) : name;
            if (resources != null) {
                URL[] jarURLs = (URL[])index.get(indexedName);
                if (jarURLs != null) {
                    this.findResources(jarURLs, name, resources);
                }
            } else if (url) {
                URL[] jarURLs = (URL[])index.get(indexedName);
                if (jarURLs != null) {
                    return this.findResourceImpl(jarURLs, name);
                }
            } else {
                URL[] jarURLs;
                String partialName = name.replace('.', '/');
                boolean fullMatch = false;
                int position = partialName.lastIndexOf(47);
                if (position != -1) {
                    String packageName = partialName.substring(0, position);
                    jarURLs = (URL[])index.get(packageName);
                } else {
                    String className = String.valueOf(partialName) + ".class";
                    jarURLs = (URL[])index.get(className);
                    fullMatch = true;
                }
                if (jarURLs != null) {
                    Class c = this.findClassImpl(jarURLs, name);
                    if (c == null && fullMatch) {
                        throw new InvalidJarIndexException();
                    }
                    return c;
                }
            }
        }
        return null;
    }

    Object findInExtensions(URL[] newExtensions, String name, int i, Vector resources, boolean url) {
        if (newExtensions != null) {
            int k = 0;
            while (k < newExtensions.length) {
                if (newExtensions[k] != null) {
                    URL[] search = new URL[]{newExtensions[k]};
                    if (resources != null) {
                        URL res = this.findResourceImpl(search, name);
                        if (search[0] == null) {
                            newExtensions[k] = null;
                        } else {
                            if (res != null && !resources.contains(res)) {
                                resources.addElement(res);
                            }
                            this.findInExtensions(this.explore(newExtensions[k], i), name, i, resources, url);
                        }
                    } else {
                        Object result = url ? this.findResourceImpl(search, name) : this.findClassImpl(search, name);
                        if (result != null) {
                            return result;
                        }
                        if (search[0] == null) {
                            newExtensions[k] = null;
                        } else {
                            result = this.findInExtensions(this.explore(newExtensions[k], i), name, i, resources, url);
                            if (result != null) {
                                return result;
                            }
                        }
                    }
                }
                ++k;
            }
        } else {
            return this.findInIndex(i, name, resources, url);
        }
        return null;
    }

    private static byte[] getBytes(InputStream is, boolean readAvailable) throws IOException {
        int count;
        if (readAvailable) {
            if (is instanceof AccessibleByteArrayInputStream) {
                return ((AccessibleByteArrayInputStream)is).getByteArray();
            }
            byte[] buf = new byte[is.available()];
            is.read(buf, 0, buf.length);
            is.close();
            return buf;
        }
        byte[] buf = new byte[4096];
        int size = is.available();
        if (size < 1024) {
            size = 1024;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream(size);
        while ((count = is.read(buf)) > 0) {
            bos.write(buf, 0, count);
        }
        return bos.toByteArray();
    }

    protected PermissionCollection getPermissions(CodeSource codesource) {
        PermissionCollection pc = super.getPermissions(codesource);
        URL u = codesource.getLocation();
        if (u.getProtocol().equals("jar")) {
            try {
                u = ((JarURLConnection)u.openConnection()).getJarFileURL();
            }
            catch (IOException iOException) {}
        }
        if (u.getProtocol().equals("file")) {
            String path = u.getFile();
            String host = u.getHost();
            if (host != null && host.length() > 0) {
                path = "//" + host + path;
            }
            if (File.separatorChar != '/') {
                path = path.replace('/', File.separatorChar);
            }
            if (URLClassLoader.isDirectory(u)) {
                pc.add(new FilePermission(String.valueOf(path) + "-", "read"));
            } else {
                pc.add(new FilePermission(path, "read"));
            }
        } else if (u.getProtocol().equals("jxe")) {
            pc.add(new JxePermission(u.getHost()));
        } else {
            String host = u.getHost();
            if (host.length() == 0) {
                host = "localhost";
            }
            pc.add(new SocketPermission(host, "connect, accept"));
        }
        return pc;
    }

    public URL[] getURLs() {
        return this.orgUrls;
    }

    private static boolean isDirectory(URL url) {
        String file = url.getFile();
        return file.length() > 0 && file.charAt(file.length() - 1) == '/';
    }

    public static URLClassLoader newInstance(final URL[] urls) {
        URLClassLoader sub = (URLClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new SubURLClassLoader(urls);
            }
        });
        sub.currentContext = AccessController.getContext();
        return sub;
    }

    public static URLClassLoader newInstance(final URL[] urls, final ClassLoader parentCl) {
        URLClassLoader sub = (URLClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new SubURLClassLoader(urls, parentCl);
            }
        });
        sub.currentContext = AccessController.getContext();
        return sub;
    }

    public URLClassLoader(URL[] searchUrls, ClassLoader parent, URLStreamHandlerFactory factory) {
        super(parent);
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkCreateClassLoader();
        }
        this.factory = factory;
        this.currentContext = AccessController.getContext();
        int nbUrls = searchUrls.length;
        this.urls = new URL[nbUrls];
        this.orgUrls = new URL[nbUrls];
        this.extensions = new HashMap(nbUrls * 2);
        int i = 0;
        while (i < nbUrls) {
            try {
                this.urls[i] = this.createSearchURL(searchUrls[i]);
                this.extensions.put(this.urls[i], null);
            }
            catch (MalformedURLException malformedURLException) {}
            this.orgUrls[i] = searchUrls[i];
            ++i;
        }
        this.indexes = new Hashtable[nbUrls];
    }

    protected Class findClass(final String clsName) throws ClassNotFoundException {
        Class cls = (Class)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return URLClassLoader.this.findClassImpl(URLClassLoader.this.urls, clsName);
            }
        }, this.currentContext);
        if (cls != null) {
            return cls;
        }
        throw new ClassNotFoundException(clsName);
    }

    private URL createSearchURL(URL url) throws MalformedURLException {
        if (url == null) {
            return url;
        }
        String protocol = url.getProtocol();
        if (protocol.equals("jxe")) {
            try {
                Jxe jxe = ((JxeURLConnection)url.openConnection()).getJxe();
                JxeUtil.romImageLoad(jxe, this);
            }
            catch (IOException e) {
                throw new MalformedURLException(e.toString());
            }
            catch (JxeException e) {
                throw new MalformedURLException(e.toString());
            }
            return url;
        }
        if (URLClassLoader.isDirectory(url) || protocol.equals("jar")) {
            return url;
        }
        if (this.factory == null) {
            return new URL("jar", "", -1, String.valueOf(url.toString()) + "!/");
        }
        return new URL("jar", "", -1, String.valueOf(url.toString()) + "!/", this.factory.createURLStreamHandler(protocol));
    }

    public URL findResource(final String name) {
        SecurityManager sm;
        if (name == null) {
            return null;
        }
        URL result = (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return URLClassLoader.this.findResourceImpl(URLClassLoader.this.urls, name);
            }
        }, this.currentContext);
        if (result != null && (sm = System.getSecurityManager()) != null) {
            try {
                sm.checkPermission(result.openConnection().getPermission());
            }
            catch (IOException iOException) {
                return null;
            }
            catch (SecurityException securityException) {
                return null;
            }
        }
        return result;
    }

    URL findResourceImpl(URL[] searchList, String resName) {
        boolean findInExtensions = searchList == this.urls;
        int i = 0;
        while (i < searchList.length) {
            if (searchList[i] != null) {
                URL result;
                JarFile jf;
                block24: {
                    jf = null;
                    try {
                        URL currentUrl = searchList[i];
                        String protocol = currentUrl.getProtocol();
                        if (protocol.equals("jar")) {
                            String entryName;
                            jf = (JarFile)this.resCache.get(currentUrl);
                            if (jf == null) {
                                URL jarURL = ((JarURLConnection)currentUrl.openConnection()).getJarFileURL();
                                try {
                                    JarURLConnection juc = (JarURLConnection)new URL("jar", "", String.valueOf(jarURL.toExternalForm()) + "!/").openConnection();
                                    jf = juc.getJarFile();
                                    this.resCache.put(currentUrl, jf);
                                }
                                catch (IOException e) {
                                    searchList[i] = null;
                                    throw e;
                                }
                            }
                            if (currentUrl.getFile().endsWith("!/")) {
                                entryName = resName;
                            } else {
                                String file = currentUrl.getFile();
                                int sepIdx = file.lastIndexOf("!/");
                                if (sepIdx == -1) {
                                    searchList[i] = null;
                                    continue;
                                }
                                entryName = new StringBuffer(file.length() - (sepIdx += 2) + resName.length()).append(file.substring(sepIdx)).append(resName).toString();
                            }
                            if (jf.getEntry(entryName) != null) {
                                return this.targetURL(currentUrl, resName);
                            }
                            break block24;
                        }
                        if (protocol.equals("file")) {
                            String baseFile = currentUrl.getFile();
                            String host = currentUrl.getHost();
                            int hostLength = 0;
                            if (host != null) {
                                hostLength = host.length();
                            }
                            StringBuffer buf = new StringBuffer(2 + hostLength + baseFile.length() + resName.length());
                            if (hostLength > 0) {
                                buf.append("//").append(host);
                            }
                            buf.append(baseFile);
                            String fixedResName = resName;
                            while (fixedResName.startsWith("/") || fixedResName.startsWith("\\")) {
                                fixedResName = fixedResName.substring(1);
                            }
                            buf.append(fixedResName);
                            String filename = buf.toString();
                            if (new File(filename).exists()) {
                                return this.targetURL(currentUrl, fixedResName);
                            }
                            break block24;
                        }
                        URL resURL = this.targetURL(currentUrl, resName);
                        URLConnection uc = resURL.openConnection();
                        try {
                            uc.getInputStream().close();
                        }
                        catch (SecurityException securityException) {
                            return null;
                        }
                        if (!resURL.getProtocol().equals("http")) {
                            return resURL;
                        }
                        int code = ((HttpURLConnection)uc).getResponseCode();
                        if (code >= 200 && code < 300) {
                            return resURL;
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                    }
                    catch (IOException iOException) {
                    }
                    catch (SecurityException securityException) {}
                }
                if (jf != null && findInExtensions && (this.indexes[i] != null ? (result = (URL)this.findInIndex(i, resName, null, true)) != null : (result = (URL)this.findInExtensions(this.explore(searchList[i], i), resName, i, null, true)) != null)) {
                    return result;
                }
            }
            ++i;
        }
        return null;
    }

    protected Package definePackage(String packageName, Manifest manifest, URL url) throws IllegalArgumentException {
        String implementationVendor;
        String implementationVersion;
        String implementationTitle;
        String specificationVendor;
        String specificationVersion;
        String specificationTitle;
        Attributes mainAttributes = manifest.getMainAttributes();
        String dirName = String.valueOf(packageName.replace('.', '/')) + "/";
        Attributes packageAttributes = manifest.getAttributes(dirName);
        boolean noEntry = false;
        if (packageAttributes == null) {
            noEntry = true;
            packageAttributes = mainAttributes;
        }
        if ((specificationTitle = packageAttributes.getValue(Attributes.Name.SPECIFICATION_TITLE)) == null && !noEntry) {
            specificationTitle = mainAttributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
        }
        if ((specificationVersion = packageAttributes.getValue(Attributes.Name.SPECIFICATION_VERSION)) == null && !noEntry) {
            specificationVersion = mainAttributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
        }
        if ((specificationVendor = packageAttributes.getValue(Attributes.Name.SPECIFICATION_VENDOR)) == null && !noEntry) {
            specificationVendor = mainAttributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
        }
        if ((implementationTitle = packageAttributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE)) == null && !noEntry) {
            implementationTitle = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
        }
        if ((implementationVersion = packageAttributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION)) == null && !noEntry) {
            implementationVersion = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
        }
        if ((implementationVendor = packageAttributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR)) == null && !noEntry) {
            implementationVendor = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
        }
        return this.definePackage(packageName, specificationTitle, specificationVersion, specificationVendor, implementationTitle, implementationVersion, implementationVendor, this.isSealed(manifest, dirName) ? url : null);
    }

    private boolean isSealed(Manifest manifest, String dirName) {
        Attributes mainAttributes = manifest.getMainAttributes();
        String value = mainAttributes.getValue(Attributes.Name.SEALED);
        boolean sealed = value != null && value.toLowerCase().equals("true");
        Attributes attributes = manifest.getAttributes(dirName);
        if (attributes != null && (value = attributes.getValue(Attributes.Name.SEALED)) != null) {
            sealed = value.toLowerCase().equals("true");
        }
        return sealed;
    }

    private URL[] getInternalURLs(URL root, String classpath) {
        StringTokenizer tokenizer = new StringTokenizer(classpath);
        Vector addedURLs = new Vector();
        String file = root.getFile();
        file = file.substring(0, file.lastIndexOf("/", file.lastIndexOf("!/") - 1) + 1);
        String protocol = root.getProtocol();
        String host = root.getHost();
        int port = root.getPort();
        while (tokenizer.hasMoreElements()) {
            String element = tokenizer.nextToken();
            if (element.equals("")) continue;
            try {
                URL newURL = new URL(protocol, host, port, String.valueOf(file) + element + "!/");
                if (this.extensions.containsKey(newURL)) continue;
                this.extensions.put(newURL, null);
                addedURLs.add(newURL);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        URL[] newURLs = (URL[])addedURLs.toArray(new URL[0]);
        return newURLs;
    }

    private ArrayList readLines(InputStream in) throws IOException {
        int next;
        byte[] buff = new byte[144];
        ArrayList lines = new ArrayList();
        int pos = 0;
        while ((next = in.read()) != -1) {
            if (next == 10) {
                lines.add(new String(buff, 0, pos, "UTF8"));
                pos = 0;
                continue;
            }
            if (next == 13) {
                lines.add(new String(buff, 0, pos, "UTF8"));
                pos = 0;
                next = in.read();
                if (next == 10) continue;
            }
            if (pos == buff.length) {
                byte[] newBuf = new byte[buff.length * 2];
                System.arraycopy((Object)buff, 0, (Object)newBuf, 0, buff.length);
                buff = newBuf;
            }
            buff[pos++] = (byte)next;
        }
        if (pos > 0) {
            lines.add(new String(buff, 0, pos, "UTF8"));
        }
        return lines;
    }

    private URL targetURL(URL base, String name) throws MalformedURLException {
        String file = new StringBuffer(base.getFile().length() + name.length()).append(base.getFile()).append(name).toString();
        if (JxeHandler == null) {
            try {
                Class clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.ibm.oti.net.www.protocol.jxe.Handler");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                JxeHandler = clazz;
            }
            catch (Throwable throwable) {
                Class clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.Object");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                JxeHandler = clazz;
            }
        }
        URLStreamHandler handler = null;
        if (base.getStreamHandler().getClass() == JxeHandler) {
            handler = base.getStreamHandler();
        }
        return new URL(base.getProtocol(), base.getHost(), base.getPort(), file, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Class findClassImpl(URL[] searchURLs, String clsName) {
        boolean readAvailable = false;
        boolean findInExtensions = searchURLs == this.urls;
        String name = clsName.replace('.', '/') + ".class";
        int i = 0;
        while (i < searchURLs.length) {
            block39: {
                if (searchURLs[i] != null) {
                    Class c;
                    byte[] clBuf;
                    Jxe jxe;
                    JarFile jf;
                    JarEntry entry;
                    InputStream is;
                    Manifest manifest;
                    block40: {
                        manifest = null;
                        is = null;
                        entry = null;
                        jf = null;
                        jxe = null;
                        clBuf = null;
                        try {
                            URL thisURL = searchURLs[i];
                            String protocol = thisURL.getProtocol();
                            if (protocol.equals("jar")) {
                                jf = (JarFile)this.resCache.get(thisURL);
                                if (jf == null) {
                                    URL jarURL = ((JarURLConnection)thisURL.openConnection()).getJarFileURL();
                                    try {
                                        JarURLConnection juc = (JarURLConnection)new URL("jar", "", String.valueOf(jarURL.toExternalForm()) + "!/").openConnection();
                                        jf = juc.getJarFile();
                                        this.resCache.put(thisURL, jf);
                                    }
                                    catch (IOException e) {
                                        searchURLs[i] = null;
                                        throw e;
                                    }
                                }
                                if (thisURL.getFile().endsWith("!/")) {
                                    entry = jf.getJarEntry(name);
                                } else {
                                    String file = thisURL.getFile();
                                    int sepIdx = file.lastIndexOf("!/");
                                    if (sepIdx == -1) {
                                        searchURLs[i] = null;
                                        break block39;
                                    }
                                    String entryName = new StringBuffer(file.length() - (sepIdx += 2) + name.length()).append(file.substring(sepIdx)).append(name).toString();
                                    entry = jf.getJarEntry(entryName);
                                }
                                if (entry != null) {
                                    readAvailable = true;
                                    is = jf.getInputStream(entry);
                                    manifest = jf.getManifest();
                                }
                                break block40;
                            }
                            if (protocol.equals("jxe")) {
                                jxe = ((JxeURLConnection)thisURL.openConnection()).getJxe();
                                if (jxe != null) {
                                    clBuf = JxeUtil.getRomClass(jxe, clsName);
                                    if (clBuf != null) {
                                        InputStream manIn;
                                        manifest = (Manifest)this.jxeManifestCache.get(jxe);
                                        if (manifest == null && (manIn = jxe.getResourceAsStream("META-INF/MANIFEST.MF")) != null) {
                                            manifest = new Manifest(manIn);
                                            manIn.close();
                                            this.jxeManifestCache.put(jxe, manifest);
                                        }
                                    } else {
                                        jxe = null;
                                    }
                                }
                                break block40;
                            }
                            if (protocol.equals("file")) {
                                String filename = thisURL.getFile();
                                String host = thisURL.getHost();
                                filename = host != null && host.length() > 0 ? new StringBuffer(host.length() + filename.length() + name.length() + 2).append("//").append(host).append(filename).append(name).toString() : new StringBuffer(filename.length() + name.length()).append(filename).append(name).toString();
                                File file = new File(filename);
                                if (!file.exists()) break block39;
                                is = new FileInputStream(file);
                                readAvailable = true;
                                break block40;
                            }
                            is = this.targetURL(thisURL, name).openStream();
                        }
                        catch (MalformedURLException malformedURLException) {
                        }
                        catch (IOException iOException) {}
                    }
                    if (is != null || jxe != null) {
                        URL codeSourceURL = null;
                        Certificate[] certificates = null;
                        CodeSource codeS = null;
                        try {
                            codeSourceURL = findInExtensions ? this.orgUrls[i] : ((JarURLConnection)searchURLs[i].openConnection()).getJarFileURL();
                        }
                        catch (IOException iOException) {
                            codeSourceURL = searchURLs[i];
                        }
                        if (is != null) {
                            try {
                                clBuf = URLClassLoader.getBytes(is, readAvailable);
                                is.close();
                            }
                            catch (IOException iOException) {
                                return null;
                            }
                        }
                        if (entry != null) {
                            certificates = entry.getCertificates();
                        }
                        codeS = new CodeSource(codeSourceURL, certificates);
                        int dotIndex = clsName.lastIndexOf(".");
                        if (dotIndex != -1) {
                            String packageName = clsName.substring(0, dotIndex);
                            URLClassLoader uRLClassLoader = this;
                            synchronized (uRLClassLoader) {
                                Package packageObj = this.getPackage(packageName);
                                if (packageObj == null) {
                                    if (manifest != null) {
                                        this.definePackage(packageName, manifest, codeSourceURL);
                                    } else {
                                        this.definePackage(packageName, null, null, null, null, null, null, null);
                                    }
                                } else {
                                    boolean exception = false;
                                    if (manifest != null) {
                                        String dirName = String.valueOf(packageName.replace('.', '/')) + "/";
                                        if (this.isSealed(manifest, dirName)) {
                                            exception = !packageObj.isSealed(codeSourceURL);
                                        }
                                    } else {
                                        exception = packageObj.isSealed();
                                    }
                                    if (exception) {
                                        throw new SecurityException(Msg.getString("K004c"));
                                    }
                                }
                            }
                        }
                        return this.defineClass(clsName, clBuf, 0, clBuf.length, codeS);
                    }
                    if (jf != null && findInExtensions && (this.indexes[i] != null ? (c = (Class)this.findInIndex(i, clsName, null, false)) != null : (c = (Class)this.findInExtensions(this.explore(searchURLs[i], i), clsName, i, null, false)) != null)) {
                        return c;
                    }
                }
            }
            ++i;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    URL[] explore(URL url, int indexNumber) {
        URL[] internal;
        HashMap hashMap = this.extensions;
        synchronized (hashMap) {
            internal = (URL[])this.extensions.get(url);
        }
        if (internal != null) {
            return internal;
        }
        if (this.indexes[indexNumber] != null) {
            return null;
        }
        if (!url.getProtocol().equals("jar")) {
            return null;
        }
        JarFile jf = (JarFile)this.resCache.get(url);
        ZipEntry ze = jf.getEntry("META-INF/INDEX.LIST");
        if (ze != null) {
            if (url.equals(this.urls[indexNumber])) {
                try {
                    Hashtable index = new Hashtable(15);
                    InputStream indexIS = jf.getInputStream(ze);
                    ArrayList lines = this.readLines(indexIS);
                    indexIS.close();
                    ListIterator iterator = lines.listIterator();
                    iterator.next();
                    iterator.next();
                    URL fileURL = ((JarURLConnection)url.openConnection()).getJarFileURL();
                    String file = fileURL.getFile();
                    String parentFile = new File(file).getParent();
                    parentFile = parentFile.replace(File.separatorChar, '/');
                    if (parentFile.charAt(0) != '/') {
                        parentFile = "/" + parentFile;
                    }
                    URL parentURL = new URL(fileURL.getProtocol(), fileURL.getHost(), fileURL.getPort(), parentFile);
                    while (iterator.hasNext()) {
                        URL jar = new URL("jar:" + parentURL.toExternalForm() + "/" + (String)iterator.next() + "!/");
                        String resource = null;
                        while (iterator.hasNext() && !(resource = (String)iterator.next()).equals("")) {
                            URL[] jars;
                            if (index.containsKey(resource)) {
                                jars = (URL[])index.get(resource);
                                URL[] newJars = new URL[jars.length + 1];
                                System.arraycopy((Object)jars, 0, (Object)newJars, 0, jars.length);
                                newJars[jars.length] = jar;
                                index.put(resource, newJars);
                                continue;
                            }
                            jars = new URL[]{jar};
                            index.put(resource, jars);
                        }
                    }
                    this.indexes[indexNumber] = index;
                }
                catch (MalformedURLException malformedURLException) {
                }
                catch (IOException iOException) {}
            }
            return null;
        }
        Manifest manifest = null;
        try {
            manifest = jf.getManifest();
        }
        catch (IOException iOException) {}
        String classpath = null;
        if (manifest != null) {
            classpath = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
        }
        HashMap hashMap2 = this.extensions;
        synchronized (hashMap2) {
            internal = (URL[])this.extensions.get(url);
            if (internal == null) {
                internal = classpath != null ? this.getInternalURLs(url, classpath) : NO_PATH;
                this.extensions.put(url, internal);
            }
        }
        return internal;
    }

    static class SubURLClassLoader
    extends URLClassLoader {
        private boolean checkingPackageAccess = false;

        SubURLClassLoader(URL[] urls) {
            super(urls, ClassLoader.getSystemClassLoader());
        }

        SubURLClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        protected synchronized Class loadClass(String className, boolean resolveClass) throws ClassNotFoundException {
            int index;
            SecurityManager sm = System.getSecurityManager();
            if (sm != null && !this.checkingPackageAccess && (index = className.lastIndexOf(46)) > 0) {
                try {
                    this.checkingPackageAccess = true;
                    sm.checkPackageAccess(className.substring(0, index));
                }
                finally {
                    this.checkingPackageAccess = false;
                }
            }
            return super.loadClass(className, resolveClass);
        }
    }
}

