/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import com.ibm.oti.util.PriviAction;
import java.security.AccessController;
import java.security.Identity;
import java.security.KeyManagementException;
import java.security.Principal;
import java.security.PublicKey;
import java.util.Enumeration;

public abstract class IdentityScope
extends Identity {
    private static final long serialVersionUID = -2337346281189773310L;
    static IdentityScope systemScope;

    protected IdentityScope() {
    }

    public IdentityScope(String name) {
        super(name);
    }

    public IdentityScope(String name, IdentityScope scope) throws KeyManagementException {
        super(name, scope);
    }

    public abstract void addIdentity(Identity var1) throws KeyManagementException;

    public abstract void removeIdentity(Identity var1) throws KeyManagementException;

    public abstract Enumeration identities();

    public Identity getIdentity(Principal principal) {
        Enumeration en = this.identities();
        while (en.hasMoreElements()) {
            Identity current = (Identity)en.nextElement();
            if (!current.getName().equals(principal.getName())) continue;
            return current;
        }
        return null;
    }

    public abstract Identity getIdentity(PublicKey var1);

    public abstract Identity getIdentity(String var1);

    protected static void setSystemScope(IdentityScope scope) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkSecurityAccess("setSystemScope");
        }
        systemScope = scope;
    }

    public abstract int size();

    public String toString() {
        String result = "Name : " + this.getName();
        if (this.getScope() != null) {
            result = String.valueOf(result) + "\nScope name : " + this.getScope().getName();
        }
        result = String.valueOf(result) + "\nNumber of identities : " + this.size();
        return result;
    }

    public static IdentityScope getSystemScope() {
        if (systemScope != null) {
            return systemScope;
        }
        String prop = (String)AccessController.doPrivileged(PriviAction.getSecurityProperty("system.scope"));
        if (prop != null) {
            try {
                Class cl = Class.forName(prop);
                systemScope = (IdentityScope)cl.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {}
        }
        return systemScope;
    }
}

