/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import com.ibm.oti.util.Msg;
import java.security.DigestException;
import java.security.MessageDigestSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;

public abstract class MessageDigest
extends MessageDigestSpi {
    private static final String KEY_PREFIX = "MessageDigest.";
    private String algorithmName;
    private Provider provider;

    protected MessageDigest(String algorithmName) {
        this.setAlgorithm(algorithmName);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public byte[] digest() {
        byte[] answer = this.engineDigest();
        this.reset();
        return answer;
    }

    public byte[] digest(byte[] bytesToHash) {
        this.update(bytesToHash);
        return this.digest();
    }

    public int digest(byte[] buffer, int offset, int length) throws DigestException {
        return this.engineDigest(buffer, offset, length);
    }

    public final String getAlgorithm() {
        return this.algorithmName;
    }

    public final int getDigestLength() {
        return this.engineGetDigestLength();
    }

    public static MessageDigest getInstance(String algorithmName) throws NoSuchAlgorithmException {
        Provider[] providers = Security.getProviders();
        int i = 0;
        while (i < providers.length) {
            Provider provider = providers[i];
            try {
                return MessageDigest.toMessageDigestImplementation(algorithmName, provider);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                ++i;
            }
        }
        throw new NoSuchAlgorithmException(algorithmName);
    }

    public static MessageDigest getInstance(String algorithmName, String providerName) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (providerName == null || providerName == "") {
            throw new IllegalArgumentException();
        }
        Provider provider = Security.getProvider(providerName);
        if (provider == null) {
            throw new NoSuchProviderException(providerName);
        }
        return MessageDigest.toMessageDigestImplementation(algorithmName, provider);
    }

    public static MessageDigest getInstance(String algorithmName, Provider provider) throws NoSuchAlgorithmException {
        return MessageDigest.toMessageDigestImplementation(algorithmName, provider);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public static boolean isEqual(byte[] digesta, byte[] digestb) {
        return Arrays.equals(digesta, digestb);
    }

    public void reset() {
        this.engineReset();
    }

    void setAlgorithm(String algorithmName) {
        this.algorithmName = algorithmName;
    }

    void setProvider(Provider provider) {
        this.provider = provider;
    }

    private static MessageDigest toMessageDigestImplementation(String algorithmName, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException();
        }
        if (algorithmName == null) {
            throw new IllegalArgumentException();
        }
        try {
            String digestClassName = provider.lookupProperty(KEY_PREFIX, algorithmName);
            if (digestClassName == null) {
                throw new NoSuchAlgorithmException(algorithmName);
            }
            Class digestClass = Class.forName(digestClassName, true, provider.getClass().getClassLoader());
            MessageDigestSpi providedDigest = (MessageDigestSpi)digestClass.newInstance();
            MessageDigest digest = providedDigest instanceof MessageDigest ? (MessageDigest)providedDigest : new Wrapper(providedDigest, algorithmName);
            digest.setProvider(provider);
            return digest;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (ClassCastException classCastException) {}
        throw new NoSuchAlgorithmException(algorithmName);
    }

    public String toString() {
        return Msg.getString("K03a3", new String[]{this.getAlgorithm(), this.getProvider().getName()});
    }

    public void update(byte[] bytesToHash) {
        this.engineUpdate(bytesToHash, 0, bytesToHash.length);
    }

    public void update(byte[] bytesToHash, int offset, int count) {
        this.engineUpdate(bytesToHash, offset, count);
    }

    public void update(byte byteToHash) {
        this.engineUpdate(byteToHash);
    }

    private static class Wrapper
    extends MessageDigest {
        MessageDigestSpi providerDigest;

        Wrapper(MessageDigestSpi providerDigest, String algorithmName) {
            super(algorithmName);
            this.providerDigest = providerDigest;
        }

        public Object clone() throws CloneNotSupportedException {
            Wrapper clone = new Wrapper((MessageDigestSpi)this.providerDigest.clone(), this.getAlgorithm());
            clone.setProvider(this.getProvider());
            return clone;
        }

        protected byte[] engineDigest() {
            return this.providerDigest.engineDigest();
        }

        protected void engineReset() {
            this.providerDigest.engineReset();
        }

        protected void engineUpdate(byte[] bytesToHash, int offset, int count) {
            this.providerDigest.engineUpdate(bytesToHash, offset, count);
        }

        protected void engineUpdate(byte byteToHash) {
            this.providerDigest.engineUpdate(byteToHash);
        }

        protected int engineGetDigestLength() {
            return this.providerDigest.engineGetDigestLength();
        }
    }
}

