/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public abstract class Provider
extends Properties {
    private static final long serialVersionUID = -4298000515446427739L;
    private String name;
    private String info;
    private double version;

    protected Provider(String name, double version, String info) {
        this.name = name;
        this.version = version;
        this.info = info;
    }

    public synchronized void clear() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkSecurityAccess("clearProviderProperties." + this.name);
        }
        super.clear();
    }

    public Set entrySet() {
        return Collections.unmodifiableSet(super.entrySet());
    }

    public String getInfo() {
        return this.info;
    }

    public String getName() {
        return this.name;
    }

    public double getVersion() {
        return this.version;
    }

    public Set keySet() {
        return Collections.unmodifiableSet(super.keySet());
    }

    public synchronized void load(InputStream in) throws IOException {
        super.load(in);
    }

    public synchronized Object put(Object key, Object value) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkSecurityAccess("putProviderProperty." + this.name);
        }
        return super.put(key, value);
    }

    public synchronized void putAll(Map map) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkSecurityAccess("putProviderProperty." + this.name);
        }
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            super.put(entry.getKey(), entry.getValue());
        }
    }

    public synchronized Object remove(Object key) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkSecurityAccess("removeProviderProperty." + this.name);
        }
        return super.remove(key);
    }

    public String toString() {
        return String.valueOf(this.name) + " version " + this.version;
    }

    public Collection values() {
        return Collections.unmodifiableCollection(super.values());
    }

    public String getProperty(String name, String defaultValue) {
        String result = this.getProperty(name);
        if (result == null) {
            return defaultValue;
        }
        return defaultValue;
    }

    public String getProperty(String name) {
        int index = name.indexOf(46);
        if (index == -1) {
            return null;
        }
        String prefix = name.substring(0, index + 1);
        String algorithm = name.substring(index + 1, name.length());
        return this.lookupProperty(prefix, algorithm);
    }

    String lookupProperty(String property) {
        String result = super.getProperty(property);
        if (result != null) {
            return result;
        }
        String upper = property.toUpperCase();
        Enumeration keyEnum = this.keys();
        while (keyEnum.hasMoreElements()) {
            String key = (String)keyEnum.nextElement();
            if (!key.toUpperCase().equals(upper)) continue;
            return this.getProperty(key);
        }
        return null;
    }

    String lookupProperty(String prefix, String name) {
        String property = String.valueOf(prefix) + name;
        String result = this.lookupProperty(property);
        if (result != null) {
            return result;
        }
        result = this.lookupProperty("Alg.Alias." + property);
        if (result != null) {
            return this.lookupProperty(String.valueOf(prefix) + result);
        }
        return null;
    }
}

