/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import com.ibm.oti.util.Msg;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;

public class CertificateFactory {
    private static final String KEY_PREFIX = "CertificateFactory.";
    private String type;
    private Provider provider;
    private CertificateFactorySpi certificateFactorySpi;

    protected CertificateFactory(CertificateFactorySpi certFacSpi, Provider provider, String type) {
        this.setProvider(provider);
        this.setType(type);
        this.certificateFactorySpi = certFacSpi;
    }

    private static CertificateFactory createCertificateFactory(Provider provider, Class certClass, String type) throws CertificateException {
        try {
            CertificateFactorySpi providedCertificateFactory = (CertificateFactorySpi)certClass.newInstance();
            return new CertificateFactory(providedCertificateFactory, provider, type);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {}
        throw new CertificateException(type);
    }

    public final Certificate generateCertificate(InputStream inStream) throws CertificateException {
        if (inStream == null) {
            throw new CertificateException(Msg.getString("K00a5", "null"));
        }
        return this.certificateFactorySpi.engineGenerateCertificate(inStream);
    }

    public final Collection generateCertificates(InputStream inStream) throws CertificateException {
        if (inStream == null) {
            throw new CertificateException(Msg.getString("K00a5", "null"));
        }
        return this.certificateFactorySpi.engineGenerateCertificates(inStream);
    }

    public final CRL generateCRL(InputStream inStream) throws CRLException {
        if (inStream == null) {
            throw new CRLException(Msg.getString("K00a5", "null"));
        }
        return this.certificateFactorySpi.engineGenerateCRL(inStream);
    }

    public final CertPath generateCertPath(InputStream inStream) throws CertificateException {
        if (inStream == null) {
            throw new CertificateException(Msg.getString("K00a5", "null"));
        }
        return this.certificateFactorySpi.engineGenerateCertPath(inStream);
    }

    public final CertPath generateCertPath(InputStream inStream, String encoding) throws CertificateException {
        if (inStream == null) {
            throw new CertificateException(Msg.getString("K00a5", "null"));
        }
        if (encoding == null) {
            throw new CertificateException(Msg.getString("K00a5", encoding));
        }
        inStream = new BufferedInputStream(inStream);
        return this.certificateFactorySpi.engineGenerateCertPath(inStream, encoding);
    }

    public final CertPath generateCertPath(List certificates) throws CertificateException {
        if (certificates == null) {
            throw new CertificateException(Msg.getString("K00a5", "null"));
        }
        return this.certificateFactorySpi.engineGenerateCertPath(certificates);
    }

    public final Iterator getCertPathEncodings() {
        return this.certificateFactorySpi.engineGetCertPathEncodings();
    }

    public final Collection generateCRLs(InputStream inStream) throws CRLException {
        if (inStream == null) {
            throw new CRLException(Msg.getString("K00a5", "null"));
        }
        return this.certificateFactorySpi.engineGenerateCRLs(inStream);
    }

    public static final CertificateFactory getInstance(String type) throws CertificateException {
        if (type == null) {
            throw new CertificateException(Msg.getString("K0337"));
        }
        return CertificateFactory.toCertificateFactoryImplementation(type);
    }

    public static final CertificateFactory getInstance(String type, String providerName) throws CertificateException, NoSuchProviderException {
        if (providerName == null) {
            throw new IllegalArgumentException();
        }
        if (type == null) {
            throw new CertificateException(Msg.getString("K0337"));
        }
        Provider provider = Security.getProvider(providerName);
        if (provider == null) {
            throw new NoSuchProviderException(providerName);
        }
        return CertificateFactory.toCertificateFactoryImplementation(type, provider);
    }

    public static final CertificateFactory getInstance(String type, Provider provider) throws CertificateException {
        if (type == null) {
            throw new CertificateException(Msg.getString("K0337"));
        }
        if (provider == null) {
            throw new IllegalArgumentException();
        }
        return CertificateFactory.toCertificateFactoryImplementation(type, provider);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getType() {
        return this.type;
    }

    void setProvider(Provider provider) {
        this.provider = provider;
    }

    void setType(String type) {
        this.type = type;
    }

    private static CertificateFactory toCertificateFactoryImplementation(String type) throws CertificateException {
        Provider[] providers = Security.getProviders();
        int i = 0;
        while (i < providers.length) {
            Provider provider = providers[i];
            try {
                return CertificateFactory.toCertificateFactoryImplementation(type, provider);
            }
            catch (CertificateException certificateException) {
                ++i;
            }
        }
        throw new CertificateException(type);
    }

    private static CertificateFactory toCertificateFactoryImplementation(String type, Provider provider) throws CertificateException {
        String certificateFactoryClassName;
        try {
            certificateFactoryClassName = CertificateFactory.lookupProperty(provider, KEY_PREFIX, type);
        }
        catch (ClassCastException classCastException) {
            throw new CertificateException(type);
        }
        if (certificateFactoryClassName == null) {
            throw new CertificateException(type);
        }
        try {
            Class certFactClass = Class.forName(certificateFactoryClassName, true, provider.getClass().getClassLoader());
            return CertificateFactory.createCertificateFactory(provider, certFactClass, type);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new CertificateException(type);
        }
    }

    private static String lookupProperty(Provider provider, String property) {
        String result = provider.getProperty(property);
        if (result != null) {
            return result;
        }
        String upper = property.toUpperCase();
        Enumeration keyEnum = provider.keys();
        while (keyEnum.hasMoreElements()) {
            String key = (String)keyEnum.nextElement();
            if (!key.toUpperCase().equals(upper)) continue;
            return provider.getProperty(key);
        }
        return null;
    }

    private static String lookupProperty(Provider provider, String prefix, String name) {
        String property = String.valueOf(prefix) + name;
        String result = CertificateFactory.lookupProperty(provider, property);
        if (result != null) {
            return result;
        }
        result = CertificateFactory.lookupProperty(provider, "Alg.Alias." + property);
        if (result != null) {
            return provider.getProperty(String.valueOf(prefix) + result);
        }
        return null;
    }
}

