/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import com.ibm.oti.locale.Locale;
import com.ibm.oti.util.ExtendedResourceBundle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.text.Format;
import java.util.Arrays;
import java.util.Currency;

public final class DecimalFormatSymbols
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 5772796243397350300L;
    private final int ZeroDigit = 0;
    private final int Digit = 1;
    private final int DecimalSeparator = 2;
    private final int GroupingSeparator = 3;
    private final int PatternSeparator = 4;
    private final int Percent = 5;
    private final int PerMill = 6;
    private final int Exponent = 7;
    private final int MonetaryDecimalSeparator = 8;
    private final int MinusSign = 9;
    transient char[] patternChars;
    private transient Currency currency;
    private transient java.util.Locale locale;
    private String infinity;
    private String NaN;
    private String currencySymbol;
    private String intlCurrencySymbol;
    private static final ObjectStreamField[] serialPersistentFields;
    static /* synthetic */ Class class$0;

    static {
        ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[15];
        Class clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectStreamFieldArray[0] = new ObjectStreamField("currencySymbol", clazz);
        objectStreamFieldArray[1] = new ObjectStreamField("decimalSeparator", Character.TYPE);
        objectStreamFieldArray[2] = new ObjectStreamField("digit", Character.TYPE);
        objectStreamFieldArray[3] = new ObjectStreamField("exponential", Character.TYPE);
        objectStreamFieldArray[4] = new ObjectStreamField("groupingSeparator", Character.TYPE);
        Class clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectStreamFieldArray[5] = new ObjectStreamField("infinity", clazz2);
        Class clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectStreamFieldArray[6] = new ObjectStreamField("intlCurrencySymbol", clazz3);
        objectStreamFieldArray[7] = new ObjectStreamField("minusSign", Character.TYPE);
        objectStreamFieldArray[8] = new ObjectStreamField("monetarySeparator", Character.TYPE);
        Class clazz4 = class$0;
        if (clazz4 == null) {
            try {
                clazz4 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectStreamFieldArray[9] = new ObjectStreamField("NaN", clazz4);
        objectStreamFieldArray[10] = new ObjectStreamField("patternSeparator", Character.TYPE);
        objectStreamFieldArray[11] = new ObjectStreamField("percent", Character.TYPE);
        objectStreamFieldArray[12] = new ObjectStreamField("perMill", Character.TYPE);
        objectStreamFieldArray[13] = new ObjectStreamField("serialVersionOnStream", Integer.TYPE);
        objectStreamFieldArray[14] = new ObjectStreamField("zeroDigit", Character.TYPE);
        serialPersistentFields = objectStreamFieldArray;
    }

    public DecimalFormatSymbols() {
        this(java.util.Locale.getDefault());
    }

    public DecimalFormatSymbols(java.util.Locale locale) {
        ExtendedResourceBundle bundle = (ExtendedResourceBundle)Format.getBundle(locale);
        this.patternChars = ((String)bundle.getObject(Locale.DECIMAL_PATTERN_CHARS)).toCharArray();
        this.infinity = (String)bundle.getObject(Locale.INFINITY);
        this.NaN = (String)bundle.getObject(Locale.NAN);
        this.locale = locale;
        try {
            this.currency = Currency.getInstance(locale);
            this.currencySymbol = this.currency.getSymbol(locale);
            this.intlCurrencySymbol = this.currency.getCurrencyCode();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.currency = Currency.getInstance("XXX");
            this.currencySymbol = (String)bundle.getObject(Locale.CURRENCY_SYMBOL);
            this.intlCurrencySymbol = (String)bundle.getObject(Locale.INTL_CURRENCY_SYMBOL);
        }
    }

    public Object clone() {
        try {
            DecimalFormatSymbols symbols = (DecimalFormatSymbols)super.clone();
            symbols.patternChars = (char[])this.patternChars.clone();
            return symbols;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DecimalFormatSymbols)) {
            return false;
        }
        DecimalFormatSymbols obj = (DecimalFormatSymbols)object;
        return Arrays.equals(this.patternChars, obj.patternChars) && this.infinity.equals(obj.infinity) && this.NaN.equals(obj.NaN) && this.currencySymbol.equals(obj.currencySymbol) && this.intlCurrencySymbol.equals(obj.intlCurrencySymbol);
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public String getInternationalCurrencySymbol() {
        return this.intlCurrencySymbol;
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public char getDecimalSeparator() {
        return this.patternChars[2];
    }

    public char getDigit() {
        return this.patternChars[1];
    }

    public char getGroupingSeparator() {
        return this.patternChars[3];
    }

    public String getInfinity() {
        return this.infinity;
    }

    String getLocalPatternChars() {
        return new String(this.patternChars, 0, this.patternChars.length - 2);
    }

    public char getMinusSign() {
        return this.patternChars[9];
    }

    public char getMonetaryDecimalSeparator() {
        return this.patternChars[8];
    }

    public String getNaN() {
        return this.NaN;
    }

    public char getPatternSeparator() {
        return this.patternChars[4];
    }

    public char getPercent() {
        return this.patternChars[5];
    }

    public char getPerMill() {
        return this.patternChars[6];
    }

    public char getZeroDigit() {
        return this.patternChars[0];
    }

    char getExponential() {
        return this.patternChars[7];
    }

    public int hashCode() {
        return new String(this.patternChars).hashCode() + this.infinity.hashCode() + this.NaN.hashCode() + this.currencySymbol.hashCode() + this.intlCurrencySymbol.hashCode();
    }

    public void setCurrency(Currency currency) {
        if (currency == null) {
            throw new NullPointerException();
        }
        if (currency == this.currency) {
            return;
        }
        this.currency = currency;
        this.intlCurrencySymbol = currency.getCurrencyCode();
        this.currencySymbol = currency.getSymbol(this.locale);
    }

    public void setInternationalCurrencySymbol(String value) {
        if (value == null) {
            this.currency = null;
            this.intlCurrencySymbol = null;
            return;
        }
        if (value.equals(this.intlCurrencySymbol)) {
            return;
        }
        try {
            this.currency = Currency.getInstance(value);
            this.currencySymbol = this.currency.getSymbol(this.locale);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.currency = null;
        }
        this.intlCurrencySymbol = value;
    }

    public void setCurrencySymbol(String value) {
        this.currencySymbol = value;
    }

    public void setDecimalSeparator(char value) {
        this.patternChars[2] = value;
    }

    public void setDigit(char value) {
        this.patternChars[1] = value;
    }

    public void setGroupingSeparator(char value) {
        this.patternChars[3] = value;
    }

    public void setInfinity(String value) {
        this.infinity = value;
    }

    public void setMinusSign(char value) {
        this.patternChars[9] = value;
    }

    public void setMonetaryDecimalSeparator(char value) {
        this.patternChars[8] = value;
    }

    public void setNaN(String value) {
        this.NaN = value;
    }

    public void setPatternSeparator(char value) {
        this.patternChars[4] = value;
    }

    public void setPercent(char value) {
        this.patternChars[5] = value;
    }

    public void setPerMill(char value) {
        this.patternChars[6] = value;
    }

    public void setZeroDigit(char value) {
        this.patternChars[0] = value;
    }

    void setExponential(char value) {
        this.patternChars[7] = value;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        ObjectOutputStream.PutField fields = stream.putFields();
        fields.put("currencySymbol", this.currencySymbol);
        fields.put("decimalSeparator", this.getDecimalSeparator());
        fields.put("digit", this.getDigit());
        fields.put("exponential", this.getExponential());
        fields.put("groupingSeparator", this.getGroupingSeparator());
        fields.put("infinity", this.infinity);
        fields.put("intlCurrencySymbol", this.intlCurrencySymbol);
        fields.put("minusSign", this.getMinusSign());
        fields.put("monetarySeparator", this.getMonetaryDecimalSeparator());
        fields.put("NaN", this.NaN);
        fields.put("patternSeparator", this.getPatternSeparator());
        fields.put("percent", this.getPercent());
        fields.put("perMill", this.getPerMill());
        fields.put("serialVersionOnStream", 1);
        fields.put("zeroDigit", this.getZeroDigit());
        stream.writeFields();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = stream.readFields();
        this.patternChars = new char[10];
        this.currencySymbol = (String)fields.get("currencySymbol", "");
        this.setDecimalSeparator(fields.get("decimalSeparator", '.'));
        this.setDigit(fields.get("digit", '#'));
        this.setGroupingSeparator(fields.get("groupingSeparator", ','));
        this.infinity = (String)fields.get("infinity", "");
        this.intlCurrencySymbol = (String)fields.get("intlCurrencySymbol", "");
        this.setMinusSign(fields.get("minusSign", '-'));
        this.NaN = (String)fields.get("NaN", "");
        this.setPatternSeparator(fields.get("patternSeparator", ';'));
        this.setPercent(fields.get("percent", '%'));
        this.setPerMill(fields.get("perMill", '\u2030'));
        this.setZeroDigit(fields.get("zeroDigit", '0'));
        if (fields.get("serialVersionOnStream", 0) == 0) {
            this.setMonetaryDecimalSeparator(this.getDecimalSeparator());
            this.setExponential('E');
        } else {
            this.setMonetaryDecimalSeparator(fields.get("monetarySeparator", '.'));
            this.setExponential(fields.get("exponential", 'E'));
        }
    }
}

