/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;

public class ArrayList
extends AbstractList
implements List,
Cloneable,
Serializable,
RandomAccess {
    private static final long serialVersionUID = 8683452581122892189L;
    private transient int firstIndex;
    private transient int lastIndex;
    private transient Object[] array;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("size", Integer.TYPE)};

    public ArrayList() {
        this(0);
    }

    public ArrayList(int capacity) {
        this.lastIndex = 0;
        this.firstIndex = 0;
        try {
            this.array = new Object[capacity];
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            throw new IllegalArgumentException();
        }
    }

    public ArrayList(Collection collection) {
        int size = collection.size();
        this.lastIndex = 0;
        this.firstIndex = 0;
        this.array = new Object[size + size / 10];
        this.addAll(collection);
    }

    public void add(int location, Object object) {
        int size = this.size();
        if (location > 0 && location < size) {
            if (this.firstIndex == 0 && this.lastIndex == this.array.length) {
                this.growForInsert(location, 1);
            } else if (location < size / 2 && this.firstIndex > 0 || this.lastIndex == this.array.length) {
                System.arraycopy((Object)this.array, this.firstIndex, (Object)this.array, --this.firstIndex, location);
            } else {
                int index = location + this.firstIndex;
                System.arraycopy((Object)this.array, index, (Object)this.array, index + 1, size - location);
                ++this.lastIndex;
            }
            this.array[location + this.firstIndex] = object;
        } else if (location == 0) {
            if (this.firstIndex == 0) {
                this.growAtFront(1);
            }
            this.array[--this.firstIndex] = object;
        } else if (location == size) {
            if (this.lastIndex == this.array.length) {
                this.growAtEnd(1);
            }
            this.array[this.lastIndex++] = object;
        } else {
            throw new IndexOutOfBoundsException();
        }
        ++this.modCount;
    }

    public boolean add(Object object) {
        if (this.lastIndex == this.array.length) {
            this.growAtEnd(1);
        }
        this.array[this.lastIndex++] = object;
        ++this.modCount;
        return true;
    }

    public boolean addAll(int location, Collection collection) {
        int index;
        int size = this.size();
        int growSize = collection.size();
        if (location > 0 && location < size) {
            if (this.array.length - size < growSize) {
                this.growForInsert(location, growSize);
            } else if (location < size / 2 && this.firstIndex > 0 || this.lastIndex > this.array.length - growSize) {
                int newFirst = this.firstIndex - growSize;
                if (newFirst < 0) {
                    index = location + this.firstIndex;
                    System.arraycopy((Object)this.array, index, (Object)this.array, index - newFirst, size - location);
                    this.lastIndex -= newFirst;
                    newFirst = 0;
                }
                System.arraycopy((Object)this.array, this.firstIndex, (Object)this.array, newFirst, location);
                this.firstIndex = newFirst;
            } else {
                int index2 = location + this.firstIndex;
                System.arraycopy((Object)this.array, index2, (Object)this.array, index2 + growSize, size - location);
                this.lastIndex += growSize;
            }
        } else if (location == 0) {
            if (this.firstIndex == 0) {
                this.growAtFront(growSize);
            }
            this.firstIndex -= growSize;
        } else if (location == size) {
            if (this.lastIndex > this.array.length - growSize) {
                this.growAtEnd(growSize);
            }
            this.lastIndex += growSize;
        } else {
            throw new IndexOutOfBoundsException();
        }
        if (growSize > 0) {
            Iterator it = collection.iterator();
            index = location + this.firstIndex;
            int end = index + growSize;
            while (index < end) {
                this.array[index++] = it.next();
            }
            ++this.modCount;
            return true;
        }
        return false;
    }

    public boolean addAll(Collection collection) {
        int growSize = collection.size();
        if (growSize > 0) {
            if (this.lastIndex > this.array.length - growSize) {
                this.growAtEnd(growSize);
            }
            Iterator it = collection.iterator();
            int end = this.lastIndex + growSize;
            while (this.lastIndex < end) {
                this.array[this.lastIndex++] = it.next();
            }
            ++this.modCount;
            return true;
        }
        return false;
    }

    public void clear() {
        if (this.firstIndex != this.lastIndex) {
            Arrays.fill(this.array, this.firstIndex, this.lastIndex, null);
            this.lastIndex = 0;
            this.firstIndex = 0;
            ++this.modCount;
        }
    }

    public Object clone() {
        try {
            ArrayList newList = (ArrayList)super.clone();
            newList.array = (Object[])this.array.clone();
            return newList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean contains(Object object) {
        if (object != null) {
            int i = this.firstIndex;
            while (i < this.lastIndex) {
                if (object.equals(this.array[i])) {
                    return true;
                }
                ++i;
            }
        } else {
            int i = this.firstIndex;
            while (i < this.lastIndex) {
                if (this.array[i] == null) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void ensureCapacity(int minimumCapacity) {
        if (this.array.length < minimumCapacity) {
            if (this.firstIndex > 0) {
                this.growAtFront(minimumCapacity - this.array.length);
            } else {
                this.growAtEnd(minimumCapacity - this.array.length);
            }
        }
    }

    public Object get(int location) {
        if (location >= 0 && location < this.size()) {
            return this.array[this.firstIndex + location];
        }
        throw new IndexOutOfBoundsException();
    }

    private void growAtEnd(int required) {
        int size = this.size();
        if (this.firstIndex >= required - (this.array.length - this.lastIndex)) {
            int newLast = this.lastIndex - this.firstIndex;
            if (size > 0) {
                System.arraycopy((Object)this.array, this.firstIndex, (Object)this.array, 0, size);
                int start = newLast < this.firstIndex ? this.firstIndex : newLast;
                Arrays.fill(this.array, start, this.array.length, null);
            }
            this.firstIndex = 0;
            this.lastIndex = newLast;
        } else {
            int increment = size / 2;
            if (required > increment) {
                increment = required;
            }
            if (increment < 12) {
                increment = 12;
            }
            Object[] newArray = new Object[this.lastIndex + increment];
            if (size > 0) {
                System.arraycopy((Object)this.array, this.firstIndex, (Object)newArray, this.firstIndex, size);
            }
            this.array = newArray;
        }
    }

    private void growAtFront(int required) {
        int size = this.size();
        if (this.array.length - this.lastIndex >= required) {
            int newFirst = this.array.length - this.lastIndex;
            if (size > 0) {
                System.arraycopy((Object)this.array, this.firstIndex, (Object)this.array, newFirst, size);
                int length = this.firstIndex + size > newFirst ? newFirst : this.firstIndex + size;
                Arrays.fill(this.array, this.firstIndex, length, null);
            }
            this.firstIndex = newFirst;
            this.lastIndex = this.array.length;
        } else {
            int increment = size / 2;
            if (required > increment) {
                increment = required;
            }
            if (increment < 12) {
                increment = 12;
            }
            Object[] newArray = new Object[size + increment];
            if (size > 0) {
                System.arraycopy((Object)this.array, this.firstIndex, (Object)newArray, newArray.length - this.lastIndex, size);
            }
            this.firstIndex = newArray.length - this.lastIndex;
            this.lastIndex = newArray.length;
            this.array = newArray;
        }
    }

    private void growForInsert(int location, int required) {
        int size = this.size();
        int increment = size / 2;
        if (required > increment) {
            increment = required;
        }
        if (increment < 12) {
            increment = 12;
        }
        Object[] newArray = new Object[size + increment];
        if (location < size / 2) {
            int newFirst = newArray.length - (size + required);
            System.arraycopy((Object)this.array, location, (Object)newArray, location + increment, size - location);
            System.arraycopy((Object)this.array, this.firstIndex, (Object)newArray, newFirst, location);
            this.firstIndex = newFirst;
            this.lastIndex = newArray.length;
        } else {
            System.arraycopy((Object)this.array, this.firstIndex, (Object)newArray, 0, location);
            System.arraycopy((Object)this.array, location, (Object)newArray, location + required, size - location);
            this.firstIndex = 0;
            this.lastIndex += required;
        }
        this.array = newArray;
    }

    public int indexOf(Object object) {
        if (object != null) {
            int i = this.firstIndex;
            while (i < this.lastIndex) {
                if (object.equals(this.array[i])) {
                    return i - this.firstIndex;
                }
                ++i;
            }
        } else {
            int i = this.firstIndex;
            while (i < this.lastIndex) {
                if (this.array[i] == null) {
                    return i - this.firstIndex;
                }
                ++i;
            }
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.lastIndex == this.firstIndex;
    }

    public int lastIndexOf(Object object) {
        if (object != null) {
            int i = this.lastIndex - 1;
            while (i >= this.firstIndex) {
                if (object.equals(this.array[i])) {
                    return i - this.firstIndex;
                }
                --i;
            }
        } else {
            int i = this.lastIndex - 1;
            while (i >= this.firstIndex) {
                if (this.array[i] == null) {
                    return i - this.firstIndex;
                }
                --i;
            }
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public Object remove(int location) {
        void var2_3;
        int size = this.size();
        if (location >= 0 && location < size) {
            Object result;
            if (location == size - 1) {
                result = this.array[--this.lastIndex];
                this.array[this.lastIndex] = null;
            } else if (location == 0) {
                result = this.array[this.firstIndex];
                this.array[this.firstIndex++] = null;
            } else {
                int elementIndex = this.firstIndex + location;
                result = this.array[elementIndex];
                if (location < size / 2) {
                    System.arraycopy((Object)this.array, this.firstIndex, (Object)this.array, this.firstIndex + 1, location);
                    this.array[this.firstIndex++] = null;
                } else {
                    System.arraycopy((Object)this.array, elementIndex + 1, (Object)this.array, elementIndex, size - location - 1);
                    this.array[--this.lastIndex] = null;
                }
            }
        } else {
            throw new IndexOutOfBoundsException();
        }
        ++this.modCount;
        return var2_3;
    }

    protected void removeRange(int start, int end) {
        if (start >= 0 && start <= end && end <= this.size()) {
            if (start == end) {
                return;
            }
            int size = this.size();
            if (end == size) {
                Arrays.fill(this.array, this.firstIndex + start, this.lastIndex, null);
                this.lastIndex = this.firstIndex + start;
            } else if (start == 0) {
                Arrays.fill(this.array, this.firstIndex, this.firstIndex + end, null);
                this.firstIndex += end;
            } else {
                System.arraycopy((Object)this.array, this.firstIndex + end, (Object)this.array, this.firstIndex + start, size - end);
                int newLast = this.lastIndex + start - end;
                Arrays.fill(this.array, newLast, this.lastIndex, null);
                this.lastIndex = newLast;
            }
            ++this.modCount;
        } else {
            throw new IndexOutOfBoundsException();
        }
    }

    public Object set(int location, Object object) {
        if (location >= 0 && location < this.size()) {
            Object result = this.array[this.firstIndex + location];
            this.array[this.firstIndex + location] = object;
            return result;
        }
        throw new IndexOutOfBoundsException();
    }

    public int size() {
        return this.lastIndex - this.firstIndex;
    }

    public Object[] toArray() {
        int size = this.size();
        Object[] result = new Object[size];
        System.arraycopy((Object)this.array, this.firstIndex, (Object)result, 0, size);
        return result;
    }

    public Object[] toArray(Object[] contents) {
        int size = this.size();
        if (size > contents.length) {
            contents = (Object[])Array.newInstance(contents.getClass().getComponentType(), size);
        }
        System.arraycopy((Object)this.array, this.firstIndex, (Object)contents, 0, size);
        if (size < contents.length) {
            contents[size] = null;
        }
        return contents;
    }

    public void trimToSize() {
        int size = this.size();
        Object[] newArray = new Object[size];
        System.arraycopy((Object)this.array, this.firstIndex, (Object)newArray, 0, size);
        this.array = newArray;
        this.firstIndex = 0;
        this.lastIndex = this.array.length;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        ObjectOutputStream.PutField fields = stream.putFields();
        fields.put("size", this.size());
        stream.writeFields();
        stream.writeInt(this.array.length);
        Iterator it = this.iterator();
        while (it.hasNext()) {
            stream.writeObject(it.next());
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = stream.readFields();
        this.lastIndex = fields.get("size", 0);
        this.array = new Object[stream.readInt()];
        int i = 0;
        while (i < this.lastIndex) {
            this.array[i] = stream.readObject();
            ++i;
        }
    }
}

