/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

public class Collections {
    public static final List EMPTY_LIST = new EmptyList();
    public static final Set EMPTY_SET = new EmptySet();
    public static final Map EMPTY_MAP = new EmptyMap();

    private Collections() {
    }

    public static int binarySearch(List list, Object object) {
        if (list == null) {
            throw new NullPointerException();
        }
        Comparable key = (Comparable)object;
        if (!(list instanceof RandomAccess)) {
            ListIterator it = list.listIterator();
            while (it.hasNext()) {
                int result = key.compareTo(it.next());
                if (result > 0) continue;
                if (result == 0) {
                    return it.previousIndex();
                }
                return -it.previousIndex() - 1;
            }
            return -list.size() - 1;
        }
        int low = 0;
        int mid = list.size();
        int high = mid - 1;
        int result = -1;
        while (low <= high) {
            mid = low + high >> 1;
            result = key.compareTo(list.get(mid));
            if (result > 0) {
                low = mid + 1;
                continue;
            }
            if (result == 0) {
                return mid;
            }
            high = mid - 1;
        }
        return -mid - (result < 0 ? 1 : 2);
    }

    public static int binarySearch(List list, Object object, Comparator comparator) {
        if (comparator == null) {
            return Collections.binarySearch(list, object);
        }
        if (!(list instanceof RandomAccess)) {
            ListIterator it = list.listIterator();
            while (it.hasNext()) {
                int result = comparator.compare(object, it.next());
                if (result > 0) continue;
                if (result == 0) {
                    return it.previousIndex();
                }
                return -it.previousIndex() - 1;
            }
            return -list.size() - 1;
        }
        int low = 0;
        int mid = list.size();
        int high = mid - 1;
        int result = -1;
        while (low <= high) {
            mid = low + high >> 1;
            result = comparator.compare(object, list.get(mid));
            if (result > 0) {
                low = mid + 1;
                continue;
            }
            if (result == 0) {
                return mid;
            }
            high = mid - 1;
        }
        return -mid - (result < 0 ? 1 : 2);
    }

    public static void copy(List destination, List source) {
        if (destination.size() < source.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Iterator srcIt = source.iterator();
        ListIterator destIt = destination.listIterator();
        while (srcIt.hasNext()) {
            try {
                destIt.next();
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new ArrayIndexOutOfBoundsException();
            }
            destIt.set(srcIt.next());
        }
    }

    public static Enumeration enumeration(Collection collection) {
        return new Enumeration(collection){
            Iterator it;
            {
                this.it = collection.iterator();
            }

            public boolean hasMoreElements() {
                return this.it.hasNext();
            }

            public Object nextElement() {
                return this.it.next();
            }
        };
    }

    public static void fill(List list, Object object) {
        ListIterator it = list.listIterator();
        while (it.hasNext()) {
            it.next();
            it.set(object);
        }
    }

    public static Object max(Collection collection) {
        Iterator it = collection.iterator();
        Comparable max = (Comparable)it.next();
        while (it.hasNext()) {
            Object next = it.next();
            if (max.compareTo(next) >= 0) continue;
            max = (Comparable)next;
        }
        return max;
    }

    public static Object max(Collection collection, Comparator comparator) {
        Iterator it = collection.iterator();
        Object max = it.next();
        while (it.hasNext()) {
            Object next = it.next();
            if (comparator.compare(max, next) >= 0) continue;
            max = next;
        }
        return max;
    }

    public static Object min(Collection collection) {
        Iterator it = collection.iterator();
        Comparable min = (Comparable)it.next();
        while (it.hasNext()) {
            Object next = it.next();
            if (min.compareTo(next) <= 0) continue;
            min = (Comparable)next;
        }
        return min;
    }

    public static Object min(Collection collection, Comparator comparator) {
        Iterator it = collection.iterator();
        Object min = it.next();
        while (it.hasNext()) {
            Object next = it.next();
            if (comparator.compare(min, next) <= 0) continue;
            min = next;
        }
        return min;
    }

    public static List nCopies(int length, Object object) {
        return new CopiesList(length, object);
    }

    public static void reverse(List list) {
        int size = list.size();
        ListIterator front = list.listIterator();
        ListIterator back = list.listIterator(size);
        int i = 0;
        while (i < size / 2) {
            Object temp = front.next();
            front.set(back.previous());
            back.set(temp);
            ++i;
        }
    }

    public static Comparator reverseOrder() {
        return new ReverseComparator();
    }

    public static void shuffle(List list) {
        Collections.shuffle(list, new Random());
    }

    public static void shuffle(List list, Random random) {
        if (!(list instanceof RandomAccess)) {
            Object[] array = list.toArray();
            int i = array.length - 1;
            while (i > 0) {
                int index = random.nextInt() % (i + 1);
                if (index < 0) {
                    index = -index;
                }
                Object temp = array[i];
                array[i] = array[index];
                array[index] = temp;
                --i;
            }
            i = 0;
            ListIterator it = list.listIterator();
            while (it.hasNext()) {
                it.next();
                it.set(array[i++]);
            }
        } else {
            int i = list.size() - 1;
            while (i > 0) {
                int index = random.nextInt() % (i + 1);
                if (index < 0) {
                    index = -index;
                }
                list.set(index, list.set(i, list.get(index)));
                --i;
            }
        }
    }

    public static Set singleton(Object object) {
        return new SingletonSet(object);
    }

    public static List singletonList(Object object) {
        return new SingletonList(object);
    }

    public static Map singletonMap(Object key, Object value) {
        return new SingletonMap(key, value);
    }

    public static void sort(List list) {
        Object[] array = list.toArray();
        Arrays.sort(array);
        int i = 0;
        ListIterator it = list.listIterator();
        while (it.hasNext()) {
            it.next();
            it.set(array[i++]);
        }
    }

    public static void sort(List list, Comparator comparator) {
        Object[] array = list.toArray();
        Arrays.sort(array, comparator);
        int i = 0;
        ListIterator it = list.listIterator();
        while (it.hasNext()) {
            it.next();
            it.set(array[i++]);
        }
    }

    public static void swap(List list, int index1, int index2) {
        if (list == null) {
            throw new NullPointerException();
        }
        if (index1 == index2) {
            return;
        }
        list.set(index2, list.set(index1, list.get(index2)));
    }

    public static boolean replaceAll(List list, Object obj, Object obj2) {
        int index;
        boolean found = false;
        while ((index = list.indexOf(obj)) > -1) {
            found = true;
            list.set(index, obj2);
        }
        return found;
    }

    public static void rotate(List list, int dist) {
        int size = list.size();
        if (size == 0) {
            return;
        }
        dist = dist > 0 ? (dist %= size) : size - dist % size * -1;
        if (dist == 0 || dist == size) {
            return;
        }
        if (list instanceof RandomAccess) {
            Object temp = list.get(0);
            int index = 0;
            int beginIndex = 0;
            int i = 0;
            while (i < size) {
                index = (index + dist) % size;
                temp = list.set(index, temp);
                if (index == beginIndex) {
                    index = ++beginIndex;
                    temp = list.get(beginIndex);
                }
                ++i;
            }
        } else {
            int divideIndex = (size - dist) % size;
            List sublist1 = list.subList(0, divideIndex);
            List sublist2 = list.subList(divideIndex, size);
            Collections.reverse(sublist1);
            Collections.reverse(sublist2);
            Collections.reverse(list);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static int indexOfSubList(List list, List sublist) {
        size = list.size();
        sublistSize = sublist.size();
        if (sublistSize > size) {
            return -1;
        }
        if (sublistSize == 0) {
            return 0;
        }
        firstObj = sublist.get(0);
        index = list.indexOf(firstObj);
        if (index != -1) ** GOTO lbl25
        return -1;
lbl-1000:
        // 1 sources

        {
            listIt = list.listIterator(index);
            if (firstObj == null ? listIt.next() == null : firstObj.equals(listIt.next()) != false) {
                sublistIt = sublist.listIterator(1);
                difFound = false;
                while (sublistIt.hasNext()) {
                    element = sublistIt.next();
                    if (!listIt.hasNext()) {
                        return -1;
                    }
                    if (!(element == null ? listIt.next() != null : element.equals(listIt.next()) == false)) continue;
                    difFound = true;
                    break;
                }
                if (!difFound) {
                    return index;
                }
            }
            ++index;
lbl25:
            // 2 sources

            ** while (index < size && size - index >= sublistSize)
        }
lbl26:
        // 1 sources

        return -1;
    }

    public static int lastIndexOfSubList(List list, List sublist) {
        int size;
        int sublistSize = sublist.size();
        if (sublistSize > (size = list.size())) {
            return -1;
        }
        if (sublistSize == 0) {
            return size;
        }
        Object lastObj = sublist.get(sublistSize - 1);
        int index = list.lastIndexOf(lastObj);
        while (index > -1 && index + 1 >= sublistSize) {
            ListIterator listIt = list.listIterator(index + 1);
            if (lastObj == null ? listIt.previous() == null : lastObj.equals(listIt.previous())) {
                ListIterator sublistIt = sublist.listIterator(sublistSize - 1);
                boolean difFound = false;
                while (sublistIt.hasPrevious()) {
                    Object element = sublistIt.previous();
                    if (!listIt.hasPrevious()) {
                        return -1;
                    }
                    if (!(element == null ? listIt.previous() != null : !element.equals(listIt.previous()))) continue;
                    difFound = true;
                    break;
                }
                if (!difFound) {
                    return listIt.nextIndex();
                }
            }
            --index;
        }
        return -1;
    }

    public static ArrayList list(Enumeration enumeration) {
        ArrayList list = new ArrayList();
        while (enumeration.hasMoreElements()) {
            list.add(enumeration.nextElement());
        }
        return list;
    }

    public static Collection synchronizedCollection(Collection collection) {
        if (collection == null) {
            throw new NullPointerException();
        }
        return new SynchronizedCollection(collection);
    }

    public static List synchronizedList(List list) {
        if (list == null) {
            throw new NullPointerException();
        }
        if (list instanceof RandomAccess) {
            return new SynchronizedRandomAccessList(list);
        }
        return new SynchronizedList(list);
    }

    public static Map synchronizedMap(Map map) {
        if (map == null) {
            throw new NullPointerException();
        }
        return new SynchronizedMap(map);
    }

    public static Set synchronizedSet(Set set) {
        if (set == null) {
            throw new NullPointerException();
        }
        return new SynchronizedSet(set);
    }

    public static SortedMap synchronizedSortedMap(SortedMap map) {
        if (map == null) {
            throw new NullPointerException();
        }
        return new SynchronizedSortedMap(map);
    }

    public static SortedSet synchronizedSortedSet(SortedSet set) {
        if (set == null) {
            throw new NullPointerException();
        }
        return new SynchronizedSortedSet(set);
    }

    public static Collection unmodifiableCollection(Collection collection) {
        if (collection == null) {
            throw new NullPointerException();
        }
        return new UnmodifiableCollection(collection);
    }

    public static List unmodifiableList(List list) {
        if (list == null) {
            throw new NullPointerException();
        }
        if (list instanceof RandomAccess) {
            return new UnmodifiableRandomAccessList(list);
        }
        return new UnmodifiableList(list);
    }

    public static Map unmodifiableMap(Map map) {
        if (map == null) {
            throw new NullPointerException();
        }
        return new UnmodifiableMap(map);
    }

    public static Set unmodifiableSet(Set set) {
        if (set == null) {
            throw new NullPointerException();
        }
        return new UnmodifiableSet(set);
    }

    public static SortedMap unmodifiableSortedMap(SortedMap map) {
        if (map == null) {
            throw new NullPointerException();
        }
        return new UnmodifiableSortedMap(map);
    }

    public static SortedSet unmodifiableSortedSet(SortedSet set) {
        if (set == null) {
            throw new NullPointerException();
        }
        return new UnmodifiableSortedSet(set);
    }

    private static final class CopiesList
    extends AbstractList
    implements Serializable {
        private static final long serialVersionUID = 2739099268398711800L;
        private final int n;
        private final Object element;

        CopiesList(int length, Object object) {
            if (length < 0) {
                throw new IllegalArgumentException();
            }
            this.n = length;
            this.element = object;
        }

        public boolean contains(Object object) {
            return this.element == null ? object == null : this.element.equals(object);
        }

        public int size() {
            return this.n;
        }

        public Object get(int location) {
            if (location >= 0 && location < this.n) {
                return this.element;
            }
            throw new IndexOutOfBoundsException();
        }
    }

    private static final class EmptyList
    extends AbstractList
    implements Serializable {
        private static final long serialVersionUID = 8842843931221139166L;

        EmptyList() {
        }

        public boolean contains(Object object) {
            return false;
        }

        public int size() {
            return 0;
        }

        public Object get(int location) {
            throw new IndexOutOfBoundsException();
        }
    }

    private static final class EmptySet
    extends AbstractSet
    implements Serializable {
        private static final long serialVersionUID = 1582296315990362920L;

        EmptySet() {
        }

        public boolean contains(Object object) {
            return false;
        }

        public int size() {
            return 0;
        }

        public Iterator iterator() {
            return new Iterator(this){
                final /* synthetic */ EmptySet this$1;
                {
                    this.this$1 = emptySet;
                }

                public boolean hasNext() {
                    return false;
                }

                public Object next() {
                    throw new NoSuchElementException();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private static final class EmptyMap
    extends AbstractMap
    implements Serializable {
        private static final long serialVersionUID = 6428348081105594320L;

        EmptyMap() {
        }

        public boolean containsKey(Object key) {
            return false;
        }

        public boolean containsValue(Object value) {
            return false;
        }

        public Set entrySet() {
            return EMPTY_SET;
        }

        public Object get(Object key) {
            return null;
        }

        public Set keySet() {
            return EMPTY_SET;
        }

        public Collection values() {
            return EMPTY_LIST;
        }
    }

    private static class ReverseComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = 7207038068494060240L;

        ReverseComparator() {
        }

        public int compare(Object o1, Object o2) {
            return -((Comparable)o1).compareTo(o2);
        }
    }

    private static final class SingletonSet
    extends AbstractSet
    implements Serializable {
        private static final long serialVersionUID = 3193687207550431679L;
        final Object element;

        SingletonSet(Object object) {
            this.element = object;
        }

        public boolean contains(Object object) {
            return this.element == null ? object == null : this.element.equals(object);
        }

        public int size() {
            return 1;
        }

        public Iterator iterator() {
            return new Iterator(this){
                boolean hasNext;
                final /* synthetic */ SingletonSet this$1;
                {
                    this.this$1 = singletonSet;
                    this.hasNext = true;
                }

                public boolean hasNext() {
                    return this.hasNext;
                }

                public Object next() {
                    if (this.hasNext) {
                        this.hasNext = false;
                        return this.this$1.element;
                    }
                    throw new NoSuchElementException();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private static final class SingletonList
    extends AbstractList
    implements Serializable {
        private static final long serialVersionUID = 3093736618740652951L;
        final Object element;

        SingletonList(Object object) {
            this.element = object;
        }

        public boolean contains(Object object) {
            return this.element == null ? object == null : this.element.equals(object);
        }

        public Object get(int location) {
            if (location == 0) {
                return this.element;
            }
            throw new IndexOutOfBoundsException();
        }

        public int size() {
            return 1;
        }
    }

    private static final class SingletonMap
    extends AbstractMap
    implements Serializable {
        private static final long serialVersionUID = -6979724477215052911L;
        final Object k;
        final Object v;

        SingletonMap(Object key, Object value) {
            this.k = key;
            this.v = value;
        }

        public boolean containsKey(Object key) {
            return this.k == null ? key == null : this.k.equals(key);
        }

        public boolean containsValue(Object value) {
            return this.v == null ? value == null : this.v.equals(value);
        }

        public Object get(Object key) {
            if (this.containsKey(key)) {
                return this.v;
            }
            return null;
        }

        public int size() {
            return 1;
        }

        public Set entrySet() {
            return new AbstractSet(this){
                final /* synthetic */ SingletonMap this$1;
                {
                    this.this$1 = singletonMap;
                }

                public boolean contains(Object object) {
                    if (object instanceof Map.Entry) {
                        Map.Entry entry = (Map.Entry)object;
                        return this.this$1.containsKey(entry.getKey()) && this.this$1.containsValue(entry.getValue());
                    }
                    return false;
                }

                public int size() {
                    return 1;
                }

                public Iterator iterator() {
                    return new Iterator(this){
                        boolean hasNext;
                        final /* synthetic */ 3 this$2;
                        {
                            this.this$2 = var1_1;
                            this.hasNext = true;
                        }

                        public boolean hasNext() {
                            return this.hasNext;
                        }

                        public Object next() {
                            if (this.hasNext) {
                                this.hasNext = false;
                                return new Map.Entry(this){
                                    final /* synthetic */ 4 this$3;
                                    {
                                        this.this$3 = var1_1;
                                    }

                                    public boolean equals(Object object) {
                                        return 4.access$0(this.this$3).contains(object);
                                    }

                                    public Object getKey() {
                                        return 3.access$0(4.access$0(this.this$3)).k;
                                    }

                                    public Object getValue() {
                                        return 3.access$0(4.access$0(this.this$3)).v;
                                    }

                                    public int hashCode() {
                                        return (3.access$0(4.access$0(this.this$3)).k == null ? 0 : 3.access$0(4.access$0(this.this$3)).k.hashCode()) ^ (3.access$0(4.access$0(this.this$3)).v == null ? 0 : 3.access$0(4.access$0(this.this$3)).v.hashCode());
                                    }

                                    public Object setValue(Object value) {
                                        throw new UnsupportedOperationException();
                                    }
                                };
                            }
                            throw new NoSuchElementException();
                        }

                        public void remove() {
                            throw new UnsupportedOperationException();
                        }

                        static /* synthetic */ 3 access$0(4 var0) {
                            return var0.this$2;
                        }
                    };
                }

                static /* synthetic */ SingletonMap access$0(3 var0) {
                    return var0.this$1;
                }
            };
        }
    }

    static class SynchronizedCollection
    implements Collection,
    Serializable {
        private static final long serialVersionUID = 3053995032091335093L;
        final Collection c;
        final Object mutex;

        SynchronizedCollection(Collection collection) {
            this.c = collection;
            this.mutex = this;
        }

        SynchronizedCollection(Collection collection, Object mutex) {
            this.c = collection;
            this.mutex = mutex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean add(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.c.add(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(Collection collection) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.addAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.c.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean contains(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.c.contains(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsAll(Collection collection) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.containsAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Iterator iterator() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.c.remove(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeAll(Collection collection) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.removeAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean retainAll(Collection collection) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.retainAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] toArray() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] toArray(Object[] array) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toArray(array);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeObject(ObjectOutputStream stream) throws IOException {
            Object object = this.mutex;
            synchronized (object) {
                stream.defaultWriteObject();
            }
        }
    }

    static class SynchronizedRandomAccessList
    extends SynchronizedList
    implements RandomAccess {
        private static final long serialVersionUID = 1530674583602358482L;

        SynchronizedRandomAccessList(List l) {
            super(l);
        }

        SynchronizedRandomAccessList(List l, Object mutex) {
            super(l, mutex);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List subList(int start, int end) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedRandomAccessList(this.list.subList(start, end), this.mutex);
            }
        }

        private Object writeReplace() {
            return new SynchronizedList(this.list);
        }
    }

    static class SynchronizedList
    extends SynchronizedCollection
    implements List {
        private static final long serialVersionUID = -7754090372962971524L;
        final List list;

        SynchronizedList(List l) {
            super(l);
            this.list = l;
        }

        SynchronizedList(List l, Object mutex) {
            super(l, mutex);
            this.list = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(int location, Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                this.list.add(location, object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(int location, Collection collection) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.addAll(location, collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.list.equals(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get(int location) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.get(location);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int indexOf(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.list.indexOf(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int lastIndexOf(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.list.lastIndexOf(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ListIterator listIterator() {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.listIterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ListIterator listIterator(int location) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.listIterator(location);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object remove(int location) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.remove(location);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object set(int location, Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.list.set(location, object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List subList(int start, int end) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedList(this.list.subList(start, end), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeObject(ObjectOutputStream stream) throws IOException {
            Object object = this.mutex;
            synchronized (object) {
                stream.defaultWriteObject();
            }
        }

        private Object readResolve() {
            if (this.list instanceof RandomAccess) {
                return new SynchronizedRandomAccessList(this.list, this.mutex);
            }
            return this;
        }
    }

    static class SynchronizedMap
    implements Map,
    Serializable {
        private static final long serialVersionUID = 1978198479659022715L;
        private final Map m;
        final Object mutex;

        SynchronizedMap(Map map) {
            this.m = map;
            this.mutex = this;
        }

        SynchronizedMap(Map map, Object mutex) {
            this.m = map;
            this.mutex = mutex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.m.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsKey(Object key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.containsKey(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsValue(Object value) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.containsValue(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set entrySet() {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSet(this.m.entrySet(), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.m.equals(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get(Object key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.get(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set keySet() {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSet(this.m.keySet(), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object put(Object key, Object value) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.put(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putAll(Map map) {
            Object object = this.mutex;
            synchronized (object) {
                this.m.putAll(map);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object remove(Object key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.remove(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection values() {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedCollection(this.m.values(), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeObject(ObjectOutputStream stream) throws IOException {
            Object object = this.mutex;
            synchronized (object) {
                stream.defaultWriteObject();
            }
        }
    }

    static class SynchronizedSet
    extends SynchronizedCollection
    implements Set {
        private static final long serialVersionUID = 487447009682186044L;

        SynchronizedSet(Set set) {
            super(set);
        }

        SynchronizedSet(Set set, Object mutex) {
            super(set, mutex);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.c.equals(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeObject(ObjectOutputStream stream) throws IOException {
            Object object = this.mutex;
            synchronized (object) {
                stream.defaultWriteObject();
            }
        }
    }

    static class SynchronizedSortedMap
    extends SynchronizedMap
    implements SortedMap {
        private static final long serialVersionUID = -8798146769416483793L;
        private final SortedMap sm;

        SynchronizedSortedMap(SortedMap map) {
            super(map);
            this.sm = map;
        }

        SynchronizedSortedMap(SortedMap map, Object mutex) {
            super(map, mutex);
            this.sm = map;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Comparator comparator() {
            Object object = this.mutex;
            synchronized (object) {
                return this.sm.comparator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object firstKey() {
            Object object = this.mutex;
            synchronized (object) {
                return this.sm.firstKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SortedMap headMap(Object endKey) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedMap(this.sm.headMap(endKey), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object lastKey() {
            Object object = this.mutex;
            synchronized (object) {
                return this.sm.lastKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SortedMap subMap(Object startKey, Object endKey) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedMap(this.sm.subMap(startKey, endKey), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SortedMap tailMap(Object startKey) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedMap(this.sm.tailMap(startKey), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeObject(ObjectOutputStream stream) throws IOException {
            Object object = this.mutex;
            synchronized (object) {
                stream.defaultWriteObject();
            }
        }
    }

    static class SynchronizedSortedSet
    extends SynchronizedSet
    implements SortedSet {
        private static final long serialVersionUID = 8695801310862127406L;
        private final SortedSet ss;

        SynchronizedSortedSet(SortedSet set) {
            super(set);
            this.ss = set;
        }

        SynchronizedSortedSet(SortedSet set, Object mutex) {
            super(set, mutex);
            this.ss = set;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Comparator comparator() {
            Object object = this.mutex;
            synchronized (object) {
                return this.ss.comparator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object first() {
            Object object = this.mutex;
            synchronized (object) {
                return this.ss.first();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SortedSet headSet(Object end) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedSet(this.ss.headSet(end), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object last() {
            Object object = this.mutex;
            synchronized (object) {
                return this.ss.last();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SortedSet subSet(Object start, Object end) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedSet(this.ss.subSet(start, end), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SortedSet tailSet(Object start) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedSet(this.ss.tailSet(start), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeObject(ObjectOutputStream stream) throws IOException {
            Object object = this.mutex;
            synchronized (object) {
                stream.defaultWriteObject();
            }
        }
    }

    private static class UnmodifiableCollection
    implements Collection,
    Serializable {
        private static final long serialVersionUID = 1820017752578914078L;
        final Collection c;

        UnmodifiableCollection(Collection collection) {
            this.c = collection;
        }

        public boolean add(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean contains(Object object) {
            return this.c.contains(object);
        }

        public boolean containsAll(Collection collection) {
            return this.c.containsAll(collection);
        }

        public boolean isEmpty() {
            return this.c.isEmpty();
        }

        public Iterator iterator() {
            return new Iterator(this){
                Iterator iterator;
                final /* synthetic */ UnmodifiableCollection this$1;
                {
                    this.this$1 = unmodifiableCollection;
                    this.iterator = unmodifiableCollection.c.iterator();
                }

                public boolean hasNext() {
                    return this.iterator.hasNext();
                }

                public Object next() {
                    return this.iterator.next();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return this.c.size();
        }

        public Object[] toArray() {
            return this.c.toArray();
        }

        public Object[] toArray(Object[] array) {
            return this.c.toArray(array);
        }
    }

    private static class UnmodifiableRandomAccessList
    extends UnmodifiableList
    implements RandomAccess {
        private static final long serialVersionUID = -2542308836966382001L;

        UnmodifiableRandomAccessList(List l) {
            super(l);
        }

        public List subList(int start, int end) {
            return new UnmodifiableRandomAccessList(this.list.subList(start, end));
        }

        private Object writeReplace() {
            return new UnmodifiableList(this.list);
        }
    }

    private static class UnmodifiableList
    extends UnmodifiableCollection
    implements List {
        private static final long serialVersionUID = -283967356065247728L;
        final List list;

        UnmodifiableList(List l) {
            super(l);
            this.list = l;
        }

        public void add(int location, Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int location, Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object object) {
            return this.list.equals(object);
        }

        public Object get(int location) {
            return this.list.get(location);
        }

        public int hashCode() {
            return this.list.hashCode();
        }

        public int indexOf(Object object) {
            return this.list.indexOf(object);
        }

        public int lastIndexOf(Object object) {
            return this.list.lastIndexOf(object);
        }

        public ListIterator listIterator() {
            return this.listIterator(0);
        }

        public ListIterator listIterator(int location) {
            return new ListIterator(this, location){
                ListIterator iterator;
                final /* synthetic */ UnmodifiableList this$1;
                {
                    this.this$1 = unmodifiableList;
                    this.iterator = unmodifiableList.list.listIterator(n);
                }

                public void add(Object object) {
                    throw new UnsupportedOperationException();
                }

                public boolean hasNext() {
                    return this.iterator.hasNext();
                }

                public boolean hasPrevious() {
                    return this.iterator.hasPrevious();
                }

                public Object next() {
                    return this.iterator.next();
                }

                public int nextIndex() {
                    return this.iterator.nextIndex();
                }

                public Object previous() {
                    return this.iterator.previous();
                }

                public int previousIndex() {
                    return this.iterator.previousIndex();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }

                public void set(Object object) {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public Object remove(int location) {
            throw new UnsupportedOperationException();
        }

        public Object set(int location, Object object) {
            throw new UnsupportedOperationException();
        }

        public List subList(int start, int end) {
            return new UnmodifiableList(this.list.subList(start, end));
        }

        private Object readResolve() {
            if (this.list instanceof RandomAccess) {
                return new UnmodifiableRandomAccessList(this.list);
            }
            return this;
        }
    }

    private static class UnmodifiableMap
    implements Map,
    Serializable {
        private static final long serialVersionUID = -1034234728574286014L;
        private final Map m;

        UnmodifiableMap(Map map) {
            this.m = map;
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean containsKey(Object key) {
            return this.m.containsKey(key);
        }

        public boolean containsValue(Object value) {
            return this.m.containsValue(value);
        }

        public Set entrySet() {
            return new UnmodifiableEntrySet(this.m.entrySet());
        }

        public boolean equals(Object object) {
            return this.m.equals(object);
        }

        public Object get(Object key) {
            return this.m.get(key);
        }

        public int hashCode() {
            return this.m.hashCode();
        }

        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        public Set keySet() {
            return new UnmodifiableSet(this.m.keySet());
        }

        public Object put(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        public void putAll(Map map) {
            throw new UnsupportedOperationException();
        }

        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return this.m.size();
        }

        public Collection values() {
            return new UnmodifiableCollection(this.m.values());
        }

        private static class UnmodifiableEntrySet
        extends UnmodifiableSet {
            private static final long serialVersionUID = 7854390611657943733L;

            UnmodifiableEntrySet(Set set) {
                super(set);
            }

            public Iterator iterator() {
                return new Iterator(this){
                    Iterator iterator;
                    final /* synthetic */ UnmodifiableEntrySet this$2;
                    {
                        this.this$2 = unmodifiableEntrySet;
                        this.iterator = unmodifiableEntrySet.c.iterator();
                    }

                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    public Object next() {
                        return new UnmodifiableMapEntry((Map.Entry)this.iterator.next());
                    }

                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            public Object[] toArray() {
                int length = this.c.size();
                Object[] result = new Object[length];
                Iterator it = this.iterator();
                int i = length;
                while (--i >= 0) {
                    result[i] = it.next();
                }
                return result;
            }

            public Object[] toArray(Object[] contents) {
                int size = this.c.size();
                int index = 0;
                Iterator it = this.iterator();
                if (size > contents.length) {
                    contents = (Object[])Array.newInstance(contents.getClass().getComponentType(), size);
                }
                while (index < size) {
                    contents[index++] = it.next();
                }
                if (index < contents.length) {
                    contents[index] = null;
                }
                return contents;
            }

            private static class UnmodifiableMapEntry
            implements Map.Entry {
                Map.Entry mapEntry;

                UnmodifiableMapEntry(Map.Entry entry) {
                    this.mapEntry = entry;
                }

                public boolean equals(Object object) {
                    return this.mapEntry.equals(object);
                }

                public Object getKey() {
                    return this.mapEntry.getKey();
                }

                public Object getValue() {
                    return this.mapEntry.getValue();
                }

                public int hashCode() {
                    return this.mapEntry.hashCode();
                }

                public Object setValue(Object object) {
                    throw new UnsupportedOperationException();
                }

                public String toString() {
                    return this.mapEntry.toString();
                }
            }
        }
    }

    private static class UnmodifiableSet
    extends UnmodifiableCollection
    implements Set {
        private static final long serialVersionUID = -9215047833775013803L;

        UnmodifiableSet(Set set) {
            super(set);
        }

        public boolean equals(Object object) {
            return this.c.equals(object);
        }

        public int hashCode() {
            return this.c.hashCode();
        }
    }

    private static class UnmodifiableSortedMap
    extends UnmodifiableMap
    implements SortedMap {
        private static final long serialVersionUID = -8806743815996713206L;
        private final SortedMap sm;

        UnmodifiableSortedMap(SortedMap map) {
            super(map);
            this.sm = map;
        }

        public Comparator comparator() {
            return this.sm.comparator();
        }

        public Object firstKey() {
            return this.sm.firstKey();
        }

        public SortedMap headMap(Object before) {
            return new UnmodifiableSortedMap(this.sm.headMap(before));
        }

        public Object lastKey() {
            return this.sm.lastKey();
        }

        public SortedMap subMap(Object start, Object end) {
            return new UnmodifiableSortedMap(this.sm.subMap(start, end));
        }

        public SortedMap tailMap(Object after) {
            return new UnmodifiableSortedMap(this.sm.tailMap(after));
        }
    }

    private static class UnmodifiableSortedSet
    extends UnmodifiableSet
    implements SortedSet {
        private static final long serialVersionUID = -4929149591599911165L;
        private final SortedSet ss;

        UnmodifiableSortedSet(SortedSet set) {
            super(set);
            this.ss = set;
        }

        public Comparator comparator() {
            return this.ss.comparator();
        }

        public Object first() {
            return this.ss.first();
        }

        public SortedSet headSet(Object before) {
            return new UnmodifiableSortedSet(this.ss.headSet(before));
        }

        public Object last() {
            return this.ss.last();
        }

        public SortedSet subSet(Object start, Object end) {
            return new UnmodifiableSortedSet(this.ss.subSet(start, end));
        }

        public SortedSet tailSet(Object after) {
            return new UnmodifiableSortedSet(this.ss.tailSet(after));
        }
    }
}

