/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.TimeZoneTable;

public class GregorianCalendar
extends Calendar {
    private static final long serialVersionUID = -8125100834729963327L;
    public static final int BC = 0;
    public static final int AD = 1;
    private long gregorianCutover = -12219292800000L;
    private transient int changeYear = 1582;
    private transient int julianSkew = (this.changeYear - 2000) / 400 + this.julianError() - (this.changeYear - 2000) / 100;
    static byte[] DaysInMonth = new byte[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static int[] DaysInYear;
    private static int[] maximums;
    private static int[] minimums;
    private static int[] leastMaximums;
    private static final int CACHED_YEAR = 0;
    private static final int CACHED_MONTH = 1;
    private static final int CACHED_DATE = 2;
    private static final int CACHED_DAY_OF_WEEK = 3;
    private static final int CACHED_TZ_OFFSET = 4;
    private transient boolean isCached = false;
    private static final int CACHED_ZONE_OFFSET = 5;
    private static final int CACHED_DST_OFFSET = 6;
    private static final int CACHED_ERA = 7;
    private static final int CACHED_WEEK_OF_YEAR = 8;
    private static final int CACHED_WEEK_OF_MONTH = 9;
    private static final int CACHED_DAY_OF_YEAR = 10;
    private static final int CACHED_DAY_OF_WEEK_IN_MONTH = 11;
    private transient int[] cachedFields = new int[12];
    private transient long nextMidnightMillis = 0L;
    private transient long lastMidnightMillis = 0L;

    static {
        int[] nArray = new int[12];
        nArray[1] = 31;
        nArray[2] = 59;
        nArray[3] = 90;
        nArray[4] = 120;
        nArray[5] = 151;
        nArray[6] = 181;
        nArray[7] = 212;
        nArray[8] = 243;
        nArray[9] = 273;
        nArray[10] = 304;
        nArray[11] = 334;
        DaysInYear = nArray;
        maximums = new int[]{1, 292278994, 11, 53, 6, 31, 366, 7, 6, 1, 11, 23, 59, 59, 999, 43200000, 3600000};
        int[] nArray2 = new int[17];
        nArray2[1] = 1;
        nArray2[3] = 1;
        nArray2[5] = 1;
        nArray2[6] = 1;
        nArray2[7] = 1;
        nArray2[8] = -1;
        nArray2[15] = -43200000;
        minimums = nArray2;
        leastMaximums = new int[]{1, 292269054, 11, 52, 4, 28, 365, 7, 4, 1, 11, 23, 59, 59, 999, 43200000, 3600000};
    }

    public GregorianCalendar() {
        this(TimeZone.getDefault(), Locale.getDefault());
    }

    public GregorianCalendar(int year, int month, int day) {
        super(TimeZone.getDefault(), Locale.getDefault());
        this.set(year, month, day);
    }

    public GregorianCalendar(int year, int month, int day, int hour, int minute) {
        super(TimeZone.getDefault(), Locale.getDefault());
        this.set(year, month, day, hour, minute);
    }

    public GregorianCalendar(int year, int month, int day, int hour, int minute, int second) {
        super(TimeZone.getDefault(), Locale.getDefault());
        this.set(year, month, day, hour, minute, second);
    }

    GregorianCalendar(long milliseconds) {
        this(false);
        this.setTimeInMillis(milliseconds);
    }

    public GregorianCalendar(Locale locale) {
        this(TimeZone.getDefault(), locale);
    }

    public GregorianCalendar(TimeZone timezone) {
        this(timezone, Locale.getDefault());
    }

    public GregorianCalendar(TimeZone timezone, Locale locale) {
        super(timezone, locale);
        this.setTimeInMillis(System.currentTimeMillis());
    }

    GregorianCalendar(boolean ignored) {
        super(TimeZone.getDefault());
        this.setFirstDayOfWeek(1);
        this.setMinimalDaysInFirstWeek(1);
    }

    public void add(int field, int value) {
        if (value == 0) {
            return;
        }
        if (field < 0 || field >= 15) {
            throw new IllegalArgumentException();
        }
        this.isCached = false;
        if (field == 0) {
            this.complete();
            if (this.fields[0] == 1) {
                if (value >= 0) {
                    return;
                }
                this.set(0, 0);
            } else {
                if (value <= 0) {
                    return;
                }
                this.set(0, 1);
            }
            this.complete();
            return;
        }
        if (field == 1 || field == 2) {
            this.complete();
            if (field == 2) {
                int month = this.fields[2] + value;
                if (month < 0) {
                    value = (month - 11) / 12;
                    month = 12 + month % 12;
                } else {
                    value = month / 12;
                }
                this.set(2, month % 12);
            }
            this.set(1, this.fields[1] + value);
            int days = this.daysInMonth(this.isLeapYear(this.fields[1]), this.fields[2]);
            if (this.fields[5] > days) {
                this.set(5, days);
            }
            this.complete();
            return;
        }
        long multiplier = 0L;
        this.getTimeInMillis();
        switch (field) {
            case 14: {
                this.time += (long)value;
                break;
            }
            case 13: {
                this.time += (long)value * 1000L;
                break;
            }
            case 12: {
                this.time += (long)value * 60000L;
                break;
            }
            case 10: 
            case 11: {
                this.time += (long)value * 3600000L;
                break;
            }
            case 9: {
                multiplier = 43200000L;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                multiplier = 86400000L;
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                multiplier = 604800000L;
            }
        }
        if (multiplier > 0L) {
            int offset = this.getTimeZone().getOffset(this.time);
            this.time += (long)value * multiplier;
            int newOffset = this.getTimeZone().getOffset(this.time);
            if (newOffset != offset) {
                this.time += (long)(offset - newOffset);
            }
        }
        this.areFieldsSet = false;
        this.complete();
    }

    private final void fullFieldsCalc(long time, int orgMillis, int offset) {
        int dstOffset;
        int dayOfYear;
        long days = time / 86400000L;
        long zoneMillis = (long)orgMillis + (long)offset;
        while (zoneMillis < 0L) {
            zoneMillis += 86400000L;
            --days;
        }
        while (zoneMillis >= 86400000L) {
            zoneMillis -= 86400000L;
            ++days;
        }
        int millis = (int)zoneMillis;
        this.fields[6] = dayOfYear = this.computeYearAndDay(days, time + (long)offset);
        int month = dayOfYear / 32;
        boolean leapYear = this.isLeapYear(this.fields[1]);
        int date = dayOfYear - this.daysInYear(leapYear, month);
        if (date > this.daysInMonth(leapYear, month)) {
            date -= this.daysInMonth(leapYear, month);
            ++month;
        }
        this.fields[7] = this.mod7(days - 3L) + 1;
        TimeZone zone = this.getTimeZone();
        boolean inDaylight = zone.inDaylightTime(new Date(time));
        this.fields[16] = dstOffset = inDaylight ? zone.getDSTSavings() : 0;
        this.fields[15] = offset - dstOffset;
        this.fields[14] = millis % 1000;
        this.fields[13] = (millis /= 1000) % 60;
        this.fields[12] = (millis /= 60) % 60;
        this.fields[11] = (millis /= 60) % 24;
        millis /= 24;
        this.fields[9] = this.fields[11] > 11 ? 1 : 0;
        this.fields[10] = this.fields[11] % 12;
        if (this.fields[1] <= 0) {
            this.fields[0] = 0;
            this.fields[1] = -this.fields[1] + 1;
        } else {
            this.fields[0] = 1;
        }
        this.fields[2] = month;
        this.fields[5] = date;
        this.fields[8] = (date - 1) / 7 + 1;
        this.fields[4] = (date - 1 + this.mod7(days - (long)date - 2L - (long)(this.getFirstDayOfWeek() - 1))) / 7 + 1;
        int daysFromStart = this.mod7(days - 3L - (long)(this.fields[6] - 1) - (long)(this.getFirstDayOfWeek() - 1));
        int week = (this.fields[6] - 1 + daysFromStart) / 7 + (7 - daysFromStart >= this.getMinimalDaysInFirstWeek() ? 1 : 0);
        this.fields[3] = week == 0 ? (7 - this.mod7(daysFromStart - (this.isLeapYear(this.fields[1] - 1) ? 2 : 1)) >= this.getMinimalDaysInFirstWeek() ? 53 : 52) : (this.fields[6] >= (leapYear ? 367 : 366) - this.mod7(daysFromStart + (leapYear ? 2 : 1)) ? (7 - this.mod7(daysFromStart + (leapYear ? 2 : 1)) >= this.getMinimalDaysInFirstWeek() ? 1 : week) : week);
    }

    private final void updateCachedFields() {
        this.fields[1] = this.cachedFields[0];
        this.fields[2] = this.cachedFields[1];
        this.fields[5] = this.cachedFields[2];
        this.fields[7] = this.cachedFields[3];
        this.fields[15] = this.cachedFields[5];
        this.fields[16] = this.cachedFields[6];
        this.fields[0] = this.cachedFields[7];
        this.fields[3] = this.cachedFields[8];
        this.fields[4] = this.cachedFields[9];
        this.fields[6] = this.cachedFields[10];
        this.fields[8] = this.cachedFields[11];
    }

    protected void computeFields() {
        this.actualComputeFields();
        int i = 0;
        while (i < 17) {
            this.isSet[i] = true;
            ++i;
        }
    }

    private void actualComputeFields() {
        int millis;
        int savedMillis = millis = (int)(this.time % 86400000L);
        int offset = this.getTimeZone().getOffset(this.time);
        long newTime = this.time + (long)offset;
        if (this.time > 0L && newTime < 0L && offset > 0) {
            newTime = Long.MAX_VALUE;
        } else if (this.time < 0L && newTime > 0L && offset < 0) {
            newTime = Long.MIN_VALUE;
        }
        if (this.isCached) {
            if (offset != this.cachedFields[4] || offset <= -86400000 || offset >= 86400000) {
                this.isCached = false;
            } else {
                if (millis < 0) {
                    millis += 86400000;
                }
                if ((millis += offset) < 0) {
                    millis += 86400000;
                } else if (millis >= 86400000) {
                    millis -= 86400000;
                }
                if (newTime >= this.nextMidnightMillis || newTime <= this.lastMidnightMillis) {
                    this.isCached = false;
                } else {
                    this.updateCachedFields();
                    this.fields[14] = millis % 1000;
                    this.fields[13] = (millis /= 1000) % 60;
                    this.fields[12] = (millis /= 60) % 60;
                    this.fields[11] = (millis /= 60) % 24;
                    millis /= 24;
                    this.fields[9] = this.fields[11] > 11 ? 1 : 0;
                    this.fields[10] = this.fields[11] % 12;
                    if (this.getTimeZone() instanceof TimeZoneTable) {
                        int dst = 0;
                        TimeZoneTable table = (TimeZoneTable)this.getTimeZone();
                        if (table.inDaylightTime(new Date(this.time))) {
                            dst = table.getDSTSavings();
                        }
                        if (dst != this.cachedFields[6]) {
                            this.fields[16] = dst;
                            this.fields[15] = offset - dst;
                        }
                    }
                }
            }
        }
        if (!this.isCached) {
            this.fullFieldsCalc(this.time, savedMillis, offset);
        }
        if (!this.isCached && newTime != Long.MAX_VALUE && newTime != Long.MIN_VALUE && (!this.getTimeZone().useDaylightTime() || this.getTimeZone() instanceof SimpleTimeZone || this.getTimeZone() instanceof TimeZoneTable)) {
            int cacheMillis = 0;
            this.cachedFields[0] = this.fields[1];
            this.cachedFields[1] = this.fields[2];
            this.cachedFields[2] = this.fields[5];
            this.cachedFields[3] = this.fields[7];
            this.cachedFields[4] = offset;
            this.cachedFields[5] = this.fields[15];
            this.cachedFields[6] = this.fields[16];
            this.cachedFields[7] = this.fields[0];
            this.cachedFields[8] = this.fields[3];
            this.cachedFields[9] = this.fields[4];
            this.cachedFields[10] = this.fields[6];
            this.cachedFields[11] = this.fields[8];
            cacheMillis += (23 - this.fields[11]) * 60 * 60 * 1000;
            cacheMillis += (59 - this.fields[12]) * 60 * 1000;
            this.nextMidnightMillis = newTime + (long)(cacheMillis += (59 - this.fields[13]) * 1000);
            cacheMillis = this.fields[11] * 60 * 60 * 1000;
            cacheMillis += this.fields[12] * 60 * 1000;
            this.lastMidnightMillis = newTime - (long)(cacheMillis += this.fields[13] * 1000);
            this.isCached = true;
        }
    }

    protected void computeTime() {
        int offset2;
        int offset1;
        long days;
        boolean useMonth;
        if (!this.isLenient()) {
            if (this.isSet[11] ? this.fields[11] < 0 || this.fields[11] > 23 : this.isSet[10] && (this.fields[10] < 0 || this.fields[10] > 11)) {
                throw new IllegalArgumentException();
            }
            if (this.isSet[12] && (this.fields[12] < 0 || this.fields[12] > 59)) {
                throw new IllegalArgumentException();
            }
            if (this.isSet[13] && (this.fields[13] < 0 || this.fields[13] > 59)) {
                throw new IllegalArgumentException();
            }
            if (this.isSet[14] && (this.fields[14] < 0 || this.fields[14] > 999)) {
                throw new IllegalArgumentException();
            }
            if (this.isSet[3] && (this.fields[3] < 1 || this.fields[3] > 53)) {
                throw new IllegalArgumentException();
            }
            if (this.isSet[7] && (this.fields[7] < 1 || this.fields[7] > 7)) {
                throw new IllegalArgumentException();
            }
            if (this.isSet[8] && (this.fields[8] < 1 || this.fields[8] > 6)) {
                throw new IllegalArgumentException();
            }
            if (this.isSet[4] && (this.fields[4] < 1 || this.fields[4] > 6)) {
                throw new IllegalArgumentException();
            }
            if (this.isSet[9] && this.fields[9] != 0 && this.fields[9] != 1) {
                throw new IllegalArgumentException();
            }
            if (this.isSet[10] && (this.fields[10] < 0 || this.fields[10] > 11)) {
                throw new IllegalArgumentException();
            }
            if (this.isSet[1]) {
                if (this.isSet[0] && this.fields[0] == 0 && (this.fields[1] < 1 || this.fields[1] > 292269054)) {
                    throw new IllegalArgumentException();
                }
                if (this.fields[1] < 1 || this.fields[1] > 292278994) {
                    throw new IllegalArgumentException();
                }
            }
            if (this.isSet[2] && (this.fields[2] < 0 || this.fields[2] > 11)) {
                throw new IllegalArgumentException();
            }
        }
        int hour = 0;
        if (this.isSet[11] && this.lastTimeFieldSet != 10) {
            hour = this.fields[11];
        } else if (this.isSet[10]) {
            hour = this.fields[9] * 12 + this.fields[10];
        }
        long time = hour * 3600000;
        if (this.isSet[12]) {
            time += (long)(this.fields[12] * 60000);
        }
        if (this.isSet[13]) {
            time += (long)(this.fields[13] * 1000);
        }
        if (this.isSet[14]) {
            time += (long)this.fields[14];
        }
        int year = this.isSet[1] ? this.fields[1] : 1970;
        this.lastTimeFieldSet = 0;
        if (this.isSet[0]) {
            if (this.fields[0] != 0 && this.fields[0] != 1) {
                throw new IllegalArgumentException();
            }
            if (this.fields[0] == 0) {
                year = 1 - year;
            }
        }
        boolean weekMonthSet = this.isSet[4] || this.isSet[8];
        boolean bl = useMonth = (this.isSet[5] || this.isSet[2] || weekMonthSet) && this.lastDateFieldSet != 6;
        if (useMonth && (this.lastDateFieldSet == 7 || this.lastDateFieldSet == 3)) {
            if (this.isSet[3] && this.isSet[7]) {
                useMonth = this.lastDateFieldSet != 3 && weekMonthSet && this.isSet[7];
            } else if (this.isSet[6]) {
                boolean bl2 = useMonth = this.isSet[5] && this.isSet[2];
            }
        }
        if (useMonth) {
            int month = this.fields[2];
            year += month / 12;
            if ((month %= 12) < 0) {
                --year;
                month += 12;
            }
            boolean leapYear = this.isLeapYear(year);
            days = this.daysFromBaseYear(year) + (long)this.daysInYear(leapYear, month);
            boolean useDate = this.isSet[5];
            if (useDate && (this.lastDateFieldSet == 7 || this.lastDateFieldSet == 4 || this.lastDateFieldSet == 8)) {
                boolean bl3 = useDate = !this.isSet[7] || !weekMonthSet;
            }
            if (useDate) {
                if (!(this.isLenient() || this.fields[5] >= 1 && this.fields[5] <= this.daysInMonth(leapYear, month))) {
                    throw new IllegalArgumentException();
                }
                days += (long)(this.fields[5] - 1);
            } else {
                int dayOfWeek = this.isSet[7] ? this.fields[7] - 1 : this.getFirstDayOfWeek() - 1;
                if (this.isSet[4] && this.lastDateFieldSet != 8) {
                    int skew = this.mod7(days - 3L - (long)(this.getFirstDayOfWeek() - 1));
                    days += (long)((this.fields[4] - 1) * 7 + this.mod7((long)(skew + dayOfWeek) - (days - 3L)) - skew);
                } else if (this.isSet[8]) {
                    days = this.fields[8] >= 0 ? (days += (long)(this.mod7((long)dayOfWeek - (days - 3L)) + (this.fields[8] - 1) * 7)) : (days += (long)(this.daysInMonth(leapYear, month) + this.mod7((long)dayOfWeek - (days + (long)this.daysInMonth(leapYear, month) - 3L)) + this.fields[8] * 7));
                }
            }
        } else {
            boolean useWeekYear;
            boolean bl4 = useWeekYear = this.isSet[3] && this.lastDateFieldSet != 6;
            if (useWeekYear && this.isSet[6]) {
                useWeekYear = this.isSet[7];
            }
            days = this.daysFromBaseYear(year);
            if (useWeekYear) {
                int dayOfWeek = this.isSet[7] ? this.fields[7] - 1 : this.getFirstDayOfWeek() - 1;
                int skew = this.mod7(days - 3L - (long)(this.getFirstDayOfWeek() - 1));
                days += (long)((this.fields[3] - 1) * 7 + this.mod7((long)(skew + dayOfWeek) - (days - 3L)) - skew);
                if (7 - skew < this.getMinimalDaysInFirstWeek()) {
                    days += 7L;
                }
            } else if (this.isSet[6]) {
                if (!(this.isLenient() || this.fields[6] >= 1 && this.fields[6] <= 365 + (this.isLeapYear(year) ? 1 : 0))) {
                    throw new IllegalArgumentException();
                }
                days += (long)(this.fields[6] - 1);
            } else if (this.isSet[7]) {
                days += (long)this.mod7((long)(this.fields[7] - 1) - (days - 3L));
            }
        }
        this.lastDateFieldSet = 0;
        if (year == this.changeYear && (time += days * 86400000L) >= this.gregorianCutover + (long)(this.julianError() * 86400000)) {
            time -= (long)(this.julianError() * 86400000);
        }
        time = (offset1 = this.getOffset(time)) == (offset2 = this.getTimeZone().getOffset(time - (long)offset1)) ? (time -= (long)offset1) : (time -= (long)offset2);
        this.time = time;
        if (!this.areFieldsSet) {
            this.actualComputeFields();
            this.areFieldsSet = true;
        }
    }

    private int computeYearAndDay(long dayCount, long localTime) {
        int approxYears;
        int year = 1970;
        long days = dayCount;
        if (localTime < this.gregorianCutover) {
            days -= (long)this.julianSkew;
        }
        while ((approxYears = (int)(days / 365L)) != 0) {
            days = dayCount - this.daysFromBaseYear(year += approxYears);
        }
        if (days < 0L) {
            days = days + 365L + (long)(this.isLeapYear(--year) ? 1 : 0);
            if (year == this.changeYear && localTime < this.gregorianCutover) {
                days -= (long)this.julianError();
            }
        }
        this.fields[1] = year;
        return (int)days + 1;
    }

    private long daysFromBaseYear(int year) {
        if (year >= 1970) {
            long days = (long)(year - 1970) * 365L + (long)((year - 1969) / 4);
            days = year > this.changeYear ? (days -= (long)((year - 1901) / 100 - (year - 1601) / 400)) : (days += (long)this.julianSkew);
            return days;
        }
        if (year <= this.changeYear) {
            return (long)(year - 1970) * 365L + (long)((year - 1972) / 4) + (long)this.julianSkew;
        }
        return (long)(year - 1970) * 365L + (long)((year - 1972) / 4) - (long)((year - 2000) / 100) + (long)((year - 2000) / 400);
    }

    private int daysInMonth() {
        return this.daysInMonth(this.isLeapYear(this.fields[1]), this.fields[2]);
    }

    private int daysInMonth(boolean leapYear, int month) {
        if (leapYear && month == 1) {
            return DaysInMonth[month] + 1;
        }
        return DaysInMonth[month];
    }

    private int daysInYear() {
        return this.isLeapYear(this.fields[1]) ? 366 : 365;
    }

    private int daysInYear(boolean leapYear, int month) {
        if (leapYear && month > 1) {
            return DaysInYear[month] + 1;
        }
        return DaysInYear[month];
    }

    public boolean equals(Object object) {
        return super.equals(object) && this.gregorianCutover == ((GregorianCalendar)object).gregorianCutover;
    }

    public int getActualMaximum(int field) {
        int value = this.getMaximum(field);
        if (value == this.getLeastMaximum(field)) {
            return value;
        }
        switch (field) {
            case 3: 
            case 4: {
                this.isCached = false;
            }
        }
        this.complete();
        long orgTime = this.time;
        int result = 0;
        switch (field) {
            case 3: {
                this.set(5, 31);
                this.set(2, 11);
                result = this.get(3);
                if (result == 1) {
                    this.set(5, 24);
                    result = this.get(3);
                }
                this.areFieldsSet = false;
                break;
            }
            case 4: {
                this.set(5, this.daysInMonth());
                result = this.get(4);
                this.areFieldsSet = false;
                break;
            }
            case 5: {
                return this.daysInMonth();
            }
            case 6: {
                return this.daysInYear();
            }
            case 8: {
                result = this.get(8) + (this.daysInMonth() - this.get(5)) / 7;
                break;
            }
            case 1: {
                GregorianCalendar clone = (GregorianCalendar)this.clone();
                if (this.get(0) == 1) {
                    clone.setTimeInMillis(Long.MAX_VALUE);
                } else {
                    clone.setTimeInMillis(Long.MIN_VALUE);
                }
                result = clone.get(1);
                clone.set(1, this.get(1));
                if (!clone.before(this)) break;
                --result;
            }
        }
        this.time = orgTime;
        return result;
    }

    public int getActualMinimum(int field) {
        return this.getMinimum(field);
    }

    public int getGreatestMinimum(int field) {
        return minimums[field];
    }

    public final Date getGregorianChange() {
        return new Date(this.gregorianCutover);
    }

    public int getLeastMaximum(int field) {
        return leastMaximums[field];
    }

    public int getMaximum(int field) {
        return maximums[field];
    }

    public int getMinimum(int field) {
        return minimums[field];
    }

    int getOffset(long localTime) {
        int approxYears;
        TimeZone timeZone = this.getTimeZone();
        if (!(timeZone instanceof TimeZoneTable) && !timeZone.useDaylightTime()) {
            return timeZone.getRawOffset();
        }
        long dayCount = localTime / 86400000L;
        int millis = (int)(localTime % 86400000L);
        if (millis < 0) {
            millis += 86400000;
            --dayCount;
        }
        int year = 1970;
        long days = dayCount;
        if (localTime < this.gregorianCutover) {
            days -= (long)this.julianSkew;
        }
        while ((approxYears = (int)(days / 365L)) != 0) {
            days = dayCount - this.daysFromBaseYear(year += approxYears);
        }
        if (days < 0L) {
            days = days + 365L + (long)(this.isLeapYear(--year) ? 1 : 0);
            if (year == this.changeYear && localTime < this.gregorianCutover) {
                days -= (long)this.julianError();
            }
        }
        if (year <= 0) {
            return timeZone.getRawOffset();
        }
        int dayOfYear = (int)days + 1;
        int month = dayOfYear / 32;
        boolean leapYear = this.isLeapYear(year);
        int date = dayOfYear - this.daysInYear(leapYear, month);
        if (date > this.daysInMonth(leapYear, month)) {
            date -= this.daysInMonth(leapYear, month);
            ++month;
        }
        int dayOfWeek = this.mod7(dayCount - 3L) + 1;
        int offset = timeZone.getOffset(1, year, month, date, dayOfWeek, millis);
        return offset;
    }

    public int hashCode() {
        return super.hashCode() + ((int)(this.gregorianCutover >>> 32) ^ (int)this.gregorianCutover);
    }

    public boolean isLeapYear(int year) {
        if (year > this.changeYear) {
            return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
        }
        return year % 4 == 0;
    }

    private int julianError() {
        return this.changeYear / 100 - this.changeYear / 400 - 2;
    }

    private int mod(int value, int mod) {
        int rem = value % mod;
        if (value < 0 && rem < 0) {
            return rem + mod;
        }
        return rem;
    }

    private int mod7(long num1) {
        int rem = (int)(num1 % 7L);
        if (num1 < 0L && rem < 0) {
            return rem + 7;
        }
        return rem;
    }

    public void roll(int field, int value) {
        if (value == 0) {
            return;
        }
        if (field < 0 || field >= 15) {
            throw new IllegalArgumentException();
        }
        this.isCached = false;
        this.complete();
        int max = -1;
        switch (field) {
            case 1: {
                max = maximums[field];
                break;
            }
            case 3: 
            case 4: {
                int day;
                int days;
                if (field == 3) {
                    days = this.daysInYear();
                    day = 6;
                } else {
                    days = this.daysInMonth();
                    day = 5;
                }
                int mod = this.mod7(this.fields[7] - this.fields[day] - (this.getFirstDayOfWeek() - 1));
                int maxWeeks = (days - 1 + mod) / 7 + 1;
                int newWeek = this.mod(this.fields[field] - 1 + value, maxWeeks) + 1;
                if (newWeek == maxWeeks) {
                    if (this.fields[day] + (newWeek - this.fields[field]) * 7 > days) {
                        this.set(day, days);
                        break;
                    }
                    this.set(field, newWeek);
                    break;
                }
                if (newWeek == 1) {
                    int week = (this.fields[day] - (this.fields[day] - 1) / 7 * 7 - 1 + mod) / 7 + 1;
                    if (week > 1) {
                        this.set(day, 1);
                        break;
                    }
                    this.set(field, newWeek);
                    break;
                }
                this.set(field, newWeek);
                break;
            }
            case 5: {
                max = this.daysInMonth();
                break;
            }
            case 6: {
                max = this.daysInYear();
                break;
            }
            case 7: {
                max = maximums[field];
                this.lastDateFieldSet = 4;
                break;
            }
            case 8: {
                max = (this.fields[5] + (this.daysInMonth() - this.fields[5]) / 7 * 7 - 1) / 7 + 1;
                break;
            }
            case 0: 
            case 2: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                this.set(field, this.mod(this.fields[field] + value, maximums[field] + 1));
                if (field == 2 && this.fields[5] > this.daysInMonth()) {
                    this.set(5, this.daysInMonth());
                    break;
                }
                if (field != 9) break;
                this.lastTimeFieldSet = 10;
            }
        }
        if (max != -1) {
            this.set(field, this.mod(this.fields[field] - 1 + value, max) + 1);
        }
        this.complete();
    }

    public void roll(int field, boolean increment) {
        this.roll(field, increment ? 1 : -1);
    }

    public void setGregorianChange(Date date) {
        this.gregorianCutover = date.getTime();
        GregorianCalendar cal = new GregorianCalendar(TimeZone.GMT);
        cal.setTime(date);
        this.changeYear = cal.get(1);
        if (cal.get(0) == 0) {
            this.changeYear = 1 - this.changeYear;
        }
        this.julianSkew = (this.changeYear - 2000) / 400 + this.julianError() - (this.changeYear - 2000) / 100;
        this.isCached = false;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.setGregorianChange(new Date(this.gregorianCutover));
        this.isCached = false;
    }

    public void setFirstDayOfWeek(int value) {
        super.setFirstDayOfWeek(value);
        this.isCached = false;
    }

    public void setMinimalDaysInFirstWeek(int value) {
        super.setMinimalDaysInFirstWeek(value);
        this.isCached = false;
    }

    public void setTimeZone(TimeZone timezone) {
        super.setTimeZone(timezone);
        this.isCached = false;
    }
}

