/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.MapEntry;
import java.util.NoSuchElementException;
import java.util.Set;

public class IdentityHashMap
extends AbstractMap
implements Map,
Serializable,
Cloneable {
    private static final long serialVersionUID = 8188218128353913216L;
    transient Object[] elementData;
    int size;
    transient int threshold;
    private static final int DEFAULT_MAX_SIZE = 21;
    private static final int loadFactor = 7500;
    transient int modCount = 0;
    private static final Object NULL_OBJECT = new Object();

    public IdentityHashMap() {
        this(21);
    }

    public IdentityHashMap(int maxSize) {
        if (maxSize < 0) {
            throw new IllegalArgumentException();
        }
        this.size = 0;
        this.threshold = this.getThreshold(maxSize);
        this.elementData = this.newElementArray(this.computeElementArraySize());
    }

    private int getThreshold(int maxSize) {
        return maxSize > 3 ? maxSize : 3;
    }

    private int computeElementArraySize() {
        return (int)((long)this.threshold * 10000L / 7500L) * 2;
    }

    private Object[] newElementArray(int s) {
        return new Object[s];
    }

    public IdentityHashMap(Map map) {
        this(map.size() < 6 ? 11 : map.size() * 2);
        this.putAll(map);
    }

    public void clear() {
        this.size = 0;
        int i = 0;
        while (i < this.elementData.length) {
            this.elementData[i] = null;
            ++i;
        }
        ++this.modCount;
    }

    public boolean containsKey(Object key) {
        int index;
        if (key == null) {
            key = NULL_OBJECT;
        }
        return this.elementData[index = this.findIndex(key, this.elementData)] == key;
    }

    public boolean containsValue(Object value) {
        if (value == null) {
            value = NULL_OBJECT;
        }
        int i = 1;
        while (i < this.elementData.length) {
            if (this.elementData[i] == value) {
                return true;
            }
            i += 2;
        }
        return false;
    }

    public Object get(Object key) {
        int index;
        if (key == null) {
            key = NULL_OBJECT;
        }
        if (this.elementData[index = this.findIndex(key, this.elementData)] == key) {
            Object result = this.elementData[index + 1];
            return result == NULL_OBJECT ? null : result;
        }
        return null;
    }

    private IdentityHashMapEntry getEntry(Object key) {
        int index;
        if (key == null) {
            key = NULL_OBJECT;
        }
        if (this.elementData[index = this.findIndex(key, this.elementData)] == key) {
            return this.getEntry(index);
        }
        return null;
    }

    private IdentityHashMapEntry getEntry(int index) {
        Object key = this.elementData[index];
        Object value = this.elementData[index + 1];
        if (key == NULL_OBJECT) {
            key = null;
        }
        if (value == NULL_OBJECT) {
            value = null;
        }
        return new IdentityHashMapEntry(key, value);
    }

    private int findIndex(Object key, Object[] array) {
        int length = array.length;
        int index = this.getModuloHash(key, length);
        int last = (index + length - 2) % length;
        while (index != last) {
            if (array[index] == key || array[index] == null) break;
            index = (index + 2) % length;
        }
        return index;
    }

    private int getModuloHash(Object key, int length) {
        return (System.identityHashCode(key) & Integer.MAX_VALUE) % (length / 2) * 2;
    }

    public Object put(Object key, Object value) {
        int index;
        if (key == null) {
            key = NULL_OBJECT;
        }
        if (value == null) {
            value = NULL_OBJECT;
        }
        if (this.elementData[index = this.findIndex(key, this.elementData)] != key) {
            ++this.modCount;
            if (++this.size > this.threshold) {
                this.rehash();
                index = this.findIndex(key, this.elementData);
            }
            this.elementData[index] = key;
            this.elementData[index + 1] = null;
        }
        Object result = this.elementData[index + 1];
        this.elementData[index + 1] = value;
        return result == NULL_OBJECT ? null : result;
    }

    private void rehash() {
        int newlength = this.elementData.length << 1;
        if (newlength == 0) {
            newlength = 1;
        }
        Object[] newData = this.newElementArray(newlength);
        int i = 0;
        while (i < this.elementData.length) {
            Object key = this.elementData[i];
            if (key != null) {
                int index = this.findIndex(key, newData);
                newData[index] = key;
                newData[index + 1] = this.elementData[i + 1];
            }
            i += 2;
        }
        this.elementData = newData;
        this.computeMaxSize();
    }

    private void computeMaxSize() {
        this.threshold = (int)((long)(this.elementData.length / 2) * 7500L / 10000L);
    }

    public Object remove(Object key) {
        Object object;
        int next;
        int index;
        if (key == null) {
            key = NULL_OBJECT;
        }
        if (this.elementData[index = (next = this.findIndex(key, this.elementData))] != key) {
            return null;
        }
        Object result = this.elementData[index + 1];
        int length = this.elementData.length;
        while ((object = this.elementData[next = (next + 2) % length]) != null) {
            boolean hashedOk;
            int hash = this.getModuloHash(object, length);
            boolean bl = hashedOk = hash > index;
            if (next < index) {
                hashedOk = hashedOk || hash <= next;
            } else {
                boolean bl2 = hashedOk = hashedOk && hash <= next;
            }
            if (hashedOk) continue;
            this.elementData[index] = object;
            this.elementData[index + 1] = this.elementData[next + 1];
            index = next;
        }
        --this.size;
        ++this.modCount;
        this.elementData[index] = null;
        this.elementData[index + 1] = null;
        return result == NULL_OBJECT ? null : result;
    }

    public Set entrySet() {
        return new IdentityHashMapEntrySet(this);
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet(){

                public boolean contains(Object object) {
                    return IdentityHashMap.this.containsKey(object);
                }

                public int size() {
                    return IdentityHashMap.this.size();
                }

                public void clear() {
                    IdentityHashMap.this.clear();
                }

                public boolean remove(Object key) {
                    if (IdentityHashMap.this.containsKey(key)) {
                        IdentityHashMap.this.remove(key);
                        return true;
                    }
                    return false;
                }

                public Iterator iterator() {
                    return new IdentityHashMapIterator(new MapEntry.Type(this){
                        final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public Object get(MapEntry entry) {
                            return entry.key;
                        }
                    }, IdentityHashMap.this);
                }
            };
        }
        return this.keySet;
    }

    public Collection values() {
        if (this.valuesCollection == null) {
            this.valuesCollection = new AbstractCollection(){

                public boolean contains(Object object) {
                    return IdentityHashMap.this.containsValue(object);
                }

                public int size() {
                    return IdentityHashMap.this.size();
                }

                public void clear() {
                    IdentityHashMap.this.clear();
                }

                public Iterator iterator() {
                    return new IdentityHashMapIterator(new MapEntry.Type(this){
                        final /* synthetic */ 4 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public Object get(MapEntry entry) {
                            return entry.value;
                        }
                    }, IdentityHashMap.this);
                }

                public boolean remove(Object object) {
                    Iterator it = this.iterator();
                    while (it.hasNext()) {
                        if (object != it.next()) continue;
                        it.remove();
                        return true;
                    }
                    return false;
                }
            };
        }
        return this.valuesCollection;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            if (this.size() != map.size()) {
                return false;
            }
            Set set = this.entrySet();
            return set.equals(map.entrySet());
        }
        return false;
    }

    public Object clone() {
        try {
            return (IdentityHashMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeInt(this.size);
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            MapEntry entry = (MapEntry)iterator.next();
            stream.writeObject(entry.key);
            stream.writeObject(entry.value);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int savedSize = stream.readInt();
        this.threshold = this.getThreshold(21);
        this.elementData = this.newElementArray(this.computeElementArraySize());
        int i = savedSize;
        while (--i >= 0) {
            Object key = stream.readObject();
            this.put(key, stream.readObject());
        }
    }

    static class IdentityHashMapEntry
    extends MapEntry {
        IdentityHashMapEntry(Object theKey, Object theValue) {
            super(theKey, theValue);
        }

        public Object clone() {
            return (IdentityHashMapEntry)super.clone();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                return this.key == entry.getKey() && this.value == entry.getValue();
            }
            return false;
        }

        public int hashCode() {
            return System.identityHashCode(this.key) ^ System.identityHashCode(this.value);
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    static class IdentityHashMapIterator
    implements Iterator {
        private int position = 0;
        private int lastPosition = 0;
        final IdentityHashMap associatedMap;
        int expectedModCount;
        final MapEntry.Type type;
        boolean canRemove = false;

        IdentityHashMapIterator(MapEntry.Type value, IdentityHashMap hm) {
            this.associatedMap = hm;
            this.type = value;
            this.expectedModCount = hm.modCount;
        }

        public boolean hasNext() {
            while (this.position < this.associatedMap.elementData.length) {
                if (this.associatedMap.elementData[this.position] == null) {
                    this.position += 2;
                    continue;
                }
                return true;
            }
            return false;
        }

        void checkConcurrentMod() throws ConcurrentModificationException {
            if (this.expectedModCount != this.associatedMap.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        public Object next() {
            this.checkConcurrentMod();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            IdentityHashMapEntry result = this.associatedMap.getEntry(this.position);
            this.lastPosition = this.position;
            this.position += 2;
            this.canRemove = true;
            return this.type.get(result);
        }

        public void remove() {
            this.checkConcurrentMod();
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            this.canRemove = false;
            this.associatedMap.remove(this.associatedMap.elementData[this.lastPosition]);
            this.position = this.lastPosition;
            ++this.expectedModCount;
        }
    }

    static class IdentityHashMapEntrySet
    extends AbstractSet {
        private final IdentityHashMap associatedMap;

        public IdentityHashMapEntrySet(IdentityHashMap hm) {
            this.associatedMap = hm;
        }

        IdentityHashMap hashMap() {
            return this.associatedMap;
        }

        public int size() {
            return this.associatedMap.size;
        }

        public void clear() {
            this.associatedMap.clear();
        }

        public boolean remove(Object object) {
            if (this.contains(object)) {
                this.associatedMap.remove(((Map.Entry)object).getKey());
                return true;
            }
            return false;
        }

        public boolean contains(Object object) {
            if (object instanceof Map.Entry) {
                IdentityHashMapEntry entry = this.associatedMap.getEntry(((Map.Entry)object).getKey());
                return entry != null && entry.equals(object);
            }
            return false;
        }

        public Iterator iterator() {
            return new IdentityHashMapIterator(new MapEntry.Type(this){
                final /* synthetic */ IdentityHashMapEntrySet this$1;
                {
                    this.this$1 = identityHashMapEntrySet;
                }

                public Object get(MapEntry entry) {
                    return entry;
                }
            }, this.associatedMap);
        }
    }
}

