/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.VM;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;

public abstract class ResourceBundle {
    protected ResourceBundle parent;
    private Locale locale;
    private static ResourceBundle MISSING = new MissingBundle();
    private static ResourceBundle MISSINGBASE = new MissingBundle();
    private static Hashtable bootCache = new Hashtable();
    private static Method getCacheMethod = ResourceBundle.initGetCacheMethod();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static final ResourceBundle getBundle(String bundleName) throws MissingResourceException {
        return ResourceBundle.getBundleImpl(bundleName, Locale.getDefault(), VM.callerClassLoader());
    }

    public static final ResourceBundle getBundle(String bundleName, Locale locale) {
        return ResourceBundle.getBundleImpl(bundleName, locale, VM.callerClassLoader());
    }

    public static ResourceBundle getBundle(String bundleName, Locale locale, ClassLoader loader) throws MissingResourceException {
        if (loader == null) {
            throw new NullPointerException();
        }
        if (bundleName != null) {
            ResourceBundle bundle;
            if (!locale.equals(Locale.getDefault()) && (bundle = ResourceBundle.handleGetBundle(bundleName, "_" + locale, false, loader)) != null) {
                return bundle;
            }
            bundle = ResourceBundle.handleGetBundle(bundleName, "_" + Locale.getDefault(), true, loader);
            if (bundle != null) {
                return bundle;
            }
            throw new MissingResourceException(Msg.getString("K0405", bundleName, locale), bundleName, "");
        }
        throw new NullPointerException();
    }

    private static ResourceBundle getBundleImpl(String bundleName, Locale locale, ClassLoader loader) throws MissingResourceException {
        if (bundleName != null) {
            ResourceBundle bundle;
            String localeName;
            if (!locale.equals(Locale.getDefault())) {
                localeName = locale.toString();
                if (localeName.length() > 0) {
                    localeName = "_" + localeName;
                }
                if ((bundle = ResourceBundle.handleGetBundle(bundleName, localeName, false, loader)) != null) {
                    return bundle;
                }
            }
            if ((localeName = Locale.getDefault().toString()).length() > 0) {
                localeName = "_" + localeName;
            }
            if ((bundle = ResourceBundle.handleGetBundle(bundleName, localeName, true, loader)) != null) {
                return bundle;
            }
            throw new MissingResourceException(Msg.getString("K0405", bundleName, locale), bundleName, "");
        }
        throw new NullPointerException();
    }

    public abstract Enumeration getKeys();

    public Locale getLocale() {
        return this.locale;
    }

    public final Object getObject(String key) {
        ResourceBundle last;
        ResourceBundle theParent = this;
        do {
            Object result;
            if ((result = theParent.handleGetObject(key)) != null) {
                return result;
            }
            last = theParent;
        } while ((theParent = theParent.parent) != null);
        String className = last.getClass().getName();
        throw new MissingResourceException(Msg.getString("K0406", key, className), className, key);
    }

    public final String getString(String key) {
        return (String)this.getObject(key);
    }

    public final String[] getStringArray(String key) {
        return (String[])this.getObject(key);
    }

    private static ResourceBundle handleGetBundle(String base, String locale, boolean loadBase, final ClassLoader loader) {
        ResourceBundle bundle = null;
        String bundleName = String.valueOf(base) + locale;
        Hashtable loaderCache = null;
        if (loader == null) {
            loaderCache = bootCache;
        } else {
            try {
                loaderCache = (Hashtable)getCacheMethod.invoke(loader, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        ResourceBundle result = (ResourceBundle)loaderCache.get(bundleName);
        if (result != null) {
            if (result == MISSINGBASE) {
                return null;
            }
            if (result == MISSING) {
                if (!loadBase) {
                    return null;
                }
                String extension = ResourceBundle.strip(locale);
                if (extension == null) {
                    return null;
                }
                return ResourceBundle.handleGetBundle(base, extension, loadBase, loader);
            }
            return result;
        }
        try {
            Class bundleClass = Class.forName(bundleName, true, loader);
            Class clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.util.ResourceBundle");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.isAssignableFrom(bundleClass)) {
                bundle = (ResourceBundle)bundleClass.newInstance();
                bundle.setLocale(locale);
            }
        }
        catch (Exception exception) {
        }
        catch (LinkageError linkageError) {}
        if (bundle == null) {
            final String fileName = bundleName.replace('.', '/');
            InputStream stream = null;
            stream = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return loader == null ? ClassLoader.getSystemResourceAsStream(String.valueOf(fileName) + ".properties") : loader.getResourceAsStream(String.valueOf(fileName) + ".properties");
                }
            });
            if (stream != null) {
                try {
                    try {
                        bundle = new PropertyResourceBundle(stream);
                    }
                    finally {
                        stream.close();
                    }
                    bundle.setLocale(locale);
                }
                catch (IOException iOException) {}
            }
        }
        String extension = ResourceBundle.strip(locale);
        if (bundle != null) {
            ResourceBundle parent;
            if (extension != null && (parent = ResourceBundle.handleGetBundle(base, extension, true, loader)) != null) {
                bundle.setParent(parent);
            }
            loaderCache.put(bundleName, bundle);
            return bundle;
        }
        if (extension != null && (loadBase || extension.length() > 0) && (bundle = ResourceBundle.handleGetBundle(base, extension, loadBase, loader)) != null) {
            loaderCache.put(bundleName, bundle);
            return bundle;
        }
        loaderCache.put(bundleName, loadBase ? MISSINGBASE : MISSING);
        return null;
    }

    private static Method initGetCacheMethod() {
        return (Method)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Class clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("java.lang.ClassLoader");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Method method = clazz.getDeclaredMethod("getBundleCache", new Class[0]);
                    method.setAccessible(true);
                    return method;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    return null;
                }
            }
        });
    }

    protected abstract Object handleGetObject(String var1);

    protected void setParent(ResourceBundle bundle) {
        this.parent = bundle;
    }

    private static String strip(String name) {
        int index = name.lastIndexOf(95);
        if (index != -1) {
            return name.substring(0, index);
        }
        return null;
    }

    private void setLocale(String name) {
        String language = "";
        String country = "";
        String variant = "";
        if (name.length() > 1) {
            int nextIndex = name.indexOf(95, 1);
            if (nextIndex == -1) {
                nextIndex = name.length();
            }
            language = name.substring(1, nextIndex);
            if (nextIndex + 1 < name.length()) {
                int index = nextIndex;
                if ((nextIndex = name.indexOf(95, nextIndex + 1)) == -1) {
                    nextIndex = name.length();
                }
                country = name.substring(index + 1, nextIndex);
                if (nextIndex + 1 < name.length()) {
                    variant = name.substring(nextIndex + 1, name.length());
                }
            }
        }
        this.locale = new Locale(language, country, variant);
    }

    static class MissingBundle
    extends ResourceBundle {
        MissingBundle() {
        }

        public Enumeration getKeys() {
            return null;
        }

        public Object handleGetObject(String name) {
            return null;
        }
    }
}

