/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.ibm.oti.util.Msg;
import java.util.Date;
import java.util.TimerTask;

public class Timer {
    private TimerImpl impl;
    private Object finalizer = new Object(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finalize() {
            TimerImpl timerImpl = Timer.this.impl;
            synchronized (timerImpl) {
                Timer.this.impl.finished = true;
                Timer.this.impl.notify();
            }
        }
    };

    public Timer(boolean isDaemon) {
        this.impl = new TimerImpl(isDaemon);
    }

    public Timer() {
        this.impl = new TimerImpl(false);
    }

    public void cancel() {
        this.impl.cancel();
    }

    public void schedule(TimerTask task, Date when) {
        if (when.getTime() < 0L) {
            throw new IllegalArgumentException();
        }
        long delay = when.getTime() - System.currentTimeMillis();
        this.scheduleImpl(task, delay < 0L ? 0L : delay, -1L, false);
    }

    public void schedule(TimerTask task, long delay) {
        if (delay < 0L) {
            throw new IllegalArgumentException();
        }
        this.scheduleImpl(task, delay, -1L, false);
    }

    public void schedule(TimerTask task, long delay, long period) {
        if (delay < 0L || period <= 0L) {
            throw new IllegalArgumentException();
        }
        this.scheduleImpl(task, delay, period, false);
    }

    public void schedule(TimerTask task, Date when, long period) {
        if (period <= 0L || when.getTime() < 0L) {
            throw new IllegalArgumentException();
        }
        long delay = when.getTime() - System.currentTimeMillis();
        this.scheduleImpl(task, delay < 0L ? 0L : delay, period, false);
    }

    public void scheduleAtFixedRate(TimerTask task, long delay, long period) {
        if (delay < 0L || period <= 0L) {
            throw new IllegalArgumentException();
        }
        this.scheduleImpl(task, delay, period, true);
    }

    public void scheduleAtFixedRate(TimerTask task, Date when, long period) {
        if (period <= 0L || when.getTime() < 0L) {
            throw new IllegalArgumentException();
        }
        long delay = when.getTime() - System.currentTimeMillis();
        this.scheduleImpl(task, delay < 0L ? 0L : delay, period, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleImpl(TimerTask task, long delay, long period, boolean fixed) {
        TimerImpl timerImpl = this.impl;
        synchronized (timerImpl) {
            if (this.impl.cancelled) {
                throw new IllegalStateException(Msg.getString("K00f3"));
            }
            long when = delay + System.currentTimeMillis();
            if (when < 0L) {
                throw new IllegalArgumentException(Msg.getString("K00f5"));
            }
            if (task.isScheduled()) {
                throw new IllegalStateException(Msg.getString("K00f6"));
            }
            if (task.isCancelled()) {
                throw new IllegalStateException(Msg.getString("K00f7"));
            }
            task.when = when;
            task.period = period;
            task.fixedRate = fixed;
            this.impl.insertTask(task);
        }
    }

    private static final class TimerImpl
    extends Thread {
        private boolean cancelled = false;
        private boolean finished = false;
        private TimerTree tasks = new TimerTree();

        TimerImpl(boolean isDaemon) {
            this.setDaemon(isDaemon);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                TimerTask task;
                TimerImpl timerImpl = this;
                synchronized (timerImpl) {
                    if (this.cancelled) {
                        return;
                    }
                    if (this.tasks.isEmpty()) {
                        if (this.finished) {
                            return;
                        }
                        try {
                            this.wait();
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    long currentTime = System.currentTimeMillis();
                    TimerNode taskNode = this.tasks.minimum();
                    task = taskNode.task;
                    if (task.isCancelled()) {
                        this.tasks.delete(taskNode);
                        continue;
                    }
                    long timeToSleep = task.when - currentTime;
                    if (timeToSleep > 0L) {
                        try {
                            this.wait(timeToSleep);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    task.setScheduledTime(task.when);
                    this.tasks.delete(taskNode);
                    if (task.period >= 0L) {
                        task.when = task.fixedRate ? (task.when += task.period) : System.currentTimeMillis() + task.period;
                        this.insertTask(task);
                    } else {
                        task.when = 0L;
                    }
                }
                try {
                    task.run();
                    continue;
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }

        private void insertTask(TimerTask newTask) {
            this.tasks.insert(new TimerNode(newTask));
            this.notify();
        }

        public synchronized void cancel() {
            this.cancelled = true;
            this.tasks = new TimerTree();
            this.notify();
        }

        private static final class TimerNode {
            TimerNode parent;
            TimerNode left;
            TimerNode right;
            TimerTask task;

            public TimerNode(TimerTask value) {
                this.task = value;
            }
        }

        private static final class TimerTree {
            TimerNode root;

            TimerTree() {
            }

            boolean isEmpty() {
                return this.root == null;
            }

            void insert(TimerNode z) {
                TimerNode y = null;
                TimerNode x = this.root;
                while (x != null) {
                    y = x;
                    x = z.task.when < x.task.when ? x.left : x.right;
                }
                z.parent = y;
                if (y == null) {
                    this.root = z;
                } else if (z.task.when < y.task.when) {
                    y.left = z;
                } else {
                    y.right = z;
                }
            }

            void delete(TimerNode z) {
                TimerNode y = null;
                TimerNode x = null;
                y = z.left == null || z.right == null ? z : this.successor(z);
                x = y.left != null ? y.left : y.right;
                if (x != null) {
                    x.parent = y.parent;
                }
                if (y.parent == null) {
                    this.root = x;
                } else if (y == y.parent.left) {
                    y.parent.left = x;
                } else {
                    y.parent.right = x;
                }
                if (y != z) {
                    z.task = y.task;
                }
            }

            private TimerNode successor(TimerNode x) {
                if (x.right != null) {
                    return this.minimum(x.right);
                }
                TimerNode y = x.parent;
                while (y != null && x == y.right) {
                    x = y;
                    y = y.parent;
                }
                return y;
            }

            private TimerNode minimum(TimerNode x) {
                while (x.left != null) {
                    x = x.left;
                }
                return x;
            }

            TimerNode minimum() {
                return this.minimum(this.root);
            }
        }
    }
}

