/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import com.ibm.oti.io.CharacterConverter;
import com.ibm.oti.util.Msg;
import com.ibm.oti.util.PriviAction;
import com.ibm.oti.util.Util;
import com.ibm.oti.vm.VM;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;

class InitManifest {
    private static final boolean useNative = VM.useNatives();
    private byte[] inbuf = new byte[1024];
    private int inbufCount = 0;
    private int inbufPos = 0;
    private byte[] buffer = new byte[5];
    private char[] charbuf = new char[0];
    private ByteArrayOutputStream out = new ByteArrayOutputStream(256);
    private String encoding;
    private CharacterConverter converter;
    private Map attributeNames = new HashMap();

    InitManifest(InputStream is, Attributes main, Map entries, Map chunks, String verString) throws IOException {
        this.encoding = (String)AccessController.doPrivileged(new PriviAction("manifest.read.encoding"));
        if ("".equals(this.encoding)) {
            this.encoding = null;
        }
        Attributes current = main;
        ArrayList list = new ArrayList();
        this.readLines(is, list);
        Iterator it = list.iterator();
        while (it.hasNext()) {
            this.addAttribute((String)it.next(), current);
        }
        if (verString != null && main.getValue(verString) == null) {
            throw new IOException(Msg.getString("K0009", verString));
        }
        list.clear();
        byte[] chunk = null;
        while (!(chunks == null ? !this.readLines(is, list) : (chunk = this.nextChunk(is, list)) == null)) {
            it = list.iterator();
            String line = (String)it.next();
            if (line.length() < 7 || !line.substring(0, 5).toLowerCase().equals("name:")) {
                throw new IOException(Msg.getString("K000a"));
            }
            String name = line.substring(6, line.length());
            current = new Attributes(12);
            if (chunks != null) {
                chunks.put(name, chunk);
            }
            entries.put(name, current);
            while (it.hasNext()) {
                this.addAttribute((String)it.next(), current);
            }
            list.clear();
        }
    }

    private void addLine(int length, List lines) throws IOException {
        if (this.encoding != null) {
            lines.add(new String(this.buffer, 0, length, this.encoding));
        } else {
            if (this.converter == null) {
                try {
                    if (useNative) {
                        lines.add(Util.convertFromUTF8(this.buffer, 0, length));
                    } else {
                        if (this.charbuf.length < length) {
                            this.charbuf = new char[length];
                        }
                        lines.add(Util.convertUTF8WithBuf(this.buffer, this.charbuf, 0, length));
                    }
                }
                catch (UTFDataFormatException uTFDataFormatException) {
                    this.converter = new CharacterConverter();
                }
            }
            if (this.converter != null) {
                if (this.charbuf.length < length) {
                    this.charbuf = new char[length];
                }
                this.converter.convert(this.buffer, 0, this.charbuf, 0, length);
                lines.add(new String(this.charbuf, 0, length));
            }
        }
    }

    private byte[] nextChunk(InputStream in, List lines) throws IOException {
        if (this.inbufCount == -1) {
            return null;
        }
        int pos = 0;
        boolean blankline = false;
        boolean lastCr = false;
        this.out.reset();
        while (true) {
            if (this.inbufPos == this.inbufCount) {
                this.inbufCount = in.read(this.inbuf);
                if (this.inbufCount == -1) {
                    if (this.out.size() == 0) {
                        return null;
                    }
                    if (blankline) {
                        this.addLine(pos, lines);
                    }
                    return this.out.toByteArray();
                }
                this.inbufPos = 0;
            }
            int next = this.inbuf[this.inbufPos++];
            if (lastCr) {
                if (next != 10) {
                    --this.inbufPos;
                    next = 13;
                } else {
                    if (this.out.size() == 0) continue;
                    this.out.write(13);
                }
                lastCr = false;
            } else if (next == 13) {
                lastCr = true;
                continue;
            }
            if (blankline) {
                if (next == 32) {
                    this.out.write(next);
                    blankline = false;
                    continue;
                }
                this.addLine(pos, lines);
                if (next == 10) {
                    this.out.write(next);
                    return this.out.toByteArray();
                }
                pos = 0;
            } else if (next == 10) {
                if (this.out.size() == 0) continue;
                this.out.write(next);
                blankline = true;
                continue;
            }
            blankline = false;
            this.out.write(next);
            if (pos == this.buffer.length) {
                byte[] newBuf = new byte[this.buffer.length * 2];
                System.arraycopy((Object)this.buffer, 0, (Object)newBuf, 0, this.buffer.length);
                this.buffer = newBuf;
            }
            this.buffer[pos++] = next;
        }
    }

    private boolean readLines(InputStream in, List lines) throws IOException {
        if (this.inbufCount == -1) {
            return false;
        }
        int pos = 0;
        boolean blankline = false;
        boolean lastCr = false;
        while (true) {
            if (this.inbufPos == this.inbufCount) {
                this.inbufCount = in.read(this.inbuf);
                if (this.inbufCount == -1) {
                    if (blankline) {
                        this.addLine(pos, lines);
                    }
                    return lines.size() != 0;
                }
                this.inbufPos = 0;
            }
            int next = this.inbuf[this.inbufPos++];
            if (lastCr) {
                if (next != 10) {
                    --this.inbufPos;
                    next = 13;
                }
                lastCr = false;
            } else if (next == 13) {
                lastCr = true;
                continue;
            }
            if (blankline) {
                if (next == 32) {
                    blankline = false;
                    continue;
                }
                this.addLine(pos, lines);
                if (next == 10) {
                    return true;
                }
                pos = 0;
            } else if (next == 10) {
                if (pos == 0 && lines.size() == 0) continue;
                blankline = true;
                continue;
            }
            blankline = false;
            if (pos == this.buffer.length) {
                byte[] newBuf = new byte[this.buffer.length * 2];
                System.arraycopy((Object)this.buffer, 0, (Object)newBuf, 0, this.buffer.length);
                this.buffer = newBuf;
            }
            this.buffer[pos++] = next;
        }
    }

    private void addAttribute(String line, Attributes current) throws IOException {
        int hdrIdx = line.indexOf(58);
        if (hdrIdx < 1) {
            throw new IOException(Msg.getString("K000b", line));
        }
        String header = line.substring(0, hdrIdx);
        Attributes.Name name = (Attributes.Name)this.attributeNames.get(header);
        if (name == null) {
            try {
                name = new Attributes.Name(header);
            }
            catch (IllegalArgumentException e) {
                throw new IOException(e.toString());
            }
            this.attributeNames.put(header, name);
        }
        if (hdrIdx + 1 >= line.length() || line.charAt(hdrIdx + 1) != ' ') {
            throw new IOException(Msg.getString("K000b", line));
        }
        current.put(name, line.substring(hdrIdx + 2, line.length()));
    }
}

