/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.fm.am;

import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.table.TableColumn;
import org.omg.CosNotification.EventType;
import org.omg.CosNotification.StructuredEvent;
import se.ericsson.cello.emas.fm.am.AlarmApplicationView;
import se.ericsson.cello.emas.fm.am.AlarmRecord;
import se.ericsson.cello.emas.fm.am.ExportActionClass;
import se.ericsson.cello.emas.fm.common.AlarmSortedTable;
import se.ericsson.cello.emas.fm.common.AlarmSortedTableModel;
import se.ericsson.cello.emas.fm.common.ColorCodedColumns;
import se.ericsson.cello.emas.fm.common.DetailsController;
import se.ericsson.cello.emas.fm.common.DetailsView;
import se.ericsson.cello.emas.fm.common.RightCellRenderer;
import se.ericsson.cello.emas.fm.common.RowDataInterface;
import se.ericsson.cello.emas.fm.common.SelectedObjectInterface;
import se.ericsson.cello.emas.fm.common.Severity;
import se.ericsson.cello.support.gui.EmasGuilibMediator;
import se.ericsson.cello.support.gui.LDNIndexService;
import se.ericsson.cello.support.gui.ListenerConnectionLost;
import se.ericsson.cello.support.gui.MainWindowController;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractApplicationController;
import se.ericsson.cello.support.gui.guilib.infra.AbstractController;
import se.ericsson.cello.support.gui.guilib.infra.AbstractDialogController;
import se.ericsson.cello.support.gui.guilib.infra.Application;
import se.ericsson.cello.support.gui.guilib.infra.EmasSystemProperties;
import se.ericsson.cello.support.gui.guilib.infra.Printout;
import se.ericsson.cello.support.mgr.OEGoToAction;
import se.ericsson.cello.support.mgr.TimeConverter;
import se.ericsson.cello.support.proxy.AlarmCorbaInterface;
import se.ericsson.cello.support.proxy.AlarmNotificationCorbaInterface;
import se.ericsson.cello.support.proxy.AlarmServiceFacade;
import se.ericsson.cello.support.proxy.UnsupportedIRPVersionException;

public class AlarmApplicationController
extends AbstractApplicationController
implements AlarmNotificationCorbaInterface,
AlarmCorbaInterface,
SelectedObjectInterface,
ListenerConnectionLost {
    private AlarmApplicationView alarmview;
    private AlarmApplicationController ac;
    private String subscriptionid = "";
    private AlarmServiceFacade aservercomm = null;
    DetailsController openedAddInfoDialog = null;
    private int TABLE_SELECTED;
    private String userid;
    boolean retrievingFinished;
    boolean firstCall = true;
    private Timer soundTimer;
    private Timer soundTimerBeep;
    Timer checkSubTimer;
    boolean soundON = false;
    boolean subscriptionOK = false;
    private boolean node_went_down = false;
    private final int tableA = 0;
    private final int tableB = 1;
    private final int noOfAlarmCounters = 5;
    private int[] alarmCountersA = new int[5];
    private int[] alarmCountersB = new int[5];
    private int totalNumAlarms = 0;
    private AlarmSortedTableModel myModelA;
    private AlarmSortedTableModel myModelB;
    private Vector newNotifications = new Vector();
    private PrintAction printAction = new PrintAction();
    private PageLayoutAction pageLayoutAction = new PageLayoutAction();
    private Printout printout = null;
    private ExportActionClass exportAction;
    private HashMap myAlarmsA = new HashMap();
    private HashMap myAlarmsB = new HashMap();
    Vector columnNamesA = new Vector();
    Vector columnNamesB = new Vector();
    ListSelectionModel rowSM1;
    ListSelectionModel rowSM2;
    Menu1Listener menu1listener;
    TableListener mytable1listener;
    TableListener mytable2listener;
    TableMouseListener mytable1MouseLis;
    TableMouseListener mytable2MouseLis;
    Ack myack;
    UnAck myunack;
    AddInfo myaddinfo;
    SoundAlarmListener soundalarmlistener;
    Refresh myrefresh;
    private boolean ackIsAvailable;
    public static final String SUPERSEDING_PARAMETER_LIST = "SUPERSEDING_PARAMETER_LIST";

    protected void init() {
        this.ac = this;
        this.alarmview = (AlarmApplicationView)this.getView();
        this.userid = this.getApplication().getUserId();
        this.alarmview.idValueLabel.setText(this.userid);
        this.getApplication().setTitle("APPLICATION_TITLE", null);
        this.setRetrievingFinished(true);
        this.getAckStatus();
        String columnTags = this.getString("ALARMLIST_COLUMNS", null).trim();
        if (columnTags.trim().equals("")) {
            this.columnNamesA.addElement("SEVERITY");
            this.columnNamesA.addElement("EVENT_TYPE");
            this.columnNamesA.addElement("EVENT_TIME");
            this.columnNamesA.addElement("MANAGED_OBJECT_INSTANCE");
            this.columnNamesA.addElement("PROBABLE_CAUSE");
            this.columnNamesA.addElement("SPECIFIC_PROBLEM");
            this.columnNamesA.addElement("ADDITIONAL_TEXT");
            if (this.isAckAvailable()) {
                this.columnNamesB.addElement("SEVERITY");
                this.columnNamesB.addElement("EVENT_TYPE");
                this.columnNamesB.addElement("EVENT_TIME");
                this.columnNamesB.addElement("MANAGED_OBJECT_INSTANCE");
                this.columnNamesB.addElement("PROBABLE_CAUSE");
                this.columnNamesB.addElement("SPECIFIC_PROBLEM");
                this.columnNamesB.addElement("ADDITIONAL_TEXT");
                this.columnNamesB.addElement("ACK");
            }
        } else {
            StringTokenizer columntok = new StringTokenizer(columnTags, ",", false);
            while (columntok.hasMoreTokens()) {
                String columnName = columntok.nextToken().trim();
                this.columnNamesA.addElement(columnName);
                if (!this.isAckAvailable()) continue;
                this.columnNamesB.addElement(columnName);
            }
            if (this.isAckAvailable()) {
                this.columnNamesB.addElement("ACK");
            }
        }
        this.myModelA = new AlarmSortedTableModel();
        this.myModelA.setColumnIdentifiers(this.columnNamesA);
        this.alarmview.jTable1.setModel(this.myModelA);
        this.mytable1listener = new TableListener(0, this.myModelA);
        if (this.isAckAvailable()) {
            this.mytable1listener = new TableListener(0, this.myModelA);
            this.myModelB = new AlarmSortedTableModel();
            this.myModelB.setColumnIdentifiers(this.columnNamesB);
            this.alarmview.jTable2.setModel(this.myModelB);
            this.mytable2listener = new TableListener(1, this.myModelB);
        }
        this.menu1listener = new Menu1Listener();
        this.alarmview.jMenuAlarm.addMenuListener(this.menu1listener);
        String rightAligned = this.getString("RIGHT_ALIGNED_COLUMNS", null).trim();
        if (!rightAligned.trim().equals("")) {
            StringTokenizer columnRightTok = new StringTokenizer(rightAligned, ",", false);
            while (columnRightTok.hasMoreTokens()) {
                try {
                    String rightName = columnRightTok.nextToken();
                    TableColumn x = this.alarmview.jTable1.getColumn(rightName);
                    x.setCellRenderer(new RightCellRenderer());
                    if (!this.isAckAvailable()) continue;
                    TableColumn y = this.alarmview.jTable2.getColumn(rightName);
                    y.setCellRenderer(new RightCellRenderer());
                }
                catch (Exception exep) {}
            }
        }
        this.rowSM1 = this.alarmview.jTable1.getSelectionModel();
        this.mytable1MouseLis = new TableMouseListener(0, this.myModelA);
        this.alarmview.jTable1.addMouseListener(this.mytable1MouseLis);
        this.myaddinfo = new AddInfo();
        this.soundalarmlistener = new SoundAlarmListener();
        if (this.isAckAvailable()) {
            this.rowSM1.addListSelectionListener(this.mytable1listener);
            this.rowSM2 = this.alarmview.jTable2.getSelectionModel();
            this.rowSM2.addListSelectionListener(this.mytable2listener);
            this.mytable2MouseLis = new TableMouseListener(1, this.myModelB);
            this.alarmview.jTable2.addMouseListener(this.mytable2MouseLis);
            this.myack = new Ack();
            this.myunack = new UnAck();
        }
        this.myrefresh = new Refresh();
        if (this.isAckAvailable()) {
            this.alarmview.jMenuItemAck.addActionListener(this.myack);
            this.alarmview.jMenuItemUnAck.addActionListener(this.myunack);
        }
        this.alarmview.jMenuItemDetails.addActionListener(this.myaddinfo);
        this.alarmview.jMenuItemSound.addActionListener(this.soundalarmlistener);
        this.alarmview.jMenuItemRefresh.addActionListener(this.myrefresh);
        this.alarmview.jMenuItemComm.addActionListener(this.myrefresh);
        this.alarmview.jMenuItemEnv.addActionListener(this.myrefresh);
        this.alarmview.jMenuItemEqu.addActionListener(this.myrefresh);
        this.alarmview.jMenuItemProcess.addActionListener(this.myrefresh);
        this.alarmview.jMenuItemQos.addActionListener(this.myrefresh);
        if (this.isAckAvailable()) {
            this.alarmview.popupmenuitemAck.addActionListener(this.myack);
            this.alarmview.popupmenuitemUnAck.addActionListener(this.myunack);
        }
        this.alarmview.popupmenuitemDetails.addActionListener(this.myaddinfo);
        this.alarmview.TopLabel4.setText("-");
        if (this.isAckAvailable()) {
            this.alarmview.BotLabel4.setText("-");
        }
        for (int i = 0; i < 5; ++i) {
            this.alarmCountersA[i] = 0;
        }
        if (this.isAckAvailable()) {
            for (int j = 0; j < 5; ++j) {
                this.alarmCountersB[j] = 0;
            }
        }
        this.totalNumAlarms = this.isAckAvailable() ? this.myModelA.getRowCount() + this.myModelB.getRowCount() : this.myModelA.getRowCount();
        this.alarmview.TopLabel2.setText("[" + this.myModelA.getRowCount() + "/" + this.totalNumAlarms + "]");
        if (this.isAckAvailable()) {
            this.alarmview.BotLabel2.setText("[" + this.myModelB.getRowCount() + "/" + this.totalNumAlarms + "]");
        }
        this.alarmview.jTable1.getColumnModel().getColumn(0).setCellRenderer(new ColorCodedColumns());
        if (this.isAckAvailable()) {
            this.alarmview.jTable2.getColumnModel().getColumn(0).setCellRenderer(new ColorCodedColumns());
        }
        this.soundTimer = new Timer(10000, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AlarmApplicationController.this.soundTimerBeep.stop();
                AlarmApplicationController.this.soundTimer.stop();
            }
        });
        this.soundTimerBeep = new Timer(200, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Toolkit.getDefaultToolkit().beep();
            }
        });
        this.aservercomm = AlarmServiceFacade.getAlarmServiceFacadeInstance((AbstractController)this);
        this.aservercomm.subscribeNotification((AlarmNotificationCorbaInterface)this);
        this.syncAlarmList();
        int howOften = Integer.parseInt(this.getProperty("GET_SUB_STATUS_INTERVAL"));
        this.checkSubTimer = new Timer(howOften, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AlarmApplicationController.this.aservercomm.getSubscriptionStatus((AlarmCorbaInterface)AlarmApplicationController.this.ac, AlarmApplicationController.this.subscriptionid);
            }
        });
        this.getApplication().setStatus("", null);
        this.exportAction = this.isAckAvailable() ? new ExportActionClass(this.myModelA, this.myModelB, this.alarmview, this.getApplication().getLanguageBundle()) : new ExportActionClass(this.myModelA, this.alarmview, this.getApplication().getLanguageBundle());
        this.alarmview.printMenuItem.addActionListener(this.printAction);
        this.alarmview.pageLayoutMenuItem.addActionListener(this.pageLayoutAction);
        this.alarmview.exportMenuItem.addActionListener(this.exportAction);
        EmasGuilibMediator.getReference().getMainWindowReference().getConnectionSupervisionController().setListenerConnectionLost((ListenerConnectionLost)this);
    }

    protected void beforeVisible() {
        this.alarmview.setHelpOnWindowKey();
    }

    protected void afterVisible() {
    }

    private void addAlarmToTableA(AlarmRecord alarm) {
        se.ericsson.cello.emas.fm.common.EventType eventType = alarm.getEventType();
        if (this.checkEventType(eventType)) {
            this.myAlarmsA.put(alarm.getAlarmId(), alarm.getSeverity());
            this.myModelA.addRow(alarm);
            this.incrementCounter(0, alarm.getSeverity());
        }
    }

    private void addAlarmToTableB(AlarmRecord alarm) {
        se.ericsson.cello.emas.fm.common.EventType eventType = alarm.getEventType();
        if (this.checkEventType(eventType)) {
            this.myAlarmsB.put(alarm.getAlarmId(), alarm.getSeverity());
            this.myModelB.addRow(alarm);
            this.incrementCounter(1, alarm.getSeverity());
        }
    }

    private void getAckStatus() {
        String columnTag = this.getString("ACKNOWLEDGEMENT_USED", null).trim();
        if (columnTag.equals("Yes")) {
            this.ackIsAvailable = true;
        }
    }

    private boolean isAckAvailable() {
        return this.ackIsAvailable;
    }

    private boolean checkEventType(se.ericsson.cello.emas.fm.common.EventType eventType) {
        if (!this.alarmview.jMenuItemComm.getState() && eventType.equals(se.ericsson.cello.emas.fm.common.EventType.CommunicationAlarm)) {
            return false;
        }
        if (!this.alarmview.jMenuItemEnv.getState() && eventType.equals(se.ericsson.cello.emas.fm.common.EventType.EnvironmentAlarm)) {
            return false;
        }
        if (!this.alarmview.jMenuItemEqu.getState() && eventType.equals(se.ericsson.cello.emas.fm.common.EventType.EquipmentAlarm)) {
            return false;
        }
        if (!this.alarmview.jMenuItemProcess.getState() && eventType.equals(se.ericsson.cello.emas.fm.common.EventType.ProcessingAlarm)) {
            return false;
        }
        return this.alarmview.jMenuItemQos.getState() || !eventType.equals(se.ericsson.cello.emas.fm.common.EventType.QoSAlarm);
    }

    private synchronized void processAlarmNotification(StructuredEvent entry) {
        while (!this.retrievingFinished) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {}
        }
        String notificationType = entry.header.fixed_header.event_name;
        if (notificationType.equals(new String("x1"))) {
            int maxAlarms = Integer.parseInt(this.getProperty("MAX_ALARMS"));
            if (this.totalNumAlarms >= maxAlarms) {
                this.showMessageDialog("MAX_ALARMS_MSG", null, "ERROR_TITLE", null, 0, null);
            } else if (entry.filterable_data.length != 0) {
                AlarmRecord ar = new AlarmRecord(entry, this.isAckAvailable());
                if (!this.isAckAvailable()) {
                    this.deleteAlarmFromTableA(ar);
                    this.addAlarmToTableA(ar);
                    this.setTheTime(0);
                } else if (!ar.checkAckAlarm()) {
                    if (this.deleteAlarmFromTableB(ar)) {
                        this.setTheTime(1);
                    }
                    this.deleteAlarmFromTableA(ar);
                    this.addAlarmToTableA(ar);
                    this.setTheTime(0);
                } else if (ar.checkAckAlarm()) {
                    if (this.deleteAlarmFromTableA(ar)) {
                        this.setTheTime(0);
                    }
                    this.deleteAlarmFromTableB(ar);
                    this.addAlarmToTableB(ar);
                    this.setTheTime(1);
                }
                if (this.soundON) {
                    this.checkSound(ar);
                }
            }
        } else if (notificationType.equals(new String("x2"))) {
            if (entry.filterable_data.length != 0) {
                this.processChangedAlarm(entry);
            }
        } else if (notificationType.equals(new String("x4"))) {
            if (entry.filterable_data.length != 0) {
                AlarmRecord ar = new AlarmRecord(entry, this.isAckAvailable());
                if (this.deleteAlarmFromTableA(ar)) {
                    this.setTheTime(0);
                } else if (this.isAckAvailable() && this.deleteAlarmFromTableB(ar)) {
                    this.setTheTime(1);
                }
            }
        } else if (notificationType.equals(new String("x5"))) {
            this.refresh();
        } else if (notificationType.equals(new String("x3")) && entry.filterable_data.length != 0) {
            this.processAckAlarm(entry);
        }
    }

    private void processChangedAlarm(StructuredEvent entry) {
        AlarmRecord ar = new AlarmRecord(entry, this.isAckAvailable());
        if (this.checkAlarmInTableA(ar)) {
            this.setTheTime(0);
            if (this.isAckAvailable() && ar.checkAckAlarm()) {
                this.deleteAlarmFromTableA(ar);
                this.addAlarmToTableB(ar);
                this.setTheTime(1);
            } else {
                this.deleteAlarmFromTableA(ar);
                this.addAlarmToTableA(ar);
            }
        } else if (this.isAckAvailable()) {
            if (this.checkAlarmInTableB(ar)) {
                this.setTheTime(1);
                if (ar.checkAckAlarm()) {
                    this.deleteAlarmFromTableB(ar);
                    this.addAlarmToTableB(ar);
                } else {
                    this.deleteAlarmFromTableB(ar);
                    this.addAlarmToTableA(ar);
                    this.setTheTime(0);
                }
            } else if (!ar.checkAckAlarm()) {
                this.addAlarmToTableA(ar);
                this.setTheTime(0);
            } else if (ar.checkAckAlarm()) {
                this.addAlarmToTableB(ar);
                this.setTheTime(1);
            }
        }
        if (this.soundON) {
            this.checkSound(ar);
        }
    }

    private void processAckAlarm(StructuredEvent entry) {
        AlarmRecord ar = new AlarmRecord(entry, this.isAckAvailable());
        if (this.checkAlarmInTableA(ar)) {
            this.setTheTime(0);
            if (ar.checkAckAlarm()) {
                this.deleteAlarmFromTableA(ar);
                this.addAlarmToTableB(ar);
                this.setTheTime(1);
            }
        } else if (ar.checkAckAlarm() && !this.checkAlarmInTableB(ar)) {
            this.addAlarmToTableB(ar);
            this.setTheTime(1);
        } else if (!ar.checkAckAlarm() && this.checkAlarmInTableB(ar)) {
            this.deleteAlarmFromTableB(ar);
            this.addAlarmToTableA(ar);
            this.setTheTime(0);
        }
    }

    private boolean deleteAlarmFromTableB(AlarmRecord alarm) {
        boolean bool = this.myModelB.removeRow(alarm);
        if (bool) {
            this.decrementCounter(1, (Severity)this.myAlarmsB.get(alarm.getAlarmId()));
            this.myAlarmsB.remove(alarm.getAlarmId());
        }
        return bool;
    }

    private boolean deleteAlarmFromTableA(AlarmRecord alarm) {
        boolean bool = this.myModelA.removeRow(alarm);
        if (bool) {
            this.decrementCounter(0, (Severity)this.myAlarmsA.get(alarm.getAlarmId()));
            this.myAlarmsA.remove(alarm.getAlarmId());
        }
        return bool;
    }

    private boolean checkAlarmInTableA(AlarmRecord ar) {
        return this.myModelA.contains(ar);
    }

    private boolean checkAlarmInTableB(AlarmRecord ar) {
        return this.myModelB.contains(ar);
    }

    private void checkSound(AlarmRecord ar) {
        String specProblem;
        se.ericsson.cello.emas.fm.common.EventType et;
        String alarmID;
        boolean envAlarm = false;
        boolean NELost = false;
        Severity sev = ar.getSeverity();
        if (sev.equals(Severity.CriticalSeverity) && (alarmID = ar.getAlarmId()) != null && !alarmID.startsWith("R") && ((et = ar.getEventType()).equals(se.ericsson.cello.emas.fm.common.EventType.CommunicationAlarm) || et.equals(se.ericsson.cello.emas.fm.common.EventType.EnvironmentAlarm))) {
            envAlarm = true;
        }
        if ((specProblem = ar.getSpecificProblem()) != null && specProblem.endsWith("FMS_Network_Element_Lost")) {
            NELost = true;
        }
        if (envAlarm || NELost) {
            this.soundTimerBeep.start();
            if (this.soundTimer.isRunning()) {
                this.soundTimer.stop();
            }
            this.soundTimer.start();
        }
    }

    private void decrementCounter(int tableNo, Severity severity) {
        if (tableNo == 0) {
            if (severity.equals(Severity.CriticalSeverity)) {
                this.alarmCountersA[0] = this.alarmCountersA[0] - 1;
            } else if (severity.equals(Severity.MajorSeverity)) {
                this.alarmCountersA[1] = this.alarmCountersA[1] - 1;
            } else if (severity.equals(Severity.MinorSeverity)) {
                this.alarmCountersA[2] = this.alarmCountersA[2] - 1;
            } else if (severity.equals(Severity.WarningSeverity)) {
                this.alarmCountersA[3] = this.alarmCountersA[3] - 1;
            } else if (severity.equals(Severity.IndeterminateSeverity)) {
                this.alarmCountersA[4] = this.alarmCountersA[4] - 1;
            }
            this.updateLabelsA();
        } else {
            if (severity.equals(Severity.CriticalSeverity)) {
                this.alarmCountersB[0] = this.alarmCountersB[0] - 1;
            } else if (severity.equals(Severity.MajorSeverity)) {
                this.alarmCountersB[1] = this.alarmCountersB[1] - 1;
            } else if (severity.equals(Severity.MinorSeverity)) {
                this.alarmCountersB[2] = this.alarmCountersB[2] - 1;
            } else if (severity.equals(Severity.WarningSeverity)) {
                this.alarmCountersB[3] = this.alarmCountersB[3] - 1;
            } else if (severity.equals(Severity.IndeterminateSeverity)) {
                this.alarmCountersB[4] = this.alarmCountersB[4] - 1;
            }
            this.updateLabelsB();
        }
    }

    private void incrementCounter(int tableNo, Severity severity) {
        if (tableNo == 0) {
            if (severity.equals(Severity.CriticalSeverity)) {
                this.alarmCountersA[0] = this.alarmCountersA[0] + 1;
            } else if (severity.equals(Severity.MajorSeverity)) {
                this.alarmCountersA[1] = this.alarmCountersA[1] + 1;
            } else if (severity.equals(Severity.MinorSeverity)) {
                this.alarmCountersA[2] = this.alarmCountersA[2] + 1;
            } else if (severity.equals(Severity.WarningSeverity)) {
                this.alarmCountersA[3] = this.alarmCountersA[3] + 1;
            } else if (severity.equals(Severity.IndeterminateSeverity)) {
                this.alarmCountersA[4] = this.alarmCountersA[4] + 1;
            }
            this.updateLabelsA();
        } else {
            if (severity.equals(Severity.CriticalSeverity)) {
                this.alarmCountersB[0] = this.alarmCountersB[0] + 1;
            } else if (severity.equals(Severity.MajorSeverity)) {
                this.alarmCountersB[1] = this.alarmCountersB[1] + 1;
            } else if (severity.equals(Severity.MinorSeverity)) {
                this.alarmCountersB[2] = this.alarmCountersB[2] + 1;
            } else if (severity.equals(Severity.WarningSeverity)) {
                this.alarmCountersB[3] = this.alarmCountersB[3] + 1;
            } else if (severity.equals(Severity.IndeterminateSeverity)) {
                this.alarmCountersB[4] = this.alarmCountersB[4] + 1;
            }
            this.updateLabelsB();
        }
    }

    private void updateLabelsA() {
        if (this.isAckAvailable()) {
            this.totalNumAlarms = this.myModelA.getRowCount() + this.myModelB.getRowCount();
            this.alarmview.BotLabel2.setText("[" + this.myModelB.getRowCount() + "/" + this.totalNumAlarms + "]");
        } else {
            this.totalNumAlarms = this.myModelA.getRowCount();
        }
        this.alarmview.TopLabel2.setText("[" + this.myModelA.getRowCount() + "/" + this.totalNumAlarms + "]");
        this.alarmview.CriLabel1.setText(this.toString(this.alarmCountersA[0]));
        this.alarmview.MajLabel1.setText(this.toString(this.alarmCountersA[1]));
        this.alarmview.MinLabel1.setText(this.toString(this.alarmCountersA[2]));
        this.alarmview.WarnLabel1.setText(this.toString(this.alarmCountersA[3]));
        this.alarmview.IndetLabel1.setText(this.toString(this.alarmCountersA[4]));
    }

    private void updateLabelsB() {
        this.totalNumAlarms = this.myModelA.getRowCount() + this.myModelB.getRowCount();
        this.alarmview.TopLabel2.setText("[" + this.myModelA.getRowCount() + "/" + this.totalNumAlarms + "]");
        this.alarmview.BotLabel2.setText("[" + this.myModelB.getRowCount() + "/" + this.totalNumAlarms + "]");
        this.alarmview.CriLabel2.setText(this.toString(this.alarmCountersB[0]));
        this.alarmview.MajLabel2.setText(this.toString(this.alarmCountersB[1]));
        this.alarmview.MinLabel2.setText(this.toString(this.alarmCountersB[2]));
        this.alarmview.WarnLabel2.setText(this.toString(this.alarmCountersB[3]));
        this.alarmview.IndetLabel2.setText(this.toString(this.alarmCountersB[4]));
    }

    private void disableAlarmMenuItems() {
        if (this.isAckAvailable()) {
            this.alarmview.jMenuItemAck.setEnabled(false);
            this.alarmview.jMenuItemUnAck.setEnabled(false);
        }
        this.alarmview.jMenuItemDetails.setEnabled(false);
        this.alarmview.jMenuItemHelpOnAlarm.setEnabled(false);
        this.alarmview.deactivateHyperlinks();
    }

    public boolean canStop() {
        try {
            this.unsubscribeCheck();
            return true;
        }
        catch (Exception e) {
            return true;
        }
    }

    protected void stop() {
        this.checkSubTimer.stop();
        if (this.soundTimerBeep.isRunning()) {
            this.soundTimerBeep.stop();
        }
        if (this.soundTimer.isRunning()) {
            this.soundTimer.stop();
        }
        this.removeListeners();
        this.alarmview.tidyUp();
        this.alarmview = null;
        this.aservercomm.unSubscribeNotification((AlarmNotificationCorbaInterface)this);
        this.aservercomm = null;
        try {
            Field[] fields = this.getClass().getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (!(!Modifier.isFinal(field.getModifiers()) & !field.getType().isPrimitive())) continue;
                fields[i].set(this, null);
            }
        }
        catch (Throwable t) {
            Log.logError(null, (Throwable)t);
        }
    }

    private String toString(int x) {
        return "" + x;
    }

    public void setTheTime(int panenum) {
        String timeString = new TimeConverter().getCurrentTime();
        if (panenum == 0) {
            this.alarmview.TopLabel4.setText(timeString);
        } else {
            this.alarmview.BotLabel4.setText(timeString);
        }
    }

    public void pushNotification(StructuredEvent[] structedEvents) {
        this.getApplication().setStatus("", null);
        for (int i = 0; i < structedEvents.length; ++i) {
            final StructuredEvent event = structedEvents[i];
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    AlarmApplicationController.this.processAlarmNotification(event);
                }
            });
        }
    }

    public void disconnectNotification() {
    }

    public void offerChangeNotification(EventType[] addedEventTypes, EventType[] removedEventTypes) {
    }

    public void setStatus(int statusKey) {
        String statusString = this.convertStatusKey(statusKey);
        this.getApplication().setStatus(statusString, null);
    }

    public String getProperty(String key) {
        return super.getProperty(key);
    }

    public void showErrorDialog(int msgKey) {
        String msgKeyString = this.convertStatusKey(msgKey);
        this.showMessageDialog(msgKeyString, null, "ERROR_TITLE", null, 0, null);
    }

    public void setSubscriptionID(String subscriptionID) {
        this.subscriptionid = subscriptionID;
        this.checkSubTimer.start();
    }

    public void processAlarmList(StructuredEvent[] alarmList) {
        try {
            if (alarmList.length == 0) {
                this.getApplication().setStatus("NO_ALARMS_MSG", null);
            } else {
                int numRowsB;
                for (int i = 0; i < alarmList.length; ++i) {
                    AlarmRecord ar = new AlarmRecord(alarmList[i], this.isAckAvailable());
                    if (this.isAckAvailable()) {
                        if (!ar.checkAckAlarm()) {
                            this.addAlarmToTableA(ar);
                            continue;
                        }
                        this.addAlarmToTableB(ar);
                        continue;
                    }
                    this.addAlarmToTableA(ar);
                }
                int numRowsA = this.myModelA.getRowCount();
                if (this.isAckAvailable() && (numRowsB = this.myModelB.getRowCount()) != 0) {
                    int pane = 1;
                    this.setTheTime(pane);
                }
                if (numRowsA != 0) {
                    int pane = 0;
                    this.setTheTime(pane);
                }
            }
        }
        catch (Exception e) {
            Log.logError(null, (Throwable)e);
        }
    }

    public void processNewAlarmNotifications() {
        Enumeration e1 = this.newNotifications.elements();
        while (e1.hasMoreElements()) {
            StructuredEvent existingAlarm = (StructuredEvent)e1.nextElement();
            this.processAlarmNotification(existingAlarm);
        }
        this.newNotifications.clear();
    }

    public void unsubscribeCheck() {
        this.aservercomm.doUnSubscribe(this.subscriptionid);
    }

    public void setSubscriptionOK(boolean subOK) {
        this.subscriptionOK = subOK;
        if (!this.subscriptionOK) {
            this.checkSubTimer.stop();
        }
    }

    public synchronized void setRetrievingFinished(boolean finished) {
        this.retrievingFinished = finished;
        this.notifyAll();
    }

    public void syncAlarmList() {
        try {
            if (this.node_went_down) {
                this.node_went_down = false;
                this.aservercomm.unSubscribeNotification((AlarmNotificationCorbaInterface)this);
                this.aservercomm.cleanup();
                this.aservercomm = null;
                this.aservercomm = AlarmServiceFacade.getAlarmServiceFacadeInstance((AbstractController)this);
                this.aservercomm.subscribeToAlarms((AlarmCorbaInterface)this);
                this.aservercomm.initNotificationServer();
            } else if (this.subscriptionOK) {
                this.aservercomm.syncAlarmList((AlarmCorbaInterface)this);
            } else {
                this.aservercomm.subscribeToAlarms((AlarmCorbaInterface)this);
            }
        }
        catch (UnsupportedIRPVersionException e) {
            this.showMessageDialog("UNSUPPORTED_NS_IRP_VERSION_MSG", null, "ERROR_TITLE", null, 0, null);
        }
    }

    private void acknowledge() {
        int[] rowarray = this.alarmview.jTable1.getOriginalSelectedRows();
        String[] alarmidarray = new String[rowarray.length];
        for (int i = 0; i < rowarray.length; ++i) {
            AlarmRecord ar = (AlarmRecord)this.myModelA.getRow(rowarray[i]);
            alarmidarray[i] = ar.getAlarmId();
        }
        this.aservercomm.setAckStatus((AlarmCorbaInterface)this, alarmidarray, "acknowledge", this.userid);
    }

    private void unacknowledge() {
        int[] rowarray = this.alarmview.jTable2.getOriginalSelectedRows();
        String[] alarmidarray = new String[rowarray.length];
        for (int i = 0; i < rowarray.length; ++i) {
            AlarmRecord ar = (AlarmRecord)this.myModelB.getRow(rowarray[i]);
            alarmidarray[i] = ar.getAlarmId();
        }
        this.aservercomm.unacknowledge((AlarmCorbaInterface)this, alarmidarray, "unacknowledge", this.userid);
    }

    public RowDataInterface getSelectedObject() {
        int row1 = this.alarmview.jTable1.getSelectedRow();
        if (row1 != -1) {
            return (RowDataInterface)this.myModelA.getRow(this.alarmview.jTable1.getOriginalSelectedRow());
        }
        return (RowDataInterface)this.myModelB.getRow(this.alarmview.jTable2.getOriginalSelectedRow());
    }

    public void disposeDetailWindow() {
        this.openedAddInfoDialog = null;
    }

    public void stopApp() {
        this.viewClosing();
    }

    protected void viewClosing() {
        this.getApplicationManager().exitApplicationEMTApp();
    }

    private JMenu getHyperlinks(AlarmRecord alarm) {
        String ldn;
        String moi = alarm.getManagedObjectInstance();
        int ldnStart = moi.indexOf("ManagedElement=");
        if (ldnStart >= 0) {
            ldn = moi.substring(ldnStart);
        } else {
            Log.logError((String)("Irregular Managed Object Instance in alarm: " + moi + "(expected string 'ManagedElement=' not found)."));
            ldn = moi;
        }
        Log.log((int)7, (String)("Alarm Managed Object Instance = " + moi + "\n Hyperlinking search term ='" + ldn + "'"));
        LDNIndexService is = LDNIndexService.getInstance();
        Action[] hyperActions = is.getHyperlinks(ldn);
        Action[] allLinks = new Action[hyperActions.length + 1];
        System.arraycopy(hyperActions, 0, allLinks, 0, hyperActions.length);
        OEGoToAction oeAction = new OEGoToAction(ldn, ldn);
        allLinks[hyperActions.length] = oeAction;
        Properties allSysProps = EmasSystemProperties.getProperties();
        allSysProps.setProperty("LDNs", ldn);
        HyperConfiguration myConfiger = new HyperConfiguration(allSysProps);
        Tool[] ts = myConfiger.getHyperTools();
        Tool aTool = null;
        String aToolName = null;
        String aCfgFileName = null;
        JMenuItem aMenuItem = null;
        HyperToolLauncher aListener = null;
        JMenu hyperlinks = new JMenu("Open In");
        hyperlinks.putClientProperty("LANGUAGE_CONTROLLED", "NT");
        Properties superProps = myConfiger.getSupersedingProperties();
        superProps.setProperty("LDNs", ldn);
        for (int i = 0; i < ts.length; ++i) {
            aTool = ts[i];
            aToolName = aTool.getName();
            aCfgFileName = aTool.getConfigFile();
            aMenuItem = new JMenuItem(aToolName);
            aMenuItem.putClientProperty("LANGUAGE_CONTROLLED", "NT");
            aListener = new HyperToolLauncher(aCfgFileName, superProps);
            aMenuItem.addActionListener(aListener);
            hyperlinks.add(aMenuItem);
        }
        return hyperlinks;
    }

    public AbstractDialogController startDialog(boolean modal, String titleKey, Object[] titleArgs, Class dialogViewClass, Class dialogControllerClass) {
        this.getApplication().setCursor(Application.DEFAULT_CURSOR);
        return super.startDialog(modal, titleKey, titleArgs, dialogViewClass, dialogControllerClass, (Object[][])null);
    }

    private void removeListeners() {
        this.rowSM1.removeListSelectionListener(this.mytable1listener);
        if (this.isAckAvailable()) {
            this.rowSM2.removeListSelectionListener(this.mytable2listener);
            this.alarmview.jTable2.removeMouseListener(this.mytable2MouseLis);
            this.alarmview.jMenuItemAck.removeActionListener(this.myack);
            this.alarmview.jMenuItemUnAck.removeActionListener(this.myunack);
            this.alarmview.popupmenuitemAck.removeActionListener(this.myack);
            this.alarmview.popupmenuitemUnAck.removeActionListener(this.myunack);
        }
        this.alarmview.jTable1.removeMouseListener(this.mytable1MouseLis);
        this.alarmview.jMenuAlarm.removeMenuListener(this.menu1listener);
        this.alarmview.jMenuItemDetails.removeActionListener(this.myaddinfo);
        this.alarmview.jMenuItemSound.removeActionListener(this.soundalarmlistener);
        this.alarmview.jMenuItemRefresh.removeActionListener(this.myrefresh);
        this.alarmview.jMenuItemComm.removeActionListener(this.myrefresh);
        this.alarmview.jMenuItemEnv.removeActionListener(this.myrefresh);
        this.alarmview.jMenuItemEqu.removeActionListener(this.myrefresh);
        this.alarmview.jMenuItemProcess.removeActionListener(this.myrefresh);
        this.alarmview.jMenuItemProcess.removeActionListener(this.myrefresh);
        this.alarmview.popupmenuitemDetails.removeActionListener(this.myaddinfo);
        this.alarmview.printMenuItem.removeActionListener(this.printAction);
        this.alarmview.exportMenuItem.removeActionListener(this.exportAction);
    }

    private String convertStatusKey(int msgKey) {
        switch (msgKey) {
            case 0: {
                return "";
            }
            case 1: {
                return "STATUS_SUBSCRIBE";
            }
            case 2: {
                return "STATUS_GETALARMLIST";
            }
            case 3: {
                return "STATUS_SETACKSTATUS";
            }
            case 4: {
                return "STATUS_UNACKSTATUS";
            }
            case 5: {
                return "NOALARMS_MSG";
            }
            case 6: {
                return "OPERATION_CANCELLED";
            }
            case 7: {
                return "SUBSCRIPTION_STATUS_LOST_MSG";
            }
            case 10: {
                return "MAX_ALARMS_MSG";
            }
            case 11: {
                return "CANNOT_GETALARMS_MSG";
            }
            case 12: {
                return "CANNOT_GETALARMS_PARAMETER_NOT_SUPPORTED_MSG";
            }
            case 13: {
                return "CANNOT_GETALARMS_INVALID_PARAMETER_MSG";
            }
            case 14: {
                return "STATUS_COMMS";
            }
            case 16: {
                return "CANNOT_SETACK_MSG";
            }
            case 17: {
                return "CANNOT_ACK_ALARMS_MSG";
            }
            case 18: {
                return "CANNOT_SETACK_PARAMETER_NOT_SUPPORTED_MSG";
            }
            case 19: {
                return "CANNOT_SETACK_INVALID_PARAMETER_MSG";
            }
            case 20: {
                return "CANNOT_SUBSCRIBE_MSG";
            }
            case 21: {
                return "CANNOT_SUBSCRIBE_PARAMETER_NOT_SUPPORETED_MSG";
            }
            case 22: {
                return "CANNOT_SUBSCRIBE_INVALID_PARAMETER_MSG";
            }
            case 23: {
                return "CANNOT_SUBSCRIBE_NOT_CTG_NOT_SUPPORTED_MSG";
            }
            case 24: {
                return "CANNOT_UNACK_MSG";
            }
            case 25: {
                return "CANNOT_UNACK_ALARMS_MSG";
            }
            case 26: {
                return "CANNOT_UNACK_PARAMETER_NOT_SUPPORTED_MSG";
            }
            case 27: {
                return "CANNOT_UNACK_INVALID_PARAMETER_MSG";
            }
        }
        return "NO_TEXT";
    }

    private void setPopUpMenu(AlarmRecord ar) {
        JMenu links = this.getHyperlinks(ar);
        if (links.getItemCount() > 0) {
            this.alarmview.activateHyperlinks(links);
        } else {
            this.alarmview.deactivateHyperlinks();
        }
        String specificProblem = ar.getSpecificProblem();
        if (specificProblem == null) {
            Log.logError((String)"Unable to read specific problem from alarm entry");
        } else {
            int index = this.alarmview.mypopupmenu.getComponentIndex(this.alarmview.popupmenuitemHelpOnAlarm);
            this.alarmview.mypopupmenu.remove(index);
            this.alarmview.popupmenuitemHelpOnAlarm = new JMenuItem("HELP_ON_ALARM_POPUP");
            this.alarmview.mypopupmenu.add(this.alarmview.popupmenuitemHelpOnAlarm);
            this.alarmview.popupmenuitemHelpOnAlarm.setEnabled(true);
            this.alarmview.popupmenuitemHelpOnAlarm.putClientProperty("HELP_ENABLE", "");
            this.alarmview.popupmenuitemHelpOnAlarm.putClientProperty("TITLE", "YES");
            this.alarmview.popupmenuitemHelpOnAlarm.putClientProperty("HELP_KEY", specificProblem);
            this.alarmview.jMenuItemHelpOnAlarm.putClientProperty("HELP_KEY", specificProblem);
            this.alarmview.jMenuItemHelpOnAlarm.putClientProperty("TITLE", "YES");
        }
    }

    private synchronized void refresh() {
        int i;
        this.getApplication().setStatus("", null);
        while (!this.retrievingFinished) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {}
        }
        this.getApplication().setStatus("STATUS_ALARM_LIST_REBUILD", null);
        while (this.alarmview.jTable1.getModel().getRowCount() != 0) {
            this.myModelA.removeRow(0);
        }
        for (i = 0; i < this.alarmCountersA.length; ++i) {
            this.alarmCountersA[i] = 0;
        }
        this.updateLabelsA();
        if (this.isAckAvailable()) {
            while (this.alarmview.jTable2.getModel().getRowCount() != 0) {
                this.myModelB.removeRow(0);
            }
            for (i = 0; i < this.alarmCountersB.length; ++i) {
                this.alarmCountersB[i] = 0;
            }
            this.updateLabelsB();
        }
        this.syncAlarmList();
    }

    public void connectionLost() {
        this.node_went_down = true;
        this.getApplication().setStatus("LINK_IS_DOWN_TRYING_TO_RECONNECT", null);
    }

    public class Tool {
        private String configFile;
        private String name;

        public Tool() {
        }

        public Tool(String key, String configFile, String name) {
            this.configFile = configFile;
            this.name = name;
        }

        public String getConfigFile() {
            return this.configFile;
        }

        public void setConfigFile(String configFile) {
            this.configFile = configFile;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    private class HyperConfiguration {
        private static final String HYPER_TOOL_KEYS = "HYPER_TOOL_KEYS";
        private static final String NAME_SUFFIX = "_NAME";
        private static final String FILE_SUFFIX = "_CONFIG";
        private static final String KEY_DELIMITER = ";";
        private Properties props = null;

        public HyperConfiguration(Properties p) {
            this.props = p;
        }

        public Tool[] getHyperTools() {
            LinkedList<Tool> hyperToolList = new LinkedList<Tool>();
            String strHyperTools = this.props.getProperty(HYPER_TOOL_KEYS);
            if (strHyperTools == null) {
                return new Tool[0];
            }
            String[] hyperKeyArray = strHyperTools.split(KEY_DELIMITER);
            for (int i = 0; i < hyperKeyArray.length; ++i) {
                String nameKey = hyperKeyArray[i] + NAME_SUFFIX;
                String hyperToolName = this.props.getProperty(nameKey, nameKey + " is not defined");
                String configKey = hyperKeyArray[i] + FILE_SUFFIX;
                String hyperToolConfigFile = this.props.getProperty(configKey, configKey + " is not defined");
                Tool hyperTool = new Tool(hyperKeyArray[i], hyperToolConfigFile, hyperToolName);
                hyperToolList.add(hyperTool);
            }
            Tool[] aToolArray = hyperToolList.toArray(new Tool[0]);
            return aToolArray;
        }

        public Properties getSupersedingProperties() {
            Properties tempProp = new Properties();
            String strSupersedingList = this.props.getProperty(AlarmApplicationController.SUPERSEDING_PARAMETER_LIST);
            if (strSupersedingList != null) {
                tempProp.put(AlarmApplicationController.SUPERSEDING_PARAMETER_LIST, strSupersedingList);
                String[] supersedingListArray = strSupersedingList.split(KEY_DELIMITER);
                for (int i = 0; i < supersedingListArray.length; ++i) {
                    String supersedingName = supersedingListArray[i];
                    String supersedingValue = this.props.getProperty(supersedingName);
                    if (null == supersedingValue) continue;
                    tempProp.put(supersedingName, supersedingValue);
                }
            }
            return tempProp;
        }
    }

    private class HyperToolLauncher
    implements ActionListener {
        private Properties props = null;
        private String myCfgFileName = null;

        public HyperToolLauncher(String cfgFileName, Properties p) {
            this.props = p;
            this.myCfgFileName = cfgFileName;
        }

        public void actionPerformed(ActionEvent arg0) {
            MainWindowController mainWindow = EmasGuilibMediator.getReference().getMainWindowReference();
            mainWindow.getApplicationManager().launchTool(this.myCfgFileName, this.props);
        }
    }

    private class Menu1Listener
    implements MenuListener {
        private Menu1Listener() {
        }

        public void menuSelected(MenuEvent e) {
            int[] numSelectedRowsTable1 = ((AlarmApplicationController)AlarmApplicationController.this).alarmview.jTable1.getOriginalSelectedRows();
            int[] numSelectedRowsTable2 = null;
            if (AlarmApplicationController.this.isAckAvailable()) {
                numSelectedRowsTable2 = ((AlarmApplicationController)AlarmApplicationController.this).alarmview.jTable2.getOriginalSelectedRows();
            }
            if (!(numSelectedRowsTable1.length != 0 || AlarmApplicationController.this.isAckAvailable() && numSelectedRowsTable2.length != 0)) {
                AlarmApplicationController.this.disableAlarmMenuItems();
            } else if (((AlarmApplicationController)AlarmApplicationController.this).alarmview.jTable1.getOriginalSelectedRow() != -1) {
                if (AlarmApplicationController.this.isAckAvailable()) {
                    ((AlarmApplicationController)AlarmApplicationController.this).alarmview.jMenuItemAck.setEnabled(true);
                    ((AlarmApplicationController)AlarmApplicationController.this).alarmview.jMenuItemUnAck.setEnabled(false);
                }
                if (numSelectedRowsTable1.length == 1) {
                    ((AlarmApplicationController)AlarmApplicationController.this).alarmview.jMenuItemDetails.setEnabled(true);
                    ((AlarmApplicationController)AlarmApplicationController.this).alarmview.jMenuItemHelpOnAlarm.setEnabled(true);
                    AlarmRecord ar = (AlarmRecord)AlarmApplicationController.this.myModelA.getRow(((AlarmApplicationController)AlarmApplicationController.this).alarmview.jTable1.getOriginalSelectedRow());
                    JMenu links = AlarmApplicationController.this.getHyperlinks(ar);
                    if (links.getItemCount() > 0) {
                        AlarmApplicationController.this.alarmview.activateHyperlinks(links);
                    } else {
                        AlarmApplicationController.this.alarmview.deactivateHyperlinks();
                    }
                } else if (numSelectedRowsTable1.length > 1) {
                    ((AlarmApplicationController)AlarmApplicationController.this).alarmview.jMenuItemDetails.setEnabled(false);
                    ((AlarmApplicationController)AlarmApplicationController.this).alarmview.jMenuItemHelpOnAlarm.setEnabled(false);
                    AlarmApplicationController.this.alarmview.deactivateHyperlinks();
                }
            } else if (AlarmApplicationController.this.isAckAvailable() && ((AlarmApplicationController)AlarmApplicationController.this).alarmview.jTable2.getOriginalSelectedRow() != -1) {
                ((AlarmApplicationController)AlarmApplicationController.this).alarmview.jMenuItemAck.setEnabled(false);
                ((AlarmApplicationController)AlarmApplicationController.this).alarmview.jMenuItemUnAck.setEnabled(true);
                if (numSelectedRowsTable2.length == 1) {
                    ((AlarmApplicationController)AlarmApplicationController.this).alarmview.jMenuItemDetails.setEnabled(true);
                    ((AlarmApplicationController)AlarmApplicationController.this).alarmview.jMenuItemHelpOnAlarm.setEnabled(true);
                    AlarmRecord ar = (AlarmRecord)AlarmApplicationController.this.myModelB.getRow(((AlarmApplicationController)AlarmApplicationController.this).alarmview.jTable2.getOriginalSelectedRow());
                    JMenu links = AlarmApplicationController.this.getHyperlinks(ar);
                    if (links.getItemCount() > 0) {
                        AlarmApplicationController.this.alarmview.activateHyperlinks(links);
                    } else {
                        AlarmApplicationController.this.alarmview.deactivateHyperlinks();
                    }
                } else if (numSelectedRowsTable2.length > 1) {
                    ((AlarmApplicationController)AlarmApplicationController.this).alarmview.jMenuItemDetails.setEnabled(false);
                    ((AlarmApplicationController)AlarmApplicationController.this).alarmview.jMenuItemHelpOnAlarm.setEnabled(false);
                    AlarmApplicationController.this.alarmview.deactivateHyperlinks();
                }
            }
        }

        public void menuDeselected(MenuEvent e) {
        }

        public void menuCanceled(MenuEvent e) {
        }
    }

    private class UnAck
    implements ActionListener {
        private UnAck() {
        }

        public void actionPerformed(ActionEvent aevent) {
            AlarmApplicationController.this.getApplication().setStatus("", null);
            AlarmApplicationController.this.unacknowledge();
        }
    }

    private class Ack
    implements ActionListener {
        private Ack() {
        }

        public void actionPerformed(ActionEvent aevent) {
            AlarmApplicationController.this.getApplication().setStatus("", null);
            AlarmApplicationController.this.acknowledge();
        }
    }

    private class Refresh
    implements ActionListener {
        private Refresh() {
        }

        public void actionPerformed(ActionEvent event) {
            AlarmApplicationController.this.refresh();
        }
    }

    private class SoundAlarmListener
    implements ActionListener {
        private SoundAlarmListener() {
        }

        public void actionPerformed(ActionEvent eventdeletethis) {
            AlarmApplicationController.this.getApplication().setStatus("", null);
            if (((AlarmApplicationController)AlarmApplicationController.this).alarmview.jMenuItemSound.getState()) {
                AlarmApplicationController.this.soundON = true;
            } else {
                AlarmApplicationController.this.soundON = false;
                if (AlarmApplicationController.this.soundTimerBeep.isRunning()) {
                    AlarmApplicationController.this.soundTimerBeep.stop();
                }
                if (AlarmApplicationController.this.soundTimer.isRunning()) {
                    AlarmApplicationController.this.soundTimer.stop();
                }
            }
        }
    }

    private class AddInfo
    implements ActionListener {
        private AddInfo() {
        }

        public void actionPerformed(ActionEvent event) {
            AlarmApplicationController.this.getApplication().setStatus("", null);
            if (AlarmApplicationController.this.openedAddInfoDialog != null) {
                AlarmApplicationController.this.openedAddInfoDialog.stopDialog();
            }
            AlarmApplicationController.this.openedAddInfoDialog = (DetailsController)AlarmApplicationController.this.startDialog(false, "ADDINFODIALOG_TITLE", null, DetailsView.class, DetailsController.class);
        }
    }

    private class TableMouseListener
    extends MouseAdapter {
        private int mySelectedTableNr;
        private AlarmSortedTable myTable;
        private AlarmSortedTableModel myModel;

        public TableMouseListener(int selectedTableNr, AlarmSortedTableModel model) {
            this.mySelectedTableNr = selectedTableNr;
            this.myTable = this.mySelectedTableNr == 0 || !AlarmApplicationController.this.isAckAvailable() ? ((AlarmApplicationController)AlarmApplicationController.this).alarmview.jTable1 : ((AlarmApplicationController)AlarmApplicationController.this).alarmview.jTable2;
            this.myModel = model;
        }

        public void mouseClicked(MouseEvent e) {
            if ((e.getModifiers() & 4) == 4) {
                int[] selectedRows = this.myTable.getOriginalSelectedRows();
                if (selectedRows.length <= 1) {
                    Point p = e.getPoint();
                    int row = this.myTable.rowAtPoint(p);
                    int col = this.myTable.columnAtPoint(p);
                    this.myTable.changeSelection(row, col, false, false);
                    selectedRows = this.myTable.getOriginalSelectedRows();
                }
                if (selectedRows.length == 1) {
                    ((AlarmApplicationController)AlarmApplicationController.this).alarmview.popupmenuitemDetails.setEnabled(true);
                    ((AlarmApplicationController)AlarmApplicationController.this).alarmview.popupmenuitemHelpOnAlarm.setEnabled(true);
                    if (AlarmApplicationController.this.isAckAvailable()) {
                        if (this.mySelectedTableNr == 0) {
                            ((AlarmApplicationController)AlarmApplicationController.this).alarmview.popupmenuitemAck.setEnabled(true);
                            ((AlarmApplicationController)AlarmApplicationController.this).alarmview.popupmenuitemUnAck.setEnabled(false);
                        } else {
                            ((AlarmApplicationController)AlarmApplicationController.this).alarmview.popupmenuitemAck.setEnabled(false);
                            ((AlarmApplicationController)AlarmApplicationController.this).alarmview.popupmenuitemUnAck.setEnabled(true);
                        }
                    }
                    AlarmRecord ar = (AlarmRecord)this.myModel.getRow(this.myTable.getOriginalSelectedRow());
                    AlarmApplicationController.this.setPopUpMenu(ar);
                } else if (selectedRows.length > 1) {
                    if (AlarmApplicationController.this.isAckAvailable()) {
                        if (this.mySelectedTableNr == 0) {
                            ((AlarmApplicationController)AlarmApplicationController.this).alarmview.popupmenuitemAck.setEnabled(true);
                            ((AlarmApplicationController)AlarmApplicationController.this).alarmview.popupmenuitemUnAck.setEnabled(false);
                        } else {
                            ((AlarmApplicationController)AlarmApplicationController.this).alarmview.popupmenuitemAck.setEnabled(false);
                            ((AlarmApplicationController)AlarmApplicationController.this).alarmview.popupmenuitemUnAck.setEnabled(true);
                        }
                    }
                    ((AlarmApplicationController)AlarmApplicationController.this).alarmview.popupmenuitemDetails.setEnabled(false);
                    ((AlarmApplicationController)AlarmApplicationController.this).alarmview.popupmenuitemHelpOnAlarm.setEnabled(false);
                    AlarmApplicationController.this.alarmview.deactivateHyperlinks();
                }
                AlarmApplicationController.this.showPopupMenu(((AlarmApplicationController)AlarmApplicationController.this).alarmview.mypopupmenu, (Component)((Object)this.myTable), (int)e.getPoint().getX(), (int)e.getPoint().getY());
            }
        }
    }

    private class TableListener
    implements ListSelectionListener {
        private int mySelectedTableNr;
        private AlarmSortedTable myTable;
        private AlarmSortedTableModel myModel;

        public TableListener(int selectedTableNr, AlarmSortedTableModel model) {
            this.mySelectedTableNr = selectedTableNr;
            this.myTable = this.mySelectedTableNr == 0 ? ((AlarmApplicationController)AlarmApplicationController.this).alarmview.jTable1 : ((AlarmApplicationController)AlarmApplicationController.this).alarmview.jTable2;
            this.myModel = model;
        }

        public void valueChanged(ListSelectionEvent le) {
            ListSelectionModel lm;
            if (!le.getValueIsAdjusting() && !(lm = (ListSelectionModel)le.getSource()).isSelectionEmpty()) {
                if (this.mySelectedTableNr == 0) {
                    ((AlarmApplicationController)AlarmApplicationController.this).alarmview.jTable2.clearSelection();
                } else {
                    ((AlarmApplicationController)AlarmApplicationController.this).alarmview.jTable1.clearSelection();
                }
                AlarmApplicationController.this.TABLE_SELECTED = this.mySelectedTableNr;
                int[] rowarray = this.myTable.getSelectedRows();
                if (rowarray.length == 1) {
                    AlarmRecord ar = (AlarmRecord)this.myModel.getRow(this.myTable.getOriginalSelectedRow());
                    AlarmApplicationController.this.setPopUpMenu(ar);
                } else {
                    AlarmApplicationController.this.alarmview.deactivateHyperlinks();
                }
            }
        }
    }

    private class PageLayoutAction
    implements ActionListener {
        private PageLayoutAction() {
        }

        public void actionPerformed(ActionEvent event) {
            if (AlarmApplicationController.this.printout == null) {
                AlarmApplicationController.this.printout = new Printout((Component)((Object)((AlarmApplicationController)AlarmApplicationController.this).alarmview.jTable1), AlarmApplicationController.this.getApplication().getLanguageBundle().getString("NEW_ALARMS"));
            }
            AlarmApplicationController.this.printout.pageLayout();
            AlarmApplicationController.this.getApplication().bringToFront();
        }
    }

    private class PrintAction
    implements ActionListener {
        private PrintAction() {
        }

        public void actionPerformed(ActionEvent event) {
            if (AlarmApplicationController.this.TABLE_SELECTED == 0) {
                if (AlarmApplicationController.this.printout == null) {
                    AlarmApplicationController.this.printout = new Printout((Component)((Object)((AlarmApplicationController)AlarmApplicationController.this).alarmview.jTable1), AlarmApplicationController.this.getApplication().getLanguageBundle().getString("NEW_ALARMS"));
                }
                AlarmApplicationController.this.printout.print();
                AlarmApplicationController.this.getApplication().bringToFront();
            }
            if (AlarmApplicationController.this.TABLE_SELECTED == 1) {
                if (AlarmApplicationController.this.printout == null) {
                    AlarmApplicationController.this.printout = new Printout((Component)((Object)((AlarmApplicationController)AlarmApplicationController.this).alarmview.jTable2), AlarmApplicationController.this.getApplication().getLanguageBundle().getString("ACK_ALARMS"));
                }
                AlarmApplicationController.this.printout.print();
                AlarmApplicationController.this.getApplication().bringToFront();
            }
        }
    }
}

