/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.fm.am;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.JFileChooser;
import se.ericsson.cello.emas.fm.am.AlarmApplicationView;
import se.ericsson.cello.emas.fm.am.AlarmRecord;
import se.ericsson.cello.emas.fm.common.AlarmSortedTableModel;
import se.ericsson.cello.support.gui.guilib.comp.Log;

public class ExportActionClass
implements ActionListener {
    private AlarmApplicationView alarmview;
    private String[] myAlarmAttributes;
    private AlarmSortedTableModel myModelA;
    private AlarmSortedTableModel myModelB;
    private ResourceBundle myBundle;
    private boolean ackIsAvailable;

    public ExportActionClass(AlarmSortedTableModel modelA, AlarmSortedTableModel modelB, AlarmApplicationView view, ResourceBundle bundle) {
        this.myModelA = modelA;
        this.myModelB = modelB;
        this.alarmview = view;
        this.myBundle = bundle;
        this.ackIsAvailable = true;
        this.fillmyAlarmAttributes();
    }

    public ExportActionClass(AlarmSortedTableModel modelA, AlarmApplicationView view, ResourceBundle bundle) {
        this.myModelA = modelA;
        this.alarmview = view;
        this.myBundle = bundle;
        this.ackIsAvailable = false;
        this.fillmyAlarmAttributes();
    }

    private void fillmyAlarmAttributes() {
        this.myAlarmAttributes = this.ackIsAvailable ? new String[]{"NOTIFICATION_ID", "CORRELATED_NOTIFICATIONS", "EVENT_TIME", "SYSTEM_DN", "MANAGED_OBJECT_CLASS", "MANAGED_OBJECT_INSTANCE", "PROBABLE_CAUSE", "SEVERITY", "SPECIFIC_PROBLEM", "ADDITIONAL_TEXT", "ALARM_ID", "ACK_USER_ID", "ACK_TIME", "ACK_SYSTEM_ID", "ACK_STATE", "EVENT_TYPE", "ADDITIONAL_INFORMATION", "PROPOSED_REPAIRED_ACTIONS"} : new String[]{"NOTIFICATION_ID", "CORRELATED_NOTIFICATIONS", "EVENT_TIME", "SYSTEM_DN", "MANAGED_OBJECT_CLASS", "MANAGED_OBJECT_INSTANCE", "PROBABLE_CAUSE", "SEVERITY", "SPECIFIC_PROBLEM", "ADDITIONAL_TEXT", "ALARM_ID", "EVENT_TYPE", "ADDITIONAL_INFORMATION", "PROPOSED_REPAIRED_ACTIONS"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent event) {
        JFileChooser fileChooser;
        int status;
        String defaultPath = System.getProperty("user.home");
        if (defaultPath == null) {
            Log.logError((String)"Error retrieving user home directory");
            defaultPath = "";
        }
        if ((status = (fileChooser = new JFileChooser(defaultPath)).showSaveDialog((Component)((Object)this.alarmview))) == 0) {
            File file = fileChooser.getSelectedFile();
            try {
                AlarmRecord ar;
                int i;
                int rows;
                StringBuffer strBuf = new StringBuffer();
                this.createHeader(strBuf);
                AlarmSortedTableModel alarmSortedTableModel = this.myModelA;
                synchronized (alarmSortedTableModel) {
                    rows = this.myModelA.getRowCount();
                    for (i = 0; i < rows; ++i) {
                        ar = (AlarmRecord)this.myModelA.getRow(i);
                        this.createAlarmInfo(ar, strBuf);
                    }
                }
                if (this.ackIsAvailable) {
                    alarmSortedTableModel = this.myModelB;
                    synchronized (alarmSortedTableModel) {
                        rows = this.myModelB.getRowCount();
                        for (i = 0; i < rows; ++i) {
                            ar = (AlarmRecord)this.myModelB.getRow(i);
                            this.createAlarmInfo(ar, strBuf);
                        }
                    }
                }
                FileWriter filewriter = new FileWriter(file);
                filewriter.write(strBuf.toString());
                filewriter.close();
            }
            catch (IOException ioe) {
                Log.logError((String)"Input/output exception while saving file");
            }
        }
    }

    private void createAlarmInfo(AlarmRecord ar, StringBuffer strBuf) {
        for (int i = 0; i < this.myAlarmAttributes.length; ++i) {
            String tmpStr = ar.getStringValue(this.myAlarmAttributes[i]);
            if (this.ackIsAvailable && this.myAlarmAttributes[i].equals("ACK_STATE")) {
                if (ar.checkAckAlarm()) {
                    strBuf.append(this.myBundle.getString("ACKNOWLEDGE"));
                } else {
                    strBuf.append(this.myBundle.getString("NOT_ACKNOWLEDGE"));
                }
            } else if (tmpStr != null) {
                strBuf.append(tmpStr);
            }
            strBuf.append(";");
        }
        strBuf.append("\n");
    }

    private void createHeader(StringBuffer strBuf) {
        strBuf.append(this.myBundle.getString("NOTIFICATION_ID_DETAILS"));
        strBuf.append(";");
        strBuf.append(this.myBundle.getString("CORRELATED_NOTIFICATIONS_DETAILS"));
        strBuf.append(";");
        strBuf.append(this.myBundle.getString("EVENT_TIME_DETAILS"));
        strBuf.append(";");
        strBuf.append(this.myBundle.getString("SYSTEM_DN_DETAILS"));
        strBuf.append(";");
        strBuf.append(this.myBundle.getString("MANAGED_OBJECT_CLASS_DETAILS"));
        strBuf.append(";");
        strBuf.append(this.myBundle.getString("MANAGED_OBJECT_INSTANCE_DETAILS"));
        strBuf.append(";");
        strBuf.append(this.myBundle.getString("PROBABLE_CAUSE_DETAILS"));
        strBuf.append(";");
        strBuf.append(this.myBundle.getString("PERCEIVED_SEVERITY_DETAILS"));
        strBuf.append(";");
        strBuf.append(this.myBundle.getString("SPECIFIC_PROBLEM_DETAILS"));
        strBuf.append(";");
        strBuf.append(this.myBundle.getString("ADDITIONAL_TEXT_DETAILS"));
        strBuf.append(";");
        strBuf.append(this.myBundle.getString("ALARM_ID_DETAILS"));
        strBuf.append(";");
        if (this.ackIsAvailable) {
            strBuf.append(this.myBundle.getString("ACK_USER_DETAILS"));
            strBuf.append(";");
            strBuf.append(this.myBundle.getString("ACK_TIME_DETAILS"));
            strBuf.append(";");
            strBuf.append(this.myBundle.getString("ACK_SYSTEM_ID_DETAILS"));
            strBuf.append(";");
            strBuf.append(this.myBundle.getString("ACK_STATE_DETAILS"));
            strBuf.append(";");
        }
        strBuf.append(this.myBundle.getString("EVENT_TYPE_DETAILS"));
        strBuf.append(";");
        strBuf.append(this.myBundle.getString("ADDITIONAL_INFORMATION_DETAILS"));
        strBuf.append(";");
        strBuf.append(this.myBundle.getString("PROPOSED_REPAIRED_ACTIONS_DETAILS"));
        strBuf.append(";");
        strBuf.append("\n");
    }
}

