/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.sshsftpservice.utils.impl;

import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import se.ericsson.cello.emt.sshsftpservice.utils.impl.SshBuf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SshUtils {
    public static final byte SSH_MSG_USERAUTH_REQUEST = 50;

    public static byte[] certArray2pkblob(ArrayList<X509Certificate> x509CertificateChain) throws CertificateEncodingException {
        SshBuf blob = new SshBuf();
        blob.putUint32(x509CertificateChain.size());
        for (X509Certificate certificate : x509CertificateChain) {
            blob.putString(certificate.getEncoded());
        }
        blob.putUint32(0);
        return blob.getBytes();
    }

    public static byte[] rsaSha1Sign(byte[] data, PrivateKey key) throws GeneralSecurityException {
        Signature signer = Signature.getInstance("SHA1withRSA");
        signer.initSign(key);
        signer.update(data);
        return signer.sign();
    }

    public static RSAPublicKey getPublicKey(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            return null;
        }
        PublicKey key = x509Certificate.getPublicKey();
        if (!(key instanceof RSAPublicKey)) {
            return null;
        }
        return (RSAPublicKey)key;
    }
}

