/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.utils.guihelper;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public class IconHelper {
    static final String DEFAULT_ICON = "se/ericsson/cello/emt/utils/guihelper/default.gif";

    public Image getIconImage(String path) {
        Image icon;
        if (!this.isFilePathConsistent(path)) {
            path = DEFAULT_ICON;
        }
        if ((icon = this.createImageFromFileSystem(path)) == null && (icon = this.getImageFromResource(path)) == null && !path.equals(DEFAULT_ICON)) {
            icon = this.getImageFromResource(DEFAULT_ICON);
        }
        return icon;
    }

    private boolean isFilePathConsistent(String path) {
        boolean result = true;
        if (null != path) {
            File f = new File(path);
            if (f.exists() && f.canRead()) {
                BufferedImage img = null;
                try {
                    img = ImageIO.read(f);
                    if (img == null || ((Image)img).getWidth(null) <= 0 || ((Image)img).getHeight(null) <= 0) {
                        result = false;
                    }
                }
                catch (IOException e) {
                    result = false;
                }
            } else {
                result = false;
            }
        } else {
            result = false;
        }
        return result;
    }

    private Image createImageFromFileSystem(String filePath) {
        Image result;
        try {
            int c;
            File imgFile = new File(filePath);
            FileInputStream stream = new FileInputStream(imgFile);
            BufferedInputStream in = new BufferedInputStream(stream);
            ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
            while ((c = in.read()) != -1) {
                byteArrayOut.write(c);
            }
            result = Toolkit.getDefaultToolkit().createImage(byteArrayOut.toByteArray());
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    private Image getImageFromResource(String filePath) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        Image icon = Toolkit.getDefaultToolkit().getImage(classLoader.getResource(filePath));
        if (icon == null) {
            icon = Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(filePath));
        }
        return icon;
    }
}

